/*
 * Decompiled with CFR 0.152.
 */
package vib.oldregistration;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import math3d.JacobiFloat;
import vib.FastMatrix;
import vib.oldregistration.IntensityMap;
import vib.oldregistration.PrincipalComponents;
import vib.transforms.FastMatrixTransform;
import vib.transforms.OrderedTransformations;
import vib.transforms.Threshold;

public class PCA_Registration
implements PlugIn {
    boolean keepSourceImages = true;
    ImagePlus[] sourceImages = null;

    public void run(String string) {
        this.chooseStacks();
        this.closeSourceImages();
    }

    public void closeSourceImages() {
        if (!this.keepSourceImages) {
            for (int i = 0; i < this.sourceImages.length; ++i) {
                ImageWindow imageWindow = this.sourceImages[i].getWindow();
                if (imageWindow == null) continue;
                imageWindow.close();
            }
        }
    }

    public Threshold threshold(int[] nArray, float f) {
        int n;
        long l = 0L;
        boolean bl = false;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (n = 1; n < 255; ++n) {
            l2 += (long)nArray[n];
        }
        for (n = 0; n < 256; ++n) {
            l3 += (long)nArray[n];
            if (n != 0 && n != 255) {
                l4 += (long)nArray[n];
            }
            if ((float)l4 >= f * (float)l2) {
                return new Threshold(n, l);
            }
            l = l3;
        }
        return null;
    }

    public Color indexToColor(int n) {
        Color color = Toolbar.getForegroundColor();
        Color color2 = new Color(color.getRed() / 3, color.getGreen() / 3, color.getBlue() / 3);
        Color color3 = new Color(color.getRed() / 4, color.getGreen() / 4, color.getBlue() / 4);
        switch (n) {
            case 0: {
                return color3;
            }
            case 1: {
                return color2;
            }
            case 2: {
                return color;
            }
        }
        return null;
    }

    public static void scaleDoubleArray(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
    }

    public PrincipalComponents doPCA(ImagePlus imagePlus, Threshold threshold, boolean bl) {
        try {
            int n;
            int n2;
            int n3;
            double d;
            int n4;
            double d2;
            int n5;
            int n6 = imagePlus.getWidth();
            int n7 = imagePlus.getHeight();
            int n8 = imagePlus.getStackSize();
            Calibration calibration = imagePlus.getCalibration();
            double d3 = 1.0;
            double d4 = 1.0;
            double d5 = 1.0;
            if (calibration.pixelWidth != 0.0 && calibration.pixelHeight != 0.0 && calibration.pixelDepth != 0.0) {
                d3 = 1.0;
                d4 = calibration.pixelHeight / calibration.pixelWidth;
                d5 = calibration.pixelDepth / calibration.pixelWidth;
            }
            System.out.println("Aspect ratio is: " + d3 + ", " + d4 + ", " + d5);
            System.out.println("Number below threshold is: " + threshold.belowThreshold);
            int n9 = n6 * n7 * n8 - (int)threshold.belowThreshold;
            System.out.println("Number over and at threshold is: " + n9);
            int n10 = 3;
            double[] dArray = new double[n10];
            double[] dArray2 = new double[n10];
            double[] dArray3 = new double[n10];
            double[] dArray4 = new double[n10];
            int[] nArray = new int[n10];
            ImageStack imageStack = imagePlus.getStack();
            int n11 = 0;
            byte[][] byArrayArray = new byte[n8][];
            for (int i = 0; i < imagePlus.getStackSize(); ++i) {
                byArrayArray[i] = (byte[])imageStack.getPixels(i + 1);
            }
            for (n5 = 0; n5 < imagePlus.getStackSize(); ++n5) {
                d2 = (double)n5 * d5;
                for (n4 = 0; n4 < imagePlus.getHeight(); ++n4) {
                    d = (double)n4 * d4;
                    for (n3 = 0; n3 < imagePlus.getWidth(); ++n3) {
                        double d6 = n3;
                        n2 = byArrayArray[n5][n4 * n6 + n3];
                        n = n2 & 0xFF;
                        if (n < threshold.value) continue;
                        dArray2[0] = dArray2[0] + d6;
                        dArray2[1] = dArray2[1] + d;
                        dArray2[2] = dArray2[2] + d2;
                        ++n11;
                    }
                }
            }
            System.out.println("Considered " + n11 + " points...");
            for (n5 = 0; n5 < n10; ++n5) {
                System.out.println("The sum of dimension " + n5 + " was " + dArray2[n5]);
            }
            for (n5 = 0; n5 < n10; ++n5) {
                dArray[n5] = dArray2[n5] / (double)n9;
                System.out.println("The mean of dimension " + n5 + " was " + dArray[n5]);
            }
            float[][] fArray = new float[n10][n10];
            for (n4 = 0; n4 < imagePlus.getStackSize(); ++n4) {
                d2 = (double)n4 * d5;
                for (n3 = 0; n3 < imagePlus.getHeight(); ++n3) {
                    d = (double)n3 * d4;
                    for (n2 = 0; n2 < imagePlus.getWidth(); ++n2) {
                        double d7 = n2;
                        n = byArrayArray[n4][n3 * n6 + n2];
                        int n12 = n & 0xFF;
                        if (n12 < threshold.value) continue;
                        double d8 = d7 - dArray[0];
                        double d9 = d - dArray[1];
                        double d10 = d2 - dArray[2];
                        dArray3[0] = dArray3[0] + d8 * d8;
                        dArray3[1] = dArray3[1] + d9 * d9;
                        dArray3[2] = dArray3[2] + d10 * d10;
                        float[] fArray2 = fArray[0];
                        fArray2[0] = (float)((double)fArray2[0] + d8 * d8);
                        float[] fArray3 = fArray[0];
                        fArray3[1] = (float)((double)fArray3[1] + d8 * d9);
                        float[] fArray4 = fArray[0];
                        fArray4[2] = (float)((double)fArray4[2] + d8 * d10);
                        float[] fArray5 = fArray[1];
                        fArray5[0] = (float)((double)fArray5[0] + d9 * d8);
                        float[] fArray6 = fArray[1];
                        fArray6[1] = (float)((double)fArray6[1] + d9 * d9);
                        float[] fArray7 = fArray[1];
                        fArray7[2] = (float)((double)fArray7[2] + d9 * d10);
                        float[] fArray8 = fArray[2];
                        fArray8[0] = (float)((double)fArray8[0] + d10 * d8);
                        float[] fArray9 = fArray[2];
                        fArray9[1] = (float)((double)fArray9[1] + d10 * d9);
                        float[] fArray10 = fArray[2];
                        fArray10[2] = (float)((double)fArray10[2] + d10 * d10);
                        ++n11;
                    }
                }
            }
            for (n4 = 0; n4 < n10; ++n4) {
                int n13 = n4;
                dArray3[n13] = dArray3[n13] / (double)(n9 - 1);
                n11 = 0;
                while (n11 < n10) {
                    float[] fArray11 = fArray[n4];
                    int n14 = n11++;
                    fArray11[n14] = fArray11[n14] / (float)(n9 - 1);
                }
                dArray4[n4] = Math.sqrt(dArray3[n4]);
                System.out.println("The standard deviation of dimension " + n4 + " was " + dArray4[n4]);
            }
            System.out.println("Covariance:");
            for (n4 = 0; n4 < n10; ++n4) {
                System.out.print("  [");
                for (n11 = 0; n11 < n10; ++n11) {
                    System.out.print(" " + fArray[n4][n11] + " ");
                }
                System.out.println("]");
            }
            JacobiFloat jacobiFloat = new JacobiFloat(fArray, 200);
            float[] fArray12 = jacobiFloat.getEigenValues();
            float[][] fArray13 = jacobiFloat.getEigenVectors();
            double[][] dArray5 = new double[3][3];
            dArray5[0][0] = fArray13[0][0];
            dArray5[0][1] = fArray13[1][0];
            dArray5[0][2] = fArray13[2][0];
            dArray5[1][0] = fArray13[0][1];
            dArray5[1][1] = fArray13[1][1];
            dArray5[1][2] = fArray13[2][1];
            dArray5[2][0] = fArray13[0][2];
            dArray5[2][1] = fArray13[1][2];
            dArray5[2][2] = fArray13[2][2];
            double[] dArray6 = new double[]{fArray12[0], fArray12[1], fArray12[2]};
            PrincipalComponents principalComponents = new PrincipalComponents(dArray6, dArray5, dArray, d3, d4, d5);
            System.out.println(principalComponents);
            double[] dArray7 = (double[])principalComponents.vectors[0].clone();
            double[] dArray8 = (double[])principalComponents.vectors[1].clone();
            double[] dArray9 = (double[])principalComponents.vectors[2].clone();
            PCA_Registration.scaleDoubleArray(dArray7, 256.0);
            PCA_Registration.scaleDoubleArray(dArray8, 256.0);
            PCA_Registration.scaleDoubleArray(dArray9, 256.0);
            for (n11 = 0; n11 < n8; ++n11) {
                ImageProcessor imageProcessor = imageStack.getProcessor(n11 + 1);
                imageProcessor.setColor(this.indexToColor(0));
                imageProcessor.moveTo((int)dArray[0], (int)(dArray[1] / d4));
                imageProcessor.lineTo((int)(dArray[0] + dArray7[0]), (int)(dArray[1] / d4 + dArray7[1]));
                imageProcessor.setColor(this.indexToColor(1));
                imageProcessor.moveTo((int)dArray[0], (int)(dArray[1] / d4));
                imageProcessor.lineTo((int)(dArray[0] + dArray8[0]), (int)(dArray[1] / d4 + dArray8[1]));
                imageProcessor.setColor(this.indexToColor(2));
                imageProcessor.moveTo((int)dArray[0], (int)(dArray[1] / d4));
                imageProcessor.lineTo((int)(dArray[0] + dArray9[0]), (int)(dArray[1] / d4 + dArray9[1]));
            }
            imagePlus.updateAndDraw();
            return principalComponents;
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            String string = stringWriter.toString();
            if (IJ.getApplet() == null) {
                IJ.log((String)("Error during PCA: " + exception + "\n" + string));
            }
            return null;
        }
    }

    public void getSampleDistribution(ImagePlus imagePlus, double[] dArray, int[] nArray) {
        for (int i = 0; i < 256; ++i) {
            nArray[i] = 0;
        }
        dArray[0] = 0.0;
        dArray[1] = 0.0;
        dArray[2] = 0.0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        ImageStack imageStack = imagePlus.getStack();
        int n = imageStack.getWidth();
        for (int i = 0; i < imagePlus.getStackSize(); ++i) {
            byte[] byArray = (byte[])imageStack.getPixels(i + 1);
            for (int j = 0; j < imagePlus.getHeight(); ++j) {
                for (int k = 0; k < imagePlus.getWidth(); ++k) {
                    int n2;
                    byte by = byArray[j * n + k];
                    int n3 = n2 = by & 0xFF;
                    nArray[n3] = nArray[n3] + 1;
                    d += (double)n2;
                    d2 += (double)(k * n2);
                    d3 += (double)(j * n2);
                    d4 += (double)(i * n2);
                }
            }
        }
        dArray[0] = d2 / d;
        dArray[1] = d3 / d;
        dArray[2] = d4 / d;
        System.out.println("x centre of mass is " + dArray[0]);
        System.out.println("y centre of mass is " + dArray[1]);
        System.out.println("z centre of mass is " + dArray[2]);
    }

    public int aboveThresholdLengthAlong(PrincipalComponents principalComponents, int n, ImagePlus imagePlus, Threshold threshold) {
        if (n < 0 || n >= 3) {
            throw new IllegalArgumentException("Eigenvector number must be 0, 1 or 2 (not " + n + ")");
        }
        FastMatrixTransform fastMatrixTransform = principalComponents.correctAspect.inverse();
        fastMatrixTransform.apply(principalComponents.vectors[n]);
        double[] dArray = new double[]{fastMatrixTransform.x, fastMatrixTransform.y, fastMatrixTransform.z};
        fastMatrixTransform.apply(principalComponents.meanXYZ);
        double[] dArray2 = new double[]{fastMatrixTransform.x, fastMatrixTransform.y, fastMatrixTransform.z};
        ImageStack imageStack = imagePlus.getStack();
        double[] dArray3 = FastMatrixTransform.normalize(dArray);
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = imagePlus.getStackSize();
        int[] nArray = new int[2];
        nArray[1] = 0;
        nArray[0] = 0;
        block0: for (int i = 0; i < 2; ++i) {
            int n5 = i * 2 - 1;
            int n6 = 0;
            while (true) {
                int n7 = (int)(dArray2[0] + dArray3[0] * (double)n6 * (double)n5);
                int n8 = (int)(dArray2[1] + dArray3[1] * (double)n6 * (double)n5);
                int n9 = (int)(dArray2[2] + dArray3[2] * (double)n6 * (double)n5);
                if (n7 < 0 || n7 >= n2 || n8 < 0 || n8 >= n3 || n9 < 0 || n9 >= n4) continue block0;
                byte by = ((byte[])imageStack.getPixels(n9 + 1))[n7 + n8 * n2];
                int n10 = by & 0xFF;
                if (n10 >= threshold.value) {
                    nArray[i] = n6;
                }
                ++n6;
            }
        }
        return nArray[0] + nArray[1];
    }

    public void chooseStacks() {
        int n;
        String string;
        ImagePlus imagePlus;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error((String)"PCA_Registration.chooseStacks(): No images are open.");
            return;
        }
        String[] stringArray = new String[nArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            imagePlus = WindowManager.getImage((int)nArray[i]);
            stringArray[i] = imagePlus != null ? imagePlus.getTitle() : "";
        }
        stringArray[nArray.length] = string = "*None*";
        imagePlus = new GenericDialog("RGB Merge");
        imagePlus.addChoice("Template stack:", stringArray, stringArray[0]);
        imagePlus.addChoice("Stack to transform:", stringArray, stringArray[1]);
        imagePlus.addCheckbox("Keep source images", true);
        imagePlus.showDialog();
        if (imagePlus.wasCanceled()) {
            return;
        }
        int[] nArray2 = new int[]{imagePlus.getNextChoiceIndex(), imagePlus.getNextChoiceIndex()};
        this.keepSourceImages = imagePlus.getNextBoolean();
        this.sourceImages = new ImagePlus[2];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.sourceImages[0] = WindowManager.getImage((int)nArray[nArray2[0]]);
        this.sourceImages[1] = WindowManager.getImage((int)nArray[nArray2[1]]);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        int[] nArray3 = new int[256];
        int[] nArray4 = new int[256];
        this.getSampleDistribution(this.sourceImages[0], dArray, nArray3);
        this.getSampleDistribution(this.sourceImages[1], dArray2, nArray4);
        Threshold threshold = this.threshold(nArray3, 0.15f);
        System.out.println("Threshold for image 0 is at: " + threshold.value + " (number below: " + threshold.belowThreshold + ")");
        Threshold threshold2 = this.threshold(nArray4, 0.15f);
        System.out.println("Threshold for image 1 is at: " + threshold2.value + " (number below: " + threshold2.belowThreshold + ")");
        PrincipalComponents principalComponents = this.doPCA(this.sourceImages[0], threshold, false);
        PrincipalComponents principalComponents2 = this.doPCA(this.sourceImages[1], threshold2, false);
        IntensityMap intensityMap = IntensityMap.fromHistograms(nArray3, nArray4, threshold, threshold2);
        intensityMap.setup("", this.sourceImages[1]);
        intensityMap.run(this.sourceImages[1].getProcessor());
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0, -principalComponents2.meanXYZ[0]}, {0.0, 0.0, 0.0, -principalComponents2.meanXYZ[1]}, {0.0, 0.0, 0.0, -principalComponents2.meanXYZ[2]}};
        FastMatrixTransform fastMatrixTransform = new FastMatrixTransform(dArrayArray).plus(new FastMatrixTransform(1.0));
        FastMatrixTransform fastMatrixTransform2 = new FastMatrixTransform(dArrayArray).scale(-1.0, -1.0, -1.0).plus(new FastMatrixTransform(1.0));
        double[][] dArrayArray2 = new double[][]{{0.0, 0.0, 0.0, -principalComponents.meanXYZ[0]}, {0.0, 0.0, 0.0, -principalComponents.meanXYZ[1]}, {0.0, 0.0, 0.0, -principalComponents.meanXYZ[2]}};
        FastMatrixTransform fastMatrixTransform3 = new FastMatrixTransform(dArrayArray2).plus(new FastMatrixTransform(1.0));
        FastMatrixTransform fastMatrixTransform4 = new FastMatrixTransform(dArrayArray2).scale(-1.0, -1.0, -1.0).plus(new FastMatrixTransform(1.0));
        FastMatrixTransform fastMatrixTransform5 = FastMatrixTransform.translate(principalComponents.meanXYZ[0] - principalComponents2.meanXYZ[0], principalComponents.meanXYZ[1] - principalComponents2.meanXYZ[1], principalComponents.meanXYZ[2] - principalComponents2.meanXYZ[2]);
        System.out.println("finalTranslationsMatrix is:\n" + fastMatrixTransform5.toStringIndented("  "));
        double[] dArray3 = (double[])principalComponents2.vectors[2].clone();
        double[] dArray4 = (double[])principalComponents2.vectors[1].clone();
        double[] dArray5 = (double[])principalComponents.vectors[2].clone();
        double[] dArray6 = (double[])principalComponents.vectors[1].clone();
        FastMatrixTransform[] fastMatrixTransformArray = new FastMatrixTransform[4];
        fastMatrixTransformArray[0] = new FastMatrixTransform(FastMatrix.rotateToAlignVectors(dArray5, dArray6, dArray3, dArray4));
        PCA_Registration.scaleDoubleArray(dArray4, -1.0);
        fastMatrixTransformArray[1] = new FastMatrixTransform(FastMatrix.rotateToAlignVectors(dArray5, dArray6, dArray3, dArray4));
        PCA_Registration.scaleDoubleArray(dArray3, -1.0);
        PCA_Registration.scaleDoubleArray(dArray4, -1.0);
        fastMatrixTransformArray[2] = new FastMatrixTransform(FastMatrix.rotateToAlignVectors(dArray5, dArray6, dArray3, dArray4));
        PCA_Registration.scaleDoubleArray(dArray4, -1.0);
        fastMatrixTransformArray[3] = new FastMatrixTransform(FastMatrix.rotateToAlignVectors(dArray5, dArray6, dArray3, dArray4));
        int n2 = this.aboveThresholdLengthAlong(principalComponents, 2, this.sourceImages[0], threshold);
        int n3 = this.aboveThresholdLengthAlong(principalComponents2, 2, this.sourceImages[1], threshold2);
        System.out.println("Length in image 0: " + n2);
        System.out.println("Length in image 1: " + n3);
        double d = (double)n2 / (double)n3;
        FastMatrixTransform fastMatrixTransform6 = n2 == 0 || n3 == 0 ? new FastMatrixTransform(1.0) : new FastMatrixTransform(d);
        System.out.println("... so scaling factor is: " + d);
        OrderedTransformations[] orderedTransformationsArray = new OrderedTransformations[4];
        double[] dArray7 = new double[4];
        for (n = 0; n < 4; ++n) {
            orderedTransformationsArray[n] = new OrderedTransformations();
            orderedTransformationsArray[n].addLast(principalComponents2.correctAspect);
            orderedTransformationsArray[n].addLast(fastMatrixTransform);
            orderedTransformationsArray[n].addLast(fastMatrixTransformArray[n]);
            orderedTransformationsArray[n].addLast(fastMatrixTransform6);
            orderedTransformationsArray[n].addLast(fastMatrixTransform2);
            orderedTransformationsArray[n].addLast(fastMatrixTransform5);
            orderedTransformationsArray[n].addLast(principalComponents.correctAspect.inverse());
            System.out.println("... before reduction, transform has " + orderedTransformationsArray[n].number() + " elements:\n" + orderedTransformationsArray[n]);
            orderedTransformationsArray[n].reduce();
            System.out.println("... after reduction, transform has " + orderedTransformationsArray[n].number() + " elements:\n" + orderedTransformationsArray[n]);
            dArray7[n] = orderedTransformationsArray[n].scoreTransformationThresholded(this.sourceImages[0], this.sourceImages[1], threshold, threshold2, 7);
            System.out.println("Score of transformation " + n + " was " + dArray7[n]);
            System.gc();
        }
        n = 0;
        double d2 = dArray7[0];
        for (int i = 1; i < 4; ++i) {
            if (!(dArray7[i] < d2)) continue;
            n = i;
            d2 = dArray7[i];
        }
        System.out.println("Picked transformation with index: " + n + " and score: " + d2);
        orderedTransformationsArray[n].createNewImage(this.sourceImages[0], this.sourceImages[1], true);
    }
}

