/*
 * Decompiled with CFR 0.152.
 */
package vib.oldregistration;

import ij.ImagePlus;
import landmarks.NamedPointSet;
import math3d.Point3d;
import util.BatchOpener;
import util.FileAndChannel;

public abstract class RegistrationAlgorithm {
    public boolean keepSourceImages;
    public ImagePlus[] sourceImages;
    boolean validTransformation = false;

    public ImagePlus getTemplate() {
        return this.sourceImages[0];
    }

    public ImagePlus getDomain() {
        return this.sourceImages[1];
    }

    public ImagePlus getModel() {
        return this.sourceImages[0];
    }

    public ImagePlus getFloating() {
        return this.sourceImages[1];
    }

    public void loadImages(FileAndChannel fileAndChannel, FileAndChannel fileAndChannel2) {
        ImagePlus[] imagePlusArray = BatchOpener.open(fileAndChannel.getPath());
        ImagePlus[] imagePlusArray2 = BatchOpener.open(fileAndChannel2.getPath());
        this.sourceImages = new ImagePlus[2];
        this.sourceImages[0] = imagePlusArray[fileAndChannel.getChannelZeroIndexed()];
        this.sourceImages[1] = imagePlusArray2[fileAndChannel2.getChannelZeroIndexed()];
        this.invalidateTransformation();
    }

    public void invalidateTransformation() {
        this.validTransformation = false;
    }

    public void validateTransformation() {
        this.validTransformation = true;
    }

    public boolean isTransformationValid() {
        return this.validTransformation;
    }

    public void setImages(ImagePlus imagePlus, ImagePlus imagePlus2) {
        if (this.sourceImages == null) {
            this.sourceImages = new ImagePlus[2];
        }
        this.sourceImages[0] = imagePlus;
        this.sourceImages[1] = imagePlus2;
        this.invalidateTransformation();
    }

    public void generateTransformation() {
        throw new RuntimeException("generateTransformation() not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public void transformDomainToTemplate(int n, int n2, int n3, ImagePoint imagePoint) {
        throw new RuntimeException("transformDomainToTemplate() not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public void transformDomainToTemplateWorld(double d, double d2, double d3, Point3d point3d) {
        throw new RuntimeException("transformDomainToTemplateWorld() not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public void transformTemplateToDomain(int n, int n2, int n3, ImagePoint imagePoint) {
        throw new RuntimeException("transformTemplateToDomain() not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public void transformTemplateToDomainWorld(double d, double d2, double d3, Point3d point3d) {
        throw new RuntimeException("transformTemplateToDomainWorld() not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public ImagePlus register() {
        throw new RuntimeException("register() not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public ImagePlus register(NamedPointSet namedPointSet, NamedPointSet namedPointSet2) {
        throw new RuntimeException("register(NamedPointSet,NamedPointSet) not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public static class ImagePoint {
        public int x;
        public int y;
        public int z;
    }
}

