/*
 * Decompiled with CFR 0.152.
 */
package vib.segment;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;

public class Border
implements Cloneable {
    public static final int NONE = 0;
    public static final int LINE = 1;
    public static final int THREED_IN = 2;
    public static final int THREED_OUT = 3;
    public static final int ETCHED_IN = 4;
    public static final int EMBOSSED_OUT = 5;
    public static final int ROUND_RECT = 6;
    private int type = 0;
    private Color border = null;
    private int topMargin = 0;
    private int leftMargin = 0;
    private int bottomMargin = 0;
    private int rightMargin = 0;
    private int minMargin = 0;
    private int maxMargin = 0;
    private int borderThickness = 0;
    private static final double BRIGHTER_FACTOR = 0.8;
    private static final double DARKER_FACTOR = 0.65;

    public static Color brighter(Color color) {
        Color color2 = new Color(Math.min((int)((double)color.getRed() * 1.25), 255), Math.min((int)((double)color.getGreen() * 1.25), 255), Math.min((int)((double)color.getBlue() * 1.25), 255));
        if (color2.equals(color)) {
            return Color.white;
        }
        return color2;
    }

    public static Color darker(Color color) {
        Color color2 = new Color(Math.max((int)((double)color.getRed() * 0.65), 0), Math.max((int)((double)color.getGreen() * 0.65), 0), Math.max((int)((double)color.getBlue() * 0.65), 0));
        if (color2.equals(color)) {
            return Color.black;
        }
        return color2;
    }

    public Object clone() {
        Border border = new Border();
        border.type = this.type;
        border.border = this.border;
        border.topMargin = this.topMargin;
        border.leftMargin = this.leftMargin;
        border.bottomMargin = this.bottomMargin;
        border.rightMargin = this.rightMargin;
        border.minMargin = this.minMargin;
        border.maxMargin = this.maxMargin;
        border.borderThickness = this.borderThickness;
        return border;
    }

    public void setNoInsets() {
        this.topMargin = 0;
        this.leftMargin = 0;
        this.bottomMargin = 0;
        this.rightMargin = 0;
        this.minMargin = 0;
        this.maxMargin = 0;
        this.borderThickness = 0;
    }

    public int getType() {
        return this.type;
    }

    public synchronized void setType(int n) {
        this.type = n;
    }

    public Color getBorder() {
        return this.border;
    }

    public synchronized void setBorder(Color color) {
        this.border = color;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    private void resetMinMaxMargin() {
        this.maxMargin = this.topMargin;
        this.maxMargin = Math.max(this.maxMargin, this.leftMargin);
        this.maxMargin = Math.max(this.maxMargin, this.bottomMargin);
        this.maxMargin = Math.max(this.maxMargin, this.rightMargin);
        this.minMargin = this.topMargin;
        this.minMargin = Math.min(this.minMargin, this.leftMargin);
        this.minMargin = Math.min(this.minMargin, this.bottomMargin);
        this.minMargin = Math.min(this.minMargin, this.rightMargin);
    }

    public synchronized void setMargins(int n) {
        this.topMargin = n;
        this.leftMargin = n;
        this.bottomMargin = n;
        this.rightMargin = n;
        this.resetMinMaxMargin();
    }

    public synchronized void setMargins(int n, int n2, int n3, int n4) {
        this.topMargin = n;
        this.leftMargin = n2;
        this.bottomMargin = n3;
        this.rightMargin = n4;
        this.resetMinMaxMargin();
    }

    public synchronized void setTopMargin(int n) {
        this.topMargin = n;
        this.resetMinMaxMargin();
    }

    public synchronized void setLeftMargin(int n) {
        this.leftMargin = n;
        this.resetMinMaxMargin();
    }

    public synchronized void setBottomMargin(int n) {
        this.bottomMargin = n;
        this.resetMinMaxMargin();
    }

    public synchronized void setRightMargin(int n) {
        this.rightMargin = n;
        this.resetMinMaxMargin();
    }

    public int getBorderThickness() {
        return this.borderThickness;
    }

    public synchronized void setBorderThickness(int n) {
        this.borderThickness = n;
    }

    public Insets getInsets() {
        int n = this.borderThickness + this.topMargin;
        int n2 = this.borderThickness + this.leftMargin;
        int n3 = this.borderThickness + this.bottomMargin;
        int n4 = this.borderThickness + this.rightMargin;
        return new Insets(n, n2, n3, n4);
    }

    public void paint(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        if (this.border == null) {
            this.border = this.type == 1 || this.type == 6 ? (color == Color.black ? Color.white : Color.black) : (color == null ? Color.lightGray : color);
        }
        if (this.border != null) {
            graphics.setColor(this.border);
            Color color2 = null;
            Color color3 = null;
            switch (this.type) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    color2 = Border.brighter(this.border);
                    color3 = Border.darker(this.border);
                }
            }
            for (int i = 0; i < this.borderThickness; ++i) {
                if (this.type == 1) {
                    graphics.drawRect(n + i, n2 + i, n3 - 1 - i * 2, n4 - 1 - i * 2);
                    continue;
                }
                if (this.type == 6) {
                    int n5 = this.minMargin * 8 - i * 2;
                    int n6 = n + i;
                    int n7 = n2 + i;
                    int n8 = n3 - 1 - i * 2;
                    int n9 = n4 - 1 - i * 2;
                    graphics.drawRoundRect(n + i, n2 + i, n8, n9, n5, n5);
                    if (i + 1 >= this.borderThickness) continue;
                    graphics.drawRoundRect(n6, n7, n8, n9 - 1, n5 - 1, n5);
                    graphics.drawRoundRect(n6 + 1, n7, n8, n9 - 1, n5 - 1, n5);
                    graphics.drawRoundRect(n6, n7, n8 - 1, n9, n5, n5 - 1);
                    graphics.drawRoundRect(n6, n7 + 1, n8 - 1, n9, n5, n5 - 1);
                    continue;
                }
                Color color4 = color2;
                Color color5 = color3;
                if (this.type == 2 || this.type == 4) {
                    color4 = color3;
                    color5 = color2;
                }
                if ((this.type == 4 || this.type == 5) && i >= this.borderThickness / 2) {
                    Color color6 = color4;
                    color4 = color5;
                    color5 = color6;
                }
                if (i == this.borderThickness - 1 && this.type == 2) {
                    graphics.setColor(Border.darker(color4));
                } else {
                    graphics.setColor(color4);
                }
                graphics.drawLine(n + i, n2 + i, n + i, n2 + (n4 - 1 - i));
                graphics.drawLine(n + i, n2 + i, n + (n3 - 1 - i), n2 + i);
                if (i == this.borderThickness - 1 && this.type == 2 || i == 0 && this.type == 3) {
                    graphics.setColor(Border.darker(color5));
                } else {
                    graphics.setColor(color5);
                }
                graphics.drawLine(n + i, n2 + (n4 - 1 - i), n + (n3 - 1 - i), n2 + (n4 - 1 - i));
                graphics.drawLine(n + (n3 - 1 - i), n2 + i, n + (n3 - 1 - i), n2 + (n4 - 1 - i));
            }
        }
    }
}

