/*
 * Decompiled with CFR 0.152.
 */
package vib.segment;

import amira.AmiraParameters;
import ij.ImagePlus;
import ij.WindowManager;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import vib.InterpolatedImage;
import vib.segment.CustomCanvas;
import vib.segment.ImageButton;
import vib.segment.MaterialList;

public class Sidebar
extends Panel
implements CustomCanvas.CanvasListener,
ItemListener {
    private CustomCanvas cc;
    private Font font = new Font("Helvetica", 0, 10);
    private GridBagConstraints constr;
    private Label lZoomLevel;
    private ImageButton bZoomPlus;
    private ImageButton bZoomMinus;
    private ImageButton bPlus;
    private ImageButton bMinus;
    private ImageButton bInterpolate;
    private ImageButton bThreshold;
    private ImageButton bOpen;
    private ImageButton bClose;
    private Checkbox check3d;
    private Choice labelImagesChoice;
    private Vector labelImages;
    private ActionListener al;
    private MaterialList materials;
    private Vector defaultMaterials;
    private boolean currentLabelsAreNew = false;

    public Sidebar(CustomCanvas customCanvas, ActionListener actionListener) {
        this.cc = customCanvas;
        this.al = actionListener;
        customCanvas.addCanvasListener(this);
        this.setLayout(new GridBagLayout());
        this.constr = new GridBagConstraints();
        this.constr.fill = 1;
        this.constr.anchor = 17;
        this.constr.gridwidth = 0;
        this.constr.insets = new Insets(0, 5, 0, 5);
        this.addLabel("Labels:");
        this.add((Component)this.addLabelImageChoice(), this.constr);
        this.addLabel("Materials:");
        this.materials = new MaterialList(customCanvas);
        this.add((Component)this.materials, this.constr);
        this.addZoom();
        this.addSelection();
        this.addTools();
        this.itemStateChanged(null);
    }

    public void updateLZoomLevel(double d) {
        this.lZoomLevel.setText(String.valueOf(d));
    }

    public boolean is3d() {
        return this.check3d.getState();
    }

    public int currentMaterialID() {
        return this.materials.currentMaterialID();
    }

    public MaterialList getMaterials() {
        return this.materials;
    }

    public void magnificationChanged(double d) {
        this.updateLZoomLevel(d);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.materials.setBackground(color);
    }

    public void setLabelImage(ImagePlus imagePlus) {
        if (imagePlus == null) {
            imagePlus = InterpolatedImage.cloneDimensionsOnly(this.cc.getImage(), 3).getImage();
            String string = this.cc.getImage().getTitle();
            String string2 = "New Labels";
            if (string.length() > 0) {
                int n = string.lastIndexOf(46);
                string2 = n >= 0 ? string.substring(0, n) + ".labels" : string + ".labels";
            } else {
                imagePlus.setTitle(string2);
            }
            imagePlus.setTitle(string2);
        }
        this.cc.setLabels(imagePlus);
        this.cc.repaint();
        if (this.materials != null) {
            this.materials.initFrom(imagePlus);
            this.materials.repaint();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.labelImagesChoice.getSelectedIndex();
        if (n < this.labelImages.size()) {
            Object e = this.labelImages.get(n);
            this.setLabelImage((ImagePlus)e);
            this.currentLabelsAreNew = false;
            this.cc.requestFocus();
            return;
        }
        String string = (String)this.defaultMaterials.get(n -= this.labelImages.size());
        if (!this.currentLabelsAreNew) {
            this.setLabelImage(null);
        }
        ImagePlus imagePlus = this.cc.getLabels();
        AmiraParameters amiraParameters = new AmiraParameters(string);
        amiraParameters.setParameters(imagePlus);
        this.setLabelImage(imagePlus);
        this.materials.params = amiraParameters;
        this.currentLabelsAreNew = true;
        this.cc.requestFocus();
    }

    private ImageButton addImageButton(String string, ActionListener actionListener) {
        Image image = null;
        try {
            URL uRL = this.getClass().getResource("icons/" + string);
            image = this.createImage((ImageProducer)uRL.getContent());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (image == null) {
            throw new RuntimeException("Image not found: " + string);
        }
        ImageButton imageButton = new ImageButton(image);
        imageButton.addActionListener(actionListener);
        this.add((Component)imageButton, this.constr);
        return imageButton;
    }

    private Label addLabel(String string) {
        this.constr.insets = new Insets(10, 5, 0, 5);
        Label label = new Label(string);
        label.setFont(this.font);
        this.add((Component)label, this.constr);
        this.constr.insets = new Insets(0, 5, 0, 5);
        return label;
    }

    private Choice addLabelImageChoice() {
        Object object;
        this.labelImagesChoice = new Choice();
        this.labelImages = new Vector();
        this.defaultMaterials = new Vector();
        int n = WindowManager.getWindowCount();
        for (int i = 0; i < n; ++i) {
            object = WindowManager.getImage((int)(i + 1));
            if (!AmiraParameters.isAmiraLabelfield(object) || object == this.cc.getImage() || object.getWidth() != this.cc.getImage().getWidth() || object.getHeight() != this.cc.getImage().getHeight() || object.getStack().getSize() != this.cc.getImage().getStack().getSize()) continue;
            this.labelImagesChoice.add(object.getTitle());
            this.labelImages.add(object);
        }
        URL uRL = this.getClass().getResource("materials/CompactStandard");
        object = this.readURL(uRL);
        this.defaultMaterials.add(object);
        this.labelImagesChoice.add("CompactStandard");
        this.labelImagesChoice.add("<new>");
        this.defaultMaterials.add("Parameters {\n\tMaterials {\n\t\tExterior {\n\t\t\tColor 0.0 0.0 0.0\n\t\t}\n\t\tInterior {\n\t\t\tColor 1.0 0.0 0.0\n\t\t}\n\t}\n}\n");
        this.labelImagesChoice.addItemListener(this);
        return this.labelImagesChoice;
    }

    private void addZoom() {
        this.addLabel("Zoom:");
        this.constr.gridwidth = 1;
        this.bZoomPlus = this.addImageButton("iconZoomPlus.png", this.al);
        this.bZoomPlus.setActionCommand("zoomin");
        this.bZoomMinus = this.addImageButton("iconZoomMinus.png", this.al);
        this.bZoomMinus.setActionCommand("zoomout");
        this.constr.gridwidth = 0;
        this.constr.fill = 0;
        this.lZoomLevel = this.addLabel(String.valueOf(this.cc.getMagnification()));
        this.constr.fill = 1;
    }

    private void addSelection() {
        this.constr.gridwidth = 0;
        this.addLabel("Selection:");
        this.constr.gridwidth = 1;
        this.bPlus = this.addImageButton("iconPlus.png", this.al);
        this.bPlus.setActionCommand("plus");
        this.bMinus = this.addImageButton("iconMinus.png", this.al);
        this.bMinus.setActionCommand("minus");
        this.constr.gridwidth = 0;
        this.constr.fill = 0;
        this.check3d = new Checkbox("3d", false);
        this.add((Component)this.check3d, this.constr);
        this.constr.fill = 1;
    }

    private void addTools() {
        this.constr.gridwidth = 0;
        this.addLabel("Tools:");
        this.constr.gridwidth = 1;
        this.bInterpolate = this.addImageButton("iconInterpolate.png", this.al);
        this.bInterpolate.setActionCommand("interpolate");
        this.bThreshold = this.addImageButton("iconThreshold.png", this.al);
        this.bThreshold.setActionCommand("threshold");
        this.bOpen = this.addImageButton("iconOpen.png", this.al);
        this.bOpen.setActionCommand("open");
        this.bClose = this.addImageButton("iconClose.png", this.al);
        this.bClose.setActionCommand("close");
        this.constr.fill = 1;
    }

    private String readURL(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            InputStream inputStream = uRL.openStream();
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            return new String(stringBuffer);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

