/*
 * Decompiled with CFR 0.152.
 */
package vib.transforms;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import math3d.Point3d;
import vib.transforms.BoundsInclusive;
import vib.transforms.Threshold;
import vib.transforms.Transform;

public class OrderedTransformations {
    private ArrayList<Transform> listOfTransforms = new ArrayList();

    public Object clone() {
        ArrayList arrayList;
        OrderedTransformations orderedTransformations = new OrderedTransformations();
        orderedTransformations.listOfTransforms = arrayList = (ArrayList)this.listOfTransforms.clone();
        return orderedTransformations;
    }

    public void addFirst(Transform transform) {
        this.listOfTransforms.add(0, transform);
    }

    public void addLast(Transform transform) {
        this.listOfTransforms.add(transform);
    }

    public void addFirst(OrderedTransformations orderedTransformations) {
        int n = 0;
        for (Transform transform : orderedTransformations.listOfTransforms) {
            this.listOfTransforms.add(n, transform);
            ++n;
        }
    }

    public void addLast(OrderedTransformations orderedTransformations) {
        for (Transform transform : orderedTransformations.listOfTransforms) {
            this.addLast(transform);
        }
    }

    public int number() {
        return this.listOfTransforms.size();
    }

    public Transform getComponentTransform(int n) {
        return this.listOfTransforms.get(n);
    }

    public String toString() {
        String string = "";
        int n = 0;
        for (Transform transform : this.listOfTransforms) {
            string = string + "Transformation " + n + " is:\n";
            string = string + transform.toStringIndented("   ");
            ++n;
        }
        return string;
    }

    public void reduce() {
        Object object;
        Iterator<Transform> iterator = this.listOfTransforms.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!object.isIdentity()) continue;
            iterator.remove();
        }
        object = new ArrayList();
        Transform transform = null;
        iterator = this.listOfTransforms.iterator();
        while (iterator.hasNext()) {
            if (transform == null) {
                transform = iterator.next();
            }
            while (iterator.hasNext()) {
                Transform transform2 = iterator.next();
                Transform transform3 = transform.composeWith(transform2);
                if (transform3 == null) {
                    ((ArrayList)object).add(transform);
                    transform = transform2;
                    break;
                }
                transform = transform3;
            }
            if (iterator.hasNext() || transform == null) continue;
            ((ArrayList)object).add(transform);
        }
        this.listOfTransforms = object;
    }

    public OrderedTransformations inverse() {
        Object object;
        ArrayList<Transform> arrayList = new ArrayList<Transform>();
        ListIterator<Transform> listIterator = this.listOfTransforms.listIterator();
        while (listIterator.hasNext()) {
            listIterator.next();
        }
        while (listIterator.hasPrevious()) {
            object = listIterator.previous();
            Transform transform = object.inverse();
            arrayList.add(transform);
        }
        object = new OrderedTransformations();
        ((OrderedTransformations)object).listOfTransforms = arrayList;
        return object;
    }

    public void apply(double d, double d2, double d3, double[] dArray) {
        for (Transform transform : this.listOfTransforms) {
            transform.apply(d, d2, d3, dArray);
            d = dArray[0];
            d2 = dArray[1];
            d3 = dArray[2];
        }
    }

    public double[] apply(double d, double d2, double d3) {
        double[] dArray = new double[3];
        for (Transform transform : this.listOfTransforms) {
            transform.apply(d, d2, d3, dArray);
            d = dArray[0];
            d2 = dArray[1];
            d3 = dArray[2];
        }
        return dArray;
    }

    public Point3d apply(Point3d point3d) {
        double[] dArray = this.apply(point3d.x, point3d.y, point3d.z);
        return new Point3d(dArray[0], dArray[1], dArray[2]);
    }

    public double scoreTransformation(ImagePlus imagePlus, ImagePlus imagePlus2, int n) {
        return this.scoreTransformationReal(imagePlus, imagePlus2, n, null);
    }

    public double scoreTransformation(ImagePlus imagePlus, ImagePlus imagePlus2, BoundsInclusive boundsInclusive) {
        return this.scoreTransformationReal(imagePlus, imagePlus2, 0, boundsInclusive);
    }

    public double scoreTransformation(ImagePlus imagePlus, ImagePlus imagePlus2, int n, BoundsInclusive boundsInclusive) {
        return this.scoreTransformationReal(imagePlus, imagePlus2, n, boundsInclusive);
    }

    public double scoreTransformationReal(ImagePlus imagePlus, ImagePlus imagePlus2, int n, BoundsInclusive boundsInclusive) {
        OrderedTransformations orderedTransformations = this.inverse();
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = imagePlus2.getStack();
        int n2 = imageStack.getSize();
        int n3 = imageStack.getHeight();
        int n4 = imageStack.getWidth();
        int n5 = imageStack2.getSize();
        int n6 = imageStack2.getHeight();
        int n7 = imageStack2.getWidth();
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = n4 - 1;
        int n12 = n3 - 1;
        int n13 = n2 - 1;
        if (boundsInclusive != null) {
            n8 = boundsInclusive.xmin;
            n9 = boundsInclusive.ymin;
            n10 = boundsInclusive.zmin;
            n11 = boundsInclusive.xmax;
            n12 = boundsInclusive.ymax;
            n13 = boundsInclusive.zmax;
        }
        double[] dArray = new double[3];
        long l = 0L;
        long l2 = 0L;
        for (int i = n10; i <= n13; i += 1 + n) {
            byte[] byArray = (byte[])imageStack.getPixels(i + 1);
            for (int j = n9; j <= n12; j += 1 + n) {
                for (int k = n8; k <= n11; k += 1 + n) {
                    orderedTransformations.apply(k, j, i, dArray);
                    int n14 = (int)dArray[0];
                    int n15 = (int)dArray[1];
                    int n16 = (int)dArray[2];
                    int n17 = 0xFF & byArray[k + j * n4];
                    if (n14 < 0 || n14 >= n7 || n15 < 0 || n15 >= n6 || n16 < 0 || n16 >= n5) continue;
                    byte[] byArray2 = (byte[])imageStack2.getPixels(n16 + 1);
                    int n18 = 0xFF & byArray2[n14 + n15 * n7];
                    int n19 = n18 - n17;
                    l2 += (long)(n19 * n19);
                    ++l;
                }
            }
        }
        return Math.sqrt((double)l2 / (double)l);
    }

    public double scoreTransformationThresholdedReal(ImagePlus imagePlus, ImagePlus imagePlus2, Threshold threshold, Threshold threshold2, int n, BoundsInclusive boundsInclusive) {
        OrderedTransformations orderedTransformations = this.inverse();
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = imagePlus2.getStack();
        int n2 = imageStack.getSize();
        int n3 = imageStack.getHeight();
        int n4 = imageStack.getWidth();
        int n5 = imageStack2.getSize();
        int n6 = imageStack2.getHeight();
        int n7 = imageStack2.getWidth();
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = n4 - 1;
        int n12 = n3 - 1;
        int n13 = n2 - 1;
        if (boundsInclusive != null) {
            n8 = boundsInclusive.xmin;
            n9 = boundsInclusive.ymin;
            n10 = boundsInclusive.zmin;
            n11 = boundsInclusive.xmax;
            n12 = boundsInclusive.ymax;
            n13 = boundsInclusive.zmax;
        }
        double[] dArray = new double[3];
        long l = 0L;
        long l2 = 0L;
        for (int i = n10; i <= n13; i += 1 + n) {
            byte[] byArray = (byte[])imageStack.getPixels(i + 1);
            for (int j = n9; j <= n12; j += 1 + n) {
                for (int k = n8; k <= n11; k += 1 + n) {
                    int n14;
                    orderedTransformations.apply(k, j, i, dArray);
                    int n15 = (int)dArray[0];
                    int n16 = (int)dArray[1];
                    int n17 = (int)dArray[2];
                    int n18 = 0xFF & byArray[k + j * n4];
                    if (n18 < threshold.value) {
                        n18 = 0;
                    }
                    if (n15 >= 0 && n15 < n7 && n16 >= 0 && n16 < n6 && n17 >= 0 && n17 < n5) {
                        byte[] byArray2 = (byte[])imageStack2.getPixels(n17 + 1);
                        n14 = 0xFF & byArray2[n15 + n16 * n7];
                        if (n14 < threshold2.value) {
                            n14 = 0;
                        }
                    } else {
                        n14 = 0;
                    }
                    int n19 = n14 - n18;
                    l2 += (long)(n19 * n19);
                    ++l;
                }
            }
        }
        return Math.sqrt((double)l2 / (double)l);
    }

    public double scoreTransformationThresholded(ImagePlus imagePlus, ImagePlus imagePlus2, Threshold threshold, Threshold threshold2, BoundsInclusive boundsInclusive) {
        return this.scoreTransformationThresholdedReal(imagePlus, imagePlus2, threshold, threshold2, 0, boundsInclusive);
    }

    public double scoreTransformationThresholded(ImagePlus imagePlus, ImagePlus imagePlus2, Threshold threshold, Threshold threshold2) {
        return this.scoreTransformationThresholdedReal(imagePlus, imagePlus2, threshold, threshold2, 0, null);
    }

    public double scoreTransformationThresholded(ImagePlus imagePlus, ImagePlus imagePlus2, Threshold threshold, Threshold threshold2, int n) {
        return this.scoreTransformationThresholdedReal(imagePlus, imagePlus2, threshold, threshold2, n, null);
    }

    public ImagePlus createNewImageReal(ImagePlus imagePlus, ImagePlus imagePlus2, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object;
        int n7;
        System.out.println("      createNewImageReal called with overlay: " + bl);
        System.out.println("                                      image0: " + imagePlus);
        System.out.println("                                      image1: " + imagePlus2);
        System.out.println("                                        xmin: " + n);
        System.out.println("                                        xmax: " + n2);
        System.out.println("                                        ymin: " + n3);
        System.out.println("                                        ymax: " + n4);
        System.out.println("                                        zmin: " + n5);
        System.out.println("                                        zmax: " + n6);
        int n8 = n2 - n + 1;
        int n9 = n4 - n3 + 1;
        int n10 = n6 - n5 + 1;
        assert (n2 >= n);
        assert (n4 >= n3);
        assert (n6 >= n5);
        assert (imagePlus2 != null);
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        ImageStack imageStack = null;
        if (imagePlus != null) {
            n11 = imagePlus.getWidth();
            n12 = imagePlus.getHeight();
            imageStack = imagePlus.getStack();
            n13 = imageStack.getSize();
        }
        ImageStack imageStack2 = imagePlus2.getStack();
        int n14 = imageStack2.getWidth();
        int n15 = imageStack2.getHeight();
        int n16 = imageStack2.getSize();
        assert (imagePlus != null || !bl);
        if (imagePlus != null && imagePlus.getType() != 0) {
            IJ.error((String)"OrderedTransformations.createNewImageReal() can onlybe used on 8 bit image, at the moment.");
            return null;
        }
        if (imagePlus2.getType() != 0) {
            IJ.error((String)"OrderedTransformations.createNewImageReal() can onlybe used on 8 bit image, at the moment.");
            return null;
        }
        ImageStack imageStack3 = new ImageStack(n8, n9);
        boolean bl2 = true;
        Object object2 = null;
        if (bl2) {
            object2 = new byte[n16][];
            for (n7 = 0; n7 < n16; ++n7) {
                object2[n7] = (byte[])imageStack2.getPixels(n7 + 1);
            }
        }
        OrderedTransformations orderedTransformations = this.inverse();
        for (n7 = 0; n7 < n10; ++n7) {
            Object object3;
            int n17 = n7 + n5;
            object = new byte[n8 * n9];
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (bl) {
                byArray2 = new byte[n8 * n9];
                byArray = n17 >= 0 && n17 < imageStack.getSize() ? (byte[])imageStack.getPixels(n17 + 1) : new byte[imagePlus.getWidth() * imagePlus.getHeight()];
            }
            double[] dArray = new double[3];
            for (int i = 0; i < n9; ++i) {
                for (int j = 0; j < n8; ++j) {
                    int n18 = i + n3;
                    int n19 = j + n;
                    orderedTransformations.apply(n19, n18, n17, dArray);
                    int n20 = (int)dArray[0];
                    int n21 = (int)dArray[1];
                    int n22 = (int)dArray[2];
                    if (n20 >= 0 && n20 < n14 && n21 >= 0 && n21 < n15 && n22 >= 0 && n22 < n16) {
                        if (bl2) {
                            object[j + i * n8] = object2[n22][n20 + n21 * n14];
                        } else {
                            object3 = (byte[])imageStack2.getPixels(n22 + 1);
                            object[j + i * n8] = (byte)object3[n20 + n21 * n14];
                        }
                    }
                    if (n17 >= 0 && n17 < n13 && n19 >= 0 && n19 < n11 && n18 >= 0 && n18 < n12) {
                        byArray2[j + i * n8] = byArray[n19 + n18 * n11];
                    }
                    IJ.showProgress((double)((double)(n7 + 1) / (double)n10));
                }
            }
            if (bl) {
                object3 = new ColorProcessor(n8, n9);
                object3.setRGB(byArray2, (byte[])object, byArray2);
                imageStack3.addSlice(null, (ImageProcessor)object3);
                continue;
            }
            object3 = new ByteProcessor(n8, n9);
            object3.setPixels(object);
            imageStack3.addSlice(null, (ImageProcessor)object3);
        }
        IJ.showProgress((double)1.0);
        object = bl ? (Object)new ImagePlus("overlay of " + imagePlus.getShortTitle() + " and transformed " + imagePlus2.getShortTitle(), imageStack3) : (Object)new ImagePlus("transformation of " + imagePlus2.getShortTitle(), imageStack3);
        if (imagePlus != null) {
            object.setCalibration(imagePlus.getCalibration());
        }
        return object;
    }

    public ImagePlus createNewImage(ImagePlus imagePlus, ImagePlus imagePlus2, boolean bl) {
        int n = imagePlus.getWidth();
        int n2 = imagePlus2.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = imagePlus2.getHeight();
        int n5 = imagePlus.getStack().getSize();
        int n6 = imagePlus2.getStack().getSize();
        if (bl) {
            return this.createNewImageReal(imagePlus, imagePlus2, 0, n - 1, 0, n3 - 1, 0, n5 - 1, true);
        }
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(0.0, 0.0, n6 - 1);
        Point3d point3d3 = new Point3d(0.0, n4 - 1, 0.0);
        Point3d point3d4 = new Point3d(0.0, n4 - 1, n6 - 1);
        Point3d point3d5 = new Point3d(n2 - 1, 0.0, 0.0);
        Point3d point3d6 = new Point3d(n2 - 1, 0.0, n6 - 1);
        Point3d point3d7 = new Point3d(n2 - 1, n4 - 1, 0.0);
        Point3d point3d8 = new Point3d(n2 - 1, n4 - 1, n6 - 1);
        Point3d point3d9 = this.apply(point3d);
        Point3d point3d10 = this.apply(point3d2);
        Point3d point3d11 = this.apply(point3d3);
        Point3d point3d12 = this.apply(point3d4);
        Point3d point3d13 = this.apply(point3d5);
        Point3d point3d14 = this.apply(point3d6);
        Point3d point3d15 = this.apply(point3d7);
        Point3d point3d16 = this.apply(point3d8);
        double[] dArray = new double[]{point3d9.x, point3d10.x, point3d11.x, point3d12.x, point3d13.x, point3d14.x, point3d15.x, point3d16.x};
        double[] dArray2 = new double[]{point3d9.y, point3d10.y, point3d11.y, point3d12.y, point3d13.y, point3d14.y, point3d15.y, point3d16.y};
        double[] dArray3 = new double[]{point3d9.z, point3d10.z, point3d11.z, point3d12.z, point3d13.z, point3d14.z, point3d15.z, point3d16.z};
        Arrays.sort(dArray);
        Arrays.sort(dArray2);
        Arrays.sort(dArray3);
        double d = dArray[0];
        double d2 = dArray2[0];
        double d3 = dArray3[0];
        double d4 = dArray[7];
        double d5 = dArray2[7];
        double d6 = dArray3[7];
        int n7 = (int)Math.floor(d);
        int n8 = (int)Math.floor(d2);
        int n9 = (int)Math.floor(d3);
        int n10 = (int)Math.ceil(d4);
        int n11 = (int)Math.ceil(d5);
        int n12 = (int)Math.ceil(d6);
        int n13 = n10 - n7 + 1;
        int n14 = n11 - n8 + 1;
        int n15 = n12 - n9 + 1;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        if (n7 < 0) {
            n16 = -n7;
        }
        if (n8 < 0) {
            n17 = -n8;
        }
        if (n9 < 0) {
            n18 = -n9;
        }
        int n19 = Math.max(n, n10 + 1) - Math.min(0, n7);
        int n20 = Math.max(n3, n11 + 1) - Math.min(0, n8);
        int n21 = Math.max(n5, n12 + 1) - Math.min(0, n9);
        return this.createNewImageReal(imagePlus, imagePlus2, -n16, n19 - n16, -n17, n20 - n17, -n18, n21 - n18, true);
    }

    public ImagePlus createNewImageSingle(ImagePlus imagePlus, int n, int n2, int n3, int n4, int n5, int n6) {
        return this.createNewImageReal(null, imagePlus, n, n2, n3, n4, n5, n6, false);
    }

    public ImagePlus createNewImageSingle(ImagePlus imagePlus, ImagePlus imagePlus2, boolean bl) {
        int n = imagePlus.getWidth();
        int n2 = imagePlus2.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = imagePlus2.getHeight();
        int n5 = imagePlus.getStack().getSize();
        int n6 = imagePlus2.getStack().getSize();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (bl) {
            return this.createNewImageReal(null, imagePlus2, 0, n - 1, 0, n3 - 1, 0, n5 - 1, false);
        }
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(0.0, 0.0, n6 - 1);
        Point3d point3d3 = new Point3d(0.0, n4 - 1, 0.0);
        Point3d point3d4 = new Point3d(0.0, n4 - 1, n6 - 1);
        Point3d point3d5 = new Point3d(n2 - 1, 0.0, 0.0);
        Point3d point3d6 = new Point3d(n2 - 1, 0.0, n6 - 1);
        Point3d point3d7 = new Point3d(n2 - 1, n4 - 1, 0.0);
        Point3d point3d8 = new Point3d(n2 - 1, n4 - 1, n6 - 1);
        Point3d point3d9 = this.apply(point3d);
        Point3d point3d10 = this.apply(point3d2);
        Point3d point3d11 = this.apply(point3d3);
        Point3d point3d12 = this.apply(point3d4);
        Point3d point3d13 = this.apply(point3d5);
        Point3d point3d14 = this.apply(point3d6);
        Point3d point3d15 = this.apply(point3d7);
        Point3d point3d16 = this.apply(point3d8);
        double[] dArray = new double[]{point3d9.x, point3d10.x, point3d11.x, point3d12.x, point3d13.x, point3d14.x, point3d15.x, point3d16.x};
        double[] dArray2 = new double[]{point3d9.y, point3d10.y, point3d11.y, point3d12.y, point3d13.y, point3d14.y, point3d15.y, point3d16.y};
        double[] dArray3 = new double[]{point3d9.z, point3d10.z, point3d11.z, point3d12.z, point3d13.z, point3d14.z, point3d15.z, point3d16.z};
        Arrays.sort(dArray);
        Arrays.sort(dArray2);
        Arrays.sort(dArray3);
        double d = dArray[0];
        double d2 = dArray2[0];
        double d3 = dArray3[0];
        double d4 = dArray[7];
        double d5 = dArray2[7];
        double d6 = dArray3[7];
        int n7 = (int)Math.floor(d);
        int n8 = (int)Math.floor(d2);
        int n9 = (int)Math.floor(d3);
        int n10 = (int)Math.ceil(d4);
        int n11 = (int)Math.ceil(d5);
        int n12 = (int)Math.ceil(d6);
        int n13 = n10 - n7 + 1;
        int n14 = n11 - n8 + 1;
        int n15 = n12 - n9 + 1;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        if (n7 < 0) {
            n16 = -n7;
        }
        if (n8 < 0) {
            n17 = -n8;
        }
        if (n9 < 0) {
            n18 = -n9;
        }
        int n19 = n10 - n7;
        int n20 = n11 - n8;
        int n21 = n12 - n9;
        return this.createNewImageReal(null, imagePlus2, -n16, n19 - n16, -n17, n20 - n17, -n18, n21 - n18, false);
    }
}

