/*
 * Decompiled with CFR 0.152.
 */
package video;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BoxLayout;
import video.VideoStack;

public class Edit_Video
implements PlugIn,
ActionListener {
    private VideoStack stack;
    private ImagePlus preview;
    private int speed = 10;
    private int color = 0xFF0000;
    private int alpha = 128;
    private int linewidth = 2;

    public void setColor(int n) {
        this.color = n;
    }

    public int getColor() {
        return this.color;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int n) {
        this.speed = n;
    }

    public void setLinewidth(int n) {
        this.linewidth = n;
    }

    public int getLinewidth() {
        return this.linewidth;
    }

    public VideoStack getStack() {
        return this.stack;
    }

    public void run(String string) {
        GenericDialog genericDialog = new GenericDialog("Video editing");
        Panel panel = new Panel();
        BoxLayout boxLayout = new BoxLayout(panel, 1);
        panel.setLayout(boxLayout);
        BorderPanel borderPanel = new BorderPanel();
        borderPanel.setLayout(new GridLayout(1, 2, 5, 5));
        borderPanel.add(new Label("Open video"));
        Button button = new Button("Open");
        button.addActionListener(this);
        borderPanel.add(button);
        panel.add(borderPanel);
        borderPanel = new BorderPanel();
        borderPanel.setLayout(new GridLayout(3, 2));
        borderPanel.add(new Label("Add empty frame"));
        button = new Button("Add Frame");
        button.addActionListener(this);
        borderPanel.add(button);
        borderPanel.add(new Label("Copy frame"));
        button = new Button("Copy Frame");
        button.addActionListener(this);
        borderPanel.add(button);
        borderPanel.add(new Label("Delete Frame"));
        button = new Button("Delete Frame");
        button.addActionListener(this);
        borderPanel.add(button);
        panel.add(borderPanel);
        borderPanel = new BorderPanel();
        borderPanel.setLayout(new GridLayout(2, 2));
        borderPanel.add(new Label("Open Frame"));
        button = new Button("Open Frame");
        button.addActionListener(this);
        borderPanel.add(button);
        borderPanel.add(new Label("Set Frame"));
        button = new Button("Set Frame");
        button.addActionListener(this);
        borderPanel.add(button);
        panel.add(borderPanel);
        borderPanel = new BorderPanel();
        borderPanel.setLayout(new GridLayout(6, 2));
        borderPanel.add(new Label("Fade over"));
        button = new Button("Fade over");
        button.addActionListener(this);
        borderPanel.add(button);
        borderPanel.add(new Label("Draw Line"));
        button = new Button("Draw Line");
        button.addActionListener(this);
        borderPanel.add(button);
        borderPanel.add(new Label("Draw Oval"));
        button = new Button("Draw Oval");
        button.addActionListener(this);
        borderPanel.add(button);
        borderPanel.add(new Label("Draw Roi"));
        button = new Button("Draw Roi");
        button.addActionListener(this);
        borderPanel.add(button);
        borderPanel.add(new Label("Fill Roi transparent"));
        button = new Button("Fill Roi transparent");
        button.addActionListener(this);
        borderPanel.add(button);
        borderPanel.add(new Label("Move Selection"));
        button = new Button("Move Selection");
        button.addActionListener(this);
        borderPanel.add(button);
        panel.add(borderPanel);
        borderPanel = new BorderPanel();
        borderPanel.setLayout(new GridLayout(2, 2));
        borderPanel.add(new Label("Create AVI"));
        button = new Button("Create AVI");
        button.addActionListener(this);
        borderPanel.add(button);
        borderPanel.add(new Label("Play AVI"));
        button = new Button("Play AVI");
        button.addActionListener(this);
        borderPanel.add(button);
        panel.add(borderPanel);
        genericDialog.addPanel(panel);
        genericDialog.setModal(false);
        genericDialog.showDialog();
        boxLayout.layoutContainer(panel);
        panel.repaint();
        if (genericDialog.wasCanceled()) {
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Open")) {
            this.open();
        } else if (actionEvent.getActionCommand().equals("Add Frame")) {
            this.addFrame();
        } else if (actionEvent.getActionCommand().equals("Copy Frame")) {
            this.copyFrame();
        } else if (actionEvent.getActionCommand().equals("Open Frame")) {
            this.openFrame();
        } else if (actionEvent.getActionCommand().equals("Set Frame")) {
            this.setFrame();
        } else if (actionEvent.getActionCommand().equals("Delete Frame")) {
            this.deleteFrame();
        } else if (actionEvent.getActionCommand().equals("Fade over")) {
            this.fadeOver();
        } else if (actionEvent.getActionCommand().equals("Draw Line")) {
            this.drawLine();
        } else if (actionEvent.getActionCommand().equals("Draw Roi")) {
            this.drawRoi();
        } else if (actionEvent.getActionCommand().equals("Fill Roi transparent")) {
            this.fillRoiTransparent();
        } else if (actionEvent.getActionCommand().equals("Draw Oval")) {
            this.drawOval();
        } else if (actionEvent.getActionCommand().equals("Move Selection")) {
            this.moveSelection();
        } else if (actionEvent.getActionCommand().equals("Create AVI")) {
            this.createAVI();
        } else if (actionEvent.getActionCommand().equals("Play AVI")) {
            this.playAVI();
        }
        System.out.println("done");
    }

    public void open() {
        this.stack = new VideoStack();
        String string = "/home/bene/Desktop/video";
        String string2 = "template";
        String string3 = "png";
        this.stack.open(string, string2, string3);
        this.preview = new ImagePlus("Preview", this.stack.getPreview());
        this.preview.show();
    }

    public void addFrame() {
        int n = this.preview.getCurrentSlice();
        this.stack.addSlice(n, null);
        this.preview.setSlice(n + 1);
        this.preview.updateAndDraw();
    }

    public void copyFrame() {
        int n = this.preview.getCurrentSlice();
        ImageProcessor imageProcessor = this.stack.getProcessor(n);
        this.stack.addSlice(n, imageProcessor);
        this.preview.setSlice(n + 1);
        this.preview.updateAndDraw();
    }

    public void openFrame() {
        int n = this.preview.getCurrentSlice();
        ImageProcessor imageProcessor = this.stack.getProcessor(n);
        new ImagePlus(this.stack.getPreview().getSliceLabel(n), imageProcessor).show();
    }

    public void setFrame() {
        int n = this.preview.getCurrentSlice();
        if (!IJ.getImage().getTitle().equals(this.stack.getPreview().getSliceLabel(n))) {
            return;
        }
        ImageProcessor imageProcessor = IJ.getImage().getProcessor();
        this.stack.setSlice(n, imageProcessor);
        IJ.getImage().changes = false;
        IJ.getImage().close();
        this.preview.setStack(null, this.stack.getPreview());
        this.preview.setSlice(n);
    }

    public void deleteFrame() {
        int n = this.preview.getCurrentSlice();
        this.stack.deleteSlice(n);
        this.preview.setStack(null, this.stack.getPreview());
        this.preview.setSlice(n);
    }

    public void fadeOver() {
        this.fade(20);
    }

    public void drawLine() {
        int n = this.preview.getCurrentSlice();
        ImagePlus imagePlus = IJ.getImage();
        if (!imagePlus.getTitle().equals(this.stack.getPreview().getSliceLabel(n))) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null || roi.getType() != 5) {
            return;
        }
        Line line = (Line)roi;
        int n2 = this.drawLine(line.x1, line.y1, line.x2, line.y2, this.speed);
        this.preview.setSlice(n + n2);
        imagePlus.changes = false;
        imagePlus.close();
    }

    public void drawRoi() {
        int n = this.preview.getCurrentSlice();
        ImagePlus imagePlus = IJ.getImage();
        if (!imagePlus.getTitle().equals(this.stack.getPreview().getSliceLabel(n))) {
            IJ.error((String)"frame name and preview slice are not the same");
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Roi[] roiArray = null;
        if (roi.getType() == 9) {
            roiArray = ((ShapeRoi)roi).getRois();
        } else if (roi instanceof PolygonRoi) {
            roiArray = new Roi[]{roi};
        } else {
            IJ.error((String)"Composite or polygon roi required");
            return;
        }
        int n2 = 0;
        for (int i = 0; i < roiArray.length; ++i) {
            if (!(roiArray[i] instanceof PolygonRoi)) continue;
            this.preview.setSlice(n + (n2 += this.drawRoi(roiArray[i], this.speed)));
        }
        imagePlus.changes = false;
        imagePlus.close();
    }

    public void fillRoiTransparent() {
        int n = this.preview.getCurrentSlice();
        ImagePlus imagePlus = IJ.getImage();
        if (!imagePlus.getTitle().equals(this.stack.getPreview().getSliceLabel(n))) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Roi[] roiArray = null;
        if (roi.getType() == 9) {
            roiArray = ((ShapeRoi)roi).getRois();
        } else if (roi instanceof PolygonRoi) {
            roiArray = new Roi[]{roi};
        } else {
            IJ.error((String)"Composite or polygon roi required");
            return;
        }
        for (int i = 0; i < roiArray.length; ++i) {
            if (!(roiArray[i] instanceof PolygonRoi)) continue;
            this.fillRoiTransparent(roiArray[i]);
        }
        imagePlus.changes = false;
        imagePlus.close();
    }

    public void drawOval() {
        int n = this.preview.getCurrentSlice();
        ImagePlus imagePlus = IJ.getImage();
        if (!imagePlus.getTitle().equals(this.stack.getPreview().getSliceLabel(n))) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null || roi.getType() != 1) {
            return;
        }
        Rectangle rectangle = roi.getBounds();
        this.drawCircle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        imagePlus.changes = false;
        imagePlus.close();
    }

    public void moveSelection() {
        int n = this.preview.getCurrentSlice();
        ImagePlus imagePlus = IJ.getImage();
        if (!imagePlus.getTitle().equals(this.stack.getPreview().getSliceLabel(n))) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            return;
        }
        GenericDialog genericDialog = new GenericDialog("Move selection");
        genericDialog.addNumericField("dx", 0.0, 0);
        genericDialog.addNumericField("dy", 0.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.moveSelection(roi, (int)genericDialog.getNextNumber(), (int)genericDialog.getNextNumber());
        imagePlus.changes = false;
        imagePlus.close();
    }

    public void moveSelection(Roi roi, int n, int n2) {
        int n3 = roi.getBounds().x;
        int n4 = roi.getBounds().y;
        int n5 = this.preview.getCurrentSlice();
        int n6 = n > n2 ? n : n2;
        ImageProcessor imageProcessor = this.stack.getProcessor(n5);
        imageProcessor.setRoi(roi);
        ImageProcessor imageProcessor2 = imageProcessor.crop();
        for (int i = 0; i < n6; ++i) {
            int n7 = n3 + Math.round((float)i * (float)n / (float)n6);
            int n8 = n4 + Math.round((float)i * (float)n2 / (float)n6);
            ImageProcessor imageProcessor3 = imageProcessor.duplicate();
            imageProcessor3.snapshot();
            roi.setLocation(n7, n8);
            imageProcessor3.setRoi(roi);
            imageProcessor3.copyBits(imageProcessor2, n7, n8, 14);
            imageProcessor3.reset(imageProcessor3.getMask());
            if (!this.stack.addSlice(n5 + i, imageProcessor3)) break;
        }
    }

    public void drawCircle(int n, int n2, int n3, int n4) {
        int n5 = this.preview.getCurrentSlice();
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        float[] fArray = new float[6];
        boolean bl = false;
        ImageProcessor imageProcessor = this.stack.getProcessor(n5);
        int n6 = 0;
        while (!bl) {
            imageProcessor = imageProcessor.convertToRGB();
            imageProcessor.setValue((double)this.color);
            imageProcessor.setLineWidth(this.linewidth);
            FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(float_.getPathIterator(null), 1.0);
            flatteningPathIterator.currentSegment(fArray);
            imageProcessor.moveTo((int)fArray[0], (int)fArray[1]);
            flatteningPathIterator.next();
            for (int i = 0; i < n6; ++i) {
                flatteningPathIterator.currentSegment(fArray);
                imageProcessor.lineTo((int)fArray[0], (int)fArray[1]);
                flatteningPathIterator.next();
                bl = flatteningPathIterator.isDone();
            }
            if (!this.stack.addSlice(n5 + n6, imageProcessor)) break;
            ++n6;
        }
    }

    public int drawRoi(Roi roi, int n) {
        int n2 = this.preview.getCurrentSlice();
        Polygon polygon = ((PolygonRoi)roi).getPolygon();
        int n3 = polygon.npoints;
        int[] nArray = polygon.xpoints;
        int[] nArray2 = polygon.ypoints;
        int n4 = nArray[0];
        int n5 = nArray2[0];
        ImageProcessor imageProcessor = this.stack.getProcessor(n2);
        imageProcessor = imageProcessor.convertToRGB();
        LineIterator lineIterator = new LineIterator();
        int n6 = -1;
        int n7 = 0;
        block0: for (int i = 0; i < n3; ++i) {
            lineIterator.init(nArray[i], nArray2[i], nArray[(i + 1) % n3], nArray2[(i + 1) % n3]);
            while (lineIterator.next() != null) {
                ++n6;
                imageProcessor.setValue((double)this.color);
                imageProcessor.setLineWidth(this.linewidth);
                imageProcessor.moveTo(n4, n5);
                n4 = (int)lineIterator.x;
                n5 = (int)lineIterator.y;
                imageProcessor.lineTo(n4, n5);
                if (n == -1 || n6 % n != 0) continue;
                if (!this.stack.addSlice(n2 + n7, imageProcessor)) continue block0;
                ++n7;
                imageProcessor = imageProcessor.duplicate();
            }
        }
        if (n == -1) {
            this.stack.setSlice(n2, imageProcessor);
            return 0;
        }
        if (n6 % n != 0 && this.stack.addSlice(n2 + n7, imageProcessor)) {
            ++n7;
        }
        return n7;
    }

    public int drawLine(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.preview.getCurrentSlice();
        int n7 = 0;
        ImageProcessor imageProcessor = this.stack.getProcessor(n6);
        imageProcessor = imageProcessor.convertToRGB();
        imageProcessor.setValue((double)this.color);
        imageProcessor.setLineWidth(this.linewidth);
        LineIterator lineIterator = new LineIterator(n, n2, n3, n4);
        int n8 = -1;
        int n9 = n;
        int n10 = n2;
        while (lineIterator.next() != null) {
            ++n8;
            imageProcessor.setValue((double)this.color);
            imageProcessor.setLineWidth(this.linewidth);
            imageProcessor.moveTo(n9, n10);
            n9 = (int)lineIterator.x;
            n10 = (int)lineIterator.y;
            imageProcessor.lineTo(n9, n10);
            if (n5 == -1 || n8 % n5 != 0) continue;
            if (!this.stack.addSlice(n6 + n7, imageProcessor)) break;
            ++n7;
            imageProcessor = imageProcessor.duplicate();
        }
        if (n5 == -1) {
            this.stack.setSlice(n6, imageProcessor);
            return 0;
        }
        if (n8 % n5 != 0 && this.stack.addSlice(n6 + n7, imageProcessor)) {
            ++n7;
        }
        return n7;
    }

    public void fillRoiTransparent(Roi roi) {
        int n = this.preview.getCurrentSlice();
        Polygon polygon = ((PolygonRoi)roi).getPolygon();
        ImageProcessor imageProcessor = this.stack.getProcessor(n);
        imageProcessor = imageProcessor.convertToRGB();
        BufferedImage bufferedImage = (BufferedImage)imageProcessor.createImage();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = new Color(this.color);
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha);
        graphics2D.setColor(color);
        graphics2D.fill(polygon);
        graphics2D.dispose();
        this.stack.setSlice(n, imageProcessor);
    }

    public void fade(int n) {
        int n2 = this.preview.getCurrentSlice();
        int[] nArray = (int[])this.stack.getProcessor(n2).convertToRGB().getPixels();
        int[] nArray2 = (int[])this.stack.getProcessor(n2 + 1).convertToRGB().getPixels();
        for (int i = 1; i < n; ++i) {
            ColorProcessor colorProcessor = new ColorProcessor(this.stack.getWidth(), this.stack.getHeight());
            int[] nArray3 = (int[])colorProcessor.getPixels();
            double d = i;
            double d2 = n - i;
            for (int j = 0; j < nArray3.length; ++j) {
                nArray3[j] = this.interpolate(nArray[j], d, nArray2[j], d2);
            }
            if (!this.stack.addSlice(n2 + i - 1, (ImageProcessor)colorProcessor)) break;
        }
        this.preview.setSlice(this.preview.getCurrentSlice() + n);
    }

    public void createAVI() {
        int n = this.stack.getWidth();
        int n2 = this.stack.getHeight();
        int n3 = 1250 * n * n2 / 256;
        String string = "vbitrate=" + n3 + ":mbd=2:keyint=132:vqblur=1.0:" + "cmp=2:subcmp=2:dia=2:mv0:last_pred=3";
        String string2 = "msmpeg4v2";
        File file = new File(this.stack.getDir());
        new File(file, "divx2pass.log").delete();
        new File(file, "frameno.avi").delete();
        try {
            String string3 = "mencoder -ovc lavc -lavcopts vcodec=" + string2 + ":vpass=1:" + string + " -mf type=png:w=" + n + ":h=" + n2 + ":fps=25 -nosound -o /dev/null " + "mf://*.png";
            Process process = Runtime.getRuntime().exec(string3, null, file);
            process.waitFor();
            string3 = "mencoder -ovc lavc -lavcopts vcodec=" + string2 + ":vpass=2:" + string + " -mf type=png:w=" + n + ":h=" + n2 + ":fps=25 -nosound -o output.avi " + "mf://*.png";
            process = Runtime.getRuntime().exec(string3, null, file);
            process.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void playAVI() {
        String string = "mplayer -loop 0 output.avi";
        File file = new File(this.stack.getDir());
        try {
            Process process = Runtime.getRuntime().exec(string, null, file);
            process.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int interpolate(int n, double d, int n2, double d2) {
        int n3 = (n & 0xFF0000) >> 16;
        int n4 = (n2 & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = (n2 & 0xFF00) >> 8;
        int n7 = n & 0xFF;
        int n8 = n2 & 0xFF;
        byte by = (byte)(((double)n4 * d + (double)n3 * d2) / (d2 + d));
        byte by2 = (byte)(((double)n6 * d + (double)n5 * d2) / (d2 + d));
        byte by3 = (byte)(((double)n8 * d + (double)n7 * d2) / (d2 + d));
        return ((by & 0xFF) << 16) + ((by2 & 0xFF) << 8) + (by3 & 0xFF);
    }

    private static final Shape roiToShape(Roi roi) {
        Shape shape = null;
        Rectangle rectangle = roi.getBounds();
        int[] nArray = null;
        int[] nArray2 = null;
        int n = 0;
        switch (roi.getType()) {
            case 5: {
                Line line = (Line)roi;
                shape = new Line2D.Double(line.x1 - rectangle.x, line.y1 - rectangle.y, line.x2 - rectangle.x, line.y2 - rectangle.y);
                break;
            }
            case 0: {
                shape = new Rectangle2D.Double(0.0, 0.0, rectangle.width, rectangle.height);
                break;
            }
            case 1: {
                Polygon polygon = roi.getPolygon();
                int n2 = 0;
                while (n2 < polygon.npoints) {
                    int n3 = n2;
                    polygon.xpoints[n3] = polygon.xpoints[n3] - rectangle.x;
                    int n4 = n2++;
                    polygon.ypoints[n4] = polygon.ypoints[n4] - rectangle.y;
                }
                break;
            }
            case 2: {
                n = ((PolygonRoi)roi).getNCoordinates();
                nArray = ((PolygonRoi)roi).getXCoordinates();
                nArray2 = ((PolygonRoi)roi).getYCoordinates();
                shape = new Polygon(nArray, nArray2, n);
                break;
            }
            case 3: 
            case 4: {
                n = ((PolygonRoi)roi).getNCoordinates();
                nArray = ((PolygonRoi)roi).getXCoordinates();
                nArray2 = ((PolygonRoi)roi).getYCoordinates();
                shape = new GeneralPath(0, n);
                ((GeneralPath)shape).moveTo(nArray[0], nArray2[0]);
                for (int i = 1; i < n; ++i) {
                    ((GeneralPath)shape).lineTo(nArray[i], nArray2[i]);
                }
                ((GeneralPath)shape).closePath();
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n = ((PolygonRoi)roi).getNCoordinates();
                nArray = ((PolygonRoi)roi).getXCoordinates();
                nArray2 = ((PolygonRoi)roi).getYCoordinates();
                shape = new GeneralPath(1, n);
                ((GeneralPath)shape).moveTo(nArray[0], nArray2[0]);
                for (int i = 1; i < n; ++i) {
                    ((GeneralPath)shape).lineTo(nArray[i], nArray2[i]);
                }
                break;
            }
            case 10: {
                ImageProcessor imageProcessor = roi.getMask();
                byte[] byArray = (byte[])imageProcessor.getPixels();
                Rectangle rectangle2 = roi.getBounds();
                int n5 = imageProcessor.getWidth();
                Area area = new Area();
                for (int i = 0; i < imageProcessor.getHeight(); ++i) {
                    int n6 = i * n5;
                    for (int j = 0; j < n5; ++j) {
                        if (byArray[j + n6] == 0) continue;
                        area.add(new Area(new Rectangle(j + rectangle2.x, i + rectangle2.y, 1, 1)));
                    }
                }
                shape = area;
                break;
            }
            default: {
                throw new IllegalArgumentException("Roi type not supported");
            }
        }
        return shape;
    }

    private class BorderPanel
    extends Panel {
        final Color BC = new Color(139, 142, 255);

        private BorderPanel() {
        }

        public Insets getInsets() {
            return new Insets(10, 10, 10, 10);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.getWidth() == 0 || this.getHeight() == 0) {
                return;
            }
            graphics.setColor(this.BC);
            graphics.drawRect(5, 5, this.getWidth() - 10, this.getHeight() - 10);
        }
    }

    private class LineIterator {
        int x1;
        int y1;
        int x2;
        int y2;
        int dx;
        int dy;
        boolean finished;
        double x;
        double y;
        double dx_dt;
        double dy_dt;

        public LineIterator() {
        }

        public LineIterator(int n, int n2, int n3, int n4) {
            this.init(n, n2, n3, n4);
        }

        public void init(int n, int n2, int n3, int n4) {
            this.x1 = n;
            this.x2 = n3;
            this.y1 = n2;
            this.y2 = n4;
            this.x = n;
            this.y = n2;
            this.dx = n3 - n;
            this.dy = n4 - n2;
            int n5 = Math.abs(this.dx) > Math.abs(this.dy) ? this.dx : this.dy;
            if ((n5 = Math.abs(n5)) == 0) {
                n5 = 1;
            }
            this.dx_dt = (double)this.dx / (double)n5;
            this.dy_dt = (double)this.dy / (double)n5;
            this.dx = Math.abs(this.dx);
            this.dy = Math.abs(this.dy);
            this.finished = false;
        }

        public LineIterator next() {
            if (this.finished) {
                return null;
            }
            this.x += this.dx_dt;
            this.y += this.dy_dt;
            boolean bl = this.finished = Math.abs((int)this.x - this.x1) >= this.dx && Math.abs((int)this.y - this.y1) >= this.dy;
            if (this.finished) {
                this.x = this.x2;
                this.y = this.y2;
            }
            return this;
        }
    }
}

