/*
 * Decompiled with CFR 0.152.
 */
package video;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileSaver;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Arrays;

public class VideoStack {
    static final int DIGITS = 8;
    static final String LAST = "99999999";
    private String dir;
    private String basename;
    private String ending;
    private int w_org;
    private int h_org;
    private int w_prev;
    private int h_prev;
    private int d;
    private ImageStack preview;
    DecimalFormat df = new DecimalFormat("00000000");

    public void open(String string, String string2, String string3) {
        this.basename = string2;
        this.ending = string3;
        this.dir = string;
        File file = new File(string, "Preview.tif");
        if (file.exists()) {
            System.out.println("Loading existing preview stack");
            this.preview = IJ.openImage((String)(string + "/Preview.tif")).getStack();
            this.w_prev = this.preview.getWidth();
            this.h_prev = this.preview.getHeight();
            String string4 = this.preview.getSliceLabel(1);
            ImagePlus imagePlus = IJ.openImage((String)(string + "/" + string4));
            this.w_org = imagePlus.getWidth();
            this.h_org = imagePlus.getHeight();
            this.d = this.preview.getSize();
            return;
        }
        Object[] objectArray = new File(string).list();
        if (objectArray.length == 0) {
            return;
        }
        Arrays.sort(objectArray);
        this.d = objectArray.length;
        System.out.println("Loading " + this.d + " files");
        for (int i = 0; i < this.d; ++i) {
            if (!((String)objectArray[i]).startsWith(string2) || !((String)objectArray[i]).endsWith(string3)) continue;
            System.out.println("opening " + (String)objectArray[i]);
            ImageProcessor imageProcessor = IJ.openImage((String)(string + "/" + (String)objectArray[i])).getProcessor();
            if (this.preview != null) {
                imageProcessor = imageProcessor.resize(64).convertToByte(true);
                this.preview.addSlice((String)objectArray[i], imageProcessor);
                continue;
            }
            this.w_org = imageProcessor.getWidth();
            this.h_org = imageProcessor.getHeight();
            imageProcessor = imageProcessor.resize(64).convertToByte(true);
            this.w_prev = imageProcessor.getWidth();
            this.h_prev = imageProcessor.getHeight();
            this.preview = new ImageStack(this.w_prev, this.h_prev);
            this.preview.addSlice((String)objectArray[i], imageProcessor);
        }
        this.d = this.preview.getSize();
    }

    public ImageProcessor getProcessor(int n) {
        return IJ.openImage((String)(this.dir + "/" + this.preview.getSliceLabel(n))).getProcessor();
    }

    public void setSlice(int n, ImageProcessor imageProcessor) {
        String string = this.preview.getSliceLabel(n);
        ImagePlus imagePlus = new ImagePlus(string, imageProcessor);
        new FileSaver(imagePlus).saveAsPng(this.dir + "/" + string);
        imageProcessor = imageProcessor.resize(this.w_prev).convertToByte(true);
        this.preview.setPixels(imageProcessor.getPixels(), n);
    }

    public boolean addSlice(int n, ImageProcessor imageProcessor) {
        int n2;
        if (imageProcessor == null) {
            imageProcessor = new ColorProcessor(this.w_org, this.h_org);
        }
        String string = this.preview.getSliceLabel(n);
        string = string.substring(this.basename.length(), this.basename.length() + 8);
        String string2 = this.preview.getSliceLabel(n + 1);
        string2 = string2.substring(this.basename.length(), this.basename.length() + 8);
        int n3 = 8;
        String string3 = "";
        int n4 = Integer.parseInt(string2.substring(0, n3));
        if (n4 > (n2 = Integer.parseInt(string.substring(0, n3))) + 1) {
            string3 = this.df.format(n2 + 1);
        }
        if (string3 == null || string3.equals("")) {
            try {
                if (!this.rebaseImages()) {
                    return false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return this.addSlice(n, imageProcessor);
        }
        while (string3.length() < 8) {
            string3 = string3 + '0';
        }
        string3 = this.basename + string3 + "." + this.ending;
        ImagePlus imagePlus = new ImagePlus(string3, imageProcessor);
        new FileSaver(imagePlus).saveAsPng(this.dir + "/" + string3);
        imageProcessor = imageProcessor.resize(this.w_prev).convertToByte(true);
        this.preview.addSlice(string3, imageProcessor, n);
        return true;
    }

    public boolean rebaseImages() {
        int n;
        int n2;
        System.out.println("rebase images");
        int n3 = this.preview.getSize();
        File file = new File(this.dir, "tmp");
        if (file.exists()) {
            IJ.error((String)"Cannot rebase images, since temporary\ndirectory already exists");
            return false;
        }
        if (!file.mkdir()) {
            IJ.error((String)"Cannot create temporary");
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            String string = this.preview.getSliceLabel(n2 + 1);
            new FileSaver(IJ.openImage((String)(this.dir + "/" + string))).saveAsPng(file.getAbsolutePath() + "/" + string);
            new File(this.dir, string).delete();
        }
        n2 = 1;
        int n4 = 1;
        String string = "0";
        while (n3 / n2 >= 10) {
            ++n4;
            string = string + '0';
            n2 *= 10;
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        String string2 = "";
        for (n = 0; n < 8 - n4; ++n) {
            string2 = string2 + '0';
        }
        for (n = 0; n < n3; ++n) {
            String string3 = this.preview.getSliceLabel(n + 1);
            String string4 = this.basename + decimalFormat.format(n + 1) + string2 + "." + this.ending;
            ImagePlus imagePlus = IJ.openImage((String)(file.getAbsolutePath() + "/" + string3));
            new FileSaver(imagePlus).saveAsPng(this.dir + "/" + string4);
            this.preview.setSliceLabel(string4, n + 1);
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
        file.delete();
        System.out.println("rebased");
        return true;
    }

    public void deleteSlice(int n) {
        File file = new File(this.dir + "/" + this.preview.getSliceLabel(n));
        file.delete();
        this.preview.deleteSlice(n);
    }

    public ImageStack getPreview() {
        return this.preview;
    }

    public int getPreviewWidth() {
        return this.w_prev;
    }

    public int getPreviewHeight() {
        return this.h_prev;
    }

    public int getWidth() {
        return this.w_org;
    }

    public int getHeight() {
        return this.h_org;
    }

    public String getDir() {
        return this.dir;
    }
}

