/*
 * Decompiled with CFR 0.152.
 */
package view4d;

import ij.gui.GenericDialog;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.net.URL;
import vib.segment.ImageButton;
import view4d.Viewer4D;

public class Viewer4DController
implements ActionListener {
    private static final String[] FILES = new String[]{"icons/first.png", "icons/previous.png", "icons/next.png", "icons/last.png", "icons/play.png", "icons/pause.png", "icons/faster.png", "icons/slower.png"};
    private static final String[] COMMANDS = new String[]{"FIRST", "PREV", "NEXT", "LAST", "PLAY", "PAUSE", "FASTER", "SLOWER"};
    private ImageButton[] buttons = new ImageButton[FILES.length];
    private Viewer4D viewer4d;

    public Viewer4DController(Viewer4D viewer4D) {
        this.viewer4d = viewer4D;
        GenericDialog genericDialog = new GenericDialog("4D Viewer");
        Panel panel = new Panel(new FlowLayout());
        for (int i = 0; i < FILES.length; ++i) {
            this.buttons[i] = new ImageButton(this.loadIcon(FILES[i]));
            this.buttons[i].addActionListener(this);
            this.buttons[i].setActionCommand(COMMANDS[i]);
            panel.add(this.buttons[i]);
        }
        genericDialog.addPanel(panel);
        genericDialog.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                Viewer4DController.this.viewer4d.releaseContents();
            }
        });
        genericDialog.setModal(false);
        genericDialog.showDialog();
    }

    private Image loadIcon(String string) {
        Image image = null;
        try {
            URL uRL = this.getClass().getResource(string);
            image = Toolkit.getDefaultToolkit().createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (image == null) {
            throw new RuntimeException("Image not found: " + string);
        }
        return image;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].repaint();
        }
        String string = actionEvent.getActionCommand();
        if (string.equals("NEXT")) {
            this.viewer4d.next();
        } else if (string.equals("PREV")) {
            this.viewer4d.previous();
        } else if (string.equals("PLAY")) {
            this.viewer4d.play();
        } else if (string.equals("FIRST")) {
            this.viewer4d.first();
        } else if (string.equals("LAST")) {
            this.viewer4d.last();
        } else if (string.equals("PAUSE")) {
            this.viewer4d.pause();
        } else if (string.equals("FASTER")) {
            this.viewer4d.faster();
        } else if (string.equals("SLOWER")) {
            this.viewer4d.slower();
        }
    }
}

