/*
 * Decompiled with CFR 0.152.
 */
package voltex;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.ContentNode;
import java.awt.Polygon;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import vib.Resample_;
import voltex.VoltexVolume;
import voltex.VolumeRenderer;

public class VoltexGroup
extends ContentNode {
    protected VolumeRenderer renderer;
    protected Content c;
    private float volume;
    private Point3d min;
    private Point3d max;
    private Point3d center;

    protected VoltexGroup() {
    }

    public VoltexGroup(Content content) {
        if (content.getImage() == null) {
            throw new IllegalArgumentException("VoltexGroup can onlybe initialized from a Content that holds an image.");
        }
        this.c = content;
        ImagePlus imagePlus = content.getResamplingFactor() == 1 ? content.getImage() : Resample_.resample(content.getImage(), content.getResamplingFactor());
        this.renderer = new VolumeRenderer(imagePlus, content.getColor(), content.getTransparency(), content.getChannels());
        this.renderer.fullReload();
        this.calculateMinMaxCenterPoint();
        this.addChild((Node)this.renderer.getVolumeNode());
    }

    public VolumeRenderer getRenderer() {
        return this.renderer;
    }

    public void getMin(Tuple3d tuple3d) {
        tuple3d.set((Tuple3d)this.min);
    }

    public void getMax(Tuple3d tuple3d) {
        tuple3d.set((Tuple3d)this.max);
    }

    public void getCenter(Tuple3d tuple3d) {
        tuple3d.set((Tuple3d)this.center);
    }

    public void thresholdUpdated() {
        this.renderer.setThreshold(this.c.getThreshold());
    }

    public float getVolume() {
        return this.volume;
    }

    public void eyePtChanged(View view) {
        this.renderer.eyePtChanged(view);
    }

    public void channelsUpdated() {
        this.renderer.setChannels(this.c.getChannels());
    }

    public void shadeUpdated() {
    }

    public void colorUpdated() {
        this.renderer.setColor(this.c.getColor());
    }

    public void transparencyUpdated() {
        this.renderer.setTransparency(this.c.getTransparency());
    }

    public void volumeToImagePlate(Transform3D transform3D) {
        Transform3D transform3D2 = new Transform3D();
        this.renderer.getVolumeNode().getLocalToVworld(transform3D2);
        transform3D.mul(transform3D2);
    }

    public void fillRoi(Canvas3D canvas3D, Roi roi, byte by) {
        int n;
        int n2;
        if (roi == null) {
            return;
        }
        Polygon polygon = roi.getPolygon();
        Transform3D transform3D = new Transform3D();
        canvas3D.getImagePlateToVworld(transform3D);
        transform3D.invert();
        this.volumeToImagePlate(transform3D);
        VoltexVolume voltexVolume = this.renderer.getVolume();
        for (int i = 0; i < voltexVolume.zDim; ++i) {
            for (n2 = 0; n2 < voltexVolume.yDim; ++n2) {
                for (n = 0; n < voltexVolume.xDim; ++n) {
                    Point2d point2d = this.volumePointInCanvas(canvas3D, transform3D, n, n2, i);
                    if (!polygon.contains(point2d.x, point2d.y)) continue;
                    voltexVolume.setNoCheck(n, n2, i, by);
                }
            }
            IJ.showStatus((String)"Filling...");
            IJ.showProgress((int)i, (int)voltexVolume.zDim);
        }
        this.renderer.fullReload();
        ImagePlus imagePlus = this.c.getImage();
        n2 = this.c.getResamplingFactor();
        if (imagePlus == null || n2 == 1) {
            return;
        }
        voltexVolume = new VoltexVolume(imagePlus);
        for (n = 0; n < voltexVolume.zDim; ++n) {
            for (int i = 0; i < voltexVolume.yDim; ++i) {
                for (int j = 0; j < voltexVolume.xDim; ++j) {
                    Point2d point2d = this.volumePointInCanvas(canvas3D, transform3D, j / n2, i / n2, n / n2);
                    if (!polygon.contains(point2d.x, point2d.y)) continue;
                    voltexVolume.set(j, i, n, by);
                }
            }
            IJ.showStatus((String)"Filling...");
            IJ.showProgress((int)n, (int)voltexVolume.zDim);
        }
    }

    private Point2d volumePointInCanvas(Canvas3D canvas3D, Transform3D transform3D, int n, int n2, int n3) {
        VoltexVolume voltexVolume = this.renderer.volume;
        double d = (double)n * voltexVolume.pw;
        double d2 = (double)n2 * voltexVolume.ph;
        double d3 = (double)n3 * voltexVolume.pd;
        Point3d point3d = new Point3d(d, d2, d3);
        transform3D.transform(point3d);
        Point2d point2d = new Point2d();
        canvas3D.getPixelLocationFromImagePlate(point3d, point2d);
        return point2d;
    }

    protected void calculateMinMaxCenterPoint() {
        ImagePlus imagePlus = this.c.getImage();
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getStackSize();
        Calibration calibration = imagePlus.getCalibration();
        this.min = new Point3d();
        this.max = new Point3d();
        this.center = new Point3d();
        this.min.x = (float)n * (float)calibration.pixelHeight;
        this.min.y = (float)n2 * (float)calibration.pixelHeight;
        this.min.z = (float)n3 * (float)calibration.pixelDepth;
        this.max.x = 0.0;
        this.max.y = 0.0;
        this.max.z = 0.0;
        long l = 0L;
        for (int i = 0; i < n3; ++i) {
            float f = (float)i * (float)calibration.pixelDepth;
            ImageProcessor imageProcessor = imagePlus.getStack().getProcessor(i + 1);
            int n4 = n * n2;
            for (int j = 0; j < n4; ++j) {
                int n5 = imageProcessor.get(j);
                if (n5 == 0) continue;
                l += (long)n5;
                float f2 = (float)(j % n) * (float)calibration.pixelWidth;
                float f3 = (float)(j / n) * (float)calibration.pixelHeight;
                if ((double)f2 < this.min.x) {
                    this.min.x = f2;
                }
                if ((double)f3 < this.min.y) {
                    this.min.y = f3;
                }
                if ((double)f < this.min.z) {
                    this.min.z = f;
                }
                if ((double)f2 > this.max.x) {
                    this.max.x = f2;
                }
                if ((double)f3 > this.max.y) {
                    this.max.y = f3;
                }
                if ((double)f > this.max.z) {
                    this.max.z = f;
                }
                this.center.x += (double)((float)n5 * f2);
                this.center.y += (double)((float)n5 * f3);
                this.center.z += (double)((float)n5 * f);
            }
        }
        this.center.x /= (double)l;
        this.center.y /= (double)l;
        this.center.z /= (double)l;
        this.volume = (float)((double)l * calibration.pixelWidth * calibration.pixelHeight * calibration.pixelDepth);
    }
}

