/*
 * Decompiled with CFR 0.152.
 */
package zeiss;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.FileSaver;
import ij.io.ImageReader;
import ij.io.OpenDialog;
import ij.io.RandomAccessStream;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.StackEditor;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.MedianCut;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class LSM_Reader
implements PlugIn {
    public GUI theGUI;
    public static JFrame infoFrame = new JFrame("LSM Infos");
    public static JFrame detailsFrame = new JFrame("LSM Details");

    public static String readLine(RandomAccessStream randomAccessStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (true) {
            int n;
            if ((n = randomAccessStream.read()) == 13) {
                int n2 = randomAccessStream.getFilePointer();
                int n3 = randomAccessStream.read();
                if (n == 10) break;
                if (n == -1) {
                    bl = true;
                    break;
                }
                randomAccessStream.seek(n2);
                break;
            }
            if (n == 10) break;
            if (n == -1) {
                bl = true;
                break;
            }
            stringBuffer = stringBuffer.append((char)n);
        }
        if (bl && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public ImagePlus[] OpenLSM2(String string, String string2) {
        LSM_Reader_ lSM_Reader_ = new LSM_Reader_();
        return lSM_Reader_.OpenLSM2(string, string2);
    }

    public void run(String string) {
        if (string.equals("about")) {
            IJ.showMessage((String)"LSM Reader 3.2(f)", (String)"Copyright (C) 2002-2004 P. Pirrotte, Y. Krempp & J. Mutterer\n \nThis software is subject to the GNU General Public License\nPlease read LICENSE or read source code information headers\nWorks on images generated by LSM 510 version 2.8 to 3.2\n \nWritten for IBMP-CNRS, Strasbourg, France\n \nContacts :\njerome.mutterer at ibmp-ulp.u-strasbg.fr\npatrick.pirrotte at gmx.net\nyannick.krempp at iphysiol.unil.ch\n");
            return;
        }
        if (string != "") {
            if (string.indexOf("://") >= 0) {
                LSM_Reader_ lSM_Reader_ = new LSM_Reader_();
                lSM_Reader_.OpenLSM(string, true);
            } else {
                File file = new File(string);
                String string2 = file.getName();
                String string3 = "";
                string3 = file.getPath();
                string3 = string3.substring(0, string3.length() - string2.length());
                LSM_Reader_ lSM_Reader_ = new LSM_Reader_();
                lSM_Reader_.OpenLSM(string3, string2);
            }
        } else {
            this.theGUI = new GUI();
            this.theGUI.init();
        }
    }

    public void applyZSTAMP(ImagePlus imagePlus, LSMFileInfo lSMFileInfo) {
        int n = 2;
        int n2 = 40;
        double d = 0.0;
        ImageStack imageStack = imagePlus.getStack();
        Font font = new Font("SansSerif", 0, 20);
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        Rectangle rectangle = imageProcessor.getRoi();
        if (rectangle.width < imageProcessor.getWidth() || rectangle.height < imageProcessor.getHeight()) {
            n = rectangle.x;
            n2 = rectangle.y + rectangle.height;
        }
        Color color = Toolbar.getForegroundColor();
        if (lSMFileInfo.DIMENSION_Z != 1L) {
            if (lSMFileInfo.TIMESTACKSIZE == 1L) {
                int n3 = 1;
                while ((long)n3 <= lSMFileInfo.DIMENSION_Z) {
                    IJ.showStatus((String)("MinMax: " + n3 + "/" + lSMFileInfo.DIMENSION_Z));
                    String string = IJ.d2s((double)d, (int)2) + " \u00b5m";
                    d += lSMFileInfo.PLANE_SPACING;
                    imageProcessor = imageStack.getProcessor(n3);
                    imageProcessor.setFont(font);
                    float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                    imageProcessor.setColor(Color.getHSBColor(255.0f, 255.0f, 255.0f - fArray[2]));
                    imageProcessor.moveTo(n, n2);
                    imageProcessor.drawString(string);
                    ++n3;
                }
            } else if (lSMFileInfo.TIMESTACKSIZE != 1L) {
                int n4 = 1;
                while ((long)n4 <= lSMFileInfo.DIMENSION_Z) {
                    IJ.showStatus((String)("MinMax: " + n4 + "/" + lSMFileInfo.DIMENSION_Z));
                    String string = IJ.d2s((double)d, (int)2) + " \u00b5m";
                    d += lSMFileInfo.PLANE_SPACING;
                    int n5 = 1;
                    while ((long)n5 <= lSMFileInfo.TIMESTACKSIZE) {
                        imageProcessor = imageStack.getProcessor((int)lSMFileInfo.DIMENSION_Z * (n5 - 1) + n4);
                        imageProcessor.setFont(font);
                        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                        imageProcessor.setColor(Color.getHSBColor(255.0f, 255.0f, 255.0f - fArray[2]));
                        imageProcessor.moveTo(n, n2);
                        imageProcessor.drawString(string);
                        ++n5;
                    }
                    ++n4;
                }
            }
        }
        imagePlus.updateAndRepaintWindow();
    }

    public void applyTSTAMP(ImagePlus imagePlus, LSMFileInfo lSMFileInfo) {
        int n = 2;
        int n2 = 20;
        ImageStack imageStack = imagePlus.getStack();
        Font font = new Font("SansSerif", 0, 20);
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        Rectangle rectangle = imageProcessor.getRoi();
        if (rectangle.width < imageProcessor.getWidth() || rectangle.height < imageProcessor.getHeight()) {
            n = rectangle.x;
            n2 = rectangle.y + rectangle.height;
        }
        Color color = Toolbar.getForegroundColor();
        if (lSMFileInfo.TIMESTACKSIZE == 1L ^ lSMFileInfo.DIMENSION_Z == 1L) {
            int n3 = imagePlus.getStackSize();
            int n4 = 1;
            while ((long)n4 <= lSMFileInfo.TS_COUNT) {
                IJ.showStatus((String)("MinMax: " + n4 + "/" + lSMFileInfo.TS_COUNT));
                String string = IJ.d2s((double)lSMFileInfo.TS_STAMPS[n4 - 1], (int)2) + " s";
                imageProcessor = imageStack.getProcessor(n4);
                imageProcessor.setFont(font);
                float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                imageProcessor.setColor(Color.getHSBColor(255.0f, 255.0f, 255.0f - fArray[2]));
                imageProcessor.moveTo(n, n2);
                imageProcessor.drawString(string);
                ++n4;
            }
        } else if (lSMFileInfo.TIMESTACKSIZE != 1L && lSMFileInfo.DIMENSION_Z != 1L) {
            int n5 = 1;
            while ((long)n5 <= lSMFileInfo.TIMESTACKSIZE) {
                IJ.showStatus((String)("MinMax: " + n5 + "/" + lSMFileInfo.TIMESTACKSIZE));
                String string = IJ.d2s((double)lSMFileInfo.TS_STAMPS[n5 - 1], (int)2) + " s";
                int n6 = 1;
                while ((long)n6 <= lSMFileInfo.DIMENSION_Z) {
                    imageProcessor = imageStack.getProcessor((int)lSMFileInfo.DIMENSION_Z * (n5 - 1) + n6);
                    imageProcessor.setFont(font);
                    float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                    imageProcessor.setColor(Color.getHSBColor(255.0f, 255.0f, 255.0f - fArray[2]));
                    imageProcessor.moveTo(n, n2);
                    imageProcessor.drawString(string);
                    ++n6;
                }
                ++n5;
            }
        }
        imagePlus.updateAndRepaintWindow();
    }

    public void applyLSTAMP(ImagePlus imagePlus, LSMFileInfo lSMFileInfo) {
        int n = 2;
        int n2 = 60;
        double d = 0.0;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        Rectangle rectangle = imageProcessor.getRoi();
        if (rectangle.width < imageProcessor.getWidth() || rectangle.height < imageProcessor.getHeight()) {
            n = rectangle.x;
            n2 = rectangle.y + rectangle.height;
        }
        StackEditor stackEditor = new StackEditor();
        stackEditor.convertImagesToStack();
        imagePlus = WindowManager.getCurrentImage();
        ImageStack imageStack = imagePlus.getStack();
        Font font = new Font("SansSerif", 0, 20);
        Color color = Toolbar.getForegroundColor();
        if (imageStack.getSize() != 1 && lSMFileInfo.SPECTRALSCAN == 1) {
            int n3 = 1;
            while ((long)n3 <= lSMFileInfo.LS_COUNT) {
                IJ.showStatus((String)("MinMax: " + n3 + "/" + lSMFileInfo.LS_COUNT));
                String string = IJ.d2s((double)(lSMFileInfo.LS_STAMPS[n3 - 1] * 1.0E9), (int)2) + " nm";
                imageProcessor = imageStack.getProcessor(n3);
                imageProcessor.setFont(font);
                float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                imageProcessor.setColor(Color.getHSBColor(255.0f, 255.0f, 255.0f - fArray[2]));
                imageProcessor.moveTo(n, n2);
                imageProcessor.drawString(string);
                ++n3;
            }
        }
        imagePlus.updateAndRepaintWindow();
    }

    class LSMFileInfo
    extends FileInfo {
        public String FILENAME = "";
        public String DIRECTORY = "";
        public double[] TS_STAMPS;
        public double FirstTimeStamp = 0.0;
        public long TS_COUNT;
        public long TS_BYTESIZE;
        public double[] LS_STAMPS;
        public long LS_COUNT;
        public long STACKSIZE;
        public long TIMESTACKSIZE;
        public long TIF_NEWSUBFILETYPE = 0L;
        public long TIF_IMAGEWIDTH = 0L;
        public long TIF_IMAGELENGTH = 0L;
        public long LENGTH1 = 0L;
        public long LENGTH2 = 0L;
        public long TIF_BITSPERSAMPLE_CHANNEL1 = 0L;
        public long TIF_BITSPERSAMPLE_CHANNEL2 = 0L;
        public long TIF_BITSPERSAMPLE_CHANNEL3 = 0L;
        public long TIF_COMPRESSION = 0L;
        public long TIF_PHOTOMETRICINTERPRETATION = 0L;
        public long TIF_STRIPOFFSETS = 0L;
        public long TIF_STRIPOFFSETS1 = 0L;
        public long TIF_STRIPOFFSETS2 = 0L;
        public long TIF_STRIPOFFSETS3 = 0L;
        public long TIF_SAMPLESPERPIXEL = 0L;
        public long TIF_STRIPBYTECOUNTS = 0L;
        public long TIF_STRIPBYTECOUNTS1 = 0L;
        public long TIF_STRIPBYTECOUNTS2 = 0L;
        public long TIF_STRIPBYTECOUNTS3 = 0L;
        public long TIF_CZ_LSMINFO = 0L;
        public long DIMENSION_X = 0L;
        public long DIMENSION_Y = 0L;
        public long DIMENSION_Z = 0L;
        public long NUMBER_OF_CHANNELS = 0L;
        public long THUMB_X = 0L;
        public long THUMB_Y = 0L;
        public double VOXELSIZE_X = 0.0;
        public double VOXELSIZE_Y = 0.0;
        public double VOXELSIZE_Z = 0.0;
        public long DATATYPE = 1L;
        public long SCANTYPE = 0L;
        public int SPECTRALSCAN = 0;
        public int DATATYPE2 = 0;
        public long OFFSET_INPUTLUT = 0L;
        public long OFFSET_OUTPUTLUT = 0L;
        public long OFFSET_SCANINFO = 0L;
        public long OFFSET_CHANNELSCOLORS = 0L;
        public long OFFSET_COLORS = 0L;
        public long OFFSET_CHANNELDATATYPES = 0L;
        public long OFFSET_TIMESTAMPS = 0L;
        public long OFFSET_CHANNELWAVELENGTH = 0L;
        public long OFFSET_EVENTLIST = 0L;
        public long NUMCOLORS = 0L;
        public long[] COLORS;
        public String DetailedNotes = "";
        public String ShortNotes = "";
        public String Objective = "";
        public String Sampling_Mode = "";
        public String User = "NA";
        public String[] Channel = new String[32];
        public long SUBTYPE = 0L;
        public long SUBSIZE = 0L;
        public long ENTRY = 0L;
        public double PLANE_SPACING = 0.0;
        public double PLANE_WIDTH = 0.0;
        public double PLANE_HEIGHT = 0.0;
        public double VOLUME_DEPTH = 0.0;
        public double VOXEL_X = 0.0;
        public double VOXEL_Y = 0.0;
        public double VOXEL_Z = 0.0;
        public double ZOOM_X = 0.0;
        public double ZOOM_Y = 0.0;
        public double ZOOM_Z = 0.0;
        public StringBuffer sb = new StringBuffer();
        public LUT_INFO INPUTLUT = new LUT_INFO();
        public LUT_INFO OUTPUTLUT = new LUT_INFO();
        public SCAN_INFO SCANINFO = new SCAN_INFO();
        public Vector STRIPOFF = new Vector();
        public Vector IMAGETYPE = new Vector();
        public String TimeEvents = "";

        LSMFileInfo() {
        }

        public class SCAN_INFO {
            private int entry_1 = 0;
            private int entry_2 = 0;
            private String entry = new String();
            private long stype = 0L;
            private long ssize = 0L;
            private int off = 0;
            private String[][] table = new String[][]{{"0x010000000", "1", "SUB", "RECORDINGS"}, {"0x020000000", "1", "SUB", "TRACKS"}, {"0x030000000", "1", "SUB", "LASERS"}, {"0x040000000", "1", "SUB", "TRACK"}, {"0x050000000", "1", "SUB", "LASER"}, {"0x060000000", "1", "SUB", "DETECTION_CHANNELS"}, {"0x070000000", "1", "SUB", "DETECTION_CHANNEL"}, {"0x080000000", "1", "SUB", "ILLUMINATION_CHANNELS"}, {"0x090000000", "1", "SUB", "ILLUMINATION_CHANNEL"}, {"0x0A0000000", "1", "SUB", "BEAM_SPLITTERS"}, {"0x0B0000000", "1", "SUB", "BEAM_SPLITTER"}, {"0x0C0000000", "1", "SUB", "DATA_CHANNELS"}, {"0x0D0000000", "1", "SUB", "DATA_CHANNEL"}, {"0x011000000", "1", "SUB", "TIMERS"}, {"0x012000000", "1", "SUB", "TIMER"}, {"0x013000000", "1", "SUB", "MARKERS"}, {"0x014000000", "1", "SUB", "MARKER"}, {"0x050000001", "0", "A", "LASER_NAME"}, {"0x050000002", "0", "L", "LASER_ACQUIRE"}, {"0x050000003", "0", "L", "LASER_POWER"}, {"0x010000001", "0", "A", "ENTRY_NAME"}, {"0x010000002", "0", "A", "ENTRY_DESCRIPTION"}, {"0x010000003", "0", "A", "ENTRY_NOTES"}, {"0x010000004", "0", "A", "ENTRY_OBJECTIVE"}, {"0x010000005", "0", "A", "PROCESSING_SUMMARY"}, {"0x010000006", "0", "A", "SPECIAL_SCAN"}, {"0x010000007", "0", "A", "SCAN_TYPE"}, {"0x010000008", "0", "A", "SCAN_MODE"}, {"0x010000009", "0", "L", "STACKS_COUNT"}, {"0x01000000A", "0", "L", "LINES_PER_PLANE"}, {"0x01000000B", "0", "L", "SAMPLES_PER_LINE"}, {"0x01000000C", "0", "L", "PLANES_PER_VOLUME"}, {"0x01000000D", "0", "L", "IMAGES_WIDTH"}, {"0x01000000E", "0", "L", "IMAGES_HEIGHT"}, {"0x01000000F", "0", "L", "NUMBER_OF_PLANES"}, {"0x010000010", "0", "L", "IMAGES_NUMBER_STACKS"}, {"0x010000011", "0", "L", "IMAGES_NUMBER_CHANNELS"}, {"0x010000012", "0", "L", "LINESCAN_XY"}, {"0x010000013", "0", "L", "SCAN_DIRECTION"}, {"0x010000014", "0", "L", "TIME_SERIES"}, {"0x010000015", "0", "L", "ORIGNAL_SCAN_DATA"}, {"0x010000016", "0", "R", "ZOOM_X"}, {"0x010000017", "0", "R", "ZOOM_Y"}, {"0x010000018", "0", "R", "ZOOM_Z"}, {"0x010000019", "0", "R", "SAMPLE_0X"}, {"0x01000001A", "0", "R", "SAMPLE_0Y"}, {"0x01000001B", "0", "R", "SAMPLE_0Z"}, {"0x01000001C", "0", "R", "SAMPLE_SPACING"}, {"0x01000001D", "0", "R", "LINE_SPACING"}, {"0x01000001E", "0", "R", "PLANE SPACING"}, {"0x01000001F", "0", "R", "PLANE_WIDTH"}, {"0x010000020", "0", "R", "PLANE_HEIGHT"}, {"0x010000021", "0", "R", "VOLUME_DEPTH"}, {"0x010000034", "0", "R", "ROTATION"}, {"0x010000035", "0", "R", "PRECESSION"}, {"0x010000036", "0", "R", "SAMPLE_0TIME"}, {"0x010000037", "0", "A", "START_SCAN_TRIGGER_IN"}, {"0x010000038", "0", "A", "START_SCAN_TRIGGER_OUT"}, {"0x010000039", "0", "L", "START_SCAN_EVENT"}, {"0x010000040", "0", "R", "START_SCAN_TIME"}, {"0x010000041", "0", "A", "STOP_SCAN_TRIGGER_IN"}, {"0x010000042", "0", "A", "STOP_SCAN_TRIGGER_OUT"}, {"0x010000043", "0", "L", "STOP_SCAN_EVENT"}, {"0x010000044", "0", "R", "START_SCAN_TIME2"}, {"0x010000045", "0", "L", "USE_ROIS"}, {"0x010000046", "0", "R", "USE_REDUCED_MEMORY_ROIS"}, {"0x010000047", "0", "A", "USER"}, {"0x010000048", "0", "L", "USE_BCCORECCTION"}, {"0x010000049", "0", "R", "POSITION_BCCORRECTION1"}, {"0x010000050", "0", "R", "POSITION_BCCORRECTION2"}, {"0x010000051", "0", "L", "INTERPOLATIONY"}, {"0x040000001", "0", "L", "MULTIPLEX_TYPE"}, {"0x040000002", "0", "L", "MULTIPLEX_ORDER"}, {"0x040000003", "0", "L", "SAMPLING_MODE"}, {"0x040000004", "0", "L", "SAMPLING_METHOD"}, {"0x040000005", "0", "L", "SAMPLING_NUMBER"}, {"0x040000006", "0", "L", "ENTRY_ACQUIRE"}, {"0x040000007", "0", "R", "OBSERVATION_TIME"}, {"0x04000000B", "0", "R", "TIME_BETWEEN_STACKS"}, {"0x04000000C", "0", "A", "TRACK_NAME"}, {"0x04000000D", "0", "A", "COLLIMATOR1_NAME"}, {"0x04000000E", "0", "L", "COLLIMATOR1_POSITION"}, {"0x04000000F", "0", "A", "COLLIMATOR2_NAME"}, {"0x040000010", "0", "A", "COLLIMATOR2_POSITION"}, {"0x040000011", "0", "L", "BLEACH_TRACK"}, {"0x040000012", "0", "L", "BLEACH_AFTER_SCAN NUMBER"}, {"0x040000013", "0", "L", "BLEACH_SCAN_NUMBER"}, {"0x040000014", "0", "A", "TRIGGER_IN"}, {"0x040000015", "0", "A", "TRIGGER_OUT"}, {"0x040000016", "0", "L", "IS_RATIO_TRACK"}, {"0x040000017", "0", "L", "BLEACH_COUNT"}, {"0x040000018", "0", "R", "SPI_CENTER_WAVELENGTH"}, {"0x040000019", "0", "R", "PIXEL_TIME"}, {"0x070000003", "0", "R", "DETECTOR_GAIN"}, {"0x070000005", "0", "R", "AMPLIFIER_GAIN"}, {"0x070000007", "0", "R", "AMPLIFIER_OFFSET"}, {"0x070000009", "0", "R", "PINHOLE_DIAMETER"}, {"0x07000000B", "0", "L", "ENTRY_ACQUIRE"}, {"0x07000000C", "0", "A", "DETECTOR_NAME"}, {"0x07000000D", "0", "A", "AMPLIFIER_NAME"}, {"0x07000000E", "0", "A", "PINHOLE_NAME"}, {"0x07000000F", "0", "A", "FILTER_SET_NAME"}, {"0x070000010", "0", "A", "FILTER_NAME"}, {"0x070000013", "0", "A", "INTEGRATOR_NAME"}, {"0x070000014", "0", "A", "DETECTION_CHANNEL_NAME"}, {"0x070000015", "0", "R", "DETECTOR_GAIN_BC1"}, {"0x070000016", "0", "R", "DETECTOR_GAIN_BC2"}, {"0x070000017", "0", "R", "AMPLIFIER_GAIN_BC1"}, {"0x070000018", "0", "R", "AMPLIFIER_GAIN_BC2"}, {"0x070000019", "0", "R", "AMPLIFIER_OFFSET_BC1"}, {"0x070000020", "0", "R", "AMPLIFIER_OFFSET_BC2"}, {"0x070000021", "0", "L", "SPECTRAL_SCAN_CHANNELS"}, {"0x070000022", "0", "R", "SPI_WAVE_LENGTH_START"}, {"0x070000022", "0", "R", "SPI_WAVELENGTH_END"}, {"0x070000026", "0", "A", "DYE_NAME"}, {"0x070000027", "0", "A", "DYE_FOLDER"}, {"0x090000001", "0", "A", "ILL_NAME"}, {"0x090000002", "0", "R", "POWER"}, {"0x090000003", "0", "R", "WAVELENGTH"}, {"0x090000004", "0", "L", "ACQUIRE"}, {"0x090000005", "0", "A", "DETCHANNEL_NAME"}, {"0x090000006", "0", "R", "POWER_BC1"}, {"0x090000007", "0", "R", "POWER_BC2"}, {"0x0B0000001", "0", "A", "FILTER_SET"}, {"0x0B0000002", "0", "A", "FILTER"}, {"0x0B0000003", "0", "A", "BS_NAME"}, {"0x0D0000001", "0", "A", "DATA_NAME"}, {"0x0D0000004", "0", "L", "COLOR"}, {"0x0D0000005", "0", "L", "SAMPLETYPE"}, {"0x0D0000006", "0", "L", "BITS_PER_SAMPLE"}, {"0x0D0000007", "0", "L", "RATIO_TYPE"}, {"0x0D0000008", "0", "L", "RATIO_TRACK1"}, {"0x0D0000009", "0", "L", "RATIO_TRACK2"}, {"0x0D000000A", "0", "A", "RATIO_CHANNEL1"}, {"0x0D000000B", "0", "A", "RATIO_CHANNEL2"}, {"0x0D000000C", "0", "R", "RATIO_CONST1"}, {"0x0D000000D", "0", "R", "RATIO_CONST2"}, {"0x0D000000E", "0", "R", "RATIO_CONST3"}, {"0x0D000000F", "0", "R", "RATIO_CONST4"}, {"0x012000001", "0", "A", "TIMER_NAME"}, {"0x012000003", "0", "R", "INTERVAL"}, {"0x012000004", "0", "A", "TRIGGER_IN"}, {"0x012000005", "0", "A", "TRIGGER_OUT"}, {"0x014000001", "0", "A", "MARKER_NAME"}, {"0x014000002", "0", "A", "DESCRIPTION"}, {"0x014000003", "0", "A", "TRIGGER_IN"}, {"0x014000004", "0", "A", "TRIGGER_OUT"}};
            public ArrayList recordings = new ArrayList();
            public ArrayList unknown = new ArrayList();
            public Vector tracks = new Vector();
            public Vector lasers = new Vector();
            public Vector det_channels = new Vector();
            public Vector illum_channels = new Vector();
            public Vector bsplits = new Vector();
            public Vector data_channels = new Vector();
            public Vector timers = new Vector();
            public Vector markers = new Vector();
            public Vector det_channels_count = new Vector();
            public Vector illum_channels_count = new Vector();
            public Vector bsplits_count = new Vector();
            public Vector data_channels_count = new Vector();
        }

        public class LUT_INFO {
            public long LUT_SIZE = 0L;
            public long SUBBLOCKS_COUNT = 0L;
            public long CHANNELS_COUNT = 0L;
            public long LUT_TYPE = 0L;
            public long ADVANCED = 0L;
            public long CURRENT_CHANNEL = 0L;
            public long G_TYPE = 0L;
            public long G_SIZE = 0L;
            public double[] G_CHANNEL;
            public long B_TYPE = 0L;
            public long B_SIZE = 0L;
            public double[] B_CHANNEL;
            public long C_TYPE = 0L;
            public long C_SIZE = 0L;
            public double[] C_CHANNEL;
            public long R_TYPE = 0L;
            public long R_SIZE = 0L;
            public double[] R_CHANNELSX;
            public double[] R_CHANNELSY;
            public double[] R_CHANNELEX;
            public double[] R_CHANNELEY;
            public long K_TYPE = 0L;
            public long K_SIZE = 0L;
            public long KNOTS = 0L;
            public double[] K_CHANNELX;
            public double[] K_CHANNELY;
            public long P_TYPE = 0L;
            public long P_SIZE = 0L;
            public byte[] P_CHANNEL;
        }
    }

    public class Batch_Converter {
        private String[] choices = new String[]{"Tiff", "8-bit Tiff", "Jpeg", "Zip", "Raw"};
        private String format = "Tiff";

        public void run(String string) {
            OpenDialog openDialog = new OpenDialog("Select a file in source folder...", "");
            if (openDialog.getFileName() == null) {
                return;
            }
            String string2 = openDialog.getDirectory();
            GenericDialog genericDialog = new GenericDialog("LSM Batch Converter", (Frame)IJ.getInstance());
            genericDialog.addChoice("Convert to: ", this.choices, this.format);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return;
            }
            this.format = genericDialog.getNextChoice();
            SaveDialog saveDialog = new SaveDialog("Open destination folder...", "dummy name (required)", "");
            if (saveDialog.getFileName() == null) {
                return;
            }
            String string3 = saveDialog.getDirectory();
            this.convert(string2, string3, this.format);
        }

        public void convert(String string, String string2, String string3) {
            String[] stringArray;
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            if ((stringArray = new File(string).list()) == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                IJ.showStatus((String)(i + "/" + stringArray.length));
                File file = new File(string + stringArray[i]);
                if (file.isDirectory()) continue;
                LSM_Reader_ lSM_Reader_ = new LSM_Reader_();
                ImagePlus[] imagePlusArray = lSM_Reader_.OpenLSM2(string, stringArray[i]);
                for (int j = 0; j < imagePlusArray.length; ++j) {
                    ImagePlus imagePlus = imagePlusArray[j];
                    if (imagePlus == null || (imagePlus = this.process(imagePlus)) == null) continue;
                    if (imagePlus.getStackSize() != 1) {
                        for (int k = 0; k < imagePlus.getStackSize(); ++k) {
                            imagePlus.setSlice(k);
                            ImageProcessor imageProcessor = imagePlus.getProcessor();
                            ImageProcessor imageProcessor2 = imageProcessor.createProcessor(imageProcessor.getWidth(), imageProcessor.getHeight());
                            imageProcessor2.setPixels(imageProcessor.getPixelsCopy());
                            String string4 = imagePlus.getTitle();
                            string4 = string4 + "_slice";
                            String string5 = IJ.d2s((double)k, (int)0);
                            string4 = string4 + "_" + string5;
                            ImagePlus imagePlus2 = new ImagePlus(string4, imageProcessor2);
                            this.save(imagePlus2, string2, string3, j);
                            string4 = "";
                            string5 = "";
                        }
                        continue;
                    }
                    this.save(imagePlus, string2, string3, j);
                }
            }
            IJ.showProgress((double)1.0);
            IJ.showStatus((String)"");
            IJ.showMessage((String)"Conversion done");
        }

        public ImagePlus process(ImagePlus imagePlus) {
            return imagePlus;
        }

        public void save(ImagePlus imagePlus, String string, String string2, int n) {
            String string3 = imagePlus.getTitle();
            int n2 = string3.lastIndexOf(".");
            int n3 = string3.lastIndexOf(":");
            String string4 = string3.substring(n3 + 1, string3.length());
            if (n2 >= 0) {
                string3 = string3.substring(0, n2);
            }
            if (n3 >= 0) {
                string3 = string3.concat(string4);
            }
            String string5 = string + string3;
            if (string2.equals("Tiff")) {
                new FileSaver(imagePlus).saveAsTiff(string5 + ".tif");
            } else if (string2.equals("8-bit Tiff")) {
                this.saveAs8bitTiff(imagePlus, string5 + ".tif");
            } else if (string2.equals("Zip")) {
                new FileSaver(imagePlus).saveAsZip(string5 + ".zip");
            } else if (string2.equals("Raw")) {
                new FileSaver(imagePlus).saveAsRaw(string5 + ".raw");
            } else if (string2.equals("Jpeg")) {
                new FileSaver(imagePlus).saveAsJpeg(string5 + ".jpg");
            }
        }

        void saveAs8bitTiff(ImagePlus imagePlus, String string) {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            if (imageProcessor instanceof ColorProcessor) {
                imageProcessor = this.reduceColors(imageProcessor);
                imagePlus.setProcessor(null, imageProcessor);
            } else if (imageProcessor instanceof ShortProcessor || imageProcessor instanceof FloatProcessor) {
                imageProcessor = imageProcessor.convertToByte(true);
                imagePlus.setProcessor(null, imageProcessor);
            }
            new FileSaver(imagePlus).saveAsTiff(string);
        }

        ImageProcessor reduceColors(ImageProcessor imageProcessor) {
            MedianCut medianCut = new MedianCut((int[])imageProcessor.getPixels(), imageProcessor.getWidth(), imageProcessor.getHeight());
            Image image = medianCut.convert(256);
            return new ByteProcessor(image);
        }
    }

    class LSM_Reader_ {
        public String FILENAME = "";
        public String DIRECTORY = "";
        public File LSM;
        private RandomAccessFile file;
        private RandomAccessStream stream;
        public LSMFileInfo lsm_fi;

        LSM_Reader_() {
        }

        public void LSM_Reader_() {
        }

        public void OpenLSM(String string, boolean bl) {
            block22: {
                try {
                    Object object;
                    URL uRL;
                    if (bl) {
                        uRL = new URL(string);
                        object = uRL.openStream();
                        this.stream = new RandomAccessStream((InputStream)object);
                    } else {
                        uRL = new OpenDialog("Open LSM image ... ", string);
                        this.FILENAME = uRL.getFileName();
                        if (this.FILENAME == null) {
                            IJ.error((String)"no file selected");
                            return;
                        }
                        this.DIRECTORY = uRL.getDirectory();
                        if (this.DIRECTORY == null) {
                            IJ.error((String)"no file selected");
                            return;
                        }
                        object = new File(this.DIRECTORY, this.FILENAME);
                        FileInputStream fileInputStream = new FileInputStream((File)object);
                        this.file = null;
                        this.stream = new RandomAccessStream((InputStream)fileInputStream);
                    }
                    if (string.equals("about")) break block22;
                    this.lsm_fi = new LSMFileInfo();
                    this.lsm_fi.FILENAME = this.FILENAME;
                    this.lsm_fi.DIRECTORY = this.DIRECTORY;
                    boolean bl2 = this.isLSMfile();
                    if (bl2) {
                        Object object2;
                        long l = 0L;
                        long l2 = 0L;
                        int n = 0;
                        long l3 = 8L;
                        do {
                            l = this.HowManyTAGs((int)l3);
                            int n2 = 0;
                            while ((long)n2 < l) {
                                byte[] byArray = this.readTAG(l3 + 2L + (long)(12 * n2));
                                this.analyseTAG(byArray);
                                ++n2;
                            }
                            this.getSTRIPOFFSETS(this.lsm_fi.TIF_STRIPOFFSETS);
                            this.stream.seek((int)l3 + 2 + 12 * (int)l);
                            l3 = l2 = (long)this.swap(this.stream.readInt());
                            ++n;
                            if (this.lsm_fi.LENGTH2 == 1L) {
                                this.lsm_fi.STRIPOFF.add(new Long(this.lsm_fi.TIF_STRIPOFFSETS));
                            } else {
                                this.lsm_fi.STRIPOFF.add(new Long(this.lsm_fi.TIF_STRIPOFFSETS1));
                            }
                            this.lsm_fi.IMAGETYPE.add(new Long(this.lsm_fi.TIF_NEWSUBFILETYPE));
                        } while (l2 != 0L);
                        long l4 = this.HowManyTAGs(8L);
                        int n3 = 0;
                        while ((long)n3 < l4) {
                            object2 = this.readTAG(10 + 12 * n3);
                            this.analyseTAG((byte[])object2);
                            ++n3;
                        }
                        if (this.lsm_fi.TIF_COMPRESSION == 5L) {
                            // empty if block
                        }
                        this.getSTRIPOFFSETS(this.lsm_fi.TIF_STRIPOFFSETS);
                        this.getSTRIPBYTECOUNTS(this.lsm_fi.TIF_STRIPBYTECOUNTS);
                        this.getCZ_LSMINFO(this.lsm_fi.TIF_CZ_LSMINFO);
                        this.getCHANNELNAMESANDCOLORS(this.lsm_fi.OFFSET_CHANNELSCOLORS);
                        this.getSCANINFO(this.lsm_fi.OFFSET_SCANINFO);
                        if (this.lsm_fi.OFFSET_TIMESTAMPS != 0L) {
                            this.getTIMESTAMPS(this.lsm_fi.OFFSET_TIMESTAMPS);
                            if (this.lsm_fi.SCANTYPE == 3L || this.lsm_fi.SCANTYPE == 4L || this.lsm_fi.SCANTYPE == 5L || this.lsm_fi.SCANTYPE == 6L || this.lsm_fi.SCANTYPE == 9L) {
                                this.getEVENTLIST((int)this.lsm_fi.OFFSET_EVENTLIST);
                            }
                        }
                        if (this.lsm_fi.OFFSET_CHANNELWAVELENGTH != 0L) {
                            this.getLAMBDASTAMPS(this.lsm_fi.OFFSET_CHANNELWAVELENGTH);
                        }
                        if (this.file != null) {
                            this.file.close();
                            this.stream.close();
                        }
                        for (n3 = 0; n3 < (int)this.lsm_fi.NUMBER_OF_CHANNELS; ++n3) {
                            object2 = new ImagePlus();
                            object2 = this.open(this.DIRECTORY, this.FILENAME, this.lsm_fi.STRIPOFF, n3, true);
                            object2.setTitle(this.FILENAME + " Channel : " + this.lsm_fi.Channel[n3]);
                            if (object2 != null) {
                                Color[] colorArray = new Color[2];
                                colorArray[0] = new Color(0, 0, 0);
                                int n4 = (int)(this.lsm_fi.COLORS[n3] & 0xFFL);
                                int n5 = (int)(this.lsm_fi.COLORS[n3] >> 8 & 0xFFL);
                                int n6 = (int)(this.lsm_fi.COLORS[n3] >> 16 & 0xFFL);
                                colorArray[1] = new Color(n4, n5, n6);
                                if (n4 == 0 && n5 == 0 && n6 == 0) {
                                    colorArray[1] = Color.white;
                                }
                                this.apply_colors((ImagePlus)object2, colorArray, 2);
                                object2.getWindow().addWindowListener((WindowListener)new MyFocusListener(this.lsm_fi, (ImagePlus)object2));
                                if (this.lsm_fi.DATATYPE == 2L) {
                                    double d = object2.getProcessor().getMin();
                                    double d2 = object2.getProcessor().getMax();
                                    object2.getProcessor().setMinAndMax(d, d2);
                                }
                                object2.show();
                                object2.updateAndDraw();
                                continue;
                            }
                            IJ.showMessage((String)"Open LSM...", (String)"Failed.");
                        }
                        break block22;
                    }
                    IJ.error((String)" Selected image is not a valid LSM file ");
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void OpenLSM(String string, String string2) {
            block19: {
                try {
                    this.FILENAME = string2;
                    if (this.FILENAME == null) {
                        IJ.error((String)"no file selected");
                        return;
                    }
                    this.DIRECTORY = string;
                    if (this.DIRECTORY == null) {
                        IJ.error((String)"no file selected");
                        return;
                    }
                    this.LSM = new File(this.DIRECTORY, this.FILENAME);
                    this.file = new RandomAccessFile(this.LSM, "r");
                    this.stream = new RandomAccessStream(this.file);
                    if (string.equals("about")) break block19;
                    this.lsm_fi = new LSMFileInfo();
                    this.lsm_fi.FILENAME = this.FILENAME;
                    this.lsm_fi.DIRECTORY = this.DIRECTORY;
                    boolean bl = this.isLSMfile();
                    if (bl) {
                        Object object;
                        long l = 0L;
                        long l2 = 0L;
                        int n = 0;
                        long l3 = 8L;
                        do {
                            l = this.HowManyTAGs((int)l3);
                            int n2 = 0;
                            while ((long)n2 < l) {
                                byte[] byArray = this.readTAG(l3 + 2L + (long)(12 * n2));
                                this.analyseTAG(byArray);
                                ++n2;
                            }
                            this.getSTRIPOFFSETS(this.lsm_fi.TIF_STRIPOFFSETS);
                            this.stream.seek((int)l3 + 2 + 12 * (int)l);
                            l3 = l2 = (long)this.swap(this.stream.readInt());
                            ++n;
                            if (this.lsm_fi.LENGTH2 == 1L) {
                                this.lsm_fi.STRIPOFF.add(new Long(this.lsm_fi.TIF_STRIPOFFSETS));
                            } else {
                                this.lsm_fi.STRIPOFF.add(new Long(this.lsm_fi.TIF_STRIPOFFSETS1));
                            }
                            this.lsm_fi.IMAGETYPE.add(new Long(this.lsm_fi.TIF_NEWSUBFILETYPE));
                        } while (l2 != 0L);
                        long l4 = this.HowManyTAGs(8L);
                        int n3 = 0;
                        while ((long)n3 < l4) {
                            object = this.readTAG(10 + 12 * n3);
                            this.analyseTAG((byte[])object);
                            ++n3;
                        }
                        if (this.lsm_fi.TIF_COMPRESSION == 5L) {
                            // empty if block
                        }
                        this.getSTRIPOFFSETS(this.lsm_fi.TIF_STRIPOFFSETS);
                        this.getSTRIPBYTECOUNTS(this.lsm_fi.TIF_STRIPBYTECOUNTS);
                        this.getCZ_LSMINFO(this.lsm_fi.TIF_CZ_LSMINFO);
                        this.getCHANNELNAMESANDCOLORS(this.lsm_fi.OFFSET_CHANNELSCOLORS);
                        this.getSCANINFO(this.lsm_fi.OFFSET_SCANINFO);
                        if (this.lsm_fi.OFFSET_TIMESTAMPS != 0L) {
                            this.getTIMESTAMPS(this.lsm_fi.OFFSET_TIMESTAMPS);
                            if (this.lsm_fi.SCANTYPE == 3L || this.lsm_fi.SCANTYPE == 4L || this.lsm_fi.SCANTYPE == 5L || this.lsm_fi.SCANTYPE == 6L || this.lsm_fi.SCANTYPE == 9L) {
                                this.getEVENTLIST((int)this.lsm_fi.OFFSET_EVENTLIST);
                            }
                        }
                        if (this.lsm_fi.OFFSET_CHANNELWAVELENGTH != 0L) {
                            this.getLAMBDASTAMPS(this.lsm_fi.OFFSET_CHANNELWAVELENGTH);
                        }
                        this.stream.close();
                        this.file.close();
                        for (n3 = 0; n3 < (int)this.lsm_fi.NUMBER_OF_CHANNELS; ++n3) {
                            object = this.open(this.DIRECTORY, this.FILENAME, this.lsm_fi.STRIPOFF, n3, true);
                            object.setTitle(this.FILENAME + " Channel : " + this.lsm_fi.Channel[n3]);
                            if (object != null) {
                                Color[] colorArray = new Color[2];
                                colorArray[0] = new Color(0, 0, 0);
                                int n4 = (int)(this.lsm_fi.COLORS[n3] & 0xFFL);
                                int n5 = (int)(this.lsm_fi.COLORS[n3] >> 8 & 0xFFL);
                                int n6 = (int)(this.lsm_fi.COLORS[n3] >> 16 & 0xFFL);
                                colorArray[1] = new Color(n4, n5, n6);
                                if (n4 == 0 && n5 == 0 && n6 == 0) {
                                    colorArray[1] = Color.white;
                                }
                                this.apply_colors((ImagePlus)object, colorArray, 2);
                                if (object.getWindow() != null) {
                                    object.getWindow().addWindowListener((WindowListener)new MyFocusListener(this.lsm_fi, (ImagePlus)object));
                                }
                                if (this.lsm_fi.DATATYPE == 2L) {
                                    double d = object.getProcessor().getMin();
                                    double d2 = object.getProcessor().getMax();
                                    object.getProcessor().setMinAndMax(d, d2);
                                }
                                object.show();
                                object.updateAndDraw();
                                continue;
                            }
                            IJ.showMessage((String)"Open LSM...", (String)"Failed.");
                        }
                        break block19;
                    }
                    IJ.error((String)" Selected image is not a valid LSM file ");
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        public ImagePlus[] OpenLSM2(String string, String string2) {
            int n;
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            this.FILENAME = string2;
            try {
                if (this.FILENAME == null) {
                    IJ.error((String)"no file selected");
                    return null;
                }
                this.DIRECTORY = string;
                if (this.DIRECTORY == null) {
                    IJ.error((String)"no file selected");
                    return null;
                }
                this.LSM = new File(this.DIRECTORY, this.FILENAME);
                this.file = new RandomAccessFile(this.LSM, "r");
                this.stream = new RandomAccessStream(this.file);
                if (!string.equals("about")) {
                    this.lsm_fi = new LSMFileInfo();
                    this.lsm_fi.FILENAME = this.FILENAME;
                    this.lsm_fi.DIRECTORY = this.DIRECTORY;
                    n = this.isLSMfile() ? 1 : 0;
                    if (n != 0) {
                        Object object;
                        long l = 0L;
                        long l2 = 0L;
                        int n2 = 0;
                        long l3 = 8L;
                        do {
                            l = this.HowManyTAGs((int)l3);
                            int n3 = 0;
                            while ((long)n3 < l) {
                                byte[] byArray = this.readTAG(l3 + 2L + (long)(12 * n3));
                                this.analyseTAG(byArray);
                                ++n3;
                            }
                            this.getSTRIPOFFSETS(this.lsm_fi.TIF_STRIPOFFSETS);
                            this.stream.seek((int)l3 + 2 + 12 * (int)l);
                            l3 = l2 = (long)this.swap(this.stream.readInt());
                            ++n2;
                            if (this.lsm_fi.LENGTH2 == 1L) {
                                this.lsm_fi.STRIPOFF.add(new Long(this.lsm_fi.TIF_STRIPOFFSETS));
                            } else {
                                this.lsm_fi.STRIPOFF.add(new Long(this.lsm_fi.TIF_STRIPOFFSETS1));
                            }
                            this.lsm_fi.IMAGETYPE.add(new Long(this.lsm_fi.TIF_NEWSUBFILETYPE));
                        } while (l2 != 0L);
                        long l4 = this.HowManyTAGs(8L);
                        int n4 = 0;
                        while ((long)n4 < l4) {
                            object = this.readTAG(10 + 12 * n4);
                            this.analyseTAG((byte[])object);
                            ++n4;
                        }
                        this.getSTRIPOFFSETS(this.lsm_fi.TIF_STRIPOFFSETS);
                        this.getSTRIPBYTECOUNTS(this.lsm_fi.TIF_STRIPBYTECOUNTS);
                        this.getCZ_LSMINFO(this.lsm_fi.TIF_CZ_LSMINFO);
                        this.getCHANNELNAMESANDCOLORS(this.lsm_fi.OFFSET_CHANNELSCOLORS);
                        this.getSCANINFO(this.lsm_fi.OFFSET_SCANINFO);
                        this.stream.close();
                        this.file.close();
                        for (n4 = 0; n4 < (int)this.lsm_fi.NUMBER_OF_CHANNELS; ++n4) {
                            object = this.open(this.DIRECTORY, this.FILENAME, this.lsm_fi.STRIPOFF, n4, false);
                            if (object != null) {
                                Color[] colorArray = new Color[2];
                                colorArray[0] = new Color(0, 0, 0);
                                int n5 = (int)(this.lsm_fi.COLORS[n4] & 0xFFL);
                                int n6 = (int)(this.lsm_fi.COLORS[n4] >> 8 & 0xFFL);
                                int n7 = (int)(this.lsm_fi.COLORS[n4] >> 16 & 0xFFL);
                                colorArray[1] = new Color(n5, n6, n7);
                                if (n5 == 0 && n6 == 0 && n7 == 0) {
                                    colorArray[1] = Color.white;
                                }
                                this.apply_colors((ImagePlus)object, colorArray, 2);
                                if (this.lsm_fi.DATATYPE == 2L) {
                                    double d = object.getProcessor().getMin();
                                    double d2 = object.getProcessor().getMax();
                                    object.getProcessor().setMinAndMax(d, d2);
                                }
                            }
                            arrayList.add(n4, (byte[])object);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            n = arrayList.size();
            ImagePlus[] imagePlusArray = new ImagePlus[n];
            for (int i = 0; i < n; ++i) {
                imagePlusArray[i] = (ImagePlus)arrayList.get(i);
            }
            return imagePlusArray;
        }

        public boolean isLSMfile() {
            boolean bl = false;
            long l = 0L;
            try {
                this.stream.seek(2);
                l = this.swap(this.stream.readShort());
                if (l == 42L) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return bl;
        }

        public byte[] readTAG(long l) {
            byte[] byArray = new byte[12];
            try {
                if (this.file == null) {
                    this.stream.seek((int)l);
                } else {
                    this.file.seek(l);
                }
                for (int i = 0; i < 12; ++i) {
                    byArray[i] = this.file == null ? (byte)this.stream.read() : this.file.readByte();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return byArray;
        }

        public void analyseTAG(byte[] byArray) {
            int n = 0;
            long l = 0L;
            int n2 = 255;
            long l2 = 255L;
            n = (byArray[1] & n2) << 8 | (byArray[0] & n2) << 0;
            l = ((long)byArray[7] & l2) << 24 | ((long)byArray[6] & l2) << 16 | ((long)byArray[5] & l2) << 8 | (long)byArray[4] & l2;
            switch (n) {
                case 254: {
                    this.lsm_fi.TIF_NEWSUBFILETYPE = ((long)byArray[11] & l2) << 24 | ((long)byArray[10] & l2) << 16 | ((long)byArray[9] & l2) << 8 | (long)byArray[8] & l2;
                    break;
                }
                case 256: {
                    this.lsm_fi.TIF_IMAGEWIDTH = ((long)byArray[11] & l2) << 24 | ((long)byArray[10] & l2) << 16 | ((long)byArray[9] & l2) << 8 | (long)byArray[8] & l2;
                    break;
                }
                case 257: {
                    this.lsm_fi.TIF_IMAGELENGTH = ((long)byArray[11] & l2) << 24 | ((long)byArray[10] & l2) << 16 | ((long)byArray[9] & l2) << 8 | (long)byArray[8] & l2;
                    break;
                }
                case 258: {
                    this.lsm_fi.LENGTH1 = ((long)byArray[7] & l2) << 24 | ((long)byArray[6] & l2) << 16 | ((long)byArray[5] & l2) << 8 | (long)byArray[4] & l2;
                    this.lsm_fi.TIF_BITSPERSAMPLE_CHANNEL1 = ((long)byArray[8] & l2) << 0;
                    this.lsm_fi.TIF_BITSPERSAMPLE_CHANNEL2 = ((long)byArray[9] & l2) << 0;
                    this.lsm_fi.TIF_BITSPERSAMPLE_CHANNEL3 = ((long)byArray[10] & l2) << 0;
                    break;
                }
                case 259: {
                    this.lsm_fi.TIF_COMPRESSION = ((long)byArray[8] & l2) << 0;
                    break;
                }
                case 262: {
                    this.lsm_fi.TIF_PHOTOMETRICINTERPRETATION = ((long)byArray[8] & l2) << 0;
                    break;
                }
                case 273: {
                    this.lsm_fi.LENGTH2 = ((long)byArray[7] & l2) << 24 | ((long)byArray[6] & l2) << 16 | ((long)byArray[5] & l2) << 8 | (long)byArray[4] & l2;
                    this.lsm_fi.TIF_STRIPOFFSETS = ((long)byArray[11] & l2) << 24 | ((long)byArray[10] & l2) << 16 | ((long)byArray[9] & l2) << 8 | (long)byArray[8] & l2;
                    break;
                }
                case 277: {
                    this.lsm_fi.TIF_SAMPLESPERPIXEL = ((long)byArray[8] & l2) << 0;
                    break;
                }
                case 279: {
                    this.lsm_fi.TIF_STRIPBYTECOUNTS = ((long)byArray[11] & l2) << 24 | ((long)byArray[10] & l2) << 16 | ((long)byArray[9] & l2) << 8 | (long)byArray[8] & l2;
                    break;
                }
                case 34412: {
                    this.lsm_fi.TIF_CZ_LSMINFO = ((long)byArray[11] & l2) << 24 | ((long)byArray[10] & l2) << 16 | ((long)byArray[9] & l2) << 8 | (long)byArray[8] & l2;
                    break;
                }
            }
        }

        public void getSTRIPOFFSETS(long l) {
            try {
                this.stream.seek((int)l);
                this.lsm_fi.TIF_STRIPOFFSETS1 = this.swap(this.stream.readInt());
                this.lsm_fi.TIF_STRIPOFFSETS2 = this.swap(this.stream.readInt());
                this.lsm_fi.TIF_STRIPOFFSETS3 = this.swap(this.stream.readInt());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void getSTRIPBYTECOUNTS(long l) {
            try {
                this.stream.seek((int)l);
                this.lsm_fi.TIF_STRIPBYTECOUNTS1 = this.swap(this.stream.readInt());
                this.lsm_fi.TIF_STRIPBYTECOUNTS2 = this.swap(this.stream.readInt());
                this.lsm_fi.TIF_STRIPBYTECOUNTS3 = this.swap(this.stream.readInt());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public long HowManyTAGs(long l) {
            long l2 = 0L;
            try {
                this.stream.seek((int)l);
                l2 = this.swap(this.stream.readShort());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return l2;
        }

        public void getCZ_LSMINFO(long l) {
            try {
                if (l == 0L) {
                    return;
                }
                this.stream.seek((int)l + 8);
                this.lsm_fi.DIMENSION_X = this.swap(this.stream.readInt());
                this.lsm_fi.DIMENSION_Y = this.swap(this.stream.readInt());
                this.lsm_fi.DIMENSION_Z = this.swap(this.stream.readInt());
                this.lsm_fi.NUMBER_OF_CHANNELS = this.swap(this.stream.readInt());
                this.lsm_fi.TIMESTACKSIZE = this.swap(this.stream.readInt());
                this.lsm_fi.DATATYPE = this.swap(this.stream.readInt());
                this.stream.seek((int)l + 88);
                this.lsm_fi.SCANTYPE = this.swap(this.stream.readShort());
                this.stream.seek((int)l + 90);
                this.lsm_fi.SPECTRALSCAN = this.swap(this.stream.readShort());
                this.stream.seek((int)l + 92);
                this.lsm_fi.DATATYPE2 = this.swap(this.stream.readInt());
                this.stream.seek((int)l + 100);
                this.lsm_fi.OFFSET_INPUTLUT = this.swap(this.stream.readInt());
                this.stream.seek((int)l + 104);
                this.lsm_fi.OFFSET_OUTPUTLUT = this.swap(this.stream.readInt());
                this.stream.seek((int)l + 40);
                this.lsm_fi.VOXELSIZE_X = this.swap(this.stream.readDouble());
                this.stream.seek((int)l + 48);
                this.lsm_fi.VOXELSIZE_Y = this.swap(this.stream.readDouble());
                this.stream.seek((int)l + 56);
                this.lsm_fi.VOXELSIZE_Z = this.swap(this.stream.readDouble());
                this.stream.seek((int)l + 108);
                this.lsm_fi.OFFSET_CHANNELSCOLORS = this.swap(this.stream.readInt());
                this.stream.seek((int)l + 120);
                this.lsm_fi.OFFSET_CHANNELDATATYPES = this.swap(this.stream.readInt());
                this.stream.seek((int)l + 124);
                this.lsm_fi.OFFSET_SCANINFO = this.swap(this.stream.readInt());
                this.stream.seek((int)l + 132);
                this.lsm_fi.OFFSET_TIMESTAMPS = this.swap(this.stream.readInt());
                this.stream.seek((int)l + 136);
                this.lsm_fi.OFFSET_EVENTLIST = this.swap(this.stream.readInt());
                this.stream.seek((int)l + 204);
                this.lsm_fi.OFFSET_CHANNELWAVELENGTH = this.swap(this.stream.readInt());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void getEVENTLIST(long l) {
            String string = new String("Time (sec) \tEvent Type \tEvent Description");
            TextWindow textWindow = new TextWindow("Time Events for " + this.lsm_fi.FILENAME, string, null, 400, 200);
            long l2 = 0L;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            int n = 0;
            String string5 = "Events :\n\n";
            int n2 = 0;
            try {
                this.stream.seek((int)l);
                l3 = this.swap(this.stream.readInt());
                l4 = this.swap(this.stream.readInt());
                if (l4 > 0L) {
                    double[] dArray = new double[(int)l4];
                    int n3 = 0;
                    while ((long)n3 < l4) {
                        boolean bl = true;
                        string3 = "";
                        n2 = this.stream.getFilePointer();
                        l5 = this.swap(this.stream.readInt());
                        dArray[n3] = this.swap(this.stream.readDouble());
                        string3 = string3 + IJ.d2s((double)(dArray[n3] - this.lsm_fi.FirstTimeStamp)) + "\t";
                        l2 = this.swap(this.stream.readInt());
                        switch ((int)l2) {
                            case 0: {
                                string2 = "Marker";
                                break;
                            }
                            case 1: {
                                string2 = "Timer Change";
                                break;
                            }
                            case 2: {
                                string2 = "Bleach Start";
                                break;
                            }
                            case 3: {
                                string2 = "Bleach Stop";
                                break;
                            }
                            case 4: {
                                string2 = "Trigger";
                                break;
                            }
                            default: {
                                string2 = "Unknown";
                            }
                        }
                        string3 = string3 + string2 + "\t";
                        n = (int)l5 - 16;
                        if (n < 255) {
                            if (this.file != null) {
                                this.file.seek(this.stream.getFilePointer());
                            }
                            if (n > 1) {
                                string4 = this.file != null ? this.file.readLine() : LSM_Reader.readLine(this.stream);
                            }
                            this.stream.seek(n2 + (int)l5);
                            if (string4.length() > 5) {
                                string4 = string4.substring(4, n - 1);
                            }
                            if (n > 5) {
                                string4 = string4.trim();
                            }
                            if (string4.length() == 0) {
                                string4 = "";
                            }
                        }
                        string3 = string3 + string4 + "\t";
                        textWindow.append(string3);
                        this.lsm_fi.TimeEvents = this.lsm_fi.TimeEvents + "- Description :" + string3 + "\n\n";
                        ++n3;
                    }
                }
            }
            catch (IOException iOException) {
                IJ.log((String)("IOException \nLast Offset: " + IJ.d2s((double)l, (int)0)));
                iOException.printStackTrace();
            }
        }

        public void getTIMESTAMPS(long l) {
            try {
                this.stream.seek((int)l);
                this.lsm_fi.TS_BYTESIZE = this.swap(this.stream.readInt());
                this.lsm_fi.TS_COUNT = this.swap(this.stream.readInt());
                this.lsm_fi.TS_STAMPS = new double[(int)this.lsm_fi.TS_COUNT];
                int n = 0;
                while ((long)n < this.lsm_fi.TS_COUNT) {
                    this.lsm_fi.TS_STAMPS[n] = this.swap(this.stream.readDouble());
                    ++n;
                }
                n = 1;
                while ((long)n < this.lsm_fi.TS_COUNT) {
                    this.lsm_fi.TS_STAMPS[n] = this.lsm_fi.TS_STAMPS[n] - this.lsm_fi.TS_STAMPS[0];
                    ++n;
                }
                this.lsm_fi.FirstTimeStamp = this.lsm_fi.TS_STAMPS[0];
                this.lsm_fi.TS_STAMPS[0] = 0.0;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void getLAMBDASTAMPS(long l) {
            try {
                this.stream.seek((int)l);
                this.lsm_fi.LS_COUNT = this.swap(this.stream.readInt());
                this.lsm_fi.LS_STAMPS = new double[(int)this.lsm_fi.LS_COUNT];
                int n = 0;
                while ((long)n < this.lsm_fi.LS_COUNT) {
                    double d = this.swap(this.stream.readDouble());
                    double d2 = this.swap(this.stream.readDouble());
                    this.lsm_fi.LS_STAMPS[n] = (d + d2) / 2.0;
                    ++n;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void getLUT(long l, LSMFileInfo.LUT_INFO lUT_INFO) {
            try {
                this.stream.seek((int)l);
                IJ.error((String)("Offset: " + Long.toString(l)));
                lUT_INFO.LUT_SIZE = this.swap(this.stream.readInt());
                IJ.error((String)("Size: " + Long.toString(lUT_INFO.LUT_SIZE)));
                lUT_INFO.SUBBLOCKS_COUNT = this.swap(this.stream.readInt());
                IJ.error((String)("SB COUNT: " + Long.toString(lUT_INFO.SUBBLOCKS_COUNT)));
                lUT_INFO.CHANNELS_COUNT = this.swap(this.stream.readInt());
                IJ.error((String)("CH COUNT: " + Long.toString(lUT_INFO.CHANNELS_COUNT)));
                lUT_INFO.LUT_TYPE = this.swap(this.stream.readInt());
                lUT_INFO.ADVANCED = this.swap(this.stream.readInt());
                lUT_INFO.CURRENT_CHANNEL = this.swap(this.stream.readInt());
                this.stream.readInt();
                IJ.error((String)("Subblocks : " + Long.toString(lUT_INFO.SUBBLOCKS_COUNT)));
                int n = 0;
                while ((long)n < lUT_INFO.SUBBLOCKS_COUNT) {
                    long l2 = this.swap(this.stream.readInt());
                    IJ.error((String)("Subblock type : " + Long.toString(l2)));
                    switch ((int)l2) {
                        case 1: {
                            lUT_INFO.G_SIZE = this.swap(this.stream.readInt());
                            IJ.error((String)"Gamma present");
                            int n2 = 0;
                            while ((long)n < lUT_INFO.CHANNELS_COUNT) {
                                lUT_INFO.G_CHANNEL[n2] = this.swap(this.stream.readDouble());
                                ++n2;
                            }
                            break;
                        }
                        case 2: {
                            lUT_INFO.B_SIZE = this.swap(this.stream.readInt());
                            IJ.error((String)"Brightness present");
                            int n2 = 0;
                            while ((long)n < lUT_INFO.CHANNELS_COUNT) {
                                lUT_INFO.B_CHANNEL[n2] = this.swap(this.stream.readDouble());
                                ++n2;
                            }
                            break;
                        }
                        case 3: {
                            lUT_INFO.C_SIZE = this.swap(this.stream.readInt());
                            IJ.error((String)"Contrast present");
                            int n2 = 0;
                            while ((long)n < lUT_INFO.CHANNELS_COUNT) {
                                lUT_INFO.C_CHANNEL[n2] = this.swap(this.stream.readDouble());
                                ++n2;
                            }
                            break;
                        }
                        case 4: {
                            lUT_INFO.R_SIZE = this.swap(this.stream.readInt());
                            IJ.error((String)"Ramp present");
                            int n2 = 0;
                            while ((long)n < lUT_INFO.CHANNELS_COUNT) {
                                lUT_INFO.R_CHANNELSX[n2] = this.swap(this.stream.readDouble());
                                lUT_INFO.R_CHANNELSY[n2] = this.swap(this.stream.readDouble());
                                lUT_INFO.R_CHANNELEX[n2] = this.swap(this.stream.readDouble());
                                lUT_INFO.R_CHANNELEY[n2] = this.swap(this.stream.readDouble());
                                ++n2;
                            }
                            break;
                        }
                        case 5: {
                            int n3;
                            lUT_INFO.K_SIZE = this.swap(this.stream.readInt());
                            IJ.error((String)"Knots present");
                            lUT_INFO.KNOTS = (lUT_INFO.K_SIZE - 4L) / (lUT_INFO.CHANNELS_COUNT * 4L);
                            int n2 = 0;
                            while ((long)n < lUT_INFO.CHANNELS_COUNT) {
                                n3 = 0;
                                while ((long)n3 < lUT_INFO.KNOTS) {
                                    lUT_INFO.K_CHANNELX[(int)((long)n2 * lUT_INFO.KNOTS + (long)n3)] = this.swap(this.stream.readDouble());
                                    lUT_INFO.K_CHANNELY[(int)((long)n2 * lUT_INFO.KNOTS + (long)n3)] = this.swap(this.stream.readDouble());
                                    ++n3;
                                }
                                ++n2;
                            }
                            break;
                        }
                        case 6: {
                            int n3;
                            lUT_INFO.P_SIZE = this.swap(this.stream.readInt());
                            IJ.error((String)"Palette present");
                            int n2 = 0;
                            while ((long)n < lUT_INFO.CHANNELS_COUNT) {
                                for (n3 = 0; n3 < 4096; ++n3) {
                                    lUT_INFO.P_CHANNEL[n2 * 4096 + n3] = (byte)this.swap(this.stream.readShort());
                                }
                                ++n2;
                            }
                            break;
                        }
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void getCHANNELNAMESANDCOLORS(long l) {
            try {
                this.stream.seek((int)l);
                int n = this.swap(this.stream.readInt());
                this.stream.seek((int)l + 4);
                this.lsm_fi.NUMCOLORS = this.swap(this.stream.readInt());
                this.stream.seek((int)l + 12);
                this.lsm_fi.OFFSET_COLORS = this.swap(this.stream.readInt());
                this.stream.seek((int)l + 16);
                int n2 = this.swap(this.stream.readInt());
                if (this.file != null) {
                    this.file.seek(n2 + (int)l);
                } else {
                    this.stream.seek(n2 + (int)l);
                }
                int n3 = n - n2;
                String string = this.file != null ? this.file.readLine() : LSM_Reader.readLine(this.stream);
                string = string.substring(0, n3);
                boolean bl = false;
                int n4 = 4;
                int n5 = 5;
                int n6 = 0;
                while ((long)n6 < this.lsm_fi.NUMBER_OF_CHANNELS) {
                    n5 = string.indexOf(0, n4);
                    this.lsm_fi.Channel[n6] = string.substring(n4, n5);
                    n4 = n5 + 5;
                    ++n6;
                }
                this.stream.seek((int)this.lsm_fi.OFFSET_COLORS + (int)l);
                this.lsm_fi.COLORS = new long[(int)this.lsm_fi.NUMCOLORS];
                for (n6 = 0; n6 < (int)this.lsm_fi.NUMCOLORS; ++n6) {
                    this.lsm_fi.COLORS[n6] = this.swap(this.stream.readInt());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void getSCANINFO(long l) {
            int n = 0;
            String string = new String("");
            n = 0;
            String string2 = new String("");
            String string3 = new String("");
            int n2 = 1;
            int n3 = 1;
            int n4 = 1;
            int n5 = 1;
            try {
                this.stream.seek((int)l);
                do {
                    int n6;
                    if (string2.equals("060000000")) {
                        this.lsm_fi.SCANINFO.det_channels_count.add(new Integer(0));
                        n2 = 1;
                    }
                    if (string2.equals("080000000")) {
                        this.lsm_fi.SCANINFO.illum_channels_count.add(new Integer(0));
                        n3 = 1;
                    }
                    if (string2.equals("0A0000000")) {
                        this.lsm_fi.SCANINFO.bsplits_count.add(new Integer(0));
                        n4 = 1;
                    }
                    if (string2.equals("0C0000000")) {
                        this.lsm_fi.SCANINFO.data_channels_count.add(new Integer(0));
                        n5 = 1;
                    }
                    this.lsm_fi.SCANINFO.off = this.stream.getFilePointer();
                    this.read_tags();
                    boolean bl = false;
                    String string4 = Integer.toHexString(this.lsm_fi.SCANINFO.entry_1).toUpperCase();
                    String string5 = Integer.toHexString(this.lsm_fi.SCANINFO.entry_2).toUpperCase();
                    int n7 = string4.length();
                    int n8 = string5.length();
                    if (n7 < 4) {
                        for (n6 = 0; n6 < 4 - n7; ++n6) {
                            string4 = "0" + string4;
                        }
                    }
                    if (n8 < 4) {
                        for (n6 = 0; n6 < 4 - n8; ++n6) {
                            string5 = "0" + string5;
                        }
                    }
                    if ((string2 = "0" + this.shifter(string4 + string5)).equals("040000000")) {
                        this.lsm_fi.SCANINFO.tracks.add(new ArrayList());
                    }
                    if (string2.equals("050000000")) {
                        this.lsm_fi.SCANINFO.lasers.add(new ArrayList());
                    }
                    if (string2.equals("070000000")) {
                        this.lsm_fi.SCANINFO.det_channels.add(new ArrayList());
                        if (this.lsm_fi.SCANINFO.det_channels_count.isEmpty()) {
                            this.lsm_fi.SCANINFO.det_channels_count.addElement(new Integer(n2++));
                        } else {
                            this.lsm_fi.SCANINFO.det_channels_count.setElementAt(new Integer(n2++), this.lsm_fi.SCANINFO.det_channels_count.size() - 1);
                        }
                    }
                    if (string2.equals("090000000")) {
                        this.lsm_fi.SCANINFO.illum_channels.add(new ArrayList());
                        if (this.lsm_fi.SCANINFO.illum_channels_count.isEmpty()) {
                            this.lsm_fi.SCANINFO.illum_channels_count.addElement(new Integer(n3++));
                        } else {
                            this.lsm_fi.SCANINFO.illum_channels_count.setElementAt(new Integer(n3++), this.lsm_fi.SCANINFO.illum_channels_count.size() - 1);
                        }
                    }
                    if (string2.equals("0B0000000")) {
                        this.lsm_fi.SCANINFO.bsplits.add(new ArrayList());
                        if (this.lsm_fi.SCANINFO.bsplits_count.isEmpty()) {
                            this.lsm_fi.SCANINFO.bsplits_count.addElement(new Integer(n4++));
                        } else {
                            this.lsm_fi.SCANINFO.bsplits_count.setElementAt(new Integer(n4++), this.lsm_fi.SCANINFO.bsplits_count.size() - 1);
                        }
                    }
                    if (string2.equals("0D0000000")) {
                        this.lsm_fi.SCANINFO.data_channels.add(new ArrayList());
                        if (this.lsm_fi.SCANINFO.data_channels_count.isEmpty()) {
                            this.lsm_fi.SCANINFO.data_channels_count.addElement(new Integer(n5++));
                        } else {
                            this.lsm_fi.SCANINFO.data_channels_count.setElementAt(new Integer(n5++), this.lsm_fi.SCANINFO.data_channels_count.size() - 1);
                        }
                    }
                    if (string2.equals("012000000")) {
                        this.lsm_fi.SCANINFO.timers.add(new ArrayList());
                    }
                    if (string2.equals("014000000")) {
                        this.lsm_fi.SCANINFO.markers.add(new ArrayList());
                    }
                    for (int i = 0; i < 147; ++i) {
                        String string6 = new String(this.lsm_fi.SCANINFO.table[i][0]);
                        if (!string2.equals(string6 = string6.substring(2))) continue;
                        bl = true;
                        if (this.lsm_fi.SCANINFO.stype == 2L) {
                            string = this.read_ASCII(this.lsm_fi.SCANINFO.ssize);
                            this.lsm_fi.sb.append(Integer.toString(this.lsm_fi.SCANINFO.off) + "\t" + Integer.toString(n) + "\t" + this.lsm_fi.SCANINFO.table[i][0] + "\t" + this.lsm_fi.SCANINFO.table[i][3] + "\t" + this.lsm_fi.SCANINFO.ssize + "\t" + string + "\n");
                            if (i >= 17 && i <= 19 && !this.lsm_fi.SCANINFO.lasers.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.lasers.lastElement()).add(new Object[]{new Integer(i), string});
                            }
                            if (i >= 20 && i <= 70) {
                                this.lsm_fi.SCANINFO.recordings.add(new Object[]{new Integer(i), string});
                            }
                            if (i >= 71 && i <= 92 && !this.lsm_fi.SCANINFO.tracks.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.tracks.lastElement()).add(new Object[]{new Integer(i), string});
                            }
                            if (i >= 93 && i <= 115 && !this.lsm_fi.SCANINFO.det_channels.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.det_channels.lastElement()).add(new Object[]{new Integer(i), string});
                            }
                            if (i >= 116 && i <= 122 && !this.lsm_fi.SCANINFO.illum_channels.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.illum_channels.lastElement()).add(new Object[]{new Integer(i), string});
                            }
                            if (i >= 123 && i <= 125 && !this.lsm_fi.SCANINFO.bsplits.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.bsplits.lastElement()).add(new Object[]{new Integer(i), string});
                            }
                            if (i >= 126 && i <= 138 && !this.lsm_fi.SCANINFO.data_channels.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.data_channels.lastElement()).add(new Object[]{new Integer(i), string});
                            }
                            if (i >= 139 && i <= 142 && !this.lsm_fi.SCANINFO.timers.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.timers.lastElement()).add(new Object[]{new Integer(i), string});
                            }
                            if (i >= 143 && i <= 146 && !this.lsm_fi.SCANINFO.markers.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.markers.lastElement()).add(new Object[]{new Integer(i), string});
                            }
                        }
                        if (this.lsm_fi.SCANINFO.stype == 5L) {
                            double d = this.swap(this.stream.readDouble());
                            this.lsm_fi.sb.append(Integer.toString(this.lsm_fi.SCANINFO.off) + "\t" + Integer.toString(n) + "\t" + this.lsm_fi.SCANINFO.table[i][0] + "\t" + this.lsm_fi.SCANINFO.table[i][3] + "\t" + this.lsm_fi.SCANINFO.ssize + "\t" + Double.toString(d) + "\n");
                            if (i >= 17 && i <= 19 && !this.lsm_fi.SCANINFO.lasers.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.lasers.lastElement()).add(new Object[]{new Integer(i), new Double(d)});
                            }
                            if (i >= 20 && i <= 70) {
                                this.lsm_fi.SCANINFO.recordings.add(new Object[]{new Integer(i), new Double(d)});
                            }
                            if (i >= 71 && i <= 92 && !this.lsm_fi.SCANINFO.tracks.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.tracks.lastElement()).add(new Object[]{new Integer(i), new Double(d)});
                            }
                            if (i >= 93 && i <= 115 && !this.lsm_fi.SCANINFO.det_channels.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.det_channels.lastElement()).add(new Object[]{new Integer(i), new Double(d)});
                            }
                            if (i >= 116 && i <= 122 && !this.lsm_fi.SCANINFO.illum_channels.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.illum_channels.lastElement()).add(new Object[]{new Integer(i), new Double(d)});
                            }
                            if (i >= 123 && i <= 125 && !this.lsm_fi.SCANINFO.bsplits.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.bsplits.lastElement()).add(new Object[]{new Integer(i), new Double(d)});
                            }
                            if (i >= 126 && i <= 138 && !this.lsm_fi.SCANINFO.data_channels.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.data_channels.lastElement()).add(new Object[]{new Integer(i), new Double(d)});
                            }
                            if (i >= 139 && i <= 142 && !this.lsm_fi.SCANINFO.timers.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.timers.lastElement()).add(new Object[]{new Integer(i), new Double(d)});
                            }
                            if (i >= 143 && i <= 146 && !this.lsm_fi.SCANINFO.markers.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.markers.lastElement()).add(new Object[]{new Integer(i), new Double(d)});
                            }
                        }
                        if (this.lsm_fi.SCANINFO.stype == 4L) {
                            long l2 = this.swap(this.stream.readInt());
                            this.lsm_fi.sb.append(Integer.toString(this.lsm_fi.SCANINFO.off) + "\t" + Integer.toString(n) + "\t" + this.lsm_fi.SCANINFO.table[i][0] + "\t" + this.lsm_fi.SCANINFO.table[i][3] + "\t" + this.lsm_fi.SCANINFO.ssize + "\t" + Long.toString(l2) + "\n");
                            if (i >= 17 && i <= 19 && !this.lsm_fi.SCANINFO.lasers.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.lasers.lastElement()).add(new Object[]{new Integer(i), new Long(l2)});
                            }
                            if (i >= 20 && i <= 70) {
                                this.lsm_fi.SCANINFO.recordings.add(new Object[]{new Integer(i), new Long(l2)});
                            }
                            if (i >= 71 && i <= 92 && !this.lsm_fi.SCANINFO.tracks.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.tracks.lastElement()).add(new Object[]{new Integer(i), new Long(l2)});
                            }
                            if (i >= 93 && i <= 115 && !this.lsm_fi.SCANINFO.det_channels.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.det_channels.lastElement()).add(new Object[]{new Integer(i), new Long(l2)});
                            }
                            if (i >= 116 && i <= 122 && !this.lsm_fi.SCANINFO.illum_channels.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.illum_channels.lastElement()).add(new Object[]{new Integer(i), new Long(l2)});
                            }
                            if (i >= 123 && i <= 125 && !this.lsm_fi.SCANINFO.bsplits.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.bsplits.lastElement()).add(new Object[]{new Integer(i), new Long(l2)});
                            }
                            if (i >= 126 && i <= 138 && !this.lsm_fi.SCANINFO.data_channels.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.data_channels.lastElement()).add(new Object[]{new Integer(i), new Long(l2)});
                            }
                            if (i >= 139 && i <= 142 && !this.lsm_fi.SCANINFO.timers.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.timers.lastElement()).add(new Object[]{new Integer(i), new Long(l2)});
                            }
                            if (i >= 143 && i <= 146 && !this.lsm_fi.SCANINFO.markers.isEmpty()) {
                                ((ArrayList)this.lsm_fi.SCANINFO.markers.lastElement()).add(new Object[]{new Integer(i), new Long(l2)});
                            }
                        }
                        if (this.lsm_fi.SCANINFO.stype != 0L) continue;
                        this.lsm_fi.sb.append(Integer.toString(this.lsm_fi.SCANINFO.off) + "\t" + Integer.toString(n) + "\t" + this.lsm_fi.SCANINFO.table[i][0] + "\t" + this.lsm_fi.SCANINFO.table[i][3] + "\t\t" + "\n");
                        ++n;
                    }
                    if (string2.equals("0FFFFFFFF")) {
                        bl = true;
                        this.lsm_fi.sb.append(Integer.toString(this.lsm_fi.SCANINFO.off) + "\t" + Integer.toString(n) + "\t0x0FFFFFFFF\tEND SUBBLOCK\t" + Long.toString(this.lsm_fi.SCANINFO.ssize) + "\n");
                        --n;
                    }
                    if (bl) continue;
                    if (this.lsm_fi.SCANINFO.stype == 2L) {
                        string = this.read_ASCII(this.lsm_fi.SCANINFO.ssize);
                        this.lsm_fi.sb.append(Integer.toString(this.lsm_fi.SCANINFO.off) + "\t" + Integer.toString(n) + "\t\tUNKNOWN TAG\t" + this.lsm_fi.SCANINFO.ssize + "\t" + string + "\n");
                        this.lsm_fi.SCANINFO.unknown.add(new Object[]{null, string});
                    }
                    if (this.lsm_fi.SCANINFO.stype == 5L) {
                        double d = this.stream.readDouble();
                        this.lsm_fi.sb.append(Integer.toString(this.lsm_fi.SCANINFO.off) + "\t" + Integer.toString(n) + "\t\tUNKNOWN TAG\t" + this.lsm_fi.SCANINFO.ssize + "\t" + Double.toString(d) + "\n");
                        this.lsm_fi.SCANINFO.unknown.add(new Object[]{null, new Double(d)});
                    }
                    if (this.lsm_fi.SCANINFO.stype != 4L) continue;
                    long l3 = this.swap(this.stream.readInt());
                    this.lsm_fi.sb.append(Integer.toString(this.lsm_fi.SCANINFO.off) + "\t" + Integer.toString(n) + "\t\tUNKNOWN TAG\t" + this.lsm_fi.SCANINFO.ssize + "\t" + Long.toString(l3) + "\n");
                    this.lsm_fi.SCANINFO.unknown.add(new Object[]{null, new Long(l3)});
                } while (n > 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.lsm_fi.Objective = (String)this.scanObjectArray(this.lsm_fi.SCANINFO.recordings, 23);
            this.lsm_fi.ShortNotes = (String)this.scanObjectArray(this.lsm_fi.SCANINFO.recordings, 22);
            this.lsm_fi.DetailedNotes = (String)this.scanObjectArray(this.lsm_fi.SCANINFO.recordings, 21);
            this.lsm_fi.User = (String)this.scanObjectArray(this.lsm_fi.SCANINFO.recordings, 66);
            this.lsm_fi.ZOOM_X = this.getDouble(41);
            this.lsm_fi.ZOOM_Y = this.getDouble(42);
            this.lsm_fi.ZOOM_Z = this.getDouble(43);
            this.lsm_fi.PLANE_SPACING = this.getDouble(49);
            this.lsm_fi.PLANE_WIDTH = this.getDouble(50);
            this.lsm_fi.PLANE_HEIGHT = this.getDouble(51);
            this.lsm_fi.VOLUME_DEPTH = this.getDouble(52);
        }

        double getDouble(int n) {
            Object object = this.scanObjectArray(this.lsm_fi.SCANINFO.recordings, n);
            if (object instanceof String && object.equals("")) {
                return -1.0;
            }
            return (Double)object;
        }

        public Object scanObjectArray(ArrayList arrayList, int n) {
            Object[] objectArray = new Object[2];
            Object object = new Object();
            object = new String("");
            for (int i = 0; i < arrayList.size(); ++i) {
                objectArray = (Object[])arrayList.get(i);
                int n2 = (Integer)objectArray[0];
                if (n != (Integer)objectArray[0]) continue;
                object = objectArray[1];
            }
            return object;
        }

        public ImagePlus open(String string, String string2, Vector vector, int n, boolean bl) {
            File file = new File(string, string2);
            try {
                FileInfo fileInfo = new FileInfo();
                fileInfo.url = "";
                fileInfo.directory = string;
                fileInfo.fileFormat = 2;
                fileInfo.fileName = string2;
                int n2 = (int)this.lsm_fi.DATATYPE;
                switch (n2) {
                    case 1: {
                        fileInfo.fileType = 0;
                        break;
                    }
                    case 2: {
                        fileInfo.fileType = 2;
                        break;
                    }
                    case 5: {
                        fileInfo.fileType = 4;
                        break;
                    }
                    default: {
                        fileInfo.fileType = 0;
                    }
                }
                fileInfo.height = (int)this.lsm_fi.TIF_IMAGELENGTH;
                fileInfo.intelByteOrder = true;
                int n3 = (int)this.lsm_fi.SCANTYPE;
                int n4 = 0;
                switch (n3) {
                    case 3: {
                        n4 = (int)this.lsm_fi.TIMESTACKSIZE;
                        break;
                    }
                    case 4: {
                        n4 = (int)this.lsm_fi.TIMESTACKSIZE;
                        break;
                    }
                    case 6: {
                        n4 = (int)this.lsm_fi.TIMESTACKSIZE * (int)this.lsm_fi.DIMENSION_Z;
                        break;
                    }
                    default: {
                        n4 = (int)this.lsm_fi.DIMENSION_Z;
                    }
                }
                ImagePlus imagePlus = new ImagePlus();
                fileInfo.width = (int)this.lsm_fi.TIF_IMAGEWIDTH;
                fileInfo.height = (int)this.lsm_fi.TIF_IMAGELENGTH;
                fileInfo.pixelDepth = this.lsm_fi.VOXELSIZE_Z * 1000000.0;
                fileInfo.pixelHeight = this.lsm_fi.VOXELSIZE_Y * 1000000.0;
                fileInfo.pixelWidth = this.lsm_fi.VOXELSIZE_X * 1000000.0;
                fileInfo.unit = "\u00b5m";
                fileInfo.valueUnit = "\u00b5m";
                fileInfo.nImages = 1;
                ColorModel colorModel = this.createColorModel(fileInfo);
                ImageStack imageStack = new ImageStack(fileInfo.width, fileInfo.height, colorModel);
                Vector<Long> vector2 = new Vector<Long>();
                for (int i = 0; i < this.lsm_fi.STRIPOFF.size(); ++i) {
                    if (((Long)this.lsm_fi.IMAGETYPE.elementAt(i)).intValue() != 0) continue;
                    vector2.addElement((Long)this.lsm_fi.STRIPOFF.elementAt(i));
                }
                ImageReader imageReader = new ImageReader(fileInfo);
                if (this.file == null) {
                    this.stream.seek(0);
                    int n5 = this.lsm_fi.DATATYPE == 2L ? ((Long)vector2.firstElement()).intValue() + n * fileInfo.width * fileInfo.height * 2 : ((Long)vector2.firstElement()).intValue() + n * fileInfo.width * fileInfo.height;
                    int n6 = 0;
                    for (int i = 0; i < vector2.size(); ++i) {
                        this.stream.skip((long)n5);
                        Object object = imageReader.readPixels((InputStream)this.stream);
                        imageStack.addSlice("", object);
                        n5 = i < vector2.size() - 1 ? (this.lsm_fi.DATATYPE == 2L ? ((Long)vector2.elementAt(i + 1)).intValue() - ((Long)vector2.elementAt(i)).intValue() - fileInfo.width * fileInfo.height * 2 : ((Long)vector2.elementAt(i + 1)).intValue() - ((Long)vector2.elementAt(i)).intValue() - fileInfo.width * fileInfo.height) : 0;
                        ++n6;
                    }
                    IJ.showProgress((double)1.0);
                    if (imageStack.getSize() == 0) {
                        return null;
                    }
                    imagePlus = new ImagePlus(fileInfo.fileName, imageStack);
                    imagePlus.setFileInfo(fileInfo);
                    this.setCalibration(imagePlus, fileInfo, null);
                    ImageProcessor imageProcessor = imagePlus.getProcessor();
                    if (imageProcessor.getMin() == imageProcessor.getMax()) {
                        IJ.showProgress((double)1.0);
                    }
                    if (bl) {
                        imagePlus.show();
                    }
                    return imagePlus;
                }
                FileOpener fileOpener = new FileOpener(fileInfo);
                InputStream inputStream = fileOpener.createInputStream(fileInfo);
                int n7 = this.lsm_fi.DATATYPE == 2L ? ((Long)vector2.firstElement()).intValue() + n * fileInfo.width * fileInfo.height * 2 : ((Long)vector2.firstElement()).intValue() + n * fileInfo.width * fileInfo.height;
                int n8 = 0;
                for (int i = 0; i < vector2.size(); ++i) {
                    inputStream.skip(n7);
                    Object object = imageReader.readPixels(inputStream);
                    imageStack.addSlice("", object);
                    n7 = i < vector2.size() - 1 ? (this.lsm_fi.DATATYPE == 2L ? ((Long)vector2.elementAt(i + 1)).intValue() - ((Long)vector2.elementAt(i)).intValue() - fileInfo.width * fileInfo.height * 2 : ((Long)vector2.elementAt(i + 1)).intValue() - ((Long)vector2.elementAt(i)).intValue() - fileInfo.width * fileInfo.height) : 0;
                    ++n8;
                }
                inputStream.close();
                IJ.showProgress((double)1.0);
                if (imageStack.getSize() == 0) {
                    return null;
                }
                imagePlus = new ImagePlus(fileInfo.fileName, imageStack);
                imagePlus.setFileInfo(fileInfo);
                this.setCalibration(imagePlus, fileInfo, fileOpener);
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                if (imageProcessor.getMin() == imageProcessor.getMax()) {
                    IJ.showProgress((double)1.0);
                }
                if (bl) {
                    imagePlus.show();
                }
                return imagePlus;
            }
            catch (IOException iOException) {
                IJ.error((String)("An error occured while reading the file.\n \n" + iOException));
                IJ.showStatus((String)"");
                return null;
            }
        }

        void setCalibration(ImagePlus imagePlus, FileInfo fileInfo, FileOpener fileOpener) {
            int n;
            Calibration calibration = imagePlus.getCalibration();
            if (fileInfo.fileType == 1) {
                if (IJ.debugMode) {
                    IJ.log((String)"16-bit signed");
                }
                double[] dArray = new double[]{-32768.0, 1.0};
                calibration.setFunction(0, dArray, "gray value");
            }
            if (fileInfo.pixelWidth > 0.0 && fileInfo.unit != null) {
                calibration.pixelWidth = fileInfo.pixelWidth;
                calibration.pixelHeight = fileInfo.pixelHeight;
                calibration.pixelDepth = fileInfo.pixelDepth;
                calibration.setUnit(fileInfo.unit);
            }
            if (fileInfo.valueUnit != null && ((n = fileInfo.calibrationFunction) >= 0 && n <= 8 && fileInfo.coefficients != null || n == 21)) {
                calibration.setFunction(n, fileInfo.coefficients, fileInfo.valueUnit);
            }
            if (fileInfo.frameInterval != 0.0) {
                calibration.frameInterval = fileInfo.frameInterval;
            }
        }

        public ColorModel createColorModel(FileInfo fileInfo) {
            if (fileInfo.fileType == 5 && fileInfo.lutSize > 0) {
                return new IndexColorModel(8, fileInfo.lutSize, fileInfo.reds, fileInfo.greens, fileInfo.blues);
            }
            return LookUpTable.createGrayscaleColorModel((boolean)fileInfo.whiteIsZero);
        }

        public void apply_colors(ImagePlus imagePlus, Color[] colorArray, int n) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.reds = new byte[256];
            fileInfo.greens = new byte[256];
            fileInfo.blues = new byte[256];
            fileInfo.lutSize = 256;
            float f = 256.0f;
            float f2 = 256.0f;
            float f3 = colorArray[0].getRed();
            float f4 = colorArray[0].getGreen();
            float f5 = colorArray[0].getBlue();
            float f6 = colorArray[1].getRed() - colorArray[0].getRed();
            float f7 = colorArray[1].getGreen() - colorArray[0].getGreen();
            float f8 = colorArray[1].getBlue() - colorArray[0].getBlue();
            f6 /= f2;
            f7 /= f2;
            f8 /= f2;
            int n2 = 0;
            n2 = (int)(f2 * 0.0f);
            while (n2 < (int)(f2 * 0.0f + f2)) {
                fileInfo.reds[n2] = (byte)f3;
                fileInfo.greens[n2] = (byte)f4;
                fileInfo.blues[n2] = (byte)f5;
                ++n2;
                f3 += f6;
                f4 += f7;
                f5 += f8;
            }
            int n3 = (int)(f2 * 0.0f + f2) - 1;
            fileInfo.reds[n3] = (byte)colorArray[1].getRed();
            fileInfo.greens[n3] = (byte)colorArray[1].getGreen();
            fileInfo.blues[n3] = (byte)colorArray[1].getBlue();
            f = 256.0f;
            if (f > 0.0f) {
                if (f < 256.0f) {
                    this.interpolate(fileInfo.reds, fileInfo.greens, fileInfo.blues, (int)f);
                }
                this.showLut(imagePlus, fileInfo, true);
                return;
            }
        }

        void interpolate(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
            byte[] byArray4 = new byte[n];
            byte[] byArray5 = new byte[n];
            byte[] byArray6 = new byte[n];
            System.arraycopy(byArray, 0, byArray4, 0, n);
            System.arraycopy(byArray2, 0, byArray5, 0, n);
            System.arraycopy(byArray3, 0, byArray6, 0, n);
            double d = (double)n / 256.0;
            for (int i = 0; i < 256; ++i) {
                int n2 = (int)((double)i * d);
                int n3 = n2 + 1;
                if (n3 == n) {
                    n3 = n - 1;
                }
                double d2 = (double)i * d - (double)n2;
                byArray[i] = (byte)((1.0 - d2) * (double)(byArray4[n2] & 0xFF) + d2 * (double)(byArray4[n3] & 0xFF));
                byArray2[i] = (byte)((1.0 - d2) * (double)(byArray5[n2] & 0xFF) + d2 * (double)(byArray5[n3] & 0xFF));
                byArray3[i] = (byte)((1.0 - d2) * (double)(byArray6[n2] & 0xFF) + d2 * (double)(byArray6[n3] & 0xFF));
            }
        }

        void showLut(ImagePlus imagePlus, FileInfo fileInfo, boolean bl) {
            if (imagePlus != null) {
                if (imagePlus.getType() == 4) {
                    IJ.error((String)"Color tables cannot be assiged to RGB Images.");
                } else {
                    ImageProcessor imageProcessor = imagePlus.getProcessor();
                    IndexColorModel indexColorModel = new IndexColorModel(8, 256, fileInfo.reds, fileInfo.greens, fileInfo.blues);
                    imageProcessor.setColorModel((ColorModel)indexColorModel);
                    if (imagePlus.getStackSize() > 1) {
                        imagePlus.getStack().setColorModel((ColorModel)indexColorModel);
                    }
                    imagePlus.updateAndDraw();
                }
            }
        }

        String read_ASCII(long l) {
            int n = 0;
            String string = new String("");
            int n2 = 0;
            boolean bl = true;
            try {
                while ((long)n < l && (n2 = this.stream.read()) != -1) {
                    char c = (char)n2;
                    if (bl) {
                        String string2 = new Character(c).toString();
                        if (c != '\u0000') {
                            string = string + string2;
                        } else {
                            bl = false;
                        }
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return string;
        }

        void read_tags() {
            try {
                this.lsm_fi.SCANINFO.entry_1 = this.stream.readShort();
                this.lsm_fi.SCANINFO.entry_2 = this.stream.readShort();
                this.lsm_fi.SCANINFO.stype = this.swap(this.stream.readInt());
                this.lsm_fi.SCANINFO.ssize = this.swap(this.stream.readInt());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        String shifter(String string) {
            String string2 = new String();
            string2 = string.substring(6, 8) + string.substring(2, 6) + string.substring(0, 2);
            return string2;
        }

        short swap(short s) {
            return (short)(s << 8 | s >> 8 & 0xFF);
        }

        char swap(char c) {
            return (char)(c << 8 | c >> 8 & 0xFF);
        }

        int swap(int n) {
            return this.swap((short)n) << 16 | this.swap((short)(n >> 16)) & 0xFFFF;
        }

        long swap(long l) {
            return (long)this.swap((int)l) << 32 | (long)this.swap((int)(l >> 32)) & 0xFFFFFFFFL;
        }

        float swap(float f) {
            return Float.intBitsToFloat(this.swap(Float.floatToIntBits(f)));
        }

        double swap(double d) {
            return Double.longBitsToDouble(this.swap(Double.doubleToLongBits(d)));
        }
    }

    public class Notes
    extends JDialog {
        public Notes(JFrame jFrame) {
            super(jFrame, "LSM Notes", true);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            JLabel jLabel = new JLabel("Short Notes :");
            JLabel jLabel2 = new JLabel("Detailed Notes :");
            JTextArea jTextArea = new JTextArea("");
            JTextArea jTextArea2 = new JTextArea("");
            jTextArea.setEditable(false);
            jTextArea.setEditable(false);
            jTextArea2.setRows(4);
            jTextArea2.setRows(4);
            jTextArea.setColumns(20);
            jTextArea2.setColumns(20);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            this.setSize(300, 300);
            JPanel jPanel3 = new JPanel();
            this.setLocation(300, 300);
            jPanel3.setLayout(new GridLayout(2, 2, 0, 2));
            jPanel3.add(jLabel);
            jPanel3.add(jTextArea);
            jPanel3.add(jLabel2);
            jPanel3.add(jTextArea2);
            container.add((Component)jPanel3, "North");
            JButton jButton = new JButton("Ok");
            this.addokbListener(jButton, this);
            container.add((Component)jButton, "South");
            jTextArea.setText(LSM_Reader.this.theGUI.lsm_fi.ShortNotes);
            jTextArea2.setText(LSM_Reader.this.theGUI.lsm_fi.DetailedNotes);
            this.pack();
            this.show();
        }

        private void addokbListener(JButton jButton, JDialog jDialog) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Notes.this.dispose();
                }
            });
        }
    }

    class MyFocusListener
    extends WindowAdapter {
        ImagePlus current_imp;
        LSMFileInfo lfi;

        public MyFocusListener(LSMFileInfo lSMFileInfo, ImagePlus imagePlus) {
            this.current_imp = imagePlus;
            this.lfi = new LSMFileInfo();
            this.lfi = lSMFileInfo;
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (LSM_Reader.this.theGUI != null) {
                LSM_Reader.this.theGUI.lsm_fi = this.lfi;
                if (LSM_Reader.this.theGUI.lsm_fi.TIMESTACKSIZE <= 1L) {
                    LSM_Reader.this.theGUI.butt5.setEnabled(false);
                } else {
                    LSM_Reader.this.theGUI.butt5.setEnabled(true);
                }
                if (LSM_Reader.this.theGUI.lsm_fi.DIMENSION_Z <= 1L) {
                    LSM_Reader.this.theGUI.butt7.setEnabled(false);
                } else {
                    LSM_Reader.this.theGUI.butt7.setEnabled(true);
                }
                if (LSM_Reader.this.theGUI.lsm_fi.SPECTRALSCAN == 0) {
                    LSM_Reader.this.theGUI.butt8.setEnabled(false);
                } else if (LSM_Reader.this.theGUI.lsm_fi.LS_COUNT >= 1L) {
                    LSM_Reader.this.theGUI.butt8.setEnabled(true);
                }
                LSM_Reader.this.theGUI.updateInfoFrame(LSM_Reader.this.theGUI.printINFO());
                LSM_Reader.this.theGUI.updateNodes(LSM_Reader.this.theGUI.rootnode);
                LSM_Reader.this.theGUI.tree.clearSelection();
                LSM_Reader.this.theGUI.tree.collapseRow(1);
                if (LSM_Reader.this.theGUI.switcher) {
                    LSM_Reader.this.theGUI.SwitchButton.setText("Switch to general view");
                } else {
                    LSM_Reader.this.theGUI.SwitchButton.setText("Switch to filtered view");
                }
            }
        }

        public void windowLostFocus(WindowEvent windowEvent) {
            if (LSM_Reader.this.theGUI != null) {
                LSM_Reader.this.theGUI.lsm_fi = this.lfi;
                if (LSM_Reader.this.theGUI.lsm_fi.TIMESTACKSIZE == 1L) {
                    LSM_Reader.this.theGUI.butt5.setEnabled(false);
                } else {
                    LSM_Reader.this.theGUI.butt5.setEnabled(true);
                }
                if (LSM_Reader.this.theGUI.lsm_fi.DIMENSION_Z == 1L) {
                    LSM_Reader.this.theGUI.butt7.setEnabled(false);
                } else {
                    LSM_Reader.this.theGUI.butt7.setEnabled(true);
                }
                if (LSM_Reader.this.theGUI.lsm_fi.SPECTRALSCAN == 1 && LSM_Reader.this.theGUI.lsm_fi.LS_COUNT > 1L) {
                    LSM_Reader.this.theGUI.butt8.setEnabled(false);
                } else {
                    LSM_Reader.this.theGUI.butt8.setEnabled(true);
                }
                LSM_Reader.this.theGUI.updateInfoFrame(LSM_Reader.this.theGUI.printINFO());
                LSM_Reader.this.theGUI.updateNodes(LSM_Reader.this.theGUI.rootnode);
                LSM_Reader.this.theGUI.tree.clearSelection();
                LSM_Reader.this.theGUI.tree.collapseRow(1);
                if (LSM_Reader.this.theGUI.switcher) {
                    LSM_Reader.this.theGUI.SwitchButton.setText("Switch to general view");
                } else {
                    LSM_Reader.this.theGUI.SwitchButton.setText("Switch to filtered view");
                }
            }
        }
    }

    class GUIButton
    extends JButton {
        public GUIButton(String string, String string2) {
            Font font = new Font(null);
            float f = 11.0f;
            font = font.deriveFont(f);
            font = font.deriveFont(1);
            this.setFont(font);
            this.setText(string);
            this.setForeground(SystemColor.windowText);
            this.setToolTipText(string2);
        }
    }

    class GUI {
        public JFrame baseFrame;
        private JPanel pan;
        private GridLayout baseGridLayout = new GridLayout(11, 1, 20, 1);
        private GUIButton butt1 = new GUIButton(" Open LSM ", "Opens a 8-bit LSM image or image stack");
        private GUIButton butt2 = new GUIButton(" Close all Windows ", "Closes all opened Image Windows");
        private GUIButton butt3 = new GUIButton(" Exit ", "Exits the LSM Reader Plug-In");
        private GUIButton butt4 = new GUIButton(" Show Infos ", "Brings the infos panel to front");
        private GUIButton butt5 = new GUIButton(" Apply t-stamp ", "Apply timestamp to each image of a time series stack");
        private GUIButton butt6 = new GUIButton(" Browse ", "Browse Hypervolume, needs HyperVolume_Browser");
        private GUIButton butt7 = new GUIButton(" Apply z-stamp ", "Apply z-stamp to each image of a z series stack");
        private GUIButton butt8 = new GUIButton(" Apply l-stamp ", "Apply lambda-stamp to each image of a spectral series");
        private GUIButton butt9 = new GUIButton(" Edit Palette ", "Edit Palette, needs Lut_Panel");
        private GUIButton butt10 = new GUIButton(" Batch convert ", "Converts LSM files to other file formats");
        private JButton SwitchButton = new JButton("Switch to filtered view");
        private JLabel label1 = new JLabel(" LSM Tools ", 0);
        public String[] LSMinfoText = new String[22];
        public String[] infos = new String[22];
        public LSMFileInfo lsm_fi;
        public long timestamps_count;
        private Dimension ScreenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        private int ScreenX = (int)this.ScreenDimension.getWidth();
        private int ScreenY = (int)this.ScreenDimension.getHeight();
        private int baseFrameXsize = 210;
        private int baseFrameYsize = 260;
        private int infoFrameXsize = 300;
        private int infoFrameYsize = 400;
        private int detailsFrameXsize = 260;
        private int detailsFrameYsize = 400;
        private int baseFrameXlocation = this.ScreenX - this.baseFrameXsize;
        private int baseFrameYlocation = this.ScreenY - this.baseFrameYsize - 30;
        private int detailsFrameXlocation = 0;
        private int detailsFrameYlocation = this.infoFrameYsize;
        private int infoFrameXlocation = 0;
        private int infoFrameYlocation = 0;
        private JLabel[] infolab = new JLabel[22];
        private JTextArea[] area = new JTextArea[22];
        private JTree tree;
        private JTable table;
        private DefaultMutableTreeNode rootnode;
        private DefaultTreeModel treemodel;
        private MyTableModel tablemodel;
        private Object[][] rowData = new Object[][]{{"N/A", "N/A"}};
        private Object[][] noData = new Object[][]{{"N/A", "N/A"}};
        private Object[][] undefinedData = new Object[][]{{"defined but empty", "defined but empty"}};
        private boolean switcher = false;

        GUI() {
        }

        public void GUI() {
        }

        public void init() {
            this.baseFrame = new JFrame();
            this.baseFrame.setTitle("LSM Reader 3.2f");
            this.baseFrame.setSize(this.baseFrameXsize, this.baseFrameYsize);
            this.baseFrame.setResizable(false);
            this.baseFrame.setLocation(this.baseFrameXlocation, this.baseFrameYlocation);
            infoFrame.setSize(this.infoFrameXsize, this.infoFrameYsize);
            this.addExitListener(this.butt3, this.baseFrame);
            this.addShowHideInfolistener(this.butt4, this.baseFrame);
            this.addOpenListener(this.butt1, this.baseFrame);
            this.addCloseWinListener(this.butt2, this.baseFrame);
            this.addApplyZStampListener(this.butt7, this.baseFrame);
            this.addApplyTStampListener(this.butt5, this.baseFrame);
            this.addBrowseListener(this.butt6, this.baseFrame);
            this.addLUTListener(this.butt9, this.baseFrame);
            this.addApplyLambdaStampListener(this.butt8, this.baseFrame);
            this.addBatchConvertListener(this.butt10, this.baseFrame);
            this.pan = new JPanel();
            this.pan.setSize(130, 260);
            this.pan.setForeground(SystemColor.window);
            this.pan.setLayout(this.baseGridLayout);
            this.pan.add(this.label1);
            this.pan.add(this.butt1);
            this.pan.add(this.butt4);
            this.pan.add(this.butt7);
            this.pan.add(this.butt5);
            this.pan.add(this.butt8);
            this.pan.add(this.butt6);
            this.pan.add(this.butt9);
            this.pan.add(this.butt2);
            this.pan.add(this.butt10);
            this.pan.add(this.butt3);
            this.butt5.setEnabled(false);
            this.butt7.setEnabled(false);
            this.butt8.setEnabled(false);
            this.baseFrame.getContentPane().add(this.pan);
            this.baseFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    GUI.this.baseFrame.dispose();
                }
            });
            this.baseFrame.setVisible(true);
            this.baseFrame.show();
            this.initInfoFrame();
        }

        private void closeFrames() {
            this.baseFrame.dispose();
            infoFrame.dispose();
            detailsFrame.dispose();
        }

        public void initInfoFrame() {
            infoFrame.getContentPane().setLayout(new BorderLayout());
            String[] stringArray = new String[]{"File Name", "User", "Image Width", "Image Height", "Number of channels", "Z Stack size", "Time Stack size", "Scan Type", "Voxel X size", "Voxel Y size", "Voxel Z size", "Objective", "X zoom factor", "Y zoom factor", "Z zoom factor", "Plane width", "Plane heigth", "Volume depth", "Plane spacing"};
            JPanel jPanel = new JPanel(new GridLayout(20, 2, 3, 3));
            Font font = new Font(null);
            float f = 11.0f;
            font = font.deriveFont(f);
            Font font2 = font.deriveFont(1);
            for (int i = 0; i < 19; ++i) {
                this.infolab[i] = new JLabel("  " + stringArray[i]);
                this.infolab[i].setFont(font2);
                jPanel.add(this.infolab[i]);
                this.area[i] = new JTextArea("");
                this.area[i].setEditable(false);
                this.area[i].setFont(font);
                jPanel.add(this.area[i]);
            }
            JButton jButton = new JButton("More details...");
            this.addDetailsListener(jButton, infoFrame);
            JButton jButton2 = new JButton("Notes");
            this.addNotesButtonListener(jButton2, infoFrame);
            JButton jButton3 = new JButton("Dump to text file");
            this.addDumpInfosListener(jButton3, infoFrame);
            infoFrame.getContentPane().add((Component)jPanel, "North");
            infoFrame.getContentPane().add((Component)jButton2, "East");
            infoFrame.getContentPane().add((Component)jButton3, "South");
            infoFrame.getContentPane().add((Component)jButton, "West");
            infoFrame.pack();
            this.initDetailsFrame();
        }

        public void updateInfoFrame(String[] stringArray) {
            for (int i = 0; i < 19; ++i) {
                this.area[i].setText(stringArray[i]);
            }
        }

        public void initDetailsFrame() {
            this.rootnode = new DefaultMutableTreeNode("LSM File Information");
            this.treemodel = new DefaultTreeModel(this.rootnode);
            detailsFrame.setSize(this.detailsFrameXsize, this.detailsFrameYsize);
            detailsFrame.setLocation(this.detailsFrameXlocation, this.detailsFrameYlocation);
            this.tree = new JTree(this.treemodel);
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setShowsRootHandles(true);
            MyTableModel myTableModel = new MyTableModel();
            this.tablemodel = new MyTableModel();
            this.table = new JTable(this.tablemodel);
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            JScrollPane jScrollPane2 = new JScrollPane(this.table);
            JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setDividerLocation(300);
            Dimension dimension = new Dimension((int)(0.75 * (double)this.infoFrameXlocation / 2.0), this.infoFrameXlocation / 2);
            dimension = new Dimension(1, 2 - 50);
            jScrollPane.setMinimumSize(dimension);
            jScrollPane2.setMinimumSize(dimension);
            JButton jButton = new JButton("Ok");
            jButton.setToolTipText("Close this window");
            JButton jButton2 = new JButton("Dump data");
            jButton2.setToolTipText("Dump data to textwindow, saving to text file is possible");
            this.SwitchButton.setToolTipText("Switch view");
            JPanel jPanel = new JPanel();
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(this.SwitchButton);
            Dimension dimension2 = new Dimension(1, 2 + 10);
            JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, jPanel);
            jSplitPane2.setOneTouchExpandable(true);
            jSplitPane2.setDividerLocation(-2 + 2 - 10);
            detailsFrame.getContentPane().add(jSplitPane2);
            this.addSwitchListener(this.SwitchButton, detailsFrame);
            this.addDumpDataListener(jButton2, detailsFrame);
            this.addDetailsListener(jButton, detailsFrame);
            detailsFrame.pack();
        }

        private void updateNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            DefaultMutableTreeNode defaultMutableTreeNode3 = null;
            DefaultMutableTreeNode defaultMutableTreeNode4 = null;
            DefaultMutableTreeNode defaultMutableTreeNode5 = null;
            DefaultMutableTreeNode defaultMutableTreeNode6 = null;
            DefaultMutableTreeNode defaultMutableTreeNode7 = null;
            Object var8_8 = null;
            DefaultMutableTreeNode defaultMutableTreeNode8 = null;
            DefaultMutableTreeNode defaultMutableTreeNode9 = null;
            DefaultMutableTreeNode defaultMutableTreeNode10 = null;
            DefaultMutableTreeNode defaultMutableTreeNode11 = null;
            defaultMutableTreeNode.removeAllChildren();
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new InfoBlock("Recordings", 1, 0));
            defaultMutableTreeNode11 = new DefaultMutableTreeNode(new InfoBlock("Unknown tags", 11, 0));
            defaultMutableTreeNode3 = new DefaultMutableTreeNode("Lasers");
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Tracks");
            defaultMutableTreeNode5 = new DefaultMutableTreeNode("Markers");
            defaultMutableTreeNode6 = new DefaultMutableTreeNode("Timers");
            ((DefaultMutableTreeNode)this.treemodel.getRoot()).add(defaultMutableTreeNode2);
            ((DefaultMutableTreeNode)this.treemodel.getRoot()).add(defaultMutableTreeNode3);
            ((DefaultMutableTreeNode)this.treemodel.getRoot()).add(defaultMutableTreeNode4);
            ((DefaultMutableTreeNode)this.treemodel.getRoot()).add(defaultMutableTreeNode5);
            ((DefaultMutableTreeNode)this.treemodel.getRoot()).add(defaultMutableTreeNode6);
            ((DefaultMutableTreeNode)this.treemodel.getRoot()).add(defaultMutableTreeNode11);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (n = 0; n < this.lsm_fi.SCANINFO.tracks.size(); ++n) {
                int n6;
                defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Track " + (n + 1)));
                ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n)).add(new DefaultMutableTreeNode(new InfoBlock("General Track Data", 10, n)));
                if ((Integer)this.lsm_fi.SCANINFO.det_channels_count.elementAt(n) == 0) {
                    ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n)).add(new DefaultMutableTreeNode(new InfoBlock("Detection Channels ", 9, 0)));
                } else {
                    ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n)).add(new DefaultMutableTreeNode("Detection Channels"));
                    for (n6 = 0; n6 < (Integer)this.lsm_fi.SCANINFO.det_channels_count.elementAt(n); ++n6) {
                        defaultMutableTreeNode7 = new DefaultMutableTreeNode(new InfoBlock("Detection Channel " + (n6 + 1), 2, n2++));
                        ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n).getChildAt(1)).add(defaultMutableTreeNode7);
                    }
                }
                if ((Integer)this.lsm_fi.SCANINFO.illum_channels_count.elementAt(n) == 0) {
                    ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n)).add(new DefaultMutableTreeNode(new InfoBlock("Illumination Channels ", 9, 0)));
                } else {
                    ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n)).add(new DefaultMutableTreeNode("Illumination Chanels"));
                    for (n6 = 0; n6 < (Integer)this.lsm_fi.SCANINFO.illum_channels_count.elementAt(n); ++n6) {
                        defaultMutableTreeNode8 = new DefaultMutableTreeNode(new InfoBlock("Illumination Channel " + (n6 + 1), 3, n3++));
                        ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n).getChildAt(2)).add(defaultMutableTreeNode8);
                    }
                }
                if ((Integer)this.lsm_fi.SCANINFO.bsplits_count.elementAt(n) == 0) {
                    ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n)).add(new DefaultMutableTreeNode(new InfoBlock("Beam Splitters ", 9, 0)));
                } else {
                    ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n)).add(new DefaultMutableTreeNode("Beam Splitters"));
                    for (n6 = 0; n6 < (Integer)this.lsm_fi.SCANINFO.bsplits_count.elementAt(n); ++n6) {
                        defaultMutableTreeNode9 = new DefaultMutableTreeNode(new InfoBlock("Beam splitter " + (n6 + 1), 4, n4++));
                        ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n).getChildAt(3)).add(defaultMutableTreeNode9);
                    }
                }
                if ((Integer)this.lsm_fi.SCANINFO.data_channels_count.elementAt(n) == 0) {
                    ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n)).add(new DefaultMutableTreeNode(new InfoBlock("Data Channels ", 9, 0)));
                    continue;
                }
                ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n)).add(new DefaultMutableTreeNode("Data Channels"));
                for (n6 = 0; n6 < (Integer)this.lsm_fi.SCANINFO.data_channels_count.elementAt(n); ++n6) {
                    defaultMutableTreeNode10 = new DefaultMutableTreeNode(new InfoBlock("Data Channel " + (n6 + 1), 5, n5++));
                    ((DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n).getChildAt(4)).add(defaultMutableTreeNode10);
                }
            }
            for (n = 0; n < this.lsm_fi.SCANINFO.markers.size(); ++n) {
                defaultMutableTreeNode5.add(new DefaultMutableTreeNode(new InfoBlock("Marker " + (n + 1), 6, n)));
            }
            for (n = 0; n < this.lsm_fi.SCANINFO.timers.size(); ++n) {
                defaultMutableTreeNode6.add(new DefaultMutableTreeNode(new InfoBlock("Timer " + (n + 1), 7, n)));
            }
            for (n = 0; n < this.lsm_fi.SCANINFO.lasers.size(); ++n) {
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new InfoBlock("Laser " + (n + 1), 8, n)));
            }
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)GUI.this.tree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode == null) {
                        return;
                    }
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (defaultMutableTreeNode.isLeaf()) {
                        InfoBlock infoBlock = (InfoBlock)object;
                        if (infoBlock.datatype == 1) {
                            GUI.access$002(GUI.this, GUI.this.getObject(GUI.this.lsm_fi.SCANINFO.recordings));
                        }
                        if (infoBlock.datatype == 2) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.det_channels.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 3) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.illum_channels.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 4) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.bsplits.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 5) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.data_channels.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 6) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.markers.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 7) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.timers.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 8) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.lasers.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 9) {
                            GUI.access$002(GUI.this, GUI.this.undefinedData);
                        }
                        if (infoBlock.datatype == 10) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.tracks.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 11) {
                            GUI.access$002(GUI.this, GUI.this.getObject(GUI.this.lsm_fi.SCANINFO.unknown));
                        }
                    } else {
                        GUI.access$002(GUI.this, GUI.this.noData);
                    }
                    GUI.this.tablemodel.fireTableDataChanged();
                }
            });
            this.treemodel.reload();
            this.expandEntireTree(defaultMutableTreeNode);
            this.switcher = true;
        }

        private void updateNodes2(DefaultMutableTreeNode defaultMutableTreeNode) {
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            DefaultMutableTreeNode defaultMutableTreeNode3 = null;
            DefaultMutableTreeNode defaultMutableTreeNode4 = null;
            DefaultMutableTreeNode defaultMutableTreeNode5 = null;
            DefaultMutableTreeNode defaultMutableTreeNode6 = null;
            DefaultMutableTreeNode defaultMutableTreeNode7 = null;
            Object var8_8 = null;
            DefaultMutableTreeNode defaultMutableTreeNode8 = null;
            DefaultMutableTreeNode defaultMutableTreeNode9 = null;
            DefaultMutableTreeNode defaultMutableTreeNode10 = null;
            DefaultMutableTreeNode defaultMutableTreeNode11 = null;
            defaultMutableTreeNode.removeAllChildren();
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new InfoBlock("Recordings", 1, 0));
            defaultMutableTreeNode11 = new DefaultMutableTreeNode(new InfoBlock("Unknown tags", 11, 0));
            defaultMutableTreeNode3 = new DefaultMutableTreeNode("Lasers");
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Tracks");
            defaultMutableTreeNode5 = new DefaultMutableTreeNode("Markers");
            defaultMutableTreeNode6 = new DefaultMutableTreeNode("Timers");
            ((DefaultMutableTreeNode)this.treemodel.getRoot()).add(defaultMutableTreeNode2);
            ((DefaultMutableTreeNode)this.treemodel.getRoot()).add(defaultMutableTreeNode3);
            ((DefaultMutableTreeNode)this.treemodel.getRoot()).add(defaultMutableTreeNode4);
            ((DefaultMutableTreeNode)this.treemodel.getRoot()).add(defaultMutableTreeNode5);
            ((DefaultMutableTreeNode)this.treemodel.getRoot()).add(defaultMutableTreeNode6);
            ((DefaultMutableTreeNode)this.treemodel.getRoot()).add(defaultMutableTreeNode11);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            boolean bl = false;
            for (n = 0; n < this.lsm_fi.SCANINFO.tracks.size(); ++n) {
                if ((Integer)this.lsm_fi.SCANINFO.det_channels_count.elementAt(n) != 0) {
                    int n6;
                    int n7;
                    defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Track " + (n + 1)));
                    ((DefaultMutableTreeNode)defaultMutableTreeNode4.getLastChild()).add(new DefaultMutableTreeNode(new InfoBlock("General Track Data", 10, n)));
                    ((DefaultMutableTreeNode)defaultMutableTreeNode4.getLastChild()).add(new DefaultMutableTreeNode("Detection Channels"));
                    for (n7 = 0; n7 < (Integer)this.lsm_fi.SCANINFO.det_channels_count.elementAt(n); ++n7) {
                        if (this.check_on((ArrayList)this.lsm_fi.SCANINFO.det_channels.elementAt(n2), 97)) {
                            defaultMutableTreeNode7 = new DefaultMutableTreeNode(new InfoBlock("Detection Channel " + (n7 + 1), 2, n2));
                            ((DefaultMutableTreeNode)defaultMutableTreeNode4.getLastChild().getChildAt(1)).add(defaultMutableTreeNode7);
                        }
                        ++n2;
                    }
                    n7 = 0;
                    int n8 = 0;
                    DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode("Illumination Chanels");
                    ((DefaultMutableTreeNode)defaultMutableTreeNode4.getLastChild()).add(defaultMutableTreeNode12);
                    n8 = ((DefaultMutableTreeNode)defaultMutableTreeNode12.getParent()).getIndex(defaultMutableTreeNode12);
                    for (int i = 0; i < (Integer)this.lsm_fi.SCANINFO.illum_channels_count.elementAt(n); ++i) {
                        if (this.check_on((ArrayList)this.lsm_fi.SCANINFO.illum_channels.elementAt(n3), 119)) {
                            defaultMutableTreeNode8 = new DefaultMutableTreeNode(new InfoBlock("Illumination Channel " + (i + 1), 3, n3));
                            ((DefaultMutableTreeNode)defaultMutableTreeNode4.getLastChild().getChildAt(2)).add(defaultMutableTreeNode8);
                            ++n7;
                        }
                        ++n3;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode13 = (DefaultMutableTreeNode)defaultMutableTreeNode4.getLastChild();
                    DefaultMutableTreeNode defaultMutableTreeNode14 = (DefaultMutableTreeNode)defaultMutableTreeNode4.getLastChild().getChildAt(2);
                    if (n7 == 0) {
                        defaultMutableTreeNode14.add(new DefaultMutableTreeNode(new InfoBlock("N/A", 12, 0)));
                    }
                    if ((Integer)this.lsm_fi.SCANINFO.bsplits_count.elementAt(n) != 0) {
                        ((DefaultMutableTreeNode)defaultMutableTreeNode4.getLastChild()).add(new DefaultMutableTreeNode("Beam Splitters"));
                        for (n6 = 0; n6 < (Integer)this.lsm_fi.SCANINFO.bsplits_count.elementAt(n); ++n6) {
                            defaultMutableTreeNode9 = new DefaultMutableTreeNode(new InfoBlock("Beam splitter " + (n6 + 1), 4, n4++));
                            ((DefaultMutableTreeNode)defaultMutableTreeNode4.getLastChild().getChildAt(3)).add(defaultMutableTreeNode9);
                        }
                    }
                    if ((Integer)this.lsm_fi.SCANINFO.data_channels_count.elementAt(n) != 0) {
                        ((DefaultMutableTreeNode)defaultMutableTreeNode4.getLastChild()).add(new DefaultMutableTreeNode("Data Channels"));
                        for (n6 = 0; n6 < (Integer)this.lsm_fi.SCANINFO.data_channels_count.elementAt(n); ++n6) {
                            defaultMutableTreeNode10 = new DefaultMutableTreeNode(new InfoBlock("Data Channel " + (n6 + 1), 5, n5++));
                            ((DefaultMutableTreeNode)defaultMutableTreeNode4.getLastChild().getChildAt(4)).add(defaultMutableTreeNode10);
                        }
                    }
                }
                if ((Integer)this.lsm_fi.SCANINFO.det_channels_count.elementAt(n) != 0) continue;
                n3 += ((Integer)this.lsm_fi.SCANINFO.illum_channels_count.elementAt(n)).intValue();
            }
            for (n = 0; n < this.lsm_fi.SCANINFO.markers.size(); ++n) {
                defaultMutableTreeNode5.add(new DefaultMutableTreeNode(new InfoBlock("Marker " + (n + 1), 6, n)));
            }
            for (n = 0; n < this.lsm_fi.SCANINFO.timers.size(); ++n) {
                defaultMutableTreeNode6.add(new DefaultMutableTreeNode(new InfoBlock("Timer " + (n + 1), 7, n)));
            }
            for (n = 0; n < this.lsm_fi.SCANINFO.lasers.size(); ++n) {
                if (!this.check_on((ArrayList)this.lsm_fi.SCANINFO.lasers.elementAt(n), 18)) continue;
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new InfoBlock("Laser " + (n + 1), 8, n)));
            }
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)GUI.this.tree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode == null) {
                        return;
                    }
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (defaultMutableTreeNode.isLeaf()) {
                        InfoBlock infoBlock = (InfoBlock)object;
                        if (infoBlock.datatype == 1) {
                            GUI.access$002(GUI.this, GUI.this.getObject(GUI.this.lsm_fi.SCANINFO.recordings));
                        }
                        if (infoBlock.datatype == 2) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.det_channels.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 3) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.illum_channels.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 4) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.bsplits.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 5) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.data_channels.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 6) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.markers.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 7) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.timers.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 8) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.lasers.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 9) {
                            GUI.access$002(GUI.this, GUI.this.undefinedData);
                        }
                        if (infoBlock.datatype == 10) {
                            GUI.access$002(GUI.this, GUI.this.getObject((ArrayList)GUI.this.lsm_fi.SCANINFO.tracks.elementAt(infoBlock.index)));
                        }
                        if (infoBlock.datatype == 11) {
                            GUI.access$002(GUI.this, GUI.this.getObject(GUI.this.lsm_fi.SCANINFO.unknown));
                        }
                        if (infoBlock.datatype == 12) {
                            GUI.access$002(GUI.this, GUI.this.noData);
                        }
                    } else {
                        GUI.access$002(GUI.this, GUI.this.noData);
                    }
                    GUI.this.tablemodel.fireTableDataChanged();
                }
            });
            this.treemodel.reload();
            this.expandEntireTree(defaultMutableTreeNode);
            this.switcher = false;
        }

        public Object[][] getObject(ArrayList arrayList) {
            Object[][] objectArray = new Object[arrayList.size()][2];
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                Object[] objectArray2 = new Object[2];
                objectArray2 = (Object[])arrayList.get(i);
                int n = 0;
                if (objectArray2[0] != null) {
                    n = (Integer)objectArray2[0];
                }
                if (objectArray2[1] instanceof String) {
                    objectArray[i][1] = object = (String)objectArray2[1];
                }
                if (objectArray2[1] instanceof Double) {
                    objectArray[i][1] = object = (Double)objectArray2[1];
                }
                if (objectArray2[1] instanceof Long) {
                    objectArray[i][1] = object = (Long)objectArray2[1];
                }
                objectArray[i][0] = objectArray2[0] != null ? this.lsm_fi.SCANINFO.table[n][3] : "UNKNOWN TAG";
            }
            return objectArray;
        }

        public boolean check_on(Object object, int n) {
            Object[] objectArray;
            int n2;
            boolean bl = false;
            if (object instanceof ArrayList && (ArrayList)object != null) {
                for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                    objectArray = new Object[2];
                    objectArray = (Object[])((ArrayList)object).get(n2);
                    if ((Integer)objectArray[0] != n || ((Long)objectArray[1]).intValue() != -1) continue;
                    bl = true;
                }
            }
            if (object instanceof Vector && (Vector)object != null) {
                for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
                    objectArray = new Object[2];
                    objectArray = (Object[])((Vector)object).get(n2);
                    if ((Integer)objectArray[0] != n || ((Long)objectArray[1]).intValue() != -1) continue;
                    bl = true;
                }
            }
            return bl;
        }

        public Hashtable translate(Hashtable hashtable) {
            Hashtable hashtable2 = new Hashtable();
            for (int i = 0; i < 147; ++i) {
                if (!hashtable.containsKey(new Integer(i))) continue;
                hashtable2.put(this.lsm_fi.SCANINFO.table[i][3], hashtable.get(new Integer(i)));
            }
            return hashtable2;
        }

        public void expandTree() {
            this.expandEntireTree((DefaultMutableTreeNode)this.treemodel.getRoot());
        }

        private void expandEntireTree(DefaultMutableTreeNode defaultMutableTreeNode) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.tree.expandPath(treePath);
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                this.expandEntireTree((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
            }
        }

        public void setLSMinfoText(String[] stringArray) {
            this.LSMinfoText = stringArray;
        }

        public void setLSMFileInfo(LSMFileInfo lSMFileInfo) {
            this.lsm_fi = lSMFileInfo;
        }

        public String[] printINFO() {
            String string = IJ.d2s((double)this.lsm_fi.DIMENSION_Z, (int)0);
            String string2 = IJ.d2s((double)this.lsm_fi.TIF_IMAGEWIDTH, (int)0);
            String string3 = IJ.d2s((double)this.lsm_fi.TIF_IMAGELENGTH, (int)0);
            String string4 = IJ.d2s((double)this.lsm_fi.NUMBER_OF_CHANNELS, (int)0);
            String string5 = "";
            int n = (int)this.lsm_fi.SCANTYPE;
            switch (n) {
                case 0: {
                    string5 = "Normal X-Y-Z scan";
                    break;
                }
                case 1: {
                    string5 = "Z scan";
                    break;
                }
                case 2: {
                    string5 = "Line scan";
                    break;
                }
                case 3: {
                    string5 = "Time series X-Y";
                    break;
                }
                case 4: {
                    string5 = "Time series X-Z";
                    break;
                }
                case 5: {
                    string5 = "Time series - Means of ROIs";
                    break;
                }
                case 6: {
                    string5 = "Time series X-Y-Z";
                    break;
                }
                default: {
                    string5 = "UNKNOWN !";
                }
            }
            String string6 = IJ.d2s((double)(this.lsm_fi.VOXELSIZE_X * 1000000.0), (int)2) + " \u00b5m";
            String string7 = IJ.d2s((double)(this.lsm_fi.VOXELSIZE_Y * 1000000.0), (int)2) + " \u00b5m";
            String string8 = IJ.d2s((double)(this.lsm_fi.VOXELSIZE_Z * 1000000.0), (int)2) + " \u00b5m";
            String string9 = IJ.d2s((double)this.lsm_fi.TIMESTACKSIZE, (int)0);
            String string10 = IJ.d2s((double)this.lsm_fi.PLANE_SPACING, (int)2) + " \u00b5m";
            String string11 = IJ.d2s((double)this.lsm_fi.PLANE_WIDTH, (int)2) + " \u00b5m";
            String string12 = IJ.d2s((double)this.lsm_fi.PLANE_HEIGHT, (int)2) + " \u00b5m";
            String string13 = IJ.d2s((double)this.lsm_fi.VOLUME_DEPTH, (int)2) + " \u00b5m";
            String string14 = "";
            this.infos[0] = this.lsm_fi.FILENAME;
            this.infos[1] = this.lsm_fi.User;
            this.infos[2] = string2;
            this.infos[3] = string3;
            this.infos[4] = string4;
            this.infos[5] = string;
            this.infos[6] = string9;
            this.infos[7] = string5;
            this.infos[8] = string6;
            this.infos[9] = string7;
            this.infos[10] = string8;
            this.infos[11] = this.lsm_fi.Objective;
            this.infos[12] = IJ.d2s((double)this.lsm_fi.ZOOM_X, (int)2);
            this.infos[13] = IJ.d2s((double)this.lsm_fi.ZOOM_Y, (int)2);
            this.infos[14] = IJ.d2s((double)this.lsm_fi.ZOOM_Z, (int)2);
            this.infos[15] = string11;
            this.infos[16] = string12;
            this.infos[17] = string13;
            this.infos[18] = string10;
            return this.infos;
        }

        public void dumpData() {
            String string = new String("Offset\tLevel\tTag\tName\tSize (bytes)\tValue\t");
            TextWindow textWindow = new TextWindow("SCANINFO DUMP", string, this.lsm_fi.sb.toString(), 250, 400);
        }

        public void dumpInfo() {
            String string = new String("Parameter\tValue");
            TextWindow textWindow = new TextWindow("LSM Infos DUMP", string, null, 280, 450);
            String[] stringArray = new String[26];
            stringArray[0] = "File Name";
            stringArray[1] = "User";
            stringArray[2] = "Image Width";
            stringArray[3] = "Image Height";
            stringArray[4] = "Number of channels";
            stringArray[5] = "Z Stack size";
            stringArray[6] = "Time Stack size";
            stringArray[7] = "Scan Type";
            stringArray[8] = "Voxel X size";
            stringArray[9] = "Voxel Y size";
            stringArray[10] = "Voxel Z size";
            stringArray[11] = "Objective";
            stringArray[12] = "X Zoom factor";
            stringArray[13] = "Y Zoom factor";
            stringArray[14] = "Z Zoom factor";
            stringArray[15] = "Plane width";
            stringArray[16] = "Plane height";
            stringArray[17] = "Volume depth";
            stringArray[18] = "Plane spacing";
            for (int i = 0; i < 19; ++i) {
                textWindow.append(stringArray[i] + "\t" + this.infos[i]);
            }
        }

        private void addExitListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WindowManager.closeAllWindows();
                    GUI.this.closeFrames();
                }
            });
        }

        private void addOpenListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LSM_Reader_ lSM_Reader_ = new LSM_Reader_();
                    lSM_Reader_.OpenLSM("", false);
                    GUI.this.setLSMFileInfo(lSM_Reader_.lsm_fi);
                    GUI.this.setLSMinfoText(GUI.this.printINFO());
                    GUI.this.updateInfoFrame(GUI.this.LSMinfoText);
                }
            });
        }

        private void addBatchConvertListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Batch_Converter batch_Converter = new Batch_Converter();
                    batch_Converter.run("");
                    WindowManager.closeAllWindows();
                }
            });
        }

        private void addCloseWinListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WindowManager.closeAllWindows();
                    GUI.this.setLSMinfoText(new String[22]);
                    infoFrame.dispose();
                    detailsFrame.dispose();
                }
            });
        }

        private void addGatherExpandlistener(final JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jButton.getText() == " Gather ") {
                        jButton.setText(" Expand ");
                        jButton.setToolTipText("Split all the channels in separated windows");
                    } else {
                        jButton.setText(" Gather ");
                        jButton.setToolTipText("Show all channels in the same window");
                    }
                }
            });
        }

        private void addShowHideInfolistener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GUI.this.updateInfoFrame(GUI.this.LSMinfoText);
                    if (!infoFrame.isShowing()) {
                        infoFrame.show();
                    } else {
                        infoFrame.hide();
                    }
                }
            });
        }

        private void addApplyZStampListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String[] stringArray = new String[]{"Dump to textfile", "Apply to image"};
                    GenericDialog genericDialog = new GenericDialog("Z-stamps");
                    genericDialog.addChoice("Stamps destination : ", stringArray, "Apply to image");
                    genericDialog.showDialog();
                    if (genericDialog.wasCanceled()) {
                        return;
                    }
                    String string = genericDialog.getNextChoice();
                    if (string.equals("Dump to textfile")) {
                        String string2 = new String("");
                        double d = 0.0;
                        int n = 1;
                        while ((long)n <= GUI.this.lsm_fi.DIMENSION_Z) {
                            String string3 = IJ.d2s((double)d, (int)2) + " \u00b5m";
                            d += GUI.this.lsm_fi.PLANE_SPACING;
                            string2 = string2 + string3 + "\n";
                            ++n;
                        }
                        TextWindow textWindow = new TextWindow("Z-stamps", "Z-stamps", string2, 200, 400);
                    } else {
                        ImagePlus imagePlus = WindowManager.getCurrentImage();
                        LSM_Reader.this.applyZSTAMP(imagePlus, GUI.this.lsm_fi);
                    }
                }
            });
        }

        private void addApplyTStampListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String[] stringArray = new String[]{"Dump to textfile", "Apply to image"};
                    GenericDialog genericDialog = new GenericDialog("Timestamps");
                    genericDialog.addChoice("Stamps destination : ", stringArray, "Apply to image");
                    genericDialog.showDialog();
                    if (genericDialog.wasCanceled()) {
                        return;
                    }
                    String string = genericDialog.getNextChoice();
                    if (string.equals("Dump to textfile")) {
                        String string2 = new String("");
                        int n = 0;
                        while ((long)n < GUI.this.lsm_fi.TS_COUNT) {
                            string2 = string2 + Double.toString(GUI.this.lsm_fi.TS_STAMPS[n]) + "\n";
                            ++n;
                        }
                        TextWindow textWindow = new TextWindow("Timestamps", "Timestamps", string2, 200, 400);
                    } else {
                        ImagePlus imagePlus = WindowManager.getCurrentImage();
                        LSM_Reader.this.applyTSTAMP(imagePlus, GUI.this.lsm_fi);
                    }
                }
            });
        }

        private void addApplyLambdaStampListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ImagePlus imagePlus = WindowManager.getCurrentImage();
                    if (GUI.this.lsm_fi.SPECTRALSCAN != 1) {
                        IJ.error((String)"Image not issued from spectral scan. Lambda stamp obsolete!");
                        return;
                    }
                    String[] stringArray = new String[]{"Dump to textfile", "Apply to image"};
                    GenericDialog genericDialog = new GenericDialog("Lambdastamps");
                    genericDialog.addChoice("Stamps destination : ", stringArray, "Apply to image");
                    genericDialog.showDialog();
                    if (genericDialog.wasCanceled()) {
                        return;
                    }
                    String string = genericDialog.getNextChoice();
                    if (string.equals("Dump to textfile")) {
                        String string2 = new String("");
                        int n = 0;
                        while ((long)n < GUI.this.lsm_fi.LS_COUNT) {
                            string2 = string2 + Double.toString(GUI.this.lsm_fi.LS_STAMPS[n]) + "\n";
                            ++n;
                        }
                        TextWindow textWindow = new TextWindow("Lambdastamps", "Lambdastamps", string2, 200, 400);
                    } else {
                        YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)GUI.this.baseFrame, "Lambda Stack creation and stamping", "LSM_Reader will merge ALL open images into a stack and merge them.\nIf images from different sources are open, do close them and restart this operation!\nIf the images are hypervolumes, do not use lambda stamp!");
                        if (yesNoCancelDialog.yesPressed()) {
                            LSM_Reader.this.applyLSTAMP(imagePlus, GUI.this.lsm_fi);
                        }
                    }
                }
            });
        }

        private void addDumpDataListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GUI.this.dumpData();
                }
            });
        }

        private void addDumpInfosListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GUI.this.dumpInfo();
                }
            });
        }

        private void addBrowseListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    IJ.runPlugIn((String)"HyperVolume_Browser", (String)("3D=z 3DV=" + GUI.this.lsm_fi.DIMENSION_Z + " 4D=t"));
                }
            });
        }

        private void addLUTListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    IJ.runPlugIn((String)"Lut_Panel", (String)"");
                }
            });
        }

        private void addNotesButtonListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Notes notes = new Notes(infoFrame);
                }
            });
        }

        private void addSwitchListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (GUI.this.switcher) {
                        GUI.this.updateNodes2(GUI.this.rootnode);
                        GUI.this.SwitchButton.setText("Switch to general View");
                    } else {
                        GUI.this.updateNodes(GUI.this.rootnode);
                        GUI.this.SwitchButton.setText("Switch to filtered View");
                    }
                }
            });
        }

        private void addDetailsListener(JButton jButton, JFrame jFrame) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!detailsFrame.isShowing()) {
                        GUI.this.updateNodes2(GUI.this.rootnode);
                        detailsFrame.show();
                    } else {
                        detailsFrame.hide();
                    }
                }
            });
        }

        static /* synthetic */ Object[][] access$002(GUI gUI, Object[][] objectArray) {
            gUI.rowData = objectArray;
            return objectArray;
        }

        private class InfoBlock {
            public int datatype = 0;
            public int index = 0;
            String leafName;

            public InfoBlock(String string, int n, int n2) {
                this.leafName = string;
                this.datatype = n;
                this.index = n2;
            }

            public String toString() {
                return this.leafName;
            }
        }

        class MyTableModel
        extends AbstractTableModel {
            String[] columnNames = new String[]{"Tag", "Property"};

            MyTableModel() {
            }

            public String getColumnName(int n) {
                return this.columnNames[n].toString();
            }

            public int getRowCount() {
                return GUI.this.rowData.length;
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int n, int n2) {
                Object object = new Object();
                object = GUI.this.rowData[GUI.this.rowData.length - n - 1][n2];
                return object;
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void setValueAt(Object object, int n, int n2) {
                ((GUI)GUI.this).rowData[n][n2] = object;
                this.fireTableCellUpdated(n, n2);
            }
        }
    }
}

