/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;

public class Align_Image
implements PlugIn {
    private boolean isSupported(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void run(String string) {
        Object object;
        int[] nArray = WindowManager.getIDList();
        if (null == nArray) {
            return;
        }
        ArrayList<ImagePlus> arrayList = new ArrayList<ImagePlus>();
        for (int i = 0; i < nArray.length; ++i) {
            ImagePlus imagePlus = WindowManager.getImage((int)nArray[i]);
            object = imagePlus.getRoi();
            int n = imagePlus.getType();
            if (null == object || !(object instanceof Line) || !this.isSupported(imagePlus.getType())) continue;
            arrayList.add(imagePlus);
        }
        if (arrayList.size() < 2) {
            IJ.showMessage((String)"Need 2 images with a line roi in each.\nImages must be 8, 16 or 32-bit.");
            return;
        }
        String[] stringArray = new String[arrayList.size()];
        int n = 0;
        object = arrayList.iterator();
        while (object.hasNext()) {
            stringArray[n++] = ((ImagePlus)object.next()).getTitle();
        }
        object = new GenericDialog("Align Images");
        String string2 = WindowManager.getCurrentImage().getTitle();
        object.addChoice("source", stringArray, string2.equals(stringArray[0]) ? stringArray[1] : stringArray[0]);
        object.addChoice("target", stringArray, string2);
        object.showDialog();
        if (object.wasCanceled()) {
            return;
        }
        ImagePlus imagePlus = WindowManager.getImage((int)nArray[object.getNextChoiceIndex()]);
        Line line = (Line)imagePlus.getRoi();
        ImagePlus imagePlus2 = WindowManager.getImage((int)nArray[object.getNextChoiceIndex()]);
        Line line2 = (Line)imagePlus2.getRoi();
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        FloatProcessor floatProcessor = new FloatProcessor(n2, n3);
        float[] fArray = (float[])floatProcessor.getPixels();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        BilinearInterpolator bilinearInterpolator = new BilinearInterpolator(imageProcessor);
        float f = line.x2 - line.x1;
        float f2 = line.y2 - line.y1;
        float f3 = line2.x2 - line2.x1;
        float f4 = line2.y2 - line2.y1;
        float f5 = f3 * f3 + f4 * f4;
        float f6 = (f3 * f + f4 * f2) / f5;
        float f7 = (f3 * f2 - f4 * f) / f5;
        float f8 = -f7;
        float f9 = f6;
        float f10 = (float)line.x1 - f6 * (float)line2.x1 - f8 * (float)line2.y1;
        float f11 = (float)line.y1 - f7 * (float)line2.x1 - f9 * (float)line2.y1;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f12 = (float)j * f6 + (float)i * f8 + f10;
                float f13 = (float)j * f7 + (float)i * f9 + f11;
                fArray[j + i * n2] = ((Interpolator)bilinearInterpolator).get(f12, f13);
            }
            IJ.showProgress((int)(i + 1), (int)n3);
        }
        floatProcessor.setMinAndMax(imageProcessor.getMin(), imageProcessor.getMax());
        switch (imagePlus.getType()) {
            case 0: {
                floatProcessor = floatProcessor.convertToByte(false);
                break;
            }
            case 1: {
                floatProcessor = floatProcessor.convertToShort(false);
            }
        }
        ImagePlus imagePlus3 = new ImagePlus("aligned " + imagePlus2.getTitle(), (ImageProcessor)floatProcessor);
        imagePlus3.setCalibration(imagePlus.getCalibration());
        imagePlus3.setRoi((Roi)line2);
        imagePlus3.show();
    }

    static class BilinearInterpolator
    extends Interpolator {
        public BilinearInterpolator(ImageProcessor imageProcessor) {
            super(imageProcessor);
        }

        public float get(float f, float f2) {
            int n = (int)f;
            int n2 = (int)f2;
            float f3 = f - (float)n;
            float f4 = f2 - (float)n2;
            float f5 = this.ip.getPixelValue(n, n2);
            float f6 = this.ip.getPixelValue(n + 1, n2);
            float f7 = this.ip.getPixelValue(n, n2 + 1);
            float f8 = this.ip.getPixelValue(n + 1, n2 + 1);
            return (1.0f - f3) * (1.0f - f4) * f5 + f3 * (1.0f - f4) * f6 + (1.0f - f3) * f4 * f7 + f3 * f4 * f8;
        }
    }

    static abstract class Interpolator {
        ImageProcessor ip;
        int w;
        int h;

        public Interpolator(ImageProcessor imageProcessor) {
            this.ip = imageProcessor;
            this.w = imageProcessor.getWidth();
            this.h = imageProcessor.getHeight();
        }

        public abstract float get(float var1, float var2);
    }
}

