/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class Average_Color
implements PlugInFilter {
    protected ImagePlus image;
    protected int w;
    protected int h;
    protected int[] pixels;

    public void test() {
        GenericDialog genericDialog = new GenericDialog("L*");
        genericDialog.addNumericField("L*", 75.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        float f = (float)genericDialog.getNextNumber();
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int[] nArray = new int[3];
        this.h = 257;
        this.w = 257;
        this.pixels = new int[this.w * this.h];
        for (int i = -128; i <= 128; ++i) {
            for (int j = -128; j <= 128; ++j) {
                fArray[0] = f;
                fArray[1] = i;
                fArray[2] = j;
                CIELAB.CIELAB2sRGB(fArray, fArray2);
                nArray[0] = CIELAB.unnorm(fArray2[0]);
                nArray[1] = CIELAB.unnorm(fArray2[1]);
                nArray[2] = CIELAB.unnorm(fArray2[2]);
                this.pixels[i + 128 + (j + 128) * this.w] = nArray[0] << 16 | nArray[1] << 8 | nArray[2];
            }
        }
        ColorProcessor colorProcessor = new ColorProcessor(this.w, this.h, this.pixels);
        new ImagePlus("Colors", (ImageProcessor)colorProcessor).show();
    }

    public void run(ImageProcessor imageProcessor) {
        Roi roi = this.image.getRoi();
        if (roi == null) {
            IJ.error((String)"Need a ROI");
            return;
        }
        boolean bl = roi instanceof ShapeRoi;
        GenericDialog genericDialog = new GenericDialog("Average Color");
        genericDialog.addCheckbox("CIELab averaging", true);
        if (bl) {
            genericDialog.addCheckbox("Split roi", true);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        boolean bl2 = genericDialog.getNextBoolean();
        boolean bl3 = bl ? genericDialog.getNextBoolean() : false;
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.pixels = (int[])this.image.getProcessor().getPixels();
        if (bl3) {
            ShapeRoi shapeRoi = (ShapeRoi)roi;
            Roi[] roiArray = shapeRoi.getRois();
            for (int i = 0; i < roiArray.length; ++i) {
                this.averageColorInRoi(roiArray[i], bl2);
            }
        } else {
            this.averageColorInRoi(roi, bl2);
        }
        this.image.updateAndDraw();
    }

    final float[] getAverageColor(Roi roi, boolean bl) {
        Rectangle rectangle = roi.getBounds();
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        int n = 0;
        for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
            for (int j = rectangle.x; j < rectangle.x + rectangle.width; ++j) {
                if (!roi.contains(j, i)) continue;
                int n2 = this.pixels[j + this.w * i];
                fArray[0] = CIELAB.norm(n2 >> 16 & 0xFF);
                fArray[1] = CIELAB.norm(n2 >> 8 & 0xFF);
                fArray[2] = CIELAB.norm(n2 & 0xFF);
                if (bl) {
                    CIELAB.sRGB2CIELAB(fArray, fArray2);
                    fArray3[0] = fArray3[0] + fArray2[0];
                    fArray3[1] = fArray3[1] + fArray2[1];
                    fArray3[2] = fArray3[2] + fArray2[2];
                } else {
                    fArray3[0] = fArray3[0] + fArray[0];
                    fArray3[1] = fArray3[1] + fArray[1];
                    fArray3[2] = fArray3[2] + fArray[2];
                }
                ++n;
            }
        }
        fArray3[0] = fArray3[0] / (float)n;
        fArray3[1] = fArray3[1] / (float)n;
        fArray3[2] = fArray3[2] / (float)n;
        return fArray3;
    }

    private void averageColorInRoi(Roi roi, boolean bl) {
        Rectangle rectangle = roi.getBounds();
        float[] fArray = this.getAverageColor(roi, bl);
        float[] fArray2 = new float[3];
        int[] nArray = new int[3];
        if (bl) {
            CIELAB.CIELAB2sRGB(fArray, fArray2);
            nArray[0] = CIELAB.unnorm(fArray2[0]);
            nArray[1] = CIELAB.unnorm(fArray2[1]);
            nArray[2] = CIELAB.unnorm(fArray2[2]);
        } else {
            nArray[0] = CIELAB.unnorm(fArray[0]);
            nArray[1] = CIELAB.unnorm(fArray[1]);
            nArray[2] = CIELAB.unnorm(fArray[2]);
        }
        int n = nArray[0] << 16 | nArray[1] << 8 | nArray[2];
        for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
            for (int j = rectangle.x; j < rectangle.x + rectangle.width; ++j) {
                if (!roi.contains(j, i)) continue;
                this.pixels[j + this.w * i] = n;
            }
        }
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 16;
    }

    public static String getAverageCIELAB() {
        Average_Color average_Color = new Average_Color();
        try {
            average_Color.image = WindowManager.getCurrentImage();
            average_Color.pixels = (int[])average_Color.image.getProcessor().getPixels();
            average_Color.w = average_Color.image.getWidth();
            average_Color.h = average_Color.image.getHeight();
            Roi roi = average_Color.image.getRoi();
            if (roi == null) {
                roi = new Roi(0, 0, average_Color.w, average_Color.h);
            }
            float[] fArray = average_Color.getAverageColor(roi, true);
            return "" + fArray[0] + " " + fArray[1] + " " + fArray[2];
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String setColorCIELAB(String string, String string2, String string3) {
        try {
            float[] fArray = new float[]{Float.parseFloat(string), Float.parseFloat(string2), Float.parseFloat(string3)};
            float[] fArray2 = new float[3];
            CIELAB.CIELAB2sRGB(fArray, fArray2);
            int n = CIELAB.unnorm(fArray2[0]);
            int n2 = CIELAB.unnorm(fArray2[1]);
            int n3 = CIELAB.unnorm(fArray2[2]);
            IJ.setForegroundColor((int)n, (int)n2, (int)n3);
            return "" + n + " " + n2 + " " + n3;
        }
        catch (Exception exception) {
            return "";
        }
    }
}

