/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import java.util.List;

public class Fill_holes
implements PlugIn {
    private static boolean debug = false;
    public static final String MACRO_CMD = "var leftClick=16, alt=9;\nmacro 'Fill hole Tool - C111O11ffC100T6c0aF' {\n while (true) {\n  getCursorLoc(x, y, z, flags);\n  if (flags&leftClick==0) exit();\n  call('Fill_holes.fillHoles', x,y,z,flags);\n  exit(); }\n}\n\n";

    public void run(String string) {
        MacroInstaller macroInstaller = new MacroInstaller();
        macroInstaller.install(MACRO_CMD);
    }

    public static synchronized void fillHoles(String string, String string2, String string3, String string4) {
        Fill_holes.fillHoles(Integer.parseInt(string), Integer.parseInt(string2), Integer.parseInt(string3));
    }

    public static synchronized void fillHoles(int n, int n2, int n3) {
        ImagePlus imagePlus = IJ.getImage();
        Roi roi = imagePlus.getRoi();
        if (roi == null || roi.getType() != 9) {
            IJ.showMessage((String)"Image with composite selection required");
            return;
        }
        if (roi.contains(n, n2)) {
            IJ.showMessage((String)"There is no hole at the specified location");
            return;
        }
        if (roi instanceof ShapeRoi) {
            try {
                Roi[] roiArray = ((ShapeRoi)roi).getRois();
                imagePlus.killRoi();
                Object var6_7 = null;
                RoiNode roiNode = new RoiNode(new ShapeRoi(new Roi(0, 0, imagePlus.getWidth(), imagePlus.getHeight())), true);
                for (int i = 0; i < roiArray.length; ++i) {
                    roiNode.add(new RoiNode(new ShapeRoi(roiArray[i])));
                }
                RoiNode roiNode2 = Fill_holes.findNodeForPosition(roiNode, n, n2);
                roiNode2.remove();
                ShapeRoi shapeRoi = new ShapeRoi(new Roi(0, 0, imagePlus.getWidth(), imagePlus.getHeight()));
                roiNode.createRoi(shapeRoi);
                imagePlus.setRoi((Roi)shapeRoi);
                imagePlus.updateAndDraw();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static RoiNode findNodeForPosition(RoiNode roiNode, int n, int n2) {
        RoiNode roiNode2 = roiNode;
        RoiNode roiNode3 = null;
        while (roiNode2 != null) {
            boolean bl = false;
            for (int i = 0; i < roiNode2.size(); ++i) {
                roiNode3 = roiNode2.children().get(i);
                if (!roiNode3.roi.contains(n, n2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                roiNode3 = roiNode2;
                break;
            }
            roiNode2 = roiNode3;
        }
        return roiNode3;
    }

    private static void dbg(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RoiNode {
        private RoiNode parent;
        private List<RoiNode> children;
        private ShapeRoi roi;
        private boolean isRoot = false;
        private int level;

        public RoiNode(ShapeRoi shapeRoi, boolean bl) {
            this(shapeRoi);
            this.isRoot = bl;
            if (bl) {
                this.level = 0;
            }
        }

        public RoiNode(ShapeRoi shapeRoi) {
            this.roi = shapeRoi;
            this.children = new ArrayList<RoiNode>();
        }

        public int getLevel() {
            return this.level;
        }

        public boolean containsChild(RoiNode roiNode) {
            return this.children.contains(roiNode);
        }

        public List<RoiNode> children() {
            return this.children;
        }

        public List<RoiNode> grandchildren() {
            ArrayList<RoiNode> arrayList = new ArrayList<RoiNode>();
            for (int i = 0; i < this.children.size(); ++i) {
                RoiNode roiNode = this.children.get(i);
                arrayList.addAll(roiNode.children);
            }
            return arrayList;
        }

        public int size() {
            return this.children.size();
        }

        public ShapeRoi getRoi() {
            return this.roi;
        }

        public RoiNode getParent() {
            return this.parent;
        }

        public void setParent(RoiNode roiNode) {
            this.parent = roiNode;
        }

        public void updateLevels() {
            this.level = this.isRoot ? 0 : this.parent.level + 1;
            for (int i = 0; i < this.size(); ++i) {
                this.children.get(i).updateLevels();
            }
        }

        public void createRoi(ShapeRoi shapeRoi) {
            if (this.level % 2 == 0) {
                shapeRoi.not(this.roi);
            } else {
                shapeRoi.or(this.roi);
            }
            for (int i = 0; i < this.size(); ++i) {
                this.children.get(i).createRoi(shapeRoi);
            }
        }

        public void add(RoiNode roiNode) {
            RoiNode roiNode2;
            int n;
            Fill_holes.dbg("\n\n" + this + "." + "add(" + roiNode + ")...");
            if (!this.contains(roiNode)) {
                Fill_holes.dbg("  this node does not contain it, give it to the parents");
                this.parent.add(roiNode);
                return;
            }
            for (n = 0; n < this.children.size(); ++n) {
                roiNode2 = this.children.get(n);
                if (!roiNode2.contains(roiNode)) continue;
                Fill_holes.dbg("My child " + roiNode2 + " contains " + roiNode + ", give the responsibility to her");
                roiNode2.add(roiNode);
                return;
            }
            Fill_holes.dbg("None of my children contains " + roiNode + ", so I must be the father myself ;)");
            roiNode.setParent(this);
            Fill_holes.dbg("But perhaps I can give some of my children to her...");
            for (n = 0; n < this.children.size(); ++n) {
                roiNode2 = this.children.get(n);
                if (!roiNode.contains(roiNode2)) continue;
                Fill_holes.dbg(roiNode + " contains " + roiNode2);
                roiNode.children.add(roiNode2);
                roiNode2.setParent(roiNode);
                this.children.remove(roiNode2);
                --n;
            }
            this.children.add(roiNode);
            this.updateLevels();
        }

        public void remove() {
            if (this.isRoot) {
                return;
            }
            this.parent.children.addAll(this.grandchildren());
            this.parent.children.remove(this);
            this.parent.updateLevels();
        }

        public boolean contains(RoiNode roiNode) {
            if (this.isRoot) {
                return true;
            }
            int n = roiNode.roi.getPolygon().xpoints[0];
            int n2 = roiNode.roi.getPolygon().ypoints[0];
            return this.roi.contains(n, n2);
        }

        public String longString() {
            String string = "";
            for (int i = 0; i < this.level; ++i) {
                string = string + "  ";
            }
            string = string + "\\--" + this + "  parent: " + this.parent;
            return string;
        }

        public String toString() {
            return "[" + this.roi.getBoundingRect().width + "; " + this.roi.getBoundingRect().height + "] (" + this.level + ")";
        }

        public void print() {
            System.out.print(this.longString() + "\n");
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).print();
            }
        }
    }
}

