/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import math3d.FastMatrixN;
import math3d.Point3d;

public class Implicit_Interpolate_Binary
implements PlugInFilter {
    private double[] lut;
    ImagePlus image;
    public ImplicitSamples[] samples;
    public ImplicitFunction implicitFunction;

    public void run(ImageProcessor imageProcessor) {
        int n;
        ImageStack imageStack = this.image.getStack();
        int n2 = imageStack.getSize();
        if (n2 < 3) {
            IJ.error((String)"Too few slices to interpolate!");
            return;
        }
        GenericDialog genericDialog = new GenericDialog("Interpolate");
        genericDialog.addNumericField("step", 30.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n3 = (int)genericDialog.getNextNumber();
        IJ.showStatus((String)"getting samples");
        this.samples = new ImplicitSamples[n2];
        for (n = 0; n < n2; ++n) {
            imageProcessor = imageStack.getProcessor(n + 1);
            this.samples[n] = ImplicitSamples.from((ByteProcessor)imageProcessor, n);
        }
        IJ.showStatus((String)"calculating weights");
        this.getImplicitFunction(n3);
        IJ.showStatus((String)"interpolating");
        for (n = 0; n < n2; ++n) {
            if (this.samples[n] == null) {
                this.evaluate((ByteProcessor)imageStack.getProcessor(n + 1), n);
            }
            IJ.showProgress((int)(n + 1), (int)n2);
        }
    }

    public void getImplicitFunction(int n) {
        Point3d point3d;
        int n2;
        int n3;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        int n4 = 0;
        for (n3 = 0; n3 < this.samples.length; ++n3) {
            if (this.samples[n3] == null) continue;
            Iterator iterator = this.samples[n3].ones.iterator();
            while (iterator.hasNext()) {
                if (n4++ % n == 0) {
                    arrayList.add(iterator.next());
                    continue;
                }
                iterator.next();
            }
            iterator = this.samples[n3].zeroes.iterator();
            while (iterator.hasNext()) {
                if (n4++ % n == 0) {
                    arrayList2.add(iterator.next());
                    continue;
                }
                iterator.next();
            }
        }
        n3 = arrayList.size();
        int n5 = arrayList2.size();
        int n6 = n3 + n5 + 4;
        double[][] dArray = new double[n6][n6];
        for (n2 = 0; n2 < n6 - 4; ++n2) {
            point3d = (Point3d)(n2 < n3 ? arrayList.get(n2) : arrayList2.get(n2 - n3));
            for (int i = n2 + 1; i < n6 - 4; ++i) {
                Point3d point3d2 = (Point3d)(i < n3 ? arrayList.get(i) : arrayList2.get(i - n3));
                double d = this.phi(point3d, point3d2);
                dArray[i][n2] = d;
                dArray[n2][i] = d;
            }
        }
        for (n2 = 0; n2 < n3 + n5; ++n2) {
            point3d = (Point3d)(n2 < n3 ? arrayList.get(n2) : arrayList2.get(n2 - n3));
            dArray[n6 - 4][n2] = 1.0;
            dArray[n2][n6 - 4] = 1.0;
            double d = point3d.x;
            dArray[n6 - 3][n2] = d;
            dArray[n2][n6 - 3] = d;
            double d2 = point3d.y;
            dArray[n6 - 2][n2] = d2;
            dArray[n2][n6 - 2] = d2;
            double d3 = point3d.z;
            dArray[n6 - 1][n2] = d3;
            dArray[n2][n6 - 1] = d3;
        }
        IJ.showStatus((String)("inverting " + n6 + " x " + n6 + " matrix"));
        FastMatrixN.invert(dArray, true);
        this.implicitFunction = new ImplicitFunction(dArray, arrayList, arrayList2);
    }

    public void evaluate(ByteProcessor byteProcessor, int n) {
        int n2 = byteProcessor.getWidth();
        int n3 = byteProcessor.getHeight();
        byte[] byArray = (byte[])byteProcessor.getPixels();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = this.implicitFunction.evaluate(j, i, n);
                byArray[j + i * n2] = (byte)(d > 0.0 ? 255 : 0);
            }
        }
    }

    public final double phi(Point3d point3d, Point3d point3d2) {
        return this.phi(point3d.x, point3d.y, point3d.z, point3d2);
    }

    public final double phi(double d, double d2, double d3, Point3d point3d) {
        double d4 = (d - point3d.x) * (d - point3d.x) + (d2 - point3d.y) * (d2 - point3d.y) + (d3 - point3d.z) * (d3 - point3d.z);
        return Implicit_Interpolate_Binary.phi(d4);
    }

    public static final double phi(double d) {
        return d > 0.0 ? d * Math.log(Math.sqrt(d)) : 0.0;
    }

    public final double phiLUT(double d) {
        int n;
        int n2 = this.image.getWidth();
        int n3 = this.image.getHeight();
        int n4 = this.image.getStackSize();
        if (this.lut == null) {
            this.lut = new double[n2 * n2 + n3 * n3 + n4 * n4];
            for (n = 0; n < this.lut.length; ++n) {
                this.lut[n] = -1.0;
            }
        }
        n = (int)Math.floor(d);
        int n5 = n + 1;
        if (this.lut[n] < 0.0) {
            this.lut[n] = Implicit_Interpolate_Binary.phi(n);
        }
        if (this.lut[n5] < 0.0) {
            this.lut[n5] = Implicit_Interpolate_Binary.phi(n5);
        }
        double d2 = this.lut[n];
        double d3 = this.lut[n5];
        double d4 = Math.abs(d - (double)n) * Math.abs(d3 - d2) / (double)(n5 - n) + d2;
        return d4;
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }

    public class ImplicitFunction {
        Point3d[] points;
        double[] weights;
        double p0;
        double pX;
        double pY;
        double pZ;

        ImplicitFunction(double[][] dArray, ArrayList arrayList, ArrayList arrayList2) {
            int n;
            this.points = new Point3d[dArray.length - 4];
            this.weights = new double[this.points.length];
            int n2 = arrayList.size();
            for (n = 0; n < this.points.length; ++n) {
                this.points[n] = (Point3d)(n < n2 ? arrayList.get(n) : arrayList2.get(n - n2));
                for (int i = 0; i < n2; ++i) {
                    int n3 = n;
                    this.weights[n3] = this.weights[n3] + dArray[n][i];
                }
            }
            for (n = 0; n < n2; ++n) {
                this.p0 += dArray[dArray.length - 4][n];
                this.pX += dArray[dArray.length - 3][n];
                this.pY += dArray[dArray.length - 2][n];
                this.pZ += dArray[dArray.length - 1][n];
            }
        }

        public double evaluate(Point3d point3d) {
            return this.evaluate(point3d.x, point3d.y, point3d.z);
        }

        public double evaluate(double d, double d2, double d3) {
            double d4 = this.p0 + this.pX * d + this.pY * d2 + this.pZ * d3;
            for (int i = 0; i < this.points.length; ++i) {
                d4 += Implicit_Interpolate_Binary.this.phi(d, d2, d3, this.points[i]) * this.weights[i];
            }
            return d4;
        }
    }

    public static class ImplicitSamples {
        ArrayList ones = new ArrayList();
        ArrayList zeroes = new ArrayList();

        ImplicitSamples() {
        }

        public static ImplicitSamples from(ByteProcessor byteProcessor, int n) {
            ImplicitSamples implicitSamples = new ImplicitSamples();
            implicitSamples.initFromSlice(byteProcessor, n);
            if (implicitSamples.ones.size() == 0 && implicitSamples.zeroes.size() == 0) {
                return null;
            }
            return implicitSamples;
        }

        public void initFromSlice(ByteProcessor byteProcessor, int n) {
            int n2 = byteProcessor.getWidth();
            int n3 = byteProcessor.getHeight();
            byte[] byArray = (byte[])byteProcessor.getPixels();
            for (int i = 1; i < n3; ++i) {
                for (int j = 1; j < n2; ++j) {
                    byte by = byArray[j - 1 + (i - 1) * n2];
                    byte by2 = byArray[j - 1 + i * n2];
                    byte by3 = byArray[j + (i - 1) * n2];
                    byte by4 = byArray[j + i * n2];
                    if (by != 0 && by2 == 0 && by3 == 0 && by4 == 0) {
                        this.zeroes.add(new Point3d((double)j - 0.6, (double)i - 0.6, n));
                        this.ones.add(new Point3d((double)j - 0.9, (double)i - 0.9, n));
                        continue;
                    }
                    if (by == 0 && by2 != 0 && by3 == 0 && by4 == 0) {
                        this.zeroes.add(new Point3d((double)j - 0.6, (double)i - 0.4, n));
                        this.ones.add(new Point3d((double)j - 0.9, (double)i - 0.1, n));
                        continue;
                    }
                    if (by == 0 && by2 == 0 && by3 != 0 && by4 == 0) {
                        this.zeroes.add(new Point3d((double)j - 0.4, (double)i - 0.6, n));
                        this.ones.add(new Point3d((double)j - 0.1, (double)i - 0.9, n));
                        continue;
                    }
                    if (by == 0 && by2 == 0 && by3 == 0 && by4 != 0) {
                        this.zeroes.add(new Point3d((double)j - 0.4, (double)i - 0.4, n));
                        this.ones.add(new Point3d((double)j - 0.1, (double)i - 0.1, n));
                        continue;
                    }
                    if (by != 0 && by2 != 0 && by3 == 0 && by4 == 0) {
                        this.zeroes.add(new Point3d((double)j - 0.7, (double)i - 0.5, n));
                        this.ones.add(new Point3d(j - 1, (double)i - 0.5, n));
                        continue;
                    }
                    if (by != 0 && by2 == 0 && by3 != 0 && by4 == 0) {
                        this.zeroes.add(new Point3d((double)j - 0.5, (double)i - 0.7, n));
                        this.ones.add(new Point3d((double)j - 0.5, i - 1, n));
                        continue;
                    }
                    if (by == 0 && by2 != 0 && by3 == 0 && by4 != 0) {
                        this.zeroes.add(new Point3d((double)j - 0.5, (double)i - 0.3, n));
                        this.ones.add(new Point3d((double)j - 0.5, i, n));
                        continue;
                    }
                    if (by == 0 && by2 == 0 && by3 != 0 && by4 != 0) {
                        this.zeroes.add(new Point3d((double)j - 0.3, (double)i - 0.5, n));
                        this.ones.add(new Point3d(j, (double)i - 0.5, n));
                        continue;
                    }
                    if (by != 0 && by2 == 0 && by3 == 0 && by4 != 0) {
                        this.zeroes.add(new Point3d((double)j - 0.7, (double)i - 0.3, n));
                        this.zeroes.add(new Point3d((double)j - 0.3, (double)i - 0.7, n));
                        this.ones.add(new Point3d((double)j - 0.5, (double)i - 0.5, n));
                        continue;
                    }
                    if (by == 0 && by2 != 0 && by3 != 0 && by4 == 0) {
                        this.zeroes.add(new Point3d((double)j - 0.7, (double)i - 0.7, n));
                        this.zeroes.add(new Point3d((double)j - 0.3, (double)i - 0.3, n));
                        this.ones.add(new Point3d((double)j - 0.5, (double)i - 0.5, n));
                        continue;
                    }
                    if (by == 0 && by2 != 0 && by3 != 0 && by4 != 0) {
                        this.zeroes.add(new Point3d((double)j - 0.7, (double)i - 0.7, n));
                        this.ones.add(new Point3d((double)j - 0.1, (double)i - 0.1, n));
                        continue;
                    }
                    if (by != 0 && by2 == 0 && by3 != 0 && by4 != 0) {
                        this.zeroes.add(new Point3d((double)j - 0.7, (double)i - 0.3, n));
                        this.ones.add(new Point3d((double)j - 0.1, (double)i - 0.9, n));
                        continue;
                    }
                    if (by != 0 && by2 != 0 && by3 == 0 && by4 != 0) {
                        this.zeroes.add(new Point3d((double)j - 0.3, (double)i - 0.7, n));
                        this.ones.add(new Point3d((double)j - 0.9, (double)i - 0.1, n));
                        continue;
                    }
                    if (by == 0 || by2 == 0 || by3 == 0 || by4 != 0) continue;
                    this.zeroes.add(new Point3d((double)j - 0.3, (double)i - 0.3, n));
                    this.ones.add(new Point3d((double)j - 0.9, (double)i - 0.9, n));
                }
            }
        }
    }
}

