/*
 * Decompiled with CFR 0.152.
 */
import com.sun.j3d.utils.geometry.Sphere;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij3d.Image3DUniverse;
import ij3d.Volume;
import java.awt.Color;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import marchingcubes.MCCube;

public class MC_Test
implements PlugIn {
    private ImagePlus image;
    private byte[][] data;
    private static final Color3f GREY = new Color3f(Color.LIGHT_GRAY);
    private static final Color3f RED = new Color3f(1.0f, 0.0f, 0.0f);

    public void run(String string) {
        int n = 1;
        final Image3DUniverse image3DUniverse = new Image3DUniverse(512, 512);
        this.displayCube(image3DUniverse);
        Transform3D transform3D = new Transform3D();
        Transform3D transform3D2 = new Transform3D();
        transform3D.rotY(0.7853981633974483);
        transform3D2.rotX(-0.7853981633974483);
        transform3D.mul(transform3D2);
        image3DUniverse.show();
        this.displayCase(image3DUniverse, n);
        GenericDialog genericDialog = new GenericDialog("ImageJ 3D Viewer");
        genericDialog.addSlider("case: ", 0.0, 255.0, (double)n);
        final Scrollbar scrollbar = (Scrollbar)genericDialog.getSliders().get(0);
        scrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                MC_Test.this.displayCase(image3DUniverse, scrollbar.getValue());
            }
        });
        genericDialog.setModal(false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
    }

    public void displayCase(Image3DUniverse image3DUniverse, int n) {
        System.out.println("Case no " + n);
        int n2 = 120;
        BranchGroup branchGroup = image3DUniverse.getScene();
        for (int i = branchGroup.numChildren() - 1; i >= 1; --i) {
            branchGroup.removeChild(i);
        }
        this.createCase(n);
        Volume volume = new Volume(this.image);
        List<Point3f> list = MCCube.getTriangles(volume, n2);
        image3DUniverse.addMesh(list, RED, "case" + n, n2);
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    if ((this.data[i][j * 2 + k] & 0xFF) >= n2) {
                        this.addVertex(image3DUniverse, RED, k, j, i);
                        continue;
                    }
                    this.addVertex(image3DUniverse, GREY, k, j, i);
                }
            }
        }
    }

    public void addVertex(Image3DUniverse image3DUniverse, Color3f color3f, float f, float f2, float f3) {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        TransformGroup transformGroup = new TransformGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(f, f2, f3));
        transformGroup.setTransform(transform3D);
        branchGroup.addChild((Node)transformGroup);
        Appearance appearance = new Appearance();
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setColor(color3f);
        appearance.setColoringAttributes(coloringAttributes);
        transformGroup.addChild((Node)new Sphere(0.1f, appearance));
        image3DUniverse.getScene().addChild((Node)branchGroup);
    }

    public void createCase(int n) {
        int n2 = -1;
        ImageStack imageStack = new ImageStack(2, 2);
        imageStack.addSlice("", (ImageProcessor)new ByteProcessor(2, 2));
        imageStack.addSlice("", (ImageProcessor)new ByteProcessor(2, 2));
        this.data = new byte[2][];
        this.data[0] = (byte[])imageStack.getProcessor(1).getPixels();
        this.data[1] = (byte[])imageStack.getProcessor(2).getPixels();
        if (n >= 128) {
            this.data[1][0] = n2;
            n -= 128;
        }
        if (n >= 64) {
            this.data[1][1] = n2;
            n -= 64;
        }
        if (n >= 32) {
            this.data[1][3] = n2;
            n -= 32;
        }
        if (n >= 16) {
            this.data[1][2] = n2;
            n -= 16;
        }
        if (n >= 8) {
            this.data[0][0] = n2;
            n -= 8;
        }
        if (n >= 4) {
            this.data[0][1] = n2;
            n -= 4;
        }
        if (n >= 2) {
            this.data[0][3] = n2;
            n -= 2;
        }
        if (n >= 1) {
            this.data[0][2] = n2;
            --n;
        }
        this.image = new ImagePlus("", imageStack);
    }

    public void displayCube(Image3DUniverse image3DUniverse) {
        QuadArray quadArray = new QuadArray(24, 1);
        Point3f[] point3fArray = new Point3f[]{new Point3f(1.0f, 0.0f, 0.0f), new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, 1.0f, 1.0f), new Point3f(1.0f, 0.0f, 1.0f), new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 1.0f, 1.0f), new Point3f(0.0f, 0.0f, 1.0f)};
        Point3f[] point3fArray2 = new Point3f[]{point3fArray[0], point3fArray[0], point3fArray[0], point3fArray[0], point3fArray[1], point3fArray[5], point3fArray[6], point3fArray[2], point3fArray[5], point3fArray[4], point3fArray[7], point3fArray[6], point3fArray[4], point3fArray[0], point3fArray[3], point3fArray[7], point3fArray[4], point3fArray[5], point3fArray[1], point3fArray[0], point3fArray[3], point3fArray[2], point3fArray[6], point3fArray[7]};
        quadArray.setCoordinates(0, point3fArray2);
        Appearance appearance = new Appearance();
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setColor(RED);
        appearance.setColoringAttributes(coloringAttributes);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setPolygonMode(1);
        polygonAttributes.setCullFace(0);
        polygonAttributes.setBackFaceNormalFlip(true);
        appearance.setPolygonAttributes(polygonAttributes);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.addChild((Node)new Shape3D((Geometry)quadArray, appearance));
        image3DUniverse.getScene().addChild((Node)branchGroup);
    }
}

