/*
 * Decompiled with CFR 0.152.
 */
import ij.ImagePlus;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;

public class Psychomorph_TEM_Reader
implements PlugInFilter {
    ImagePlus image;

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        OpenDialog openDialog = new OpenDialog("TEM File", null);
        String string = openDialog.getDirectory();
        String string2 = openDialog.getFileName();
        if (string2 == null) {
            return;
        }
        try {
            TEM tEM = new TEM();
            tEM.readFile(string + File.separator + string2);
            tEM.setRoi(this.image);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        if (stringArray.length != 3 && stringArray.length != 4) {
            System.err.println("Usage: prog <original-tem> <incomplete-tem> <output-tem>");
            System.err.println("       prog -scale <factor> <original-tem>  <output-tem>");
            System.exit(1);
        }
        TEM tEM = new TEM();
        TEM tEM2 = new TEM();
        if (stringArray[0].equals("-scale")) {
            float f = Float.parseFloat(stringArray[1]);
            try {
                tEM.readFile(stringArray[2]);
                n2 = 0;
                while (n2 < tEM.pointCount) {
                    int n3 = n2;
                    tEM.x[n3] = tEM.x[n3] * f;
                    int n4 = n2++;
                    tEM.y[n4] = tEM.y[n4] * f;
                }
                tEM.writeFile(stringArray[3]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception);
            }
            System.exit(0);
        }
        try {
            tEM.readFile(stringArray[0]);
            tEM2.readFile(stringArray[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
        Moving_Least_Squares.Method method = Moving_Least_Squares.getMethod(2);
        n2 = tEM.pointCount;
        int n5 = tEM2.pointCount;
        method.setCoordinates(tEM.x, tEM.y, tEM2.x, tEM2.y, n5);
        for (n = n5; n < n2; ++n) {
            method.calculate(tEM.x[n], tEM.y[n]);
            if (method.resultX < 1.0f) {
                method.resultX = 1.0f;
            }
            if (method.resultY < 1.0f) {
                method.resultY = 1.0f;
            }
            tEM2.addPoint(method.resultX, method.resultY);
        }
        for (n = tEM2.lineCount; n < tEM.lineCount; ++n) {
            tEM2.addLine(tEM.lines[n]);
        }
        try {
            tEM2.writeFile(stringArray[2]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    private static class TEM {
        int pointCount;
        int lineCount;
        float[] x;
        float[] y;
        int[][] lines;

        private TEM() {
        }

        void setRoi(ImagePlus imagePlus) {
            int n = this.x.length;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = Math.round(this.x[i]);
                nArray2[i] = Math.round(this.y[i]);
            }
            PointRoi pointRoi = new PointRoi(nArray, nArray2, n);
            imagePlus.setRoi((Roi)pointRoi);
            imagePlus.updateAndDraw();
        }

        void readFile(String string) throws IOException {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.pointCount = Integer.parseInt(bufferedReader.readLine());
            this.x = new float[this.pointCount];
            this.y = new float[this.pointCount];
            for (n = 0; n < this.pointCount; ++n) {
                String[] stringArray = Tools.split((String)bufferedReader.readLine());
                this.x[n] = Float.parseFloat(stringArray[0]);
                this.y[n] = Float.parseFloat(stringArray[1]);
            }
            this.lineCount = Integer.parseInt(bufferedReader.readLine());
            this.lines = new int[this.lineCount][];
            for (n = 0; n < this.lineCount; ++n) {
                bufferedReader.readLine();
                int n2 = Integer.parseInt(bufferedReader.readLine());
                String string2 = bufferedReader.readLine();
                String[] stringArray = Tools.split((String)string2);
                if (n2 != stringArray.length) {
                    throw new RuntimeException("len mismatch: len=" + n2 + ", line is " + string2);
                }
                this.lines[n] = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    this.lines[n][i] = Integer.parseInt(stringArray[i]);
                }
            }
            bufferedReader.close();
        }

        void writeFile(String string) throws IOException {
            int n;
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println(this.pointCount);
            for (n = 0; n < this.pointCount; ++n) {
                printStream.println("" + this.x[n] + "\t" + this.y[n]);
            }
            printStream.println(this.lineCount);
            for (n = 0; n < this.lineCount; ++n) {
                printStream.println(0);
                int n2 = this.lines[n].length;
                printStream.println(n2);
                for (int i = 0; i < n2 - 1; ++i) {
                    printStream.print(this.lines[n][i] + " ");
                }
                printStream.println(this.lines[n][n2 - 1]);
            }
            printStream.println(0);
            printStream.close();
        }

        boolean lineSetsEqual(TEM tEM) {
            if (this.lines.length != tEM.lines.length) {
                return false;
            }
            for (int i = 0; i < this.lines.length; ++i) {
                if (this.lines[i].length != tEM.lines[i].length) {
                    return false;
                }
                for (int j = 0; j < this.lines[i].length; ++j) {
                    if (this.lines[i][j] == tEM.lines[i][j]) continue;
                    return false;
                }
            }
            return true;
        }

        void addPoint(float f, float f2) {
            if (this.pointCount + 1 > this.x.length) {
                int n = this.pointCount + 32;
                float[] fArray = new float[n];
                System.arraycopy(this.x, 0, fArray, 0, this.pointCount);
                this.x = fArray;
                fArray = new float[n];
                System.arraycopy(this.y, 0, fArray, 0, this.pointCount);
                this.y = fArray;
            }
            this.x[this.pointCount] = f;
            this.y[this.pointCount++] = f2;
        }

        void addLine(int[] nArray) {
            if (this.lineCount + 1 > this.lines.length) {
                int n = this.lineCount + 32;
                int[][] nArrayArray = new int[n][];
                System.arraycopy(this.lines, 0, nArrayArray, 0, this.lineCount);
                this.lines = nArrayArray;
            }
            this.lines[this.lineCount++] = nArray;
        }
    }
}

