/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class Reslice_Z
implements PlugInFilter {
    private ImagePlus image;
    private Calibration cal;
    private int w;
    private int h;

    public void run(ImageProcessor imageProcessor) {
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.cal = this.image.getCalibration();
        GenericDialog genericDialog = new GenericDialog("Reslice_Z");
        genericDialog.addNumericField("New pixel depth", this.cal.pixelDepth, 3);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        double d = genericDialog.getNextNumber();
        int n = this.image.getType();
        if (n == 0) {
            this.resliceByte(d).show();
        } else if (n == 4) {
            this.resliceColor(d).show();
        } else {
            IJ.error((String)"Wrong image type");
        }
    }

    public ImagePlus resliceColor(double d) {
        ImageStack imageStack = this.image.getStack();
        int n = (int)((double)this.image.getStackSize() * this.cal.pixelDepth / d);
        ImageStack imageStack2 = new ImageStack(this.w, this.h);
        for (int i = 0; i < n; ++i) {
            ColorProcessor colorProcessor = new ColorProcessor(this.w, this.h);
            int[] nArray = (int[])colorProcessor.getPixels();
            double d2 = (double)i * d;
            int n2 = (int)Math.floor(d2 / this.cal.pixelDepth);
            int n3 = n2 + 1;
            if (n3 >= this.image.getStackSize()) break;
            double d3 = d2 - (double)n2 * this.cal.pixelDepth;
            double d4 = (double)n3 * this.cal.pixelDepth - d2;
            int[] nArray2 = (int[])imageStack.getProcessor(n2 + 1).getPixels();
            int[] nArray3 = (int[])imageStack.getProcessor(n3 + 1).getPixels();
            for (int j = 0; j < nArray.length; ++j) {
                byte by = this.interpolate((byte)((nArray2[j] & 0xFF0000) >> 16), d3, (byte)((nArray3[j] & 0xFF0000) >> 16), d4);
                byte by2 = this.interpolate((byte)((nArray2[j] & 0xFF00) >> 8), d3, (byte)((nArray3[j] & 0xFF00) >> 8), d4);
                byte by3 = this.interpolate((byte)(nArray2[j] & 0xFF), d3, (byte)(nArray3[j] & 0xFF), d4);
                nArray[j] = (((by & 0xFF) << 8) + (by2 & 0xFF) << 8) + (by3 & 0xFF);
            }
            imageStack2.addSlice("", (ImageProcessor)colorProcessor);
        }
        ImagePlus imagePlus = new ImagePlus("Resliced", imageStack2);
        this.cal = this.cal.copy();
        this.cal.pixelDepth = d;
        imagePlus.setCalibration(this.cal);
        return imagePlus;
    }

    public ImagePlus resliceByte(double d) {
        ImageStack imageStack = this.image.getStack();
        int n = (int)((double)this.image.getStackSize() * this.cal.pixelDepth / d);
        ImageStack imageStack2 = new ImageStack(this.w, this.h);
        for (int i = 0; i < n; ++i) {
            ByteProcessor byteProcessor = new ByteProcessor(this.w, this.h);
            byte[] byArray = (byte[])byteProcessor.getPixels();
            double d2 = (double)i * d;
            int n2 = (int)Math.floor(d2 / this.cal.pixelDepth);
            int n3 = n2 + 1;
            if (n3 >= this.image.getStackSize()) break;
            double d3 = d2 - (double)n2 * this.cal.pixelDepth;
            double d4 = (double)n3 * this.cal.pixelDepth - d2;
            byte[] byArray2 = (byte[])imageStack.getProcessor(n2 + 1).getPixels();
            byte[] byArray3 = (byte[])imageStack.getProcessor(n3 + 1).getPixels();
            for (int j = 0; j < byArray.length; ++j) {
                byArray[j] = this.interpolate(byArray2[j], d3, byArray3[j], d4);
            }
            imageStack2.addSlice("", (ImageProcessor)byteProcessor);
        }
        ImagePlus imagePlus = new ImagePlus("Resliced", imageStack2);
        this.cal = this.cal.copy();
        this.cal.pixelDepth = d;
        imagePlus.setCalibration(this.cal);
        return imagePlus;
    }

    public byte interpolate(byte by, double d, byte by2, double d2) {
        return (byte)(((double)(by & 0xFF) * d2 + (double)(by2 & 0xFF) * d) / (d2 + d));
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 17;
    }
}

