/*
 * Decompiled with CFR 0.152.
 */
import amira.AmiraParameters;
import amira.AmiraTable;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.text.TextPanel;
import ij.util.Tools;
import java.util.ArrayList;

public class Show_Label_Centers
implements PlugInFilter {
    private ImagePlus image;

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 3;
    }

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Show Label Centers");
        AmiraParameters.addAmiraTableList(genericDialog, "Statistics file");
        genericDialog.addNumericField("Radius", 10.0, 2);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        String string = genericDialog.getNextChoice();
        AmiraTable amiraTable = (AmiraTable)((Object)WindowManager.getFrame((String)string));
        double d = genericDialog.getNextNumber();
        Show_Label_Centers.calculateCenters(this.image, amiraTable, d).show();
    }

    public static ImagePlus calculateCenters(ImagePlus imagePlus, AmiraTable amiraTable, double d) {
        double d2 = d * d;
        Point3D[] point3DArray = Show_Label_Centers.getList(amiraTable);
        ImageStack imageStack = imagePlus.getStack();
        Calibration calibration = imagePlus.getCalibration();
        double d3 = calibration.pixelWidth;
        double d4 = calibration.pixelHeight;
        double d5 = calibration.pixelDepth;
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getStackSize();
        ImageStack imageStack2 = new ImageStack(n, n2);
        for (int i = 0; i < n3; ++i) {
            byte[] byArray = new byte[n * n2];
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    int n4 = j * n + k;
                    for (int i2 = 0; i2 < point3DArray.length; ++i2) {
                        if (!Show_Label_Centers.check(point3DArray[i2], new Point3D((double)k * d3, (double)j * d4, (double)i * d5), d2)) continue;
                        byArray[n4] = -1;
                    }
                }
            }
            imageStack2.addSlice("", (ImageProcessor)new ByteProcessor(n, n2, byArray, null));
        }
        ImagePlus imagePlus2 = new ImagePlus("Centers", imageStack2);
        imagePlus2.setCalibration(calibration);
        return imagePlus2;
    }

    private static boolean check(Point3D point3D, Point3D point3D2, double d) {
        return (point3D2.x - point3D.x) * (point3D2.x - point3D.x) + (point3D2.y - point3D.y) * (point3D2.y - point3D.y) + (point3D2.z - point3D.z) * (point3D2.z - point3D.z) < d;
    }

    public static Point3D[] getList(AmiraTable amiraTable) {
        TextPanel textPanel = amiraTable.getTextPanel();
        int n = textPanel.getLineCount();
        ArrayList<Point3D> arrayList = new ArrayList<Point3D>();
        for (int i = 1; i < n; ++i) {
            String[] stringArray = Tools.split((String)textPanel.getLine(i), (String)"\t");
            int n2 = Integer.parseInt(stringArray[2]);
            if (n2 == 0) continue;
            arrayList.add(new Point3D(Double.parseDouble(stringArray[4]), Double.parseDouble(stringArray[5]), Double.parseDouble(stringArray[6])));
        }
        return arrayList.toArray(new Point3D[0]);
    }

    private static class Point3D {
        private double x;
        private double y;
        private double z;

        public Point3D(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }
    }
}

