/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.io.DirectoryChooser;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import vib.app.Options;
import vib.app.gui.FileGroupDialog;
import vib.app.gui.ProgressIndicator;
import vib.app.module.EndModule;
import vib.app.module.Module;
import vib.app.module.State;

public class VIB_Protocol
implements PlugIn,
ActionListener {
    static final int WD = 0;
    static final int TEMPL = 1;
    static final int NO_CHANNEL = 0;
    static final int REF_CHANNEL = 1;
    static final int RES_F = 2;
    private Button fg;
    private Button load;
    private Button save;
    private Button templateButton;
    private Options options;
    private GenericDialog gd;
    private FileGroupDialog fgd;
    private File template;

    public void run(String string) {
        String string2;
        this.options = new Options();
        if (Macro.getOptions() != null && !(string2 = Macro.getValue((String)Macro.getOptions(), (String)"load", (String)"")).equals("")) {
            this.options.loadFrom(string2);
            State state = new State(this.options);
            Module.addModuleListener(new ProgressIndicator(this.options));
            new EndModule().runOnAllImages(state);
            return;
        }
        this.gd = new GenericDialog("VIB Protocol");
        this.gd.addMessage("Do you want to load a stored configuration? ");
        this.gd.addMessage("If not, leave blank and click 'OK'");
        this.gd.addMessage("  ");
        Panel panel = new Panel();
        Button button = new Button("Load");
        panel.add(button);
        this.gd.addPanel(panel);
        this.gd.addStringField("Configuration file", "", 25);
        final TextField textField = (TextField)this.gd.getStringFields().get(0);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpenDialog openDialog = new OpenDialog("Load", "");
                String string = openDialog.getDirectory() + openDialog.getFileName();
                textField.setText(string);
                VIB_Protocol.this.gd.repaint();
            }
        });
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return;
        }
        this.gd = new GenericDialog("VIB Protocol");
        this.fgd = new FileGroupDialog(this.options.fileGroup);
        this.templateButton = this.fgd.getTemplateButton();
        this.templateButton.addActionListener(this);
        this.gd.addPanel((Panel)this.fgd);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        this.load = new Button("Select working directory");
        this.load.addActionListener(this);
        panel = new Panel();
        this.gd.addPanel(panel);
        this.gd.remove((Component)panel);
        this.gd.add((Component)this.load, (Object)gridBagConstraints);
        this.gd.addStringField("Working directory", "", 25);
        this.gd.addStringField("Template", "", 25);
        this.gd.addNumericField("No of channels", 2.0, 0);
        this.gd.addNumericField("No of the reference channel", 2.0, 0);
        this.gd.addNumericField("Resampling factor", 2.0, 0);
        TextField textField2 = (TextField)this.gd.getStringFields().get(0);
        if (!textField.getText().trim().equals("")) {
            this.loadFrom(textField.getText());
        }
        TextField textField3 = (TextField)this.gd.getStringFields().get(1);
        textField3.setEditable(false);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return;
        }
        this.initOptions();
        String string3 = this.options.workingDirectory + File.separator + "options.config";
        this.options.saveTo(string3);
        if (!Interpreter.isBatchMode() && Macro.getOptions() == null) {
            IJ.showMessage((String)("Stored configuration in \n" + string3 + "\nYou can load it the next time you start " + "the protocol."));
        }
        State state = new State(this.options);
        Module.addModuleListener(new ProgressIndicator(this.options));
        new EndModule().runOnAllImages(state);
    }

    public void loadFrom(String string) {
        if (new File(string).exists()) {
            this.options.loadFrom(string);
            this.initTextFields();
        }
    }

    public void initTextFields() {
        this.template = new File(this.options.templatePath);
        this.setString(0, this.options.workingDirectory);
        this.setString(1, this.options.templatePath);
        this.setNumber(0, this.options.numChannels);
        this.setNumber(1, this.options.refChannel);
        this.setNumber(2, this.options.resamplingFactor);
        this.fgd.update();
    }

    public void initOptions() {
        this.options.workingDirectory = this.getString(0);
        this.options.templatePath = this.getString(1);
        this.options.numChannels = this.getNumber(0);
        this.options.refChannel = this.getNumber(1);
        this.options.resamplingFactor = this.getNumber(2);
    }

    private String getChoice(int n) {
        Choice choice = (Choice)this.gd.getChoices().get(n);
        return choice.getSelectedItem();
    }

    private void setChoice(int n, String string) {
        ((Choice)this.gd.getChoices().get(n)).select(string);
    }

    private int getNumber(int n) {
        TextField textField = (TextField)this.gd.getNumericFields().get(n);
        double d = 0.0;
        try {
            d = Double.parseDouble(textField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            IJ.error((String)(textField.getText() + " is not a number"));
        }
        return (int)Math.round(d);
    }

    private String getString(int n) {
        TextField textField = (TextField)this.gd.getStringFields().get(n);
        return textField.getText();
    }

    private void setNumber(int n, int n2) {
        ((TextField)this.gd.getNumericFields().get(n)).setText(Integer.toString(n2));
    }

    private void setString(int n, String string) {
        ((TextField)this.gd.getStringFields().get(n)).setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DirectoryChooser directoryChooser;
        String string;
        if (actionEvent.getSource() == this.templateButton) {
            File file = this.fgd.getSelected();
            if (file != null) {
                this.template = file;
                this.setString(1, file.getAbsolutePath());
            }
        } else if (actionEvent.getSource() == this.load && (string = (directoryChooser = new DirectoryChooser("Working Directory")).getDirectory()) != null) {
            this.setString(0, string);
        }
    }
}

