/*
 * Decompiled with CFR 0.152.
 */
package adt;

import java.awt.Point;
import java.awt.Polygon;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Points {
    private HashSet<Point> points = new HashSet();
    private Points child = null;
    private Point topLeft;
    private Point bottomRight;

    public void addPoint(int n, int n2) {
        this.addPoint(new Point(n, n2));
    }

    public void addPoint(Point point) {
        if (this.topLeft == null) {
            this.topLeft = new Point(point.x, point.y);
        } else {
            if (point.x < this.topLeft.x) {
                this.topLeft.x = point.x;
            }
            if (point.y < this.topLeft.y) {
                this.topLeft.y = point.y;
            }
        }
        if (this.bottomRight == null) {
            this.bottomRight = new Point(point.x, point.y);
        } else {
            if (point.x > this.bottomRight.x) {
                this.bottomRight.x = point.x;
            }
            if (point.y > this.bottomRight.y) {
                this.bottomRight.y = point.y;
            }
        }
        this.points.add(point);
    }

    public int getSize() {
        return this.points.size() + (this.child == null ? 0 : this.child.getSize());
    }

    public boolean contains(Point point) {
        if (this.child == null) {
            return this.points.contains(point);
        }
        return this.points.contains(point) || this.child.contains(point);
    }

    public void addPoints(Points points) {
        if (points.topLeft.x < this.topLeft.x) {
            this.topLeft.x = points.topLeft.x;
        }
        if (points.topLeft.y < this.topLeft.y) {
            this.topLeft.y = points.topLeft.y;
        }
        if (points.bottomRight.x < this.bottomRight.x) {
            this.bottomRight.x = points.bottomRight.x;
        }
        if (points.bottomRight.y < this.bottomRight.y) {
            this.bottomRight.y = points.bottomRight.y;
        }
        if (points.points.size() > 5) {
            if (this.child == null) {
                this.child = points;
            } else {
                this.child.addPoints(points);
            }
        } else {
            this.points.addAll(points.points);
        }
    }

    private void removeChildRef() {
        Points points = this.child;
        while (points != null) {
            this.points.addAll(points.points);
            Points points2 = points;
            points = points.child;
            points2.child = null;
        }
        this.child = null;
    }

    public Iterable<Point> getPoints() {
        this.removeChildRef();
        return this.points;
    }

    public Polygon getOutline() {
        this.removeChildRef();
        Polygon polygon = new Polygon();
        SearchNode searchNode = this.findInitialEdge();
        Point point = searchNode.p;
        do {
            polygon.addPoint(searchNode.p.x, searchNode.p.y);
            searchNode.next();
        } while (!searchNode.p.equals(point));
        return polygon;
    }

    private SearchNode findInitialEdge() {
        for (int i = this.topLeft.x; i <= this.bottomRight.x; ++i) {
            for (int j = this.topLeft.y; j <= this.bottomRight.y; ++j) {
                if (!this.contains(new Point(i, j))) continue;
                if (j > this.topLeft.y) {
                    System.err.println("border has been calculated incorrectly, but corrected for");
                }
                return new SearchNode(new Point(i, j), 0);
            }
        }
        throw new RuntimeException("border has been calculated incorrectly");
    }

    class SearchNode {
        Point p;
        int borderDir;

        public SearchNode(Point point, int n) {
            this.p = point;
            this.borderDir = n;
        }

        public void next() {
            int n;
            Point point = null;
            int n2 = this.borderDir;
            Point point2 = this.getPointInDir(this.p, this.borderDir);
            for (n = 1; n < 8 && !Points.this.contains(point = this.getPointInDir(this.p, n2 = (this.borderDir + n) % 8)); ++n) {
                point2 = point;
            }
            if (point == null) {
                point = this.p;
                System.out.println("single point points = " + Points.this.points);
            }
            this.p = point;
            this.borderDir = this.dir(this.p, point2);
            for (n = 1; n < 8 && !Points.this.contains(point = this.getPointInDir(this.p, n2 = (this.borderDir + 1) % 8)); ++n) {
                this.borderDir = n2;
            }
        }

        public Point getPointInDir(Point point, int n) {
            if (n == 0) {
                return new Point(point.x, point.y - 1);
            }
            if (n == 1) {
                return new Point(point.x + 1, point.y - 1);
            }
            if (n == 2) {
                return new Point(point.x + 1, point.y);
            }
            if (n == 3) {
                return new Point(point.x + 1, point.y + 1);
            }
            if (n == 4) {
                return new Point(point.x, point.y + 1);
            }
            if (n == 5) {
                return new Point(point.x - 1, point.y + 1);
            }
            if (n == 6) {
                return new Point(point.x - 1, point.y);
            }
            if (n == 7) {
                return new Point(point.x - 1, point.y - 1);
            }
            throw new RuntimeException("dir = " + n);
        }

        public int dir(Point point, Point point2) {
            if (point2.x < point.x) {
                if (point2.y < point.y) {
                    return 7;
                }
                if (point2.y == point.y) {
                    return 6;
                }
                return 5;
            }
            if (point2.x == point.x) {
                if (point2.y < point.y) {
                    return 0;
                }
                if (point2.y == point.y) {
                    return -1;
                }
                return 4;
            }
            if (point2.y < point.y) {
                return 1;
            }
            if (point2.y == point.y) {
                return 2;
            }
            return 3;
        }
    }
}

