/*
 * Decompiled with CFR 0.152.
 */
package amira;

import amira.AmiraParameters;
import amira.AmiraTable;
import com.jcraft.jzlib.ZInputStream;
import ij.IJ;
import ij.ImageStack;
import java.awt.image.ColorModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AmiraMeshDecoder {
    private int width;
    private int height;
    private int numSlices;
    private int mode;
    public final int RAW = 0;
    public final int RLE = 1;
    public final int ZLIB = 2;
    public final int ASCII = 3;
    public AmiraParameters parameters;
    private RandomAccessFile file;
    private long endOffsetOfPreamble;
    private String line;
    private byte[] rleOverrun;
    private int rleOverrunLength;
    private ZInputStream zStream;
    private int zLength;
    private String fileName;
    private String[] colFormat;
    private String[] colName;

    public void AmiraMeshDecoder() {
        this.numSlices = -1;
        this.height = -1;
        this.width = -1;
        this.endOffsetOfPreamble = -1L;
        this.rleOverrunLength = 0;
    }

    public boolean open(String string) {
        try {
            Matcher matcher;
            Pattern pattern;
            Object object;
            block11: {
                File file = new File(string);
                this.file = new RandomAccessFile(file, "r");
                this.fileName = file.getName();
                Pattern pattern2 = Pattern.compile("define Lattice ([0-9]+) ([0-9]+) ([0-9]+).*");
                boolean bl = true;
                Pattern pattern3 = Pattern.compile("^\\s*#.*AmiraMesh.*$");
                do {
                    if (!this.readPreambleLine()) {
                        return false;
                    }
                    if (bl) {
                        object = pattern3.matcher(this.line);
                        if (!((Matcher)object).matches()) {
                            throw new Exception("This doesn't look like an AmiraMesh file; the first line must be a comment containing the text 'AmiraMesh'.");
                        }
                        bl = false;
                    }
                    if (!((Matcher)(object = pattern2.matcher(this.line))).matches()) continue;
                    this.width = Integer.decode(((Matcher)object).group(1));
                    this.height = Integer.decode(((Matcher)object).group(2));
                    this.numSlices = Integer.decode(((Matcher)object).group(3));
                    break block11;
                } while (!this.line.startsWith("# AmiraMesh 3D ASCII"));
                this.mode = 3;
            }
            while (this.readPreambleLine() && (this.line.length() < 11 || !this.line.substring(0, 10).equals("Parameters"))) {
            }
            object = this.line;
            while (this.readPreambleLine()) {
                object = (String)object + this.line + "\n";
            }
            this.parameters = new AmiraParameters((String)object);
            if (this.mode == 3) {
                this.parseColumns((String)object);
            }
            if ((pattern = Pattern.compile(".*HxByteRLE.*", 40)).matcher((CharSequence)object).matches()) {
                this.mode = 1;
            }
            if ((matcher = Pattern.compile(".*HxZip,([0-9]+).*", 40).matcher((CharSequence)object)).matches()) {
                this.mode = 2;
                this.zLength = Integer.parseInt(matcher.group(1));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            IJ.error((String)exception.toString());
            return false;
        }
        return true;
    }

    private boolean readPreambleLine() {
        if (this.file == null || this.endOffsetOfPreamble > 0L) {
            return false;
        }
        if (!this.readLine()) {
            return false;
        }
        if (this.line != "" && this.line.charAt(0) == '@') {
            try {
                this.endOffsetOfPreamble = this.file.getFilePointer();
            }
            catch (Exception exception) {
                IJ.error((String)("error: " + exception.toString()));
            }
            return false;
        }
        return true;
    }

    private boolean readLine() {
        this.line = "";
        try {
            int n;
            while ((n = this.file.read()) >= 0 && n != 13 && n != 10) {
                this.line = this.line + String.valueOf((char)n);
            }
            while ((n = this.file.read()) >= 0 && n == 13 && n == 10) {
            }
            this.file.seek(this.file.getFilePointer() - 1L);
        }
        catch (Exception exception) {
            IJ.error((String)("error: " + exception.toString()));
            return false;
        }
        return true;
    }

    private void parseColumns(String string) {
        int n = string.lastIndexOf(64) + 1;
        int n2 = n + 1;
        while (Character.isDigit(string.charAt(n2))) {
            ++n2;
        }
        int n3 = Integer.parseInt(string.substring(n, n2));
        this.colFormat = new String[n3];
        this.colName = new String[n3];
        for (int i = n3; i > 0; --i) {
            n2 = string.lastIndexOf(10, n);
            int n4 = string.indexOf(123, n2);
            while (string.charAt(n4 - 1) == ' ') {
                --n4;
            }
            this.colName[i - 1] = string.substring(n2 + 1, n4);
            ++n4;
            while (string.charAt(n4) == ' ' || string.charAt(n4) == '{') {
                ++n4;
            }
            int n5 = string.indexOf(32, n4);
            this.colFormat[i - 1] = string.substring(n4, n5);
            n = string.lastIndexOf(64, n2);
        }
    }

    public int readRLE(byte[] byArray, int n, int n2) throws IOException {
        if (this.rleOverrun == null) {
            this.rleOverrun = new byte[256];
        }
        if (this.rleOverrunLength > 0) {
            int n3;
            for (n3 = 0; n2 > 0 && n3 < this.rleOverrunLength; --n2, ++n3) {
                byArray[n] = this.rleOverrun[n3];
                ++n;
            }
            if (n3 < this.rleOverrunLength) {
                int n4 = 0;
                while (n3 + n4 < this.rleOverrunLength) {
                    this.rleOverrun[n4] = this.rleOverrun[n3 + n4];
                    ++n4;
                }
                this.rleOverrunLength -= n3;
            }
            this.rleOverrunLength = 0;
            return n3;
        }
        this.file.read(this.rleOverrun, 0, 1);
        if (this.rleOverrun[0] == 0) {
            IJ.log((String)("byte at offset " + this.file.getFilePointer() + " is 0!"));
            throw new IOException("unexpected zero");
        }
        if (this.rleOverrun[0] < 0) {
            this.rleOverrun[0] = (byte)(this.rleOverrun[0] & 0x7F);
            if (this.rleOverrun[0] > n2) {
                this.file.read(byArray, n, n2);
                this.rleOverrunLength = this.rleOverrun[0] - n2;
                this.file.read(this.rleOverrun, 0, this.rleOverrunLength);
                return n2;
            }
            this.file.read(byArray, n, this.rleOverrun[0]);
            return this.rleOverrun[0];
        }
        this.file.read(byArray, n, 1);
        if (this.rleOverrun[0] > n2) {
            int n5;
            for (n5 = 1; n5 < n2; ++n5) {
                byArray[n + n5] = byArray[n];
            }
            this.rleOverrunLength = this.rleOverrun[0] - n2;
            for (n5 = 0; n5 < this.rleOverrunLength; ++n5) {
                this.rleOverrun[n5] = byArray[n];
            }
            return n2;
        }
        for (int i = 1; i < this.rleOverrun[0]; ++i) {
            byArray[n + i] = byArray[n];
        }
        return this.rleOverrun[0];
    }

    public int readZlib(byte[] byArray, int n, int n2) throws IOException {
        if (this.zStream == null) {
            this.zStream = new ZInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.file.getFD())));
        }
        return this.zStream.read(byArray, n, n2);
    }

    public ImageStack getStack() {
        if (this.file == null || this.endOffsetOfPreamble < 0L) {
            return null;
        }
        ColorModel colorModel = this.parameters.getColorModel();
        ImageStack imageStack = colorModel == null ? new ImageStack(this.width, this.height) : new ImageStack(this.width, this.height, colorModel);
        try {
            this.file.seek(this.endOffsetOfPreamble);
            for (int i = 0; i < this.numSlices; ++i) {
                int n;
                int n2;
                int n3;
                byte[] byArray = new byte[this.width * this.height];
                if (this.mode == 1) {
                    n3 = 0;
                    for (n = this.width * this.height; (n2 = this.readRLE(byArray, n3, n)) < n; n -= n2) {
                        n3 += n2;
                    }
                } else if (this.mode == 2) {
                    n3 = 0;
                    for (n = this.width * this.height; (n2 = this.readZlib(byArray, n3, n)) < n && n2 >= 0; n -= n2) {
                        n3 += n2;
                    }
                } else {
                    this.file.read(byArray, 0, this.width * this.height);
                }
                imageStack.addSlice(null, (Object)byArray);
                IJ.showProgress((int)(i + 1), (int)this.numSlices);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            IJ.error((String)("internal: " + exception.toString()));
        }
        return imageStack;
    }

    public boolean isTable() {
        return this.mode == 3;
    }

    public AmiraTable getTable() {
        try {
            int n;
            int n2 = Integer.parseInt(this.parameters.getProperty("numRows"));
            this.file.seek(this.endOffsetOfPreamble);
            String[] stringArray = new String[n2];
            int n3 = this.colName.length;
            for (int i = 0; i < n3; ++i) {
                for (n = 0; n < n2; ++n) {
                    String string;
                    if (this.colFormat[i].equals("byte")) {
                        int n4;
                        string = "";
                        while (this.readLine() && (n4 = Integer.parseInt(this.line.trim())) != 0) {
                            string = string + Character.toString((char)n4);
                        }
                    } else {
                        this.readLine();
                        string = this.line;
                    }
                    if (i == 0) {
                        stringArray[n] = string;
                        continue;
                    }
                    int n5 = n;
                    stringArray[n5] = stringArray[n5] + "\t" + string;
                }
                while (i < this.colName.length - 1 && this.readLine() && (this.line == "" || this.line.charAt(0) != '@')) {
                }
            }
            String string = this.colName[0];
            for (n = 1; n < this.colName.length; ++n) {
                string = string + "\t" + this.colName[n];
            }
            String string2 = stringArray.length > 0 ? stringArray[0] : "";
            for (int i = 1; i < n2; ++i) {
                string2 = string2 + "\n" + stringArray[i];
            }
            AmiraTable amiraTable = new AmiraTable(this.fileName, string, string2);
            this.parameters.setParameters(amiraTable.properties);
            return amiraTable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("internal: ", exception);
        }
    }
}

