/*
 * Decompiled with CFR 0.152.
 */
package amira;

import amira.AmiraParameters;
import com.jcraft.jzlib.ZOutputStream;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class AmiraMeshEncoder {
    private int width;
    private int height;
    private int numSlices;
    private int mode;
    public final int RAW = 0;
    public final int RLE = 1;
    public final int ZLIB = 2;
    private Hashtable parameters;
    private Vector materials;
    private String path;
    private RandomAccessFile file;
    private long offsetOfStreamLength;
    private String line;
    private byte[] rleOverrun;
    private int rleOverrunLength;
    private ZOutputStream zStream;
    private int zLength;

    public AmiraMeshEncoder(String string) {
        this.path = string;
        this.numSlices = -1;
        this.height = -1;
        this.width = -1;
        this.offsetOfStreamLength = 0L;
        this.rleOverrunLength = 0;
        this.mode = 2;
    }

    public boolean open() {
        try {
            this.file = new RandomAccessFile(this.path, "rw");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return true;
    }

    public boolean writeHeader(ImagePlus imagePlus) {
        try {
            AmiraParameters amiraParameters = new AmiraParameters(imagePlus);
            if (AmiraParameters.isAmiraLabelfield(imagePlus)) {
                this.mode = 1;
            }
            Date date = new Date();
            this.file.writeBytes("# AmiraMesh 3D BINARY 2.0\n# CreationDate: " + date.toString() + "\n" + "\n" + "define Lattice " + this.width + " " + this.height + " " + this.numSlices + "\n" + "\n" + "Parameters {\n" + amiraParameters.toString() + "}\n" + "\n" + "Lattice { byte " + (this.mode == 1 ? "Labels" : "Data") + " } @1");
            if (this.mode == 1) {
                this.file.writeBytes("(HxByteRLE,");
                this.offsetOfStreamLength = this.file.getFilePointer();
                this.file.writeBytes("          ");
            } else if (this.mode == 2) {
                this.file.writeBytes("(HxZip,");
                this.offsetOfStreamLength = this.file.getFilePointer();
                this.file.writeBytes("          ");
            }
            this.file.writeBytes("\n\n# Data section follows\n@1\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
        return true;
    }

    public boolean write(ImagePlus imagePlus) {
        IJ.showStatus((String)("Writing " + this.path + " (AmiraMesh) ..."));
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
        this.numSlices = imagePlus.getStackSize();
        if (!this.writeHeader(imagePlus)) {
            return false;
        }
        try {
            long l = this.file.getFilePointer();
            ImageStack imageStack = imagePlus.getStack();
            for (int i = 1; i <= this.numSlices; ++i) {
                ByteProcessor byteProcessor = (ByteProcessor)imageStack.getProcessor(i);
                byte[] byArray = (byte[])byteProcessor.getPixels();
                if (this.mode == 1) {
                    this.writeRLE(byArray);
                } else if (this.mode == 2) {
                    this.writeZlib(byArray);
                } else {
                    this.file.write(byArray);
                }
                IJ.showProgress((int)i, (int)this.numSlices);
            }
            if (this.mode == 2) {
                this.zStream.finish();
            }
            long l2 = this.file.getFilePointer();
            this.file.setLength(l2);
            if (this.mode == 1 || this.mode == 2) {
                long l3 = l2 - l;
                this.file.seek(this.offsetOfStreamLength);
                this.file.writeBytes("" + l3 + ")\n");
                this.file.seek(l2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.toString());
        }
        IJ.showStatus((String)"");
        return true;
    }

    public void writeRLE(byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            int n2;
            if (n + 1 >= byArray.length) {
                this.file.writeByte(1);
                this.file.writeByte(byArray[n]);
                ++n;
                continue;
            }
            if (byArray[n] == byArray[n + 1]) {
                for (n2 = 2; n2 < 127 && n2 + n + 1 < byArray.length && byArray[n] == byArray[n + n2]; ++n2) {
                }
                this.file.writeByte(n2);
                this.file.writeByte(byArray[n]);
                n += n2;
                continue;
            }
            for (n2 = 1; n2 < 127 && n2 + n + 1 < byArray.length && byArray[n + n2] != byArray[n + n2 + 1]; ++n2) {
            }
            this.file.writeByte(n2 | 0x80);
            this.file.write(byArray, n, n2);
            n += n2;
        }
    }

    public void writeZlib(byte[] byArray) throws IOException {
        if (this.zStream == null) {
            this.zStream = new ZOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.file.getFD())), 9);
        }
        this.zStream.write(byArray, 0, byArray.length);
    }
}

