/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CustomMesh
extends Shape3D {
    public static final Color3f DEFAULT_COLOR = new Color3f(0.0f, 1.0f, 0.0f);
    protected Color3f color = DEFAULT_COLOR;
    protected List<Point3f> mesh = null;
    protected float transparency = 0.0f;
    protected boolean shaded = true;

    protected CustomMesh() {
    }

    protected CustomMesh(List<Point3f> list) {
        this(list, DEFAULT_COLOR, 0.0f);
    }

    protected CustomMesh(List<Point3f> list, Color3f color3f, float f) {
        this.mesh = list;
        if (color3f != null) {
            this.color = color3f;
        }
        this.transparency = f;
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
        this.update();
    }

    protected void update() {
        if (this.mesh != null) {
            this.setGeometry(this.createGeometry());
            this.setAppearance(this.createAppearance());
        }
    }

    public List getMesh() {
        return this.mesh;
    }

    public Color3f getColor() {
        return this.color;
    }

    public float getTransparency() {
        return this.transparency;
    }

    public boolean isShaded() {
        return this.shaded;
    }

    public void setShaded(boolean bl) {
        this.shaded = bl;
        PolygonAttributes polygonAttributes = this.getAppearance().getPolygonAttributes();
        if (bl) {
            polygonAttributes.setPolygonMode(2);
        } else {
            polygonAttributes.setPolygonMode(1);
        }
    }

    public void calculateMinMaxCenterPoint(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        if (this.mesh == null) {
            return;
        }
        point3f.z = Float.MAX_VALUE;
        point3f.y = Float.MAX_VALUE;
        point3f.x = Float.MAX_VALUE;
        point3f2.z = Float.MIN_VALUE;
        point3f2.y = Float.MIN_VALUE;
        point3f2.x = Float.MIN_VALUE;
        for (int i = 0; i < this.mesh.size(); ++i) {
            Point3f point3f4 = this.mesh.get(i);
            if (point3f4.x < point3f.x) {
                point3f.x = point3f4.x;
            }
            if (point3f4.y < point3f.y) {
                point3f.y = point3f4.y;
            }
            if (point3f4.z < point3f.z) {
                point3f.z = point3f4.z;
            }
            if (point3f4.x > point3f2.x) {
                point3f2.x = point3f4.x;
            }
            if (point3f4.y > point3f2.y) {
                point3f2.y = point3f4.y;
            }
            if (!(point3f4.z > point3f2.z)) continue;
            point3f2.z = point3f4.z;
        }
        point3f3.x = (point3f2.x + point3f.x) / 2.0f;
        point3f3.y = (point3f2.y + point3f.y) / 2.0f;
        point3f3.z = (point3f2.z + point3f.z) / 2.0f;
    }

    public abstract float getVolume();

    public void setColor(Color3f color3f) {
        this.color = color3f != null ? color3f : DEFAULT_COLOR;
        int n = ((GeometryArray)this.getGeometry()).getVertexCount();
        Color3f[] color3fArray = new Color3f[n];
        for (int i = 0; i < n; ++i) {
            color3fArray[i] = this.color;
        }
        ((GeometryArray)this.getGeometry()).setColors(0, color3fArray);
    }

    public void setTransparency(float f) {
        TransparencyAttributes transparencyAttributes = this.getAppearance().getTransparencyAttributes();
        if (f <= 0.01f) {
            this.transparency = 0.0f;
            transparencyAttributes.setTransparencyMode(4);
        } else {
            this.transparency = f;
            transparencyAttributes.setTransparencyMode(0);
        }
        transparencyAttributes.setTransparency(this.transparency);
    }

    protected Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setCapability(10);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCapability(3);
        polygonAttributes.setPolygonMode(2);
        polygonAttributes.setCullFace(0);
        polygonAttributes.setBackFaceNormalFlip(true);
        appearance.setPolygonAttributes(polygonAttributes);
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setShadeModel(3);
        coloringAttributes.setColor(this.color);
        appearance.setColoringAttributes(coloringAttributes);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        int n = this.transparency == 0.0f ? 4 : 0;
        transparencyAttributes.setCapability(3);
        transparencyAttributes.setCapability(1);
        transparencyAttributes.setTransparencyMode(n);
        transparencyAttributes.setTransparency(this.transparency);
        appearance.setTransparencyAttributes(transparencyAttributes);
        Material material = new Material();
        material.setCapability(1);
        material.setAmbientColor(0.1f, 0.1f, 0.1f);
        material.setSpecularColor(0.1f, 0.1f, 0.1f);
        material.setDiffuseColor(0.1f, 0.1f, 0.1f);
        appearance.setMaterial(material);
        return appearance;
    }

    protected abstract Geometry createGeometry();
}

