/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.CustomMesh;
import ij3d.Content;
import ij3d.ContentNode;
import javax.media.j3d.Node;
import javax.media.j3d.View;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;

public class CustomMeshNode
extends ContentNode {
    private CustomMesh mesh;
    private Content content;
    private Point3f min;
    private Point3f max;
    private Point3f center;

    public CustomMeshNode(CustomMesh customMesh, Content content) {
        this.mesh = customMesh;
        this.content = content;
        this.calculateMinMaxCenterPoint();
        this.addChild((Node)customMesh);
    }

    public CustomMesh getMesh() {
        return this.mesh;
    }

    public void getMin(Tuple3d tuple3d) {
        tuple3d.set((Tuple3f)this.min);
    }

    public void getMax(Tuple3d tuple3d) {
        tuple3d.set((Tuple3f)this.max);
    }

    public void getCenter(Tuple3d tuple3d) {
        tuple3d.set((Tuple3f)this.center);
    }

    public void channelsUpdated() {
    }

    public void colorUpdated() {
        this.mesh.setColor(this.content.getColor());
    }

    public void eyePtChanged(View view) {
    }

    public float getVolume() {
        return this.mesh.getVolume();
    }

    public void shadeUpdated() {
        this.mesh.setShaded(this.content.isShaded());
    }

    public void thresholdUpdated() {
    }

    public void transparencyUpdated() {
        this.mesh.setTransparency(this.content.getTransparency());
    }

    private void calculateMinMaxCenterPoint() {
        this.min = new Point3f();
        this.max = new Point3f();
        this.center = new Point3f();
        this.mesh.calculateMinMaxCenterPoint(this.min, this.max, this.center);
    }
}

