/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import customnode.CustomLineMesh;
import customnode.CustomMesh;
import customnode.CustomPointMesh;
import customnode.CustomQuadMesh;
import customnode.CustomTriangleMesh;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshLoader {
    public static Map<String, CustomMesh> load(String string) {
        ObjectFile objectFile = new ObjectFile();
        Scene scene = null;
        try {
            scene = objectFile.load(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Could not find " + string);
            return null;
        }
        TreeMap<String, CustomMesh> treeMap = new TreeMap<String, CustomMesh>();
        BranchGroup branchGroup = scene.getSceneGroup();
        int n = branchGroup.numChildren();
        for (int i = 0; i < n; ++i) {
            Node node = branchGroup.getChild(i);
            if (!(node instanceof Shape3D)) continue;
            Shape3D shape3D = (Shape3D)node;
            Geometry geometry = shape3D.getGeometry();
            if (!(geometry instanceof GeometryArray)) {
                System.out.println("Skipping node " + i + ", since " + "geometry is not a GeometryArray.");
                continue;
            }
            GeometryArray geometryArray = (GeometryArray)geometry;
            int n2 = geometryArray.getVertexFormat();
            if ((n2 & 0x100) == 0) {
                System.out.println("Skipping node " + i + ", since " + "geometry data is not in interleaved format.");
                continue;
            }
            String string2 = shape3D.getName();
            if (null == string2) {
                string2 = "Mesh-" + (1 + treeMap.size());
            }
            if (geometryArray instanceof TriangleArray) {
                treeMap.put(string2, new CustomTriangleMesh(MeshLoader.readCoordinatesFromInterleaved(geometryArray)));
                continue;
            }
            if (geometryArray instanceof QuadArray) {
                treeMap.put(string2, new CustomQuadMesh(MeshLoader.readCoordinatesFromInterleaved(geometryArray)));
                continue;
            }
            if (geometryArray instanceof PointArray) {
                treeMap.put(string2, new CustomPointMesh(MeshLoader.readCoordinatesFromInterleaved(geometryArray)));
                continue;
            }
            if (geometryArray instanceof LineArray) {
                treeMap.put(string2, new CustomLineMesh(MeshLoader.readCoordinatesFromInterleaved(geometryArray), 0));
                continue;
            }
            System.out.println("Skipping node " + i + ", since " + "geometry data is not one of TriangleArray, " + "QuadArray, PointArray or LineArray.");
        }
        return treeMap;
    }

    private static List<Point3f> readCoordinatesFromInterleaved(GeometryArray geometryArray) {
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        int n = geometryArray.getValidVertexCount();
        float[] fArray = geometryArray.getInterleavedVertices();
        int n2 = fArray.length / n;
        for (int i = 0; i < n; ++i) {
            int n3 = i * n2;
            arrayList.add(new Point3f(fArray[n3], fArray[n3 + 1], fArray[n3 + 2]));
        }
        return arrayList;
    }
}

