/*
 * Decompiled with CFR 0.152.
 */
package delaunay;

import delaunay.Pnt;
import delaunay.Simplex;
import delaunay.Triangulation;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class DelaunayTriangulation
extends Triangulation {
    private Simplex mostRecent = null;
    public boolean debug = false;

    public DelaunayTriangulation(Simplex simplex) {
        super(simplex);
        this.mostRecent = simplex;
    }

    public Simplex locate(Pnt pnt) {
        Object object;
        Simplex simplex = this.mostRecent;
        if (!this.contains(simplex)) {
            simplex = null;
        }
        HashSet<Simplex> hashSet = new HashSet<Simplex>();
        while (simplex != null) {
            if (hashSet.contains(simplex)) {
                System.out.println("Warning: Caught in a locate loop");
                break;
            }
            hashSet.add(simplex);
            object = pnt.isOutside(simplex.toArray(new Pnt[0]));
            if (object == null) {
                return simplex;
            }
            simplex = this.neighborOpposite(object, simplex);
        }
        System.out.println("Warning: Checking all triangles for " + pnt);
        object = this.iterator();
        while (object.hasNext()) {
            Simplex simplex2 = (Simplex)object.next();
            if (pnt.isOutside(simplex2.toArray(new Pnt[0])) != null) continue;
            return simplex2;
        }
        System.out.println("Warning: No triangle holds " + pnt);
        return null;
    }

    public Set delaunayPlace(Pnt pnt) {
        Simplex simplex;
        HashSet<Simplex> hashSet = new HashSet<Simplex>();
        HashSet<Simplex> hashSet2 = new HashSet<Simplex>();
        HashSet<Set> hashSet3 = new HashSet<Set>();
        LinkedList<Set> linkedList = new LinkedList<Set>();
        if (this.debug) {
            System.out.println("Locate");
        }
        if ((simplex = this.locate(pnt)) == null || simplex.contains(pnt)) {
            return hashSet;
        }
        if (this.debug) {
            System.out.println("Cavity");
        }
        linkedList.add(simplex);
        while (!linkedList.isEmpty()) {
            simplex = (Simplex)linkedList.removeFirst();
            if (pnt.vsCircumcircle(simplex.toArray(new Pnt[0])) == 1) continue;
            hashSet2.add(simplex);
            for (Set set : this.neighbors(simplex)) {
                if (hashSet3.contains(set)) continue;
                hashSet3.add(set);
                linkedList.add(set);
            }
        }
        if (this.debug) {
            System.out.println("Create");
        }
        for (Set set : Simplex.boundary(hashSet2)) {
            set.add(pnt);
            hashSet.add(new Simplex(set));
        }
        if (this.debug) {
            System.out.println("Update");
        }
        this.update(hashSet2, hashSet);
        if (!hashSet.isEmpty()) {
            this.mostRecent = (Simplex)hashSet.iterator().next();
        }
        return hashSet;
    }

    public static void main(String[] stringArray) {
        Simplex simplex = new Simplex(new Pnt[]{new Pnt(-10.0, 10.0), new Pnt(10.0, 10.0), new Pnt(0.0, -10.0)});
        System.out.println("Triangle created: " + simplex);
        DelaunayTriangulation delaunayTriangulation = new DelaunayTriangulation(simplex);
        System.out.println("DelaunayTriangulation created: " + delaunayTriangulation);
        delaunayTriangulation.delaunayPlace(new Pnt(0.0, 0.0));
        delaunayTriangulation.delaunayPlace(new Pnt(1.0, 0.0));
        delaunayTriangulation.delaunayPlace(new Pnt(0.0, 1.0));
        System.out.println("After adding 3 points, the DelaunayTriangulation is a " + delaunayTriangulation);
        delaunayTriangulation.printStuff();
    }
}

