/*
 * Decompiled with CFR 0.152.
 */
package delaunay;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Simplex
extends AbstractSet
implements Set {
    private List vertices;
    private long idNumber;
    private static long idGenerator = 0L;
    public static boolean moreInfo = false;

    public Simplex(Collection collection) {
        this.vertices = Collections.unmodifiableList(new ArrayList(collection));
        this.idNumber = idGenerator++;
        HashSet hashSet = new HashSet(this);
        if (hashSet.size() != this.vertices.size()) {
            throw new IllegalArgumentException("Duplicate vertices in Simplex");
        }
    }

    public Simplex(Object[] objectArray) {
        this(Arrays.asList(objectArray));
    }

    public String toString() {
        if (!moreInfo) {
            return "Simplex" + this.idNumber;
        }
        return "Simplex" + this.idNumber + super.toString();
    }

    public int dimension() {
        return this.vertices.size() - 1;
    }

    public boolean isNeighbor(Simplex simplex) {
        HashSet hashSet = new HashSet(this);
        hashSet.removeAll(simplex);
        return this.size() == simplex.size() && hashSet.size() == 1;
    }

    public List facets() {
        LinkedList linkedList = new LinkedList();
        for (Object e : this) {
            HashSet hashSet = new HashSet(this);
            hashSet.remove(e);
            linkedList.add(hashSet);
        }
        return linkedList;
    }

    public static Set boundary(Set set) {
        HashSet<Set> hashSet = new HashSet<Set>();
        for (Simplex simplex : set) {
            for (Set set2 : simplex.facets()) {
                if (hashSet.contains(set2)) {
                    hashSet.remove(set2);
                    continue;
                }
                hashSet.add(set2);
            }
        }
        return hashSet;
    }

    public Iterator iterator() {
        return this.vertices.iterator();
    }

    public int size() {
        return this.vertices.size();
    }

    public int hashCode() {
        return (int)(this.idNumber ^ this.idNumber >>> 32);
    }

    public boolean equals(Object object) {
        return this == object;
    }
}

