/*
 * Decompiled with CFR 0.152.
 */
package distance;

import distance.PixelPairs;

public class Correlation
implements PixelPairs {
    private float sumX;
    private float sumY;
    private float sumXY;
    private float sumXSquared;
    private float sumYSquared;
    private long count;
    private static boolean verbose = false;

    public void reset() {
        this.sumXY = 0.0f;
        this.sumY = 0.0f;
        this.sumX = 0.0f;
        this.sumYSquared = 0.0f;
        this.sumXSquared = 0.0f;
        this.count = 0L;
    }

    public void add(float f, float f2) {
        if (verbose) {
            System.err.println("got " + f + " and " + f2);
        }
        this.sumX += f;
        this.sumY += f2;
        this.sumXY += f * f2;
        this.sumXSquared += f * f;
        this.sumYSquared += f2 * f2;
        ++this.count;
    }

    public float correlation() {
        float f = 0.0f;
        float f2 = this.count * this.count;
        float f3 = this.sumXY / (float)this.count - this.sumX * this.sumY / f2;
        float f4 = this.sumXSquared / (float)this.count - this.sumX * this.sumX / f2;
        float f5 = this.sumYSquared / (float)this.count - this.sumY * this.sumY / f2;
        float f6 = (float)(Math.sqrt(f4) * Math.sqrt(f5));
        if ((double)f6 > 1.0E-8) {
            f = f3 / f6;
        }
        return f;
    }

    public float distance() {
        return 1.0f - this.correlation();
    }
}

