/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.GaussianGenerationCallback;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import math3d.Eigensystem2x2Double;
import math3d.Eigensystem2x2Float;
import math3d.Eigensystem3x3Double;
import math3d.Eigensystem3x3Float;
import math3d.JacobiDouble;
import math3d.JacobiFloat;

public class ComputeCurvatures
implements Runnable {
    private boolean _3D;
    private FloatArray data;
    private double[][] hessianMatrix;
    private float[] eigenValues = new float[3];
    private FloatArray3D[] result3D;
    private FloatArray3D result2D;
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;
    protected ImagePlus imp;
    protected double sigma;
    protected boolean useCalibration;
    protected GaussianGenerationCallback callback;
    private boolean cancelGeneration = false;

    public ComputeCurvatures() {
    }

    public ComputeCurvatures(ImagePlus imagePlus, double d, GaussianGenerationCallback gaussianGenerationCallback, boolean bl) {
        this.imp = imagePlus;
        this.sigma = d;
        this.callback = gaussianGenerationCallback;
        this.useCalibration = bl;
    }

    public void runAsPlugIn(String string) {
        int n;
        int n2;
        FloatArray floatArray;
        ImageStack imageStack;
        this.imp = WindowManager.getCurrentImage();
        if (null == this.imp) {
            IJ.error((String)"No images open.");
            return;
        }
        if (this.imp.getStackSize() > 1) {
            imageStack = this.imp.getStack();
            this._3D = true;
            this.data = this.StackToFloatArray(imageStack);
            if (this.data == null) {
                return;
            }
        } else {
            this._3D = false;
            this.data = this.ImageToFloatArray(this.imp.getProcessor());
            if (this.data == null) {
                return;
            }
        }
        imageStack = this.imp.getCalibration();
        double d = 1.0;
        if (imageStack != null) {
            d = Math.min(imageStack.pixelWidth, Math.min(imageStack.pixelHeight, imageStack.pixelDepth));
        }
        GenericDialog genericDialog = new GenericDialog("Principle curvature computing");
        genericDialog.addMessage("Options:");
        if (this._3D) {
            genericDialog.addCheckbox("Show Eigenvalue 1 (smallest)", true);
            genericDialog.addCheckbox("Show Eigenvalue 2", true);
            genericDialog.addCheckbox("Show Eigenvalue 3 (largest)", true);
            genericDialog.addMessage("");
        }
        genericDialog.addCheckbox("Compute a gaussian convolution", true);
        genericDialog.addMessage("Please define sigma (>= 0.5) for computing.");
        genericDialog.addMessage("(Applies only if you wish to compute the convolution first)");
        genericDialog.addNumericField("Sigma: ", imageStack == null ? 0.5 : d / 2.0, 4);
        genericDialog.addCheckbox("Use calibration information", imageStack != null);
        genericDialog.addCheckbox("Show Gauss Image", false);
        genericDialog.addCheckbox("Order eigenvalues on absolute values", true);
        genericDialog.addCheckbox("Normalize eigenvalues", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        boolean[] blArray = new boolean[3];
        if (this._3D) {
            blArray[0] = genericDialog.getNextBoolean();
            blArray[1] = genericDialog.getNextBoolean();
            blArray[2] = genericDialog.getNextBoolean();
        }
        boolean bl = genericDialog.getNextBoolean();
        this.sigma = genericDialog.getNextNumber();
        this.useCalibration = genericDialog.getNextBoolean();
        boolean bl2 = genericDialog.getNextBoolean();
        boolean bl3 = genericDialog.getNextBoolean();
        boolean bl4 = genericDialog.getNextBoolean();
        if (bl) {
            if (this._3D) {
                this.data = this.computeGaussianFastMirror((FloatArray3D)this.data, (float)this.sigma, (GaussianGenerationCallback)new TrivialProgressDisplayer(), (Calibration)(this.useCalibration ? imageStack : null));
                if (bl2) {
                    this.FloatArrayToStack((FloatArray3D)this.data, "Gauss image", 0.0f, 255.0f).show();
                }
            } else {
                this.data = this.computeGaussianFastMirror((FloatArray2D)this.data, (float)this.sigma, (GaussianGenerationCallback)new TrivialProgressDisplayer(), (Calibration)(this.useCalibration ? imageStack : null));
                if (bl2) {
                    ComputeCurvatures.FloatArrayToImagePlus((FloatArray2D)this.data, "Gauss image", 0.0f, 255.0f).show();
                }
            }
        } else {
            this.sigma = 1.0;
        }
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        if (this.useCalibration && imageStack != null) {
            f = (float)imageStack.pixelWidth;
            f2 = (float)imageStack.pixelHeight;
            f3 = (float)imageStack.pixelDepth;
        }
        if (this._3D) {
            floatArray = (FloatArray3D)this.data;
            this.result3D = new FloatArray3D[3];
            for (n2 = 0; n2 < 3; ++n2) {
                if (!blArray[n2]) continue;
                this.result3D[n2] = new FloatArray3D(floatArray.width, floatArray.height, floatArray.depth);
            }
            IJ.showProgress((double)0.0);
            for (n2 = 1; n2 < floatArray.depth - 1; ++n2) {
                for (n = 1; n < floatArray.height - 1; ++n) {
                    for (int i = 1; i < floatArray.width - 1; ++i) {
                        int n3;
                        if (this.hessianEigenvaluesAtPoint3D(i, n, n2, bl3, this.eigenValues, bl4, false, f, f2, f3)) {
                            for (n3 = 0; n3 < 3; ++n3) {
                                if (!blArray[n3]) continue;
                                this.result3D[n3].set(this.eigenValues[n3], i, n, n2);
                            }
                            if ((double)this.eigenValues[0] < this.min) {
                                this.min = this.eigenValues[0];
                            }
                            if ((double)this.eigenValues[1] < this.min) {
                                this.min = this.eigenValues[1];
                            }
                            if ((double)this.eigenValues[2] < this.min) {
                                this.min = this.eigenValues[2];
                            }
                            if ((double)this.eigenValues[0] > this.max) {
                                this.max = this.eigenValues[0];
                            }
                            if ((double)this.eigenValues[1] > this.max) {
                                this.max = this.eigenValues[1];
                            }
                            if (!((double)this.eigenValues[2] > this.max)) continue;
                            this.max = this.eigenValues[2];
                            continue;
                        }
                        for (n3 = 0; n3 < 3; ++n3) {
                            if (!blArray[n3]) continue;
                            this.result3D[n3].set(0.0f, i, n, n2);
                        }
                        if (0.0 < this.min) {
                            this.min = 0.0;
                        }
                        if (!(0.0 > this.max)) continue;
                        this.max = 0.0;
                    }
                }
                IJ.showProgress((double)((double)n2 / (double)floatArray.depth));
            }
            IJ.showProgress((double)1.0);
        } else {
            floatArray = (FloatArray2D)this.data;
            this.result2D = new FloatArray3D(((FloatArray2D)floatArray).width, ((FloatArray2D)floatArray).height, 2);
            for (n2 = 1; n2 < ((FloatArray2D)floatArray).height - 1; ++n2) {
                for (n = 1; n < ((FloatArray2D)floatArray).width - 1; ++n) {
                    if (this.hessianEigenvaluesAtPoint2D(n, n2, bl3, this.eigenValues, bl4, false, f, f2)) {
                        this.result2D.set(this.eigenValues[0], n, n2, 0);
                        this.result2D.set(this.eigenValues[1], n, n2, 1);
                        if ((double)this.eigenValues[0] < this.min) {
                            this.min = this.eigenValues[0];
                        }
                        if ((double)this.eigenValues[1] < this.min) {
                            this.min = this.eigenValues[1];
                        }
                        if ((double)this.eigenValues[0] > this.max) {
                            this.max = this.eigenValues[0];
                        }
                        if (!((double)this.eigenValues[1] > this.max)) continue;
                        this.max = this.eigenValues[1];
                        continue;
                    }
                    this.result2D.set(0.0f, n, n2, 0);
                    this.result2D.set(0.0f, n, n2, 1);
                    if (0.0 < this.min) {
                        this.min = 0.0;
                    }
                    if (!(0.0 > this.max)) continue;
                    this.max = 0.0;
                }
            }
        }
        if (this._3D) {
            for (int i = 0; i < 3; ++i) {
                if (!blArray[i]) continue;
                this.FloatArrayToStack(this.result3D[i], "Eigenvalues " + (i + 1), (float)this.min, (float)this.max).show();
            }
        } else {
            this.FloatArrayToStack(this.result2D, "Eigenvalues", (float)this.min, (float)this.max).show();
        }
    }

    public void cancelGaussianGeneration() {
        this.cancelGeneration = true;
    }

    public void run() {
        if (this.imp == null) {
            IJ.error((String)"BUG: imp should not be null - are you using the right constructor?");
            return;
        }
        this.setup();
    }

    public void setup() {
        try {
            if (this.imp == null) {
                IJ.error((String)"BUG: imp should not be null - are you using the right constructor?");
                return;
            }
            if (this.callback != null) {
                this.callback.proportionDone(0.0);
            }
            if (this.imp.getStackSize() > 1) {
                ImageStack imageStack = this.imp.getStack();
                this._3D = true;
                this.data = this.StackToFloatArray(imageStack);
                if (this.data == null) {
                    return;
                }
            } else {
                this._3D = false;
                this.data = this.ImageToFloatArray(this.imp.getProcessor());
                if (this.data == null) {
                    return;
                }
            }
            boolean bl = true;
            boolean bl2 = false;
            Calibration calibration = this.imp.getCalibration();
            if (this._3D) {
                this.data = this.computeGaussianFastMirror((FloatArray3D)this.data, (float)this.sigma, this.callback, (Calibration)(this.useCalibration ? calibration : null));
                if (this.data == null) {
                    if (this.callback != null) {
                        this.callback.proportionDone(-1.0);
                    }
                    return;
                }
                if (bl2) {
                    this.FloatArrayToStack((FloatArray3D)this.data, "Gauss image", 0.0f, 255.0f).show();
                }
            } else {
                this.data = this.computeGaussianFastMirror((FloatArray2D)this.data, (float)this.sigma, this.callback, (Calibration)(this.useCalibration ? calibration : null));
                if (this.data == null) {
                    if (this.callback != null) {
                        this.callback.proportionDone(-1.0);
                    }
                    return;
                }
                if (bl2) {
                    ComputeCurvatures.FloatArrayToImagePlus((FloatArray2D)this.data, "Gauss image", 0.0f, 255.0f).show();
                }
            }
            if (this.callback != null) {
                this.callback.proportionDone(1.0);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            long l = this.imp.getWidth() * this.imp.getHeight() * this.imp.getStackSize() * 4 / 0x100000;
            IJ.error((String)("Out of memory when calculating the Gaussian convolution of the image (requires " + l + "MiB"));
            if (this.callback != null) {
                this.callback.proportionDone(-1.0);
            }
            return;
        }
    }

    public boolean hessianEigenvaluesAtPoint2D(int n, int n2, boolean bl, float[] fArray, boolean bl2, boolean bl3, float f, float f2) {
        float f3;
        float[][] fArray2;
        float[] fArray3;
        if (this._3D) {
            IJ.error((String)"hessianEigenvaluesAtPoint2D( x, y, z, ... ) is only for 2D data.");
            return false;
        }
        FloatArray2D floatArray2D = (FloatArray2D)this.data;
        if (bl3) {
            if (n == 0) {
                n = 1;
            }
            if (n == floatArray2D.width - 1) {
                n = floatArray2D.width - 2;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            if (n2 == floatArray2D.height - 1) {
                n2 = floatArray2D.height - 2;
            }
        }
        if ((fArray3 = this.computeEigenValues(fArray2 = this.computeHessianMatrix2DFloat(floatArray2D, n, n2, this.sigma, f, f2))) == null) {
            return false;
        }
        float f4 = fArray3[0];
        float f5 = fArray3[1];
        float f6 = bl ? Math.abs(f4) : f4;
        float f7 = f3 = bl ? Math.abs(f5) : f5;
        if (f6 <= f3) {
            fArray[0] = f4;
            fArray[1] = f5;
        } else {
            fArray[0] = f5;
            fArray[1] = f4;
        }
        if (bl2) {
            float f8 = Math.abs(fArray[1]);
            fArray[0] = fArray[0] / f8;
            fArray[1] = fArray[1] / f8;
        }
        return true;
    }

    public boolean hessianEigenvaluesAtPoint2D(int n, int n2, boolean bl, double[] dArray, boolean bl2, boolean bl3, float f, float f2) {
        double d;
        double[][] dArray2;
        double[] dArray3;
        if (this._3D) {
            IJ.error((String)"hessianEigenvaluesAtPoint2D( x, y, z, ... ) is only for 2D data.");
            return false;
        }
        FloatArray2D floatArray2D = (FloatArray2D)this.data;
        if (bl3) {
            if (n == 0) {
                n = 1;
            }
            if (n == floatArray2D.width - 1) {
                n = floatArray2D.width - 2;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            if (n2 == floatArray2D.height - 1) {
                n2 = floatArray2D.height - 2;
            }
        }
        if ((dArray3 = this.computeEigenValues(dArray2 = this.computeHessianMatrix2DDouble(floatArray2D, n, n2, this.sigma, f, f2))) == null) {
            return false;
        }
        double d2 = dArray3[0];
        double d3 = dArray3[1];
        double d4 = bl ? Math.abs(d2) : d2;
        double d5 = d = bl ? Math.abs(d3) : d3;
        if (d4 <= d) {
            dArray[0] = d2;
            dArray[1] = d3;
        } else {
            dArray[0] = d3;
            dArray[1] = d2;
        }
        if (bl2) {
            double d6 = Math.abs(dArray[1]);
            dArray[0] = dArray[0] / d6;
            dArray[1] = dArray[1] / d6;
        }
        return true;
    }

    public boolean hessianEigenvaluesAtPoint3D(int n, int n2, int n3, boolean bl, float[] fArray, boolean bl2, boolean bl3, float f, float f2, float f3) {
        float f4;
        float[][] fArray2;
        float[] fArray3;
        if (!this._3D) {
            IJ.error((String)"hessianEigenvaluesAtPoint3D( x, y, z, ... ) is only for 3D data.");
            return false;
        }
        FloatArray3D floatArray3D = (FloatArray3D)this.data;
        if (bl3) {
            if (n == 0) {
                n = 1;
            }
            if (n == floatArray3D.width - 1) {
                n = floatArray3D.width - 2;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            if (n2 == floatArray3D.height - 1) {
                n2 = floatArray3D.height - 2;
            }
            if (n3 == 0) {
                n3 = 1;
            }
            if (n3 == floatArray3D.depth - 1) {
                n3 = floatArray3D.depth - 2;
            }
        }
        if ((fArray3 = this.computeEigenValues(fArray2 = this.computeHessianMatrix3DFloat(floatArray3D, n, n2, n3, this.sigma, f, f2, f3))) == null) {
            return false;
        }
        float f5 = fArray3[0];
        float f6 = fArray3[1];
        float f7 = fArray3[2];
        float f8 = bl ? Math.abs(f5) : f5;
        float f9 = bl ? Math.abs(f6) : f6;
        float f10 = f4 = bl ? Math.abs(f7) : f7;
        if (f8 <= f9) {
            if (f9 <= f4) {
                fArray[0] = f5;
                fArray[1] = f6;
                fArray[2] = f7;
            } else if (f8 <= f4) {
                fArray[0] = f5;
                fArray[1] = f7;
                fArray[2] = f6;
            } else {
                fArray[0] = f7;
                fArray[1] = f5;
                fArray[2] = f6;
            }
        } else if (f8 <= f4) {
            fArray[0] = f6;
            fArray[1] = f5;
            fArray[2] = f7;
        } else if (f9 <= f4) {
            fArray[0] = f6;
            fArray[1] = f7;
            fArray[2] = f5;
        } else {
            fArray[0] = f7;
            fArray[1] = f6;
            fArray[2] = f5;
        }
        if (bl2) {
            float f11 = Math.abs(fArray[2]);
            fArray[0] = fArray[0] / f11;
            fArray[1] = fArray[1] / f11;
            fArray[2] = fArray[2] / f11;
        }
        return true;
    }

    public boolean hessianEigenvaluesAtPoint3D(int n, int n2, int n3, boolean bl, double[] dArray, boolean bl2, boolean bl3, float f, float f2, float f3) {
        double d;
        double[][] dArray2;
        double[] dArray3;
        if (!this._3D) {
            IJ.error((String)"hessianEigenvaluesAtPoint3D( x, y, z, ... ) is only for 3D data.");
            return false;
        }
        FloatArray3D floatArray3D = (FloatArray3D)this.data;
        if (bl3) {
            if (n == 0) {
                n = 1;
            }
            if (n == floatArray3D.width - 1) {
                n = floatArray3D.width - 2;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            if (n2 == floatArray3D.height - 1) {
                n2 = floatArray3D.height - 2;
            }
            if (n3 == 0) {
                n3 = 1;
            }
            if (n3 == floatArray3D.depth - 1) {
                n3 = floatArray3D.depth - 2;
            }
        }
        if ((dArray3 = this.computeEigenValues(dArray2 = this.computeHessianMatrix3DDouble(floatArray3D, n, n2, n3, this.sigma, f, f2, f3))) == null) {
            return false;
        }
        double d2 = dArray3[0];
        double d3 = dArray3[1];
        double d4 = dArray3[2];
        double d5 = bl ? Math.abs(d2) : d2;
        double d6 = bl ? Math.abs(d3) : d3;
        double d7 = d = bl ? Math.abs(d4) : d4;
        if (d5 <= d6) {
            if (d6 <= d) {
                dArray[0] = d2;
                dArray[1] = d3;
                dArray[2] = d4;
            } else if (d5 <= d) {
                dArray[0] = d2;
                dArray[1] = d4;
                dArray[2] = d3;
            } else {
                dArray[0] = d4;
                dArray[1] = d2;
                dArray[2] = d3;
            }
        } else if (d5 <= d) {
            dArray[0] = d3;
            dArray[1] = d2;
            dArray[2] = d4;
        } else if (d6 <= d) {
            dArray[0] = d3;
            dArray[1] = d4;
            dArray[2] = d2;
        } else {
            dArray[0] = d4;
            dArray[1] = d3;
            dArray[2] = d2;
        }
        if (bl2) {
            double d8 = Math.abs(dArray[2]);
            dArray[0] = dArray[0] / d8;
            dArray[1] = dArray[1] / d8;
            dArray[2] = dArray[2] / d8;
        }
        return true;
    }

    public static ImagePlus FloatArrayToImagePlus(FloatArray2D floatArray2D, String string, float f, float f2) {
        ImagePlus imagePlus = IJ.createImage((String)string, (String)"32-Bit Black", (int)floatArray2D.width, (int)floatArray2D.height, (int)1);
        FloatProcessor floatProcessor = (FloatProcessor)imagePlus.getProcessor();
        ComputeCurvatures.FloatArrayToFloatProcessor((ImageProcessor)floatProcessor, floatArray2D);
        if (f == f2) {
            floatProcessor.resetMinAndMax();
        } else {
            floatProcessor.setMinAndMax((double)f, (double)f2);
        }
        imagePlus.updateAndDraw();
        return imagePlus;
    }

    public static void FloatArrayToFloatProcessor(ImageProcessor imageProcessor, FloatArray2D floatArray2D) {
        float[] fArray = new float[floatArray2D.width * floatArray2D.height];
        int n = 0;
        for (int i = 0; i < floatArray2D.height; ++i) {
            for (int j = 0; j < floatArray2D.width; ++j) {
                fArray[n] = floatArray2D.data[n++];
            }
        }
        imageProcessor.setPixels((Object)fArray);
        imageProcessor.resetMinAndMax();
    }

    public ImagePlus FloatArrayToStack(FloatArray3D floatArray3D, String string, float f, float f2) {
        int n = floatArray3D.width;
        int n2 = floatArray3D.height;
        int n3 = floatArray3D.depth;
        ImageStack imageStack = new ImageStack(n, n2);
        for (int i = 0; i < n3; ++i) {
            ImagePlus imagePlus = IJ.createImage((String)string, (String)"32-Bit Black", (int)n, (int)n2, (int)1);
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            float[] fArray = new float[n * n2];
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    fArray[k * n + j] = floatArray3D.get(j, k, i);
                }
            }
            imageProcessor.setPixels((Object)fArray);
            if (f == f2) {
                imageProcessor.resetMinAndMax();
            } else {
                imageProcessor.setMinAndMax((double)f, (double)f2);
            }
            imageStack.addSlice("Slice " + i, imageProcessor);
        }
        return new ImagePlus(string, imageStack);
    }

    public double[] computeEigenValues(double[][] dArray) {
        if (dArray.length == 3 && dArray[0].length == 3) {
            Eigensystem3x3Double eigensystem3x3Double = new Eigensystem3x3Double(dArray);
            boolean bl = eigensystem3x3Double.findEvalues();
            return bl ? eigensystem3x3Double.getEvaluesCopy() : null;
        }
        if (dArray.length == 2 && dArray[0].length == 2) {
            Eigensystem2x2Double eigensystem2x2Double = new Eigensystem2x2Double(dArray);
            boolean bl = eigensystem2x2Double.findEvalues();
            return bl ? eigensystem2x2Double.getEvaluesCopy() : null;
        }
        JacobiDouble jacobiDouble = new JacobiDouble(dArray, 50);
        return jacobiDouble.getEigenValues();
    }

    public float[] computeEigenValues(float[][] fArray) {
        if (fArray.length == 3 && fArray[0].length == 3) {
            Eigensystem3x3Float eigensystem3x3Float = new Eigensystem3x3Float(fArray);
            boolean bl = eigensystem3x3Float.findEvalues();
            return bl ? eigensystem3x3Float.getEvaluesCopy() : null;
        }
        if (fArray.length == 2 && fArray[0].length == 2) {
            Eigensystem2x2Float eigensystem2x2Float = new Eigensystem2x2Float(fArray);
            boolean bl = eigensystem2x2Float.findEvalues();
            return bl ? eigensystem2x2Float.getEvaluesCopy() : null;
        }
        JacobiFloat jacobiFloat = new JacobiFloat(fArray, 50);
        return jacobiFloat.getEigenValues();
    }

    public double[][] computeHessianMatrix2DDouble(FloatArray2D floatArray2D, int n, int n2, double d, float f, float f2) {
        if (floatArray2D == null) {
            floatArray2D = (FloatArray2D)this.data;
        }
        double[][] dArray = new double[2][2];
        double d2 = 2.0f * floatArray2D.get(n, n2);
        dArray[0][0] = (double)floatArray2D.get(n + 1, n2) - d2 + (double)floatArray2D.get(n - 1, n2);
        dArray[1][1] = (double)floatArray2D.get(n, n2 + 1) - d2 + (double)floatArray2D.get(n, n2 - 1);
        double d3 = ((floatArray2D.get(n + 1, n2 + 1) - floatArray2D.get(n - 1, n2 + 1)) / 2.0f - (floatArray2D.get(n + 1, n2 - 1) - floatArray2D.get(n - 1, n2 - 1)) / 2.0f) / 2.0f;
        dArray[1][0] = d3;
        dArray[0][1] = d3;
        for (int i = 0; i < 2; ++i) {
            int n3 = 0;
            while (n3 < 2) {
                double[] dArray2 = dArray[i];
                int n4 = n3++;
                dArray2[n4] = dArray2[n4] * (d * d);
            }
        }
        return dArray;
    }

    public float[][] computeHessianMatrix2DFloat(FloatArray2D floatArray2D, int n, int n2, double d, float f, float f2) {
        if (floatArray2D == null) {
            floatArray2D = (FloatArray2D)this.data;
        }
        float[][] fArray = new float[2][2];
        float f3 = 2.0f * floatArray2D.get(n, n2);
        fArray[0][0] = floatArray2D.get(n + 1, n2) - f3 + floatArray2D.get(n - 1, n2);
        fArray[1][1] = floatArray2D.get(n, n2 + 1) - f3 + floatArray2D.get(n, n2 - 1);
        float f4 = ((floatArray2D.get(n + 1, n2 + 1) - floatArray2D.get(n - 1, n2 + 1)) / 2.0f - (floatArray2D.get(n + 1, n2 - 1) - floatArray2D.get(n - 1, n2 - 1)) / 2.0f) / 2.0f;
        fArray[1][0] = f4;
        fArray[0][1] = f4;
        for (int i = 0; i < 2; ++i) {
            int n3 = 0;
            while (n3 < 2) {
                float[] fArray2 = fArray[i];
                int n4 = n3++;
                fArray2[n4] = (float)((double)fArray2[n4] * (d * d));
            }
        }
        return fArray;
    }

    public double[][] computeHessianMatrix3DDouble(FloatArray3D floatArray3D, int n, int n2, int n3, double d, float f, float f2, float f3) {
        if (floatArray3D == null) {
            floatArray3D = (FloatArray3D)this.data;
        }
        double[][] dArray = new double[3][3];
        double d2 = 2.0f * floatArray3D.get(n, n2, n3);
        dArray[0][0] = (double)floatArray3D.get(n + 1, n2, n3) - d2 + (double)floatArray3D.get(n - 1, n2, n3);
        dArray[1][1] = (double)floatArray3D.get(n, n2 + 1, n3) - d2 + (double)floatArray3D.get(n, n2 - 1, n3);
        dArray[2][2] = (double)floatArray3D.get(n, n2, n3 + 1) - d2 + (double)floatArray3D.get(n, n2, n3 - 1);
        double d3 = ((floatArray3D.get(n + 1, n2 + 1, n3) - floatArray3D.get(n - 1, n2 + 1, n3)) / 2.0f - (floatArray3D.get(n + 1, n2 - 1, n3) - floatArray3D.get(n - 1, n2 - 1, n3)) / 2.0f) / 2.0f;
        dArray[1][0] = d3;
        dArray[0][1] = d3;
        double d4 = ((floatArray3D.get(n + 1, n2, n3 + 1) - floatArray3D.get(n - 1, n2, n3 + 1)) / 2.0f - (floatArray3D.get(n + 1, n2, n3 - 1) - floatArray3D.get(n - 1, n2, n3 - 1)) / 2.0f) / 2.0f;
        dArray[2][0] = d4;
        dArray[0][2] = d4;
        double d5 = ((floatArray3D.get(n, n2 + 1, n3 + 1) - floatArray3D.get(n, n2 - 1, n3 + 1)) / 2.0f - (floatArray3D.get(n, n2 + 1, n3 - 1) - floatArray3D.get(n, n2 - 1, n3 - 1)) / 2.0f) / 2.0f;
        dArray[2][1] = d5;
        dArray[1][2] = d5;
        for (int i = 0; i < 3; ++i) {
            int n4 = 0;
            while (n4 < 3) {
                double[] dArray2 = dArray[i];
                int n5 = n4++;
                dArray2[n5] = dArray2[n5] * (d * d);
            }
        }
        return dArray;
    }

    public float[][] computeHessianMatrix3DFloat(FloatArray3D floatArray3D, int n, int n2, int n3, double d, float f, float f2, float f3) {
        if (floatArray3D == null) {
            floatArray3D = (FloatArray3D)this.data;
        }
        float[][] fArray = new float[3][3];
        float f4 = 2.0f * floatArray3D.get(n, n2, n3);
        fArray[0][0] = floatArray3D.get(n + 1, n2, n3) - f4 + floatArray3D.get(n - 1, n2, n3);
        fArray[1][1] = floatArray3D.get(n, n2 + 1, n3) - f4 + floatArray3D.get(n, n2 - 1, n3);
        fArray[2][2] = floatArray3D.get(n, n2, n3 + 1) - f4 + floatArray3D.get(n, n2, n3 - 1);
        float f5 = ((floatArray3D.get(n + 1, n2 + 1, n3) - floatArray3D.get(n - 1, n2 + 1, n3)) / 2.0f - (floatArray3D.get(n + 1, n2 - 1, n3) - floatArray3D.get(n - 1, n2 - 1, n3)) / 2.0f) / 2.0f;
        fArray[1][0] = f5;
        fArray[0][1] = f5;
        float f6 = ((floatArray3D.get(n + 1, n2, n3 + 1) - floatArray3D.get(n - 1, n2, n3 + 1)) / 2.0f - (floatArray3D.get(n + 1, n2, n3 - 1) - floatArray3D.get(n - 1, n2, n3 - 1)) / 2.0f) / 2.0f;
        fArray[2][0] = f6;
        fArray[0][2] = f6;
        float f7 = ((floatArray3D.get(n, n2 + 1, n3 + 1) - floatArray3D.get(n, n2 - 1, n3 + 1)) / 2.0f - (floatArray3D.get(n, n2 + 1, n3 - 1) - floatArray3D.get(n, n2 - 1, n3 - 1)) / 2.0f) / 2.0f;
        fArray[2][1] = f7;
        fArray[1][2] = f7;
        for (int i = 0; i < 3; ++i) {
            int n4 = 0;
            while (n4 < 3) {
                float[] fArray2 = fArray[i];
                int n5 = n4++;
                fArray2[n5] = (float)((double)fArray2[n5] * (d * d));
            }
        }
        return fArray;
    }

    public static float[] createGaussianKernel1D(float f, boolean bl) {
        float[] fArray;
        if (f <= 0.0f) {
            fArray = new float[3];
            fArray[1] = 1.0f;
        } else {
            int n = Math.max(3, 2 * (int)((double)(3.0f * f) + 0.5) + 1);
            float f2 = 2.0f * f * f;
            fArray = new float[n];
            for (int i = n / 2; i >= 0; --i) {
                float f3;
                fArray[n / 2 - i] = f3 = (float)Math.exp(-((float)(i * i)) / f2);
                fArray[n / 2 + i] = f3;
            }
        }
        if (bl) {
            int n;
            float f4 = 0.0f;
            for (n = 0; n < fArray.length; ++n) {
                f4 += fArray[n];
            }
            n = 0;
            while (n < fArray.length) {
                int n2 = n++;
                fArray[n2] = fArray[n2] / f4;
            }
        }
        return fArray;
    }

    public FloatArray2D computeGaussianFastMirror(FloatArray2D floatArray2D, float f, GaussianGenerationCallback gaussianGenerationCallback, Calibration calibration) {
        int n;
        float f2;
        int n2;
        int n3;
        FloatArray2D floatArray2D2 = new FloatArray2D(floatArray2D.width, floatArray2D.height);
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        float f7 = 1.0f;
        float f8 = 1.0f;
        if (calibration != null) {
            f6 = (float)calibration.pixelWidth;
            f7 = (float)calibration.pixelHeight;
            f8 = (float)calibration.pixelDepth;
        }
        float[] fArray = ComputeCurvatures.createGaussianKernel1D(f / f6, true);
        float[] fArray2 = ComputeCurvatures.createGaussianKernel1D(f / f7, true);
        int n4 = fArray.length;
        int n5 = fArray2.length;
        for (n3 = 0; n3 < fArray.length; ++n3) {
            f3 += fArray[n3];
        }
        for (n3 = 0; n3 < fArray2.length; ++n3) {
            f4 += fArray2[n3];
        }
        double d = floatArray2D.width * floatArray2D.height * 2;
        long l = 0L;
        for (n2 = 0; n2 < floatArray2D.width; ++n2) {
            if (this.cancelGeneration) {
                return null;
            }
            for (int i = 0; i < floatArray2D.height; ++i) {
                f2 = 0.0f;
                if (n2 - n4 / 2 >= 0 && n2 + n4 / 2 < floatArray2D.width) {
                    for (n = -n4 / 2; n <= n4 / 2; ++n) {
                        f2 += floatArray2D.get(n2 + n, i) * fArray[n + n4 / 2];
                    }
                } else {
                    for (n = -n4 / 2; n <= n4 / 2; ++n) {
                        f2 += floatArray2D.getMirror(n2 + n, i) * fArray[n + n4 / 2];
                    }
                }
                floatArray2D2.set(f2 / f3, n2, i);
            }
            l += (long)floatArray2D.height;
            if (gaussianGenerationCallback == null) continue;
            gaussianGenerationCallback.proportionDone((double)l / d);
        }
        for (n2 = 0; n2 < floatArray2D.width; ++n2) {
            if (this.cancelGeneration) {
                return null;
            }
            float[] fArray3 = new float[floatArray2D.height];
            for (n = 0; n < floatArray2D.height; ++n) {
                int n6;
                f2 = 0.0f;
                if (n - n5 / 2 >= 0 && n + n5 / 2 < floatArray2D.height) {
                    for (n6 = -n5 / 2; n6 <= n5 / 2; ++n6) {
                        f2 += floatArray2D2.get(n2, n + n6) * fArray2[n6 + n5 / 2];
                    }
                } else {
                    for (n6 = -n5 / 2; n6 <= n5 / 2; ++n6) {
                        f2 += floatArray2D2.getMirror(n2, n + n6) * fArray2[n6 + n5 / 2];
                    }
                }
                fArray3[n] = f2 / f4;
            }
            for (n = 0; n < floatArray2D.height; ++n) {
                floatArray2D2.set(fArray3[n], n2, n);
            }
            l += (long)floatArray2D.height;
            if (gaussianGenerationCallback == null) continue;
            gaussianGenerationCallback.proportionDone((double)l / d);
        }
        if (gaussianGenerationCallback != null) {
            gaussianGenerationCallback.proportionDone(1.0);
        }
        return floatArray2D2;
    }

    public FloatArray3D computeGaussianFastMirror(FloatArray3D floatArray3D, float f, GaussianGenerationCallback gaussianGenerationCallback, Calibration calibration) {
        int n;
        int n2;
        float f2;
        int n3;
        int n4;
        int n5;
        FloatArray3D floatArray3D2 = new FloatArray3D(floatArray3D.width, floatArray3D.height, floatArray3D.depth);
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        float f7 = 1.0f;
        float f8 = 1.0f;
        if (calibration != null) {
            f6 = (float)calibration.pixelWidth;
            f7 = (float)calibration.pixelHeight;
            f8 = (float)calibration.pixelDepth;
        }
        float[] fArray = ComputeCurvatures.createGaussianKernel1D(f / f6, true);
        float[] fArray2 = ComputeCurvatures.createGaussianKernel1D(f / f7, true);
        float[] fArray3 = ComputeCurvatures.createGaussianKernel1D(f / f8, true);
        int n6 = fArray.length;
        int n7 = fArray2.length;
        int n8 = fArray3.length;
        for (n5 = 0; n5 < fArray.length; ++n5) {
            f3 += fArray[n5];
        }
        for (n5 = 0; n5 < fArray2.length; ++n5) {
            f4 += fArray2[n5];
        }
        for (n5 = 0; n5 < fArray3.length; ++n5) {
            f5 += fArray3[n5];
        }
        double d = floatArray3D.width * floatArray3D.height * floatArray3D.depth * 3;
        long l = 0L;
        for (n4 = 0; n4 < floatArray3D.width; ++n4) {
            if (this.cancelGeneration) {
                return null;
            }
            for (n3 = 0; n3 < floatArray3D.height; ++n3) {
                for (int i = 0; i < floatArray3D.depth; ++i) {
                    f2 = 0.0f;
                    if (n4 - n6 / 2 >= 0 && n4 + n6 / 2 < floatArray3D.width) {
                        for (n2 = -n6 / 2; n2 <= n6 / 2; ++n2) {
                            f2 += floatArray3D.get(n4 + n2, n3, i) * fArray[n2 + n6 / 2];
                        }
                    } else {
                        for (n2 = -n6 / 2; n2 <= n6 / 2; ++n2) {
                            f2 += floatArray3D.getMirror(n4 + n2, n3, i) * fArray[n2 + n6 / 2];
                        }
                    }
                    floatArray3D2.set(f2 / f3, n4, n3, i);
                }
            }
            l += (long)(floatArray3D.height * floatArray3D.depth);
            if (gaussianGenerationCallback == null) continue;
            gaussianGenerationCallback.proportionDone((double)l / d);
        }
        for (n4 = 0; n4 < floatArray3D.width; ++n4) {
            if (this.cancelGeneration) {
                return null;
            }
            for (n3 = 0; n3 < floatArray3D.depth; ++n3) {
                float[] fArray4 = new float[floatArray3D.height];
                for (n2 = 0; n2 < floatArray3D.height; ++n2) {
                    f2 = 0.0f;
                    if (n2 - n7 / 2 >= 0 && n2 + n7 / 2 < floatArray3D.height) {
                        for (n = -n7 / 2; n <= n7 / 2; ++n) {
                            f2 += floatArray3D2.get(n4, n2 + n, n3) * fArray2[n + n7 / 2];
                        }
                    } else {
                        for (n = -n7 / 2; n <= n7 / 2; ++n) {
                            f2 += floatArray3D2.getMirror(n4, n2 + n, n3) * fArray2[n + n7 / 2];
                        }
                    }
                    fArray4[n2] = f2 / f4;
                }
                for (n2 = 0; n2 < floatArray3D.height; ++n2) {
                    floatArray3D2.set(fArray4[n2], n4, n2, n3);
                }
            }
            l += (long)(floatArray3D.depth * floatArray3D.height);
            if (gaussianGenerationCallback == null) continue;
            gaussianGenerationCallback.proportionDone((double)l / d);
        }
        for (n4 = 0; n4 < floatArray3D.width; ++n4) {
            if (this.cancelGeneration) {
                return null;
            }
            for (n3 = 0; n3 < floatArray3D.height; ++n3) {
                float[] fArray5 = new float[floatArray3D.depth];
                for (n2 = 0; n2 < floatArray3D.depth; ++n2) {
                    f2 = 0.0f;
                    if (n2 - n8 / 2 >= 0 && n2 + n8 / 2 < floatArray3D.depth) {
                        for (n = -n8 / 2; n <= n8 / 2; ++n) {
                            f2 += floatArray3D2.get(n4, n3, n2 + n) * fArray3[n + n8 / 2];
                        }
                    } else {
                        for (n = -n8 / 2; n <= n8 / 2; ++n) {
                            f2 += floatArray3D2.getMirror(n4, n3, n2 + n) * fArray3[n + n8 / 2];
                        }
                    }
                    fArray5[n2] = f2 / f5;
                }
                for (n2 = 0; n2 < floatArray3D.depth; ++n2) {
                    floatArray3D2.set(fArray5[n2], n4, n3, n2);
                }
            }
            l += (long)(floatArray3D.height * floatArray3D.depth);
            if (gaussianGenerationCallback == null) continue;
            gaussianGenerationCallback.proportionDone((double)l / d);
        }
        if (gaussianGenerationCallback != null) {
            gaussianGenerationCallback.proportionDone(1.0);
        }
        return floatArray3D2;
    }

    public FloatArray3D StackToFloatArray(ImageStack imageStack) {
        Object[] objectArray = imageStack.getImageArray();
        int n = imageStack.getWidth();
        int n2 = imageStack.getHeight();
        int n3 = imageStack.getSize();
        if (objectArray == null || objectArray.length == 0) {
            IJ.error((String)"Image Stack is empty.");
            return null;
        }
        if (objectArray[0] instanceof int[]) {
            IJ.error((String)"RGB images not supported at the moment.");
            return null;
        }
        FloatArray3D floatArray3D = new FloatArray3D(n, n2, n3);
        if (objectArray[0] instanceof byte[]) {
            for (int i = 0; i < n3; ++i) {
                byte[] byArray = (byte[])objectArray[i];
                int n4 = 0;
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        floatArray3D.data[floatArray3D.getPos((int)k, (int)j, (int)i)] = byArray[n4++] & 0xFF;
                    }
                }
            }
        } else if (objectArray[0] instanceof short[]) {
            for (int i = 0; i < n3; ++i) {
                short[] sArray = (short[])objectArray[i];
                int n5 = 0;
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        floatArray3D.data[floatArray3D.getPos((int)k, (int)j, (int)i)] = sArray[n5++] & 0xFFFF;
                    }
                }
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                float[] fArray = (float[])objectArray[i];
                int n6 = 0;
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        floatArray3D.data[floatArray3D.getPos((int)k, (int)j, (int)i)] = fArray[n6++];
                    }
                }
            }
        }
        return floatArray3D;
    }

    public FloatArray2D ImageToFloatArray(ImageProcessor imageProcessor) {
        FloatArray2D floatArray2D;
        Object object = imageProcessor.getPixels();
        int n = 0;
        if (imageProcessor instanceof ByteProcessor) {
            floatArray2D = new FloatArray2D(imageProcessor.getWidth(), imageProcessor.getHeight());
            byte[] byArray = (byte[])object;
            for (int i = 0; i < imageProcessor.getHeight(); ++i) {
                for (int j = 0; j < imageProcessor.getWidth(); ++j) {
                    floatArray2D.data[n] = byArray[n++] & 0xFF;
                }
            }
        } else if (imageProcessor instanceof ShortProcessor) {
            floatArray2D = new FloatArray2D(imageProcessor.getWidth(), imageProcessor.getHeight());
            short[] sArray = (short[])object;
            for (int i = 0; i < imageProcessor.getHeight(); ++i) {
                for (int j = 0; j < imageProcessor.getWidth(); ++j) {
                    floatArray2D.data[n] = sArray[n++] & 0xFFFF;
                }
            }
        } else if (imageProcessor instanceof FloatProcessor) {
            floatArray2D = new FloatArray2D(imageProcessor.getWidth(), imageProcessor.getHeight());
            float[] fArray = (float[])object;
            for (int i = 0; i < imageProcessor.getHeight(); ++i) {
                for (int j = 0; j < imageProcessor.getWidth(); ++j) {
                    floatArray2D.data[n] = fArray[n++];
                }
            }
        } else {
            IJ.error((String)"RGB images not supported");
            floatArray2D = null;
        }
        return floatArray2D;
    }

    public class FloatArray3D
    extends FloatArray {
        public float[] data;
        public int width;
        public int height;
        public int depth;

        public FloatArray3D(float[] fArray, int n, int n2, int n3) {
            this.data = null;
            this.width = 0;
            this.height = 0;
            this.depth = 0;
            this.data = fArray;
            this.width = n;
            this.height = n2;
            this.depth = n3;
        }

        public FloatArray3D(int n, int n2, int n3) {
            this.data = null;
            this.width = 0;
            this.height = 0;
            this.depth = 0;
            this.data = new float[n * n2 * n3];
            this.width = n;
            this.height = n2;
            this.depth = n3;
        }

        public FloatArray3D clone() {
            FloatArray3D floatArray3D = new FloatArray3D(this.width, this.height, this.depth);
            System.arraycopy(this.data, 0, floatArray3D.data, 0, this.data.length);
            return floatArray3D;
        }

        public int getPos(int n, int n2, int n3) {
            return n + this.width * (n2 + n3 * this.height);
        }

        public float get(int n, int n2, int n3) {
            return this.data[this.getPos(n, n2, n3)];
        }

        public float getMirror(int n, int n2, int n3) {
            int n4;
            int n5;
            if (n >= this.width) {
                n = this.width - (n - this.width + 2);
            }
            if (n2 >= this.height) {
                n2 = this.height - (n2 - this.height + 2);
            }
            if (n3 >= this.depth) {
                n3 = this.depth - (n3 - this.depth + 2);
            }
            if (n < 0) {
                n5 = 0;
                n4 = 1;
                while (n < 0) {
                    if ((n5 += n4) == this.width - 1 || n5 == 0) {
                        n4 *= -1;
                    }
                    ++n;
                }
                n = n5;
            }
            if (n2 < 0) {
                n5 = 0;
                n4 = 1;
                while (n2 < 0) {
                    if ((n5 += n4) == this.height - 1 || n5 == 0) {
                        n4 *= -1;
                    }
                    ++n2;
                }
                n2 = n5;
            }
            if (n3 < 0) {
                n5 = 0;
                n4 = 1;
                while (n3 < 0) {
                    if ((n5 += n4) == this.height - 1 || n5 == 0) {
                        n4 *= -1;
                    }
                    ++n3;
                }
                n3 = n5;
            }
            return this.data[this.getPos(n, n2, n3)];
        }

        public void set(float f, int n, int n2, int n3) {
            this.data[this.getPos((int)n, (int)n2, (int)n3)] = f;
        }

        public FloatArray2D getXPlane(int n) {
            FloatArray2D floatArray2D = new FloatArray2D(this.height, this.depth);
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.depth; ++j) {
                    floatArray2D.set(this.get(n, i, j), i, j);
                }
            }
            return floatArray2D;
        }

        public float[][] getXPlane_float(int n) {
            float[][] fArray = new float[this.height][this.depth];
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.depth; ++j) {
                    fArray[i][j] = this.get(n, i, j);
                }
            }
            return fArray;
        }

        public FloatArray2D getYPlane(int n) {
            FloatArray2D floatArray2D = new FloatArray2D(this.width, this.depth);
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.depth; ++j) {
                    floatArray2D.set(this.get(i, n, j), i, j);
                }
            }
            return floatArray2D;
        }

        public float[][] getYPlane_float(int n) {
            float[][] fArray = new float[this.width][this.depth];
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.depth; ++j) {
                    fArray[i][j] = this.get(i, n, j);
                }
            }
            return fArray;
        }

        public FloatArray2D getZPlane(int n) {
            FloatArray2D floatArray2D = new FloatArray2D(this.width, this.height);
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    floatArray2D.set(this.get(i, j, n), i, j);
                }
            }
            return floatArray2D;
        }

        public float[][] getZPlane_float(int n) {
            float[][] fArray = new float[this.width][this.height];
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    fArray[i][j] = this.get(i, j, n);
                }
            }
            return fArray;
        }

        public void setXPlane(FloatArray2D floatArray2D, int n) {
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.depth; ++j) {
                    this.set(floatArray2D.get(i, j), n, i, j);
                }
            }
        }

        public void setXPlane(float[][] fArray, int n) {
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.depth; ++j) {
                    this.set(fArray[i][j], n, i, j);
                }
            }
        }

        public void setYPlane(FloatArray2D floatArray2D, int n) {
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.depth; ++j) {
                    this.set(floatArray2D.get(i, j), i, n, j);
                }
            }
        }

        public void setYPlane(float[][] fArray, int n) {
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.depth; ++j) {
                    this.set(fArray[i][j], i, n, j);
                }
            }
        }

        public void setZPlane(FloatArray2D floatArray2D, int n) {
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    this.set(floatArray2D.get(i, j), i, j, n);
                }
            }
        }

        public void setZPlane(float[][] fArray, int n) {
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    this.set(fArray[i][j], i, j, n);
                }
            }
        }
    }

    public class FloatArray2D
    extends FloatArray {
        public float[] data;
        public int width;
        public int height;

        public FloatArray2D(int n, int n2) {
            this.data = null;
            this.width = 0;
            this.height = 0;
            this.data = new float[n * n2];
            this.width = n;
            this.height = n2;
        }

        public FloatArray2D(float[] fArray, int n, int n2) {
            this.data = null;
            this.width = 0;
            this.height = 0;
            this.data = fArray;
            this.width = n;
            this.height = n2;
        }

        public FloatArray2D clone() {
            FloatArray2D floatArray2D = new FloatArray2D(this.width, this.height);
            System.arraycopy(this.data, 0, floatArray2D.data, 0, this.data.length);
            return floatArray2D;
        }

        public int getPos(int n, int n2) {
            return n + this.width * n2;
        }

        public float get(int n, int n2) {
            return this.data[this.getPos(n, n2)];
        }

        public float getMirror(int n, int n2) {
            int n3;
            int n4;
            if (n >= this.width) {
                n = this.width - (n - this.width + 2);
            }
            if (n2 >= this.height) {
                n2 = this.height - (n2 - this.height + 2);
            }
            if (n < 0) {
                n4 = 0;
                n3 = 1;
                while (n < 0) {
                    if ((n4 += n3) == this.width - 1 || n4 == 0) {
                        n3 *= -1;
                    }
                    ++n;
                }
                n = n4;
            }
            if (n2 < 0) {
                n4 = 0;
                n3 = 1;
                while (n2 < 0) {
                    if ((n4 += n3) == this.height - 1 || n4 == 0) {
                        n3 *= -1;
                    }
                    ++n2;
                }
                n2 = n4;
            }
            return this.data[this.getPos(n, n2)];
        }

        public float getZero(int n, int n2) {
            if (n >= this.width) {
                return 0.0f;
            }
            if (n2 >= this.height) {
                return 0.0f;
            }
            if (n < 0) {
                return 0.0f;
            }
            if (n2 < 0) {
                return 0.0f;
            }
            return this.data[this.getPos(n, n2)];
        }

        public void set(float f, int n, int n2) {
            this.data[this.getPos((int)n, (int)n2)] = f;
        }
    }

    public abstract class FloatArray {
        public float[] data = null;

        public abstract FloatArray clone();
    }

    static class TrivialProgressDisplayer
    implements GaussianGenerationCallback {
        TrivialProgressDisplayer() {
        }

        public void proportionDone(double d) {
            if (d < 0.0) {
                IJ.showProgress((double)1.0);
            } else {
                IJ.showProgress((double)d);
            }
        }
    }
}

