/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.HessianEvalueProcessor;
import features.TubenessProcessor;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Polygon;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import stacks.ThreePaneCrop;
import util.Limits;

public class Sigma_Palette
extends Thread
implements PlugIn {
    double[] sigmaValues;
    int croppedWidth;
    int croppedHeight;
    int croppedDepth;
    SigmaPaletteListener listener;
    ImagePlus paletteImage;
    double max;
    int selectedSigmaIndex = -1;
    int x_min;
    int x_max;
    int y_min;
    int y_max;
    int z_min;
    int z_max;
    HessianEvalueProcessor hep;
    double defaultMax;
    int sigmasAcross;
    int sigmasDown;
    int initial_z;
    ImagePlus image;

    public void setListener(SigmaPaletteListener sigmaPaletteListener) {
        this.listener = sigmaPaletteListener;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double d) {
        this.max = d;
        if (this.paletteImage != null) {
            this.paletteImage.getProcessor().setMinAndMax(0.0, d);
            this.paletteImage.updateAndDraw();
        }
        if (this.listener != null) {
            this.listener.newMaximum(d);
        }
    }

    public int getSelectedSigmaIndex() {
        return this.selectedSigmaIndex;
    }

    public void setSelectedSigmaIndex(int n) {
        this.selectedSigmaIndex = n;
        if (this.listener != null && n >= 0) {
            this.listener.newSigmaSelected(this.sigmaValues[n]);
        }
        this.paletteImage.updateAndDraw();
    }

    public void makePalette(ImagePlus imagePlus, int n, int n2, int n3, int n4, int n5, int n6, HessianEvalueProcessor hessianEvalueProcessor, double[] dArray, double d, int n7, int n8, int n9) {
        this.image = imagePlus;
        this.x_min = n;
        this.x_max = n2;
        this.y_min = n3;
        this.y_max = n4;
        this.z_min = n5;
        this.z_max = n6;
        this.hep = hessianEvalueProcessor;
        this.sigmaValues = dArray;
        this.defaultMax = d;
        this.sigmasAcross = n7;
        this.sigmasDown = n8;
        this.initial_z = n9;
        int n10 = imagePlus.getWidth();
        int n11 = imagePlus.getHeight();
        int n12 = imagePlus.getStackSize();
        this.start();
    }

    public void run() {
        Object object;
        ImagePlus imagePlus = ThreePaneCrop.performCrop(this.image, this.x_min, this.x_max, this.y_min, this.y_max, this.z_min, this.z_max, false);
        this.croppedWidth = this.x_max - this.x_min + 1;
        this.croppedHeight = this.y_max - this.y_min + 1;
        this.croppedDepth = this.z_max - this.z_min + 1;
        if (this.sigmaValues.length > this.sigmasAcross * this.sigmasDown) {
            IJ.error((String)("A " + this.sigmasAcross + "x" + this.sigmasDown + " layout is not large enough for " + this.sigmaValues + " + 1 images"));
            return;
        }
        int n = this.croppedWidth * this.sigmasAcross + (this.sigmasAcross + 1);
        int n2 = this.croppedHeight * this.sigmasDown + (this.sigmasDown + 1);
        ImageStack imageStack = new ImageStack(n, n2);
        for (int i = 0; i < this.croppedDepth; ++i) {
            object = new FloatProcessor(n, n2);
            imageStack.addSlice("", (ImageProcessor)object);
        }
        this.paletteImage = new ImagePlus("Pick Sigma and Maximum", imageStack);
        this.setMax(this.defaultMax);
        PaletteCanvas paletteCanvas = new PaletteCanvas(this.paletteImage, this, this.croppedWidth, this.croppedHeight, this.sigmasAcross, this.sigmasDown);
        object = new PaletteStackWindow(this.paletteImage, paletteCanvas, this, this.defaultMax);
        this.paletteImage.setSlice(this.initial_z - this.z_min + 1);
        for (int i = 0; i < this.sigmaValues.length; ++i) {
            int n3 = i / this.sigmasAcross;
            int n4 = i % this.sigmasAcross;
            int n5 = n4 * (this.croppedWidth + 1) + 1;
            int n6 = n3 * (this.croppedHeight + 1) + 1;
            double d = this.sigmaValues[i];
            this.hep.setSigma(d);
            ImagePlus imagePlus2 = this.hep.generateImage(imagePlus);
            if (!object.manuallyChangedAlready) {
                float[] fArray = Limits.getStackLimits(imagePlus2);
                int n7 = (int)fArray[1];
                object.maxValueScrollbar.setValue(n7);
                ((PaletteStackWindow)((Object)object)).maxChanged(n7);
            }
            this.copyIntoPalette(imagePlus2, this.paletteImage, n5, n6);
            this.paletteImage.updateAndDraw();
        }
    }

    public void copyIntoPalette(ImagePlus imagePlus, ImagePlus imagePlus2, int n, int n2) {
        int n3 = imagePlus2.getWidth();
        int n4 = imagePlus2.getHeight();
        int n5 = imagePlus2.getStackSize();
        if (n5 != imagePlus.getStackSize()) {
            throw new RuntimeException("In copyIntoPalette(), depths don't match");
        }
        int n6 = imagePlus.getWidth();
        int n7 = imagePlus.getHeight();
        float[] fArray = Limits.getStackLimits(imagePlus);
        ImageStack imageStack = imagePlus2.getStack();
        ImageStack imageStack2 = imagePlus.getStack();
        for (int i = 0; i < n5; ++i) {
            float[] fArray2 = (float[])imageStack2.getProcessor(i + 1).getPixels();
            float[] fArray3 = (float[])imageStack.getProcessor(i + 1).getPixels();
            for (int j = 0; j < n7; ++j) {
                int n8 = j * n6;
                System.arraycopy(fArray2, n8, fArray3, (n2 + j) * n3 + n, n6);
            }
        }
    }

    public void run(String string) {
        Roi roi;
        this.image = IJ.getImage();
        if (this.image == null) {
            IJ.error((String)"There is no current image");
            return;
        }
        Calibration calibration = this.image.getCalibration();
        double d = 1.0;
        if (calibration != null) {
            d = Math.min(calibration.pixelWidth, Math.min(calibration.pixelHeight, calibration.pixelDepth));
        }
        if ((roi = this.image.getRoi()) == null) {
            IJ.error((String)"There is no current point selection");
            return;
        }
        if (roi.getType() != 10) {
            IJ.error((String)"You must have a point selection");
            return;
        }
        Polygon polygon = roi.getPolygon();
        if (polygon.npoints != 1) {
            IJ.error((String)"You must have exactly one point selected");
            return;
        }
        ImageProcessor imageProcessor = this.image.getProcessor();
        int n = polygon.xpoints[0];
        int n2 = polygon.ypoints[0];
        int n3 = this.image.getCurrentSlice() - 1;
        int n4 = 40;
        int n5 = n - n4;
        int n6 = n + n4;
        int n7 = n2 - n4;
        int n8 = n2 + n4;
        int n9 = n3 - n4;
        int n10 = n3 + n4;
        int n11 = this.image.getWidth();
        int n12 = this.image.getHeight();
        int n13 = this.image.getStackSize();
        if (n5 < 0) {
            n5 = 0;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n9 < 0) {
            n9 = 0;
        }
        if (n6 >= n11) {
            n6 = n11 - 1;
        }
        if (n8 >= n12) {
            n8 = n12 - 1;
        }
        if (n10 >= n13) {
            n10 = n13 - 1;
        }
        double[] dArray = new double[9];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (double)(i + 1) * d / 2.0;
        }
        this.makePalette(this.image, n5, n6, n7, n8, n9, n10, new TubenessProcessor(true), dArray, 4.0, 3, 3, n3);
    }

    public static class PaletteCanvas
    extends ImageCanvas {
        Sigma_Palette owner;
        int croppedWidth;
        int croppedHeight;
        int sigmasAcross;
        int sigmasDown;
        private int backBufferWidth;
        private int backBufferHeight;
        private Graphics backBufferGraphics;
        private Image backBufferImage;

        protected PaletteCanvas(ImagePlus imagePlus, Sigma_Palette sigma_Palette, int n, int n2, int n3, int n4) {
            super(imagePlus);
            this.owner = sigma_Palette;
            this.croppedWidth = n;
            this.croppedHeight = n2;
            this.sigmasAcross = n3;
            this.sigmasDown = n4;
        }

        int sigmaIndexFromMouseEvent(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            int n4 = this.offScreenX(n2);
            int n5 = this.offScreenY(n3);
            int n6 = n5 / (this.owner.croppedHeight + 1);
            int n7 = n6 * this.sigmasAcross + (n = n4 / (this.owner.croppedWidth + 1));
            if (n7 >= 0 && n7 < this.owner.sigmaValues.length) {
                return n7;
            }
            return -1;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.sigmaIndexFromMouseEvent(mouseEvent);
            if (n >= 0) {
                double d = this.owner.sigmaValues[n];
                IJ.showStatus((String)("\u03c3 = " + d));
            } else {
                IJ.showStatus((String)"No  \u03c3 (unused entry)");
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.owner.getSelectedSigmaIndex();
            int n2 = this.sigmaIndexFromMouseEvent(mouseEvent);
            if (n2 >= 0) {
                if (n2 == n) {
                    this.owner.setSelectedSigmaIndex(-1);
                } else {
                    this.owner.setSelectedSigmaIndex(n2);
                }
            }
        }

        private void resetBackBuffer() {
            if (this.backBufferGraphics != null) {
                this.backBufferGraphics.dispose();
                this.backBufferGraphics = null;
            }
            if (this.backBufferImage != null) {
                this.backBufferImage.flush();
                this.backBufferImage = null;
            }
            this.backBufferWidth = this.getSize().width;
            this.backBufferHeight = this.getSize().height;
            this.backBufferImage = this.createImage(this.backBufferWidth, this.backBufferHeight);
            this.backBufferGraphics = this.backBufferImage.getGraphics();
        }

        public void paint(Graphics graphics) {
            if (this.backBufferWidth != this.getSize().width || this.backBufferHeight != this.getSize().height || this.backBufferImage == null || this.backBufferGraphics == null) {
                this.resetBackBuffer();
            }
            super.paint(this.backBufferGraphics);
            this.drawOverlay(this.backBufferGraphics);
            graphics.drawImage(this.backBufferImage, 0, 0, (ImageObserver)((Object)this));
        }

        protected void drawOverlay(Graphics graphics) {
            int n;
            int n2;
            int n3;
            graphics.setColor(Color.MAGENTA);
            int n4 = this.imp.getWidth();
            int n5 = this.imp.getHeight();
            for (n3 = 0; n3 <= this.sigmasAcross; ++n3) {
                n2 = n3 * (this.croppedWidth + 1);
                n = this.screenX(n2);
                graphics.drawLine(n, this.screenY(0), n, this.screenY(n5 - 1));
            }
            for (n3 = 0; n3 <= this.sigmasDown; ++n3) {
                n2 = n3 * (this.croppedHeight + 1);
                n = this.screenY(n2);
                graphics.drawLine(this.screenX(0), n, this.screenX(n4 - 1), n);
            }
            n3 = this.owner.getSelectedSigmaIndex();
            if (n3 >= 0 && n3 < this.owner.sigmaValues.length) {
                graphics.setColor(Color.GREEN);
                n2 = n3 / this.sigmasAcross;
                n = n3 % this.sigmasAcross;
                int n6 = this.screenX(n * (this.croppedWidth + 1));
                int n7 = this.screenX((n + 1) * (this.croppedWidth + 1));
                int n8 = this.screenY(n2 * (this.croppedHeight + 1));
                int n9 = this.screenY((n2 + 1) * (this.croppedHeight + 1));
                graphics.drawLine(n6, n8, n7, n8);
                graphics.drawLine(n6, n8, n6, n9);
                graphics.drawLine(n6, n9, n7, n9);
                graphics.drawLine(n7, n9, n7, n8);
            }
        }
    }

    public static class PaletteStackWindow
    extends StackWindow {
        Sigma_Palette owner;
        Label label;
        Scrollbar maxValueScrollbar;
        boolean manuallyChangedAlready = false;

        private void addExtraScrollbar(double d) {
            this.label = new Label("");
            this.add(this.label);
            this.updateLabel(d);
            this.maxValueScrollbar = new Scrollbar(0, (int)d, 1, 1, 350);
            this.maxValueScrollbar.addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    PaletteStackWindow.this.manuallyChangedAlready = true;
                    int n = adjustmentEvent.getValue();
                    PaletteStackWindow.this.maxChanged(n);
                }
            });
            this.add(this.maxValueScrollbar);
            this.pack();
        }

        private void updateLabel(double d) {
            int n = (int)Math.round(d);
            this.label.setText("Adjust maximum value: " + n);
        }

        private void maxChanged(double d) {
            this.updateLabel(d);
            if (this.owner != null) {
                this.owner.setMax(d);
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (this.owner != null && this.owner.listener != null) {
                this.owner.listener.sigmaPaletteClosing();
            }
            super.windowClosing(windowEvent);
        }

        public PaletteStackWindow(ImagePlus imagePlus) {
            super(imagePlus);
            this.addExtraScrollbar(80.0);
        }

        public PaletteStackWindow(ImagePlus imagePlus, ImageCanvas imageCanvas, Sigma_Palette sigma_Palette, double d) {
            super(imagePlus, imageCanvas);
            this.owner = sigma_Palette;
            this.addExtraScrollbar(d);
        }
    }

    public static interface SigmaPaletteListener {
        public void newSigmaSelected(double var1);

        public void newMaximum(double var1);

        public void sigmaPaletteClosing();
    }
}

