/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.TubenessProcessor;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;

public class Tubeness_
implements PlugIn {
    static final String PLUGIN_VERSION = "1.2";

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.error((String)"No current image to calculate tubeness of.");
            return;
        }
        Calibration calibration = imagePlus.getCalibration();
        double d = 1.0;
        if (calibration != null) {
            d = Math.min(calibration.pixelWidth, Math.min(calibration.pixelHeight, calibration.pixelDepth));
        }
        GenericDialog genericDialog = new GenericDialog("\"Tubeness\" Filter (version 1.2)");
        genericDialog.addNumericField("Sigma: ", calibration == null ? 1.0 : d, 4);
        genericDialog.addMessage("(The default value for sigma is the minimum voxel separation.)");
        genericDialog.addCheckbox("Use calibration information", calibration != null);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        double d2 = genericDialog.getNextNumber();
        if (d2 <= 0.0) {
            IJ.error((String)"The value of sigma must be positive");
            return;
        }
        boolean bl = genericDialog.getNextBoolean();
        TubenessProcessor tubenessProcessor = new TubenessProcessor(d2, bl);
        ImagePlus imagePlus2 = tubenessProcessor.generateImage(imagePlus);
        imagePlus2.setTitle("tubeness of " + imagePlus.getTitle());
        imagePlus2.show();
    }
}

