/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij3d.ContentNode;
import ij3d.UniverseListener;
import ij3d.UniverseSettings;
import ij3d.pointlist.PointListDialog;
import ij3d.pointlist.PointListPanel;
import ij3d.pointlist.PointListShape;
import ij3d.shapes.BoundingBox;
import ij3d.shapes.CoordinateSystem;
import isosurface.MeshGroup;
import java.util.BitSet;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import orthoslice.OrthoGroup;
import surfaceplot.SurfacePlotGroup;
import vib.PointList;
import voltex.VoltexGroup;

public class Content
extends BranchGroup
implements UniverseListener {
    protected final String name;
    protected Color3f color = null;
    protected ImagePlus image;
    protected boolean[] channels = new boolean[]{true, true, true};
    protected float transparency = 0.0f;
    protected int resamplingF = 1;
    protected int threshold = 0;
    protected boolean shaded = true;
    protected int type = 0;
    private boolean locked = false;
    private boolean visible = true;
    private boolean coordVisible = UniverseSettings.showLocalCoordinateSystemsByDefault;
    private boolean showPL = false;
    protected boolean selected = false;
    private ContentNode contentNode = null;
    private PointListShape plShape = null;
    private PointListDialog plDialog = null;
    private PointListPanel plPanel = null;
    private PointList points;
    private Switch bbSwitch;
    private BitSet whichChild = new BitSet(5);
    protected TransformGroup localRotate;
    protected TransformGroup localTranslate;
    public static final int CO = 0;
    public static final int BB = 1;
    public static final int CS = 2;
    public static final int PL = 3;
    public static final int VOLUME = 0;
    public static final int ORTHO = 1;
    public static final int SURFACE = 2;
    public static final int SURFACE_PLOT2D = 3;
    public static final int CUSTOM = 4;

    public Content(String string) {
        this.name = string;
        this.setCapability(17);
        this.setCapability(1);
        this.localTranslate = new TransformGroup();
        this.localTranslate.setCapability(17);
        this.localTranslate.setCapability(18);
        this.addChild((Node)this.localTranslate);
        this.localRotate = new TransformGroup();
        this.localRotate.setCapability(17);
        this.localRotate.setCapability(18);
        this.localTranslate.addChild((Node)this.localRotate);
        this.bbSwitch = new Switch();
        this.bbSwitch.setWhichChild(-3);
        this.bbSwitch.setCapability(17);
        this.bbSwitch.setCapability(18);
        this.bbSwitch.setCapability(13);
        this.bbSwitch.setCapability(14);
        this.localRotate.addChild((Node)this.bbSwitch);
        this.points = new PointList();
        this.plShape = new PointListShape(this.points);
        this.plShape.setPickable(false);
        this.plPanel = new PointListPanel(string, this.points);
    }

    public void displayAs(int n) {
        if (this.image == null) {
            return;
        }
        switch (n) {
            case 0: {
                this.contentNode = new VoltexGroup(this);
                break;
            }
            case 1: {
                this.contentNode = new OrthoGroup(this);
                break;
            }
            case 2: {
                this.contentNode = new MeshGroup(this);
                break;
            }
            case 3: {
                this.contentNode = new SurfacePlotGroup(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Specified type is neither VOLUME, ORTHO,SURFACE or SURFACEPLOT2D");
            }
        }
        this.display(this.contentNode);
        this.type = n;
    }

    public static int getDefaultThreshold(ImagePlus imagePlus, int n) {
        if (n != 2) {
            return 0;
        }
        ImageStack imageStack = imagePlus.getStack();
        int n2 = imagePlus.getStackSize();
        int[] nArray = imageStack.getProcessor(1).getHistogram();
        for (int i = 1; i < n2; ++i) {
            int[] nArray2 = imageStack.getProcessor(i + 1).getHistogram();
            for (int j = 0; j < nArray.length; ++j) {
                int n3 = j;
                nArray[n3] = nArray[n3] + nArray2[j];
            }
        }
        return imagePlus.getProcessor().getAutoThreshold(nArray);
    }

    public static int getDefaultResamplingFactor(ImagePlus imagePlus, int n) {
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = imagePlus.getStackSize();
        int n5 = Math.max(n2, Math.max(n3, n4));
        switch (n) {
            case 2: {
                return (int)Math.ceil((float)n5 / 128.0f);
            }
            case 0: {
                return (int)Math.ceil((float)n5 / 256.0f);
            }
            case 1: {
                return (int)Math.ceil((float)n5 / 256.0f);
            }
            case 3: {
                return (int)Math.ceil((float)n5 / 128.0f);
            }
        }
        return 1;
    }

    public void display(ContentNode contentNode) {
        this.bbSwitch.removeAllChildren();
        this.contentNode = contentNode;
        this.bbSwitch.addChild((Node)this.contentNode);
        Point3d point3d = new Point3d();
        this.contentNode.getMin((Tuple3d)point3d);
        Point3d point3d2 = new Point3d();
        this.contentNode.getMax((Tuple3d)point3d2);
        BoundingBox boundingBox = new BoundingBox(point3d, point3d2);
        boundingBox.setPickable(false);
        this.bbSwitch.addChild((Node)boundingBox);
        float f = (float)Math.abs(point3d2.x - point3d.x) / 5.0f;
        CoordinateSystem coordinateSystem = new CoordinateSystem(f, new Color3f(0.0f, 1.0f, 0.0f));
        coordinateSystem.setPickable(false);
        this.bbSwitch.addChild((Node)coordinateSystem);
        this.bbSwitch.addChild((Node)this.plShape);
        this.whichChild.set(1, this.selected);
        this.whichChild.set(2, this.coordVisible);
        this.whichChild.set(0, this.visible);
        this.whichChild.set(3, this.showPL);
        this.bbSwitch.setChildMask(this.whichChild);
        this.type = 4;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.whichChild.set(0, bl);
        this.whichChild.set(2, bl);
        if (!bl) {
            this.showPointList(false);
        }
        this.bbSwitch.setChildMask(this.whichChild);
    }

    public void showBoundingBox(boolean bl) {
        this.whichChild.set(1, bl);
        this.bbSwitch.setChildMask(this.whichChild);
    }

    public void showCoordinateSystem(boolean bl) {
        this.whichChild.set(2, bl);
        this.bbSwitch.setChildMask(this.whichChild);
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.showBoundingBox(bl);
    }

    public void setPointListDialog(PointListDialog pointListDialog) {
        this.plDialog = pointListDialog;
    }

    public void showPointList(boolean bl) {
        if (this.plShape == null) {
            return;
        }
        this.whichChild.set(3, bl);
        this.showPL = bl;
        this.bbSwitch.setChildMask(this.whichChild);
        if (bl && this.plDialog != null) {
            this.plDialog.addPointList(this.name, this.plPanel);
        } else if (!bl && this.plDialog != null) {
            this.plDialog.removePointList(this.plPanel);
        }
    }

    public void loadPointList() {
        this.points = PointList.load(this.image);
        this.plPanel.setPointList(this.points);
        this.plShape.setPointList(this.points);
    }

    public void savePointList() {
        String string = OpenDialog.getDefaultDirectory();
        String string2 = this.name;
        if (this.image != null) {
            FileInfo fileInfo = this.image.getFileInfo();
            string = fileInfo.directory;
            string2 = fileInfo.fileName;
        }
        this.points.save(string, string2);
    }

    public void addPointListPoint(Point3d point3d) {
        this.points.add(point3d.x, point3d.y, point3d.z);
        if (this.plDialog != null) {
            this.plDialog.update();
        }
    }

    public void setListPointPos(int n, Point3d point3d) {
        this.points.placePoint(this.points.get(n), point3d.x, point3d.y, point3d.z);
    }

    public float getLandmarkPointSize() {
        return this.plShape.getRadius();
    }

    public void setLandmarkPointSize(float f) {
        this.plShape.setRadius(f);
    }

    public PointList getPointList() {
        return this.points;
    }

    public void deletePointListPoint(int n) {
        this.points.remove(n);
        if (this.plDialog != null) {
            this.plDialog.update();
        }
    }

    public void toggleLock() {
        this.locked = !this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public void applyTransform(Transform3D transform3D) {
        Transform3D transform3D2 = new Transform3D();
        this.localTranslate.getTransform(transform3D2);
        Transform3D transform3D3 = new Transform3D();
        this.localRotate.getTransform(transform3D3);
        transform3D2.mul(transform3D3);
        transform3D2.mul(transform3D, transform3D2);
        this.setTransform(transform3D2);
    }

    public void setTransform(Transform3D transform3D) {
        if (this.contentNode == null) {
            return;
        }
        Transform3D transform3D2 = new Transform3D();
        Point3d point3d = new Point3d();
        this.contentNode.getCenter((Tuple3d)point3d);
        Matrix3f matrix3f = new Matrix3f();
        transform3D.getRotationScale(matrix3f);
        transform3D2.setRotationScale(matrix3f);
        Vector3d vector3d = new Vector3d();
        vector3d.x = (double)(-matrix3f.m00) * point3d.x - (double)matrix3f.m01 * point3d.y - (double)matrix3f.m02 * point3d.z + point3d.x;
        vector3d.y = (double)(-matrix3f.m10) * point3d.x - (double)matrix3f.m11 * point3d.y - (double)matrix3f.m12 * point3d.z + point3d.y;
        vector3d.z = (double)(-matrix3f.m20) * point3d.x - (double)matrix3f.m21 * point3d.y - (double)matrix3f.m22 * point3d.z + point3d.z;
        transform3D2.setTranslation(vector3d);
        this.localRotate.setTransform(transform3D2);
        Vector3d vector3d2 = new Vector3d();
        transform3D.get(vector3d2);
        vector3d2.sub((Tuple3d)vector3d);
        transform3D2.set(vector3d2);
        this.localTranslate.setTransform(transform3D2);
    }

    public void setChannels(boolean[] blArray) {
        boolean bl;
        boolean bl2 = bl = blArray[0] != this.channels[0] || blArray[1] != this.channels[1] || blArray[2] != this.channels[2];
        if (!bl) {
            return;
        }
        this.channels = blArray;
        if (this.contentNode != null) {
            this.contentNode.channelsUpdated();
        }
    }

    public void setThreshold(int n) {
        if (n != this.threshold) {
            this.threshold = n;
            if (this.contentNode != null) {
                this.contentNode.thresholdUpdated();
            }
        }
    }

    public void setShaded(boolean bl) {
        if (bl != this.shaded) {
            this.shaded = bl;
            if (this.contentNode != null) {
                this.contentNode.shadeUpdated();
            }
        }
    }

    public boolean isShaded() {
        return this.shaded;
    }

    public void setColor(Color3f color3f) {
        boolean bl;
        boolean bl2 = bl = this.color != null || color3f != null || this.color == null && color3f != null || color3f == null && this.color != null || !this.color.equals((Tuple3f)color3f);
        if (!bl) {
            return;
        }
        this.color = color3f;
        this.plShape.setColor(color3f);
        if (this.contentNode != null) {
            this.contentNode.colorUpdated();
        }
    }

    public synchronized void setTransparency(float f) {
        f = f < 0.0f ? 0.0f : f;
        float f2 = f = f > 1.0f ? 1.0f : f;
        if ((double)Math.abs(f - this.transparency) < 0.01) {
            return;
        }
        this.transparency = f;
        if (this.contentNode != null) {
            this.contentNode.transparencyUpdated();
        }
    }

    public void transformationStarted(View view) {
    }

    public void contentAdded(Content content) {
    }

    public void contentRemoved(Content content) {
        if (this.plDialog != null && this == content) {
            this.plDialog.removePointList(this.plPanel);
        }
    }

    public void canvasResized() {
    }

    public void contentSelected(Content content) {
    }

    public void contentChanged(Content content) {
    }

    public void universeClosed() {
        if (this.plDialog != null) {
            this.plDialog.removePointList(this.plPanel);
        }
    }

    public void transformationUpdated(View view) {
        this.eyePtChanged(view);
    }

    public void transformationFinished(View view) {
        this.eyePtChanged(view);
    }

    public void eyePtChanged(View view) {
        if (this.contentNode != null) {
            this.contentNode.eyePtChanged(view);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public ContentNode getContent() {
        return this.contentNode;
    }

    public ImagePlus getImage() {
        return this.image;
    }

    public boolean[] getChannels() {
        return this.channels;
    }

    public Color3f getColor() {
        return this.color;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public float getTransparency() {
        return this.transparency;
    }

    public int getResamplingFactor() {
        return this.resamplingF;
    }

    public TransformGroup getLocalRotate() {
        return this.localRotate;
    }

    public TransformGroup getLocalTranslate() {
        return this.localTranslate;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean hasCoord() {
        return this.coordVisible;
    }

    public boolean isPLVisible() {
        return this.showPL;
    }
}

