/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import com.sun.j3d.utils.universe.SimpleUniverse;
import ij.ImagePlus;
import ij.gui.Toolbar;
import ij3d.Content;
import ij3d.ImageCanvas3D;
import ij3d.ImageWindow3D;
import ij3d.UniverseListener;
import ij3d.UniverseSettings;
import ij3d.behaviors.BehaviorCallback;
import ij3d.behaviors.ContentTransformer;
import ij3d.behaviors.InteractiveBehavior;
import ij3d.behaviors.InteractiveViewPlatformTransformer;
import ij3d.behaviors.Picker;
import ij3d.behaviors.WaitForNextFrameBehavior;
import ij3d.shapes.CoordinateSystem;
import ij3d.shapes.Scalebar;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;

public abstract class DefaultUniverse
extends SimpleUniverse
implements BehaviorCallback {
    public static final int CENTER_TG = 0;
    public static final int ZOOM_TG = 4;
    public static final int TRANSLATE_TG = 1;
    public static final int ANIMATE_TG = 3;
    public static final int ROTATION_TG = 2;
    public static final int ATTRIBUTE_SCALEBAR = 0;
    public static final int ATTRIBUTE_COORD_SYSTEM = 1;
    protected BranchGroup scene;
    protected Scalebar scalebar;
    protected CoordinateSystem globalCoord;
    protected BoundingSphere bounds;
    protected ImageWindow3D win;
    protected final Point3d globalMin = new Point3d();
    protected final Point3d globalMax = new Point3d();
    protected final Point3d globalCenter = new Point3d();
    protected final InteractiveBehavior mouseBehavior;
    protected final ContentTransformer contentTransformer;
    protected final Picker picker;
    protected final InteractiveViewPlatformTransformer viewTransformer;
    protected final WaitForNextFrameBehavior frameBehavior;
    protected final Switch attributesSwitch;
    private BitSet attributesMask = new BitSet(2);
    private List listeners = new ArrayList();
    private boolean transformed = false;
    protected boolean useToFront = true;

    public abstract Content getSelected();

    public abstract Iterator contents();

    public DefaultUniverse(int n, int n2) {
        super((Canvas3D)new ImageCanvas3D(n, n2), 5);
        this.getViewer().getView().setProjectionPolicy(UniverseSettings.projection);
        this.bounds = new BoundingSphere();
        this.bounds.setRadius(Double.POSITIVE_INFINITY);
        this.scene = new BranchGroup();
        this.scene.setCapability(14);
        this.scene.setCapability(12);
        this.scene.setCapability(13);
        this.attributesSwitch = new Switch();
        this.attributesSwitch.setWhichChild(-3);
        this.attributesSwitch.setCapability(17);
        this.attributesSwitch.setCapability(18);
        this.scene.addChild((Node)this.attributesSwitch);
        this.scalebar = new Scalebar();
        this.attributesSwitch.addChild((Node)this.scalebar);
        this.attributesMask.set(0, UniverseSettings.showScalebar);
        this.globalCoord = new CoordinateSystem(100.0f, new Color3f(1.0f, 0.0f, 0.0f));
        this.attributesSwitch.addChild((Node)this.globalCoord);
        this.attributesMask.set(1, UniverseSettings.showGlobalCoordinateSystem);
        this.attributesSwitch.setChildMask(this.attributesMask);
        BranchGroup branchGroup = new BranchGroup();
        AmbientLight ambientLight = new AmbientLight();
        ambientLight.setInfluencingBounds((Bounds)this.bounds);
        ambientLight.setEnable(false);
        branchGroup.addChild((Node)ambientLight);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setInfluencingBounds((Bounds)this.bounds);
        branchGroup.addChild((Node)directionalLight);
        PointLight pointLight = new PointLight();
        pointLight.setPosition(-2.0f, 0.0f, -3.0f);
        pointLight.setInfluencingBounds((Bounds)this.bounds);
        branchGroup.addChild((Node)pointLight);
        this.getZoomTG().addChild((Node)branchGroup);
        this.viewTransformer = new InteractiveViewPlatformTransformer(this, this);
        this.contentTransformer = new ContentTransformer(this, this);
        this.picker = new Picker(this);
        this.mouseBehavior = new InteractiveBehavior(this);
        this.mouseBehavior.setSchedulingBounds((Bounds)this.bounds);
        this.scene.addChild((Node)this.mouseBehavior);
        this.frameBehavior = new WaitForNextFrameBehavior();
        this.frameBehavior.setSchedulingBounds((Bounds)this.bounds);
        this.frameBehavior.setEnable(true);
        this.scene.addChild((Node)this.frameBehavior);
        this.scene.compile();
        this.addBranchGraph(this.scene);
        this.getCanvas().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                int n = Toolbar.getToolId();
                if (n == 12 || n == 11) {
                    if (DefaultUniverse.this.transformed) {
                        DefaultUniverse.this.fireTransformationFinished();
                    }
                    DefaultUniverse.this.transformed = false;
                }
            }
        });
        this.getCanvas().addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = Toolbar.getToolId();
                if (n == 12 || n == 11) {
                    if (!DefaultUniverse.this.transformed) {
                        DefaultUniverse.this.fireTransformationStarted();
                    }
                    DefaultUniverse.this.transformed = true;
                }
            }
        });
        this.getCanvas().addComponentListener((ComponentListener)new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DefaultUniverse.this.fireCanvasResized();
            }
        });
        this.fireTransformationUpdated();
    }

    public TransformGroup getZoomTG() {
        return this.getViewingPlatform().getMultiTransformGroup().getTransformGroup(4);
    }

    public TransformGroup getCenterTG() {
        return this.getViewingPlatform().getMultiTransformGroup().getTransformGroup(0);
    }

    public TransformGroup getRotationTG() {
        return this.getViewingPlatform().getMultiTransformGroup().getTransformGroup(2);
    }

    public TransformGroup getTranslateTG() {
        return this.getViewingPlatform().getMultiTransformGroup().getTransformGroup(1);
    }

    public TransformGroup getAnimationTG() {
        return this.getViewingPlatform().getMultiTransformGroup().getTransformGroup(3);
    }

    public Scalebar getScalebar() {
        return this.scalebar;
    }

    public ContentTransformer getContentTransformer() {
        return this.contentTransformer;
    }

    public Picker getPicker() {
        return this.picker;
    }

    public InteractiveViewPlatformTransformer getViewPlatformTransformer() {
        return this.viewTransformer;
    }

    public void showAttribute(int n, boolean bl) {
        this.attributesMask.set(n, bl);
        this.attributesSwitch.setChildMask(this.attributesMask);
    }

    public boolean isAttributeVisible(int n) {
        return this.attributesMask.get(n);
    }

    public BranchGroup getScene() {
        return this.scene;
    }

    public void transformChanged(int n, Transform3D transform3D) {
        this.fireTransformationUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNextFrame() {
        this.frameBehavior.postId(1);
        WaitForNextFrameBehavior waitForNextFrameBehavior = this.frameBehavior;
        synchronized (waitForNextFrameBehavior) {
            try {
                ((Object)((Object)this.frameBehavior)).wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setUseToFront(boolean bl) {
        this.useToFront = bl;
    }

    public boolean getUseToFront() {
        return this.useToFront;
    }

    public Dimension getSize() {
        if (this.win != null) {
            return this.win.getSize();
        }
        return null;
    }

    public void setSize(int n, int n2) {
        if (this.win != null) {
            this.win.setSize(n, n2);
        }
    }

    public void show() {
        this.win = new ImageWindow3D("ImageJ 3D Viewer", this);
    }

    public void close() {
        UniverseSettings.save();
        if (this.win != null) {
            this.fireUniverseClosed();
            while (!this.listeners.isEmpty()) {
                this.listeners.remove(0);
            }
            this.win.close();
            ImageWindow3D imageWindow3D = this.win;
            this.win = null;
            imageWindow3D.destroy();
        }
        super.removeAllLocales();
        super.cleanup();
    }

    public ImageWindow3D getWindow() {
        return this.win;
    }

    public ImagePlus takeSnapshot() {
        this.win.updateImagePlusAndWait();
        return this.win.getImagePlus();
    }

    public void addUniverseListener(UniverseListener universeListener) {
        this.listeners.add(universeListener);
    }

    public void removeUniverseListener(UniverseListener universeListener) {
        this.listeners.remove(universeListener);
    }

    public void fireUniverseClosed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener universeListener = (UniverseListener)this.listeners.get(i);
            universeListener.universeClosed();
        }
    }

    public void fireTransformationStarted() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener universeListener = (UniverseListener)this.listeners.get(i);
            universeListener.transformationStarted(this.getCanvas().getView());
        }
    }

    public void fireTransformationUpdated() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener universeListener = (UniverseListener)this.listeners.get(i);
            universeListener.transformationUpdated(this.getCanvas().getView());
        }
    }

    public void fireTransformationFinished() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener universeListener = (UniverseListener)this.listeners.get(i);
            universeListener.transformationFinished(this.getCanvas().getView());
        }
    }

    public void fireContentAdded(Content content) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener universeListener = (UniverseListener)this.listeners.get(i);
            universeListener.contentAdded(content);
        }
    }

    public void fireContentChanged(Content content) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener universeListener = (UniverseListener)this.listeners.get(i);
            universeListener.contentChanged(content);
        }
    }

    public void fireContentRemoved(Content content) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener universeListener = (UniverseListener)this.listeners.get(i);
            universeListener.contentRemoved(content);
        }
    }

    public void fireContentSelected(Content content) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener universeListener = (UniverseListener)this.listeners.get(i);
            universeListener.contentSelected(content);
        }
    }

    public void fireCanvasResized() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener universeListener = (UniverseListener)this.listeners.get(i);
            universeListener.canvasResized();
        }
    }
}

