/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import customnode.CustomMesh;
import customnode.CustomMeshNode;
import customnode.CustomTriangleMesh;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.frame.Recorder;
import ij.process.ImageConverter;
import ij.process.StackConverter;
import ij.text.TextWindow;
import ij.util.Tools;
import ij3d.ColorTable;
import ij3d.Content;
import ij3d.ContentNode;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import ij3d.RegistrationMenubar;
import ij3d.UniverseSettings;
import ij3d.shapes.Scalebar;
import isosurface.MeshEditor;
import isosurface.MeshExporter;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.media.j3d.Background;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import math3d.Transform_IO;
import octree.FilePreparer;
import octree.OctreeDialog;
import orthoslice.OrthoGroup;
import vib.FastMatrix;
import vib.InterpolatedImage;
import view4d.Viewer4D;
import view4d.Viewer4DController;
import voltex.VoltexGroup;

public class Executer {
    public static final String START_ANIMATE = "startAnimate";
    public static final String STOP_ANIMATE = "stopAnimate";
    public static final String START_FREEHAND_RECORDING = "startFreehandRecording";
    public static final String STOP_FREEHAND_RECORDING = "stopFreehandRecording";
    public static final String RECORD_360 = "record360";
    public static final String RESET_VIEW = "resetView";
    public static final String SCALEBAR = "scalebar";
    public static final String CLOSE = "close";
    public static final String WINDOW_SIZE = "windowSize";
    public static final String SET_COLOR = "setColor";
    public static final String SET_TRANSPARENCY = "setTransparency";
    public static final String SET_CHANNELS = "setChannels";
    public static final String FILL_SELECTION = "fillSelection";
    public static final String SET_SLICES = "setSlices";
    public static final String LOCK = "lock";
    public static final String UNLOCK = "unlock";
    public static final String SET_THRESHOLD = "setThreshold";
    public static final String SET_CS = "setCoordinateSystem";
    public static final String SET_TRANSFORM = "setTransform";
    public static final String APPLY_TRANSFORM = "applyTransform";
    public static final String SAVE_TRANSFORM = "saveTransform";
    public static final String RESET_TRANSFORM = "resetTransform";
    public static final String ADD = "add";
    public static final String DELETE = "delete";
    public static final String SMOOTH = "smooth";
    private Image3DUniverse univ;

    public Executer(Image3DUniverse image3DUniverse) {
        this.univ = image3DUniverse;
    }

    public void addContent(final ImagePlus imagePlus, final int n) {
        new Thread(){

            public void run() {
                Executer.this.addC(imagePlus, n);
            }
        }.start();
    }

    private Content addC(ImagePlus imagePlus, int n) {
        Content content;
        int n2 = WindowManager.getImageCount();
        Vector<String> vector = new Vector<String>();
        for (int i = 1; i <= n2; ++i) {
            int n3 = WindowManager.getNthImageID((int)i);
            ImagePlus imagePlus2 = WindowManager.getImage((int)n3);
            if (imagePlus2 == null || imagePlus2.getTitle().equals("3d")) continue;
            vector.add(imagePlus2.getTitle());
        }
        if (vector.size() == 0) {
            IJ.error((String)"No images open");
            return null;
        }
        String[] stringArray = vector.toArray(new String[0]);
        String string = imagePlus == null ? stringArray[0] : imagePlus.getTitle();
        String[] stringArray2 = new String[]{"Volume", "Orthoslice", "Surface", "Surface Plot 2D"};
        n = n < 0 ? 0 : n;
        int n4 = n == 2 ? 50 : 0;
        int n5 = 2;
        GenericDialog genericDialog = new GenericDialog("Add ...", (Frame)((Object)this.univ.getWindow()));
        genericDialog.addChoice("Image", stringArray, string);
        genericDialog.addStringField("Name", string, 10);
        genericDialog.addChoice("Display as", stringArray2, stringArray2[n]);
        genericDialog.addChoice("Color", ColorTable.colorNames, ColorTable.colorNames[0]);
        genericDialog.addNumericField("Threshold", (double)n4, 0);
        genericDialog.addNumericField("Resampling factor", (double)n5, 0);
        genericDialog.addMessage("Channels");
        genericDialog.addCheckboxGroup(1, 3, new String[]{"red", "green", "blue"}, new boolean[]{true, true, true});
        final TextField textField = (TextField)genericDialog.getNumericFields().get(0);
        final Choice choice = (Choice)genericDialog.getChoices().get(1);
        choice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (choice.getSelectedIndex() == 2) {
                    textField.setText(Integer.toString(50));
                } else {
                    textField.setText(Integer.toString(0));
                }
            }
        });
        final Choice choice2 = (Choice)genericDialog.getChoices().get(0);
        final TextField textField2 = (TextField)genericDialog.getStringFields().get(0);
        choice2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                textField2.setText(choice2.getSelectedItem());
            }
        });
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return null;
        }
        imagePlus = WindowManager.getImage((String)genericDialog.getNextChoice());
        string = genericDialog.getNextString();
        n = genericDialog.getNextChoiceIndex();
        Color3f color3f = ColorTable.getColor(genericDialog.getNextChoice());
        n4 = (int)genericDialog.getNextNumber();
        n5 = (int)genericDialog.getNextNumber();
        boolean[] blArray = new boolean[]{genericDialog.getNextBoolean(), genericDialog.getNextBoolean(), genericDialog.getNextBoolean()};
        if (this.univ.contains(string)) {
            IJ.error((String)("Could not add new content. A content with name \"" + string + "\" exists already."));
            return null;
        }
        int n6 = imagePlus.getType();
        if (n6 != 0 && n6 != 4 && IJ.showMessageWithCancel((String)"Convert...", (String)"8-bit image required. Convert?")) {
            Executer.convert(imagePlus);
        }
        if ((content = this.univ.addContent(imagePlus, color3f, string, n4, blArray, n5, n)) == null) {
            return null;
        }
        String[] stringArray3 = new String[]{content.image.getTitle(), ColorTable.getColorName(content.color), content.name, Integer.toString(content.threshold), Boolean.toString(content.channels[0]), Boolean.toString(content.channels[1]), Boolean.toString(content.channels[2]), Integer.toString(content.resamplingF), Integer.toString(content.type)};
        Executer.record(ADD, stringArray3);
        return content;
    }

    public void delete(Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        this.univ.removeContent(content.name);
        Executer.record(DELETE);
    }

    public void loadOctree() {
        OctreeDialog octreeDialog = new OctreeDialog();
        octreeDialog.showDialog();
        if (!octreeDialog.checkUserInput()) {
            return;
        }
        String string = octreeDialog.getImageDir();
        String string2 = octreeDialog.getName();
        String string3 = octreeDialog.getImagePath();
        if (octreeDialog.shouldCreateData()) {
            try {
                new FilePreparer(string3, 256, string).createFiles();
            }
            catch (Exception exception) {
                IJ.error((String)exception.getMessage());
                exception.printStackTrace();
                return;
            }
        }
        this.univ.addOctree(string, string2);
    }

    public void removeOctree() {
        this.univ.removeOctree();
    }

    public void load4D() {
        if (!this.univ.getContents().isEmpty() && !IJ.showMessageWithCancel((String)"Loading 4D data...", (String)"All current 3D objects are removed from\nthe view! Continue?")) {
            return;
        }
        Viewer4D viewer4D = new Viewer4D(this.univ);
        if (viewer4D.loadContents()) {
            new Viewer4DController(viewer4D);
        }
    }

    public void importWaveFront() {
        Collection<Future<Content>> collection;
        OpenDialog openDialog = new OpenDialog("Select .obj file", OpenDialog.getDefaultDirectory(), null);
        String string = openDialog.getFileName();
        if (null == string) {
            return;
        }
        if (!string.toLowerCase().endsWith(".obj")) {
            IJ.showMessage((String)"Must select a wavefront .obj file!");
            return;
        }
        String string2 = openDialog.getDirectory() + string;
        IJ.log((String)("path: " + string2));
        try {
            collection = this.univ.addContentLater(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            collection = null;
        }
        if (null == collection) {
            IJ.showMessage((String)("Could not load the file:\n" + string2));
        }
    }

    public void saveAsDXF() {
        MeshExporter.saveAsDXF(this.univ.getContents());
    }

    public void saveAsWaveFront() {
        MeshExporter.saveAsWaveFront(this.univ.getContents());
    }

    public void close() {
        this.univ.close();
        Executer.record(CLOSE);
    }

    public void changeSlices(final Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        final GenericDialog genericDialog = new GenericDialog("Adjust slices...", (Frame)((Object)this.univ.getWindow()));
        final OrthoGroup orthoGroup = (OrthoGroup)content.getContent();
        final int n = orthoGroup.getSlice(0);
        final int n2 = orthoGroup.getSlice(1);
        final int n3 = orthoGroup.getSlice(2);
        final boolean bl = orthoGroup.isVisible(0);
        final boolean bl2 = orthoGroup.isVisible(1);
        final boolean bl3 = orthoGroup.isVisible(2);
        ImagePlus imagePlus = content.image;
        int n4 = imagePlus.getWidth() / content.getResamplingFactor();
        int n5 = imagePlus.getHeight() / content.getResamplingFactor();
        int n6 = imagePlus.getStackSize() / content.getResamplingFactor();
        genericDialog.addCheckbox("Show_yz plane", bl);
        genericDialog.addSlider("x coordinate", 0.0, (double)(n4 - 1), (double)n);
        genericDialog.addCheckbox("Show_xz plane", bl2);
        genericDialog.addSlider("y coordinate", 0.0, (double)(n5 - 1), (double)n2);
        genericDialog.addCheckbox("Show_xy plane", bl3);
        genericDialog.addSlider("z coordinate", 0.0, (double)(n6 - 1), (double)n3);
        genericDialog.addMessage("You can use the x, y and z key plus\nthe arrow keys to adjust slices in\nx, y and z direction respectively.\n \nx, y, z + SPACE switches planes on\nand off");
        final int[] nArray = new int[]{0, 1, 2};
        final Scrollbar[] scrollbarArray = new Scrollbar[3];
        final Checkbox[] checkboxArray = new Checkbox[3];
        int n7 = 0;
        while (n7 < 3) {
            final int n8 = n7++;
            scrollbarArray[n8] = (Scrollbar)genericDialog.getSliders().get(n8);
            scrollbarArray[n8].addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    orthoGroup.setSlice(nArray[n8], scrollbarArray[n8].getValue());
                    Executer.this.univ.fireContentChanged(content);
                }
            });
            checkboxArray[n8] = (Checkbox)genericDialog.getCheckboxes().get(n8);
            checkboxArray[n8].addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    orthoGroup.setVisible(nArray[n8], checkboxArray[n8].getState());
                }
            });
        }
        genericDialog.setModal(false);
        genericDialog.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (genericDialog.wasCanceled()) {
                    orthoGroup.setSlice(0, n);
                    orthoGroup.setSlice(1, n2);
                    orthoGroup.setSlice(2, n3);
                    orthoGroup.setVisible(0, bl);
                    orthoGroup.setVisible(1, bl2);
                    orthoGroup.setVisible(2, bl3);
                    Executer.this.univ.fireContentChanged(content);
                    return;
                }
                Executer.record(Executer.SET_SLICES, Integer.toString(scrollbarArray[0].getValue()), Integer.toString(scrollbarArray[1].getValue()), Integer.toString(scrollbarArray[2].getValue()));
            }
        });
        genericDialog.showDialog();
    }

    public void fill(final Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        int n = content.getType();
        if (n != 0 && n != 1) {
            return;
        }
        new Thread(){

            public void run() {
                ImageCanvas3D imageCanvas3D = (ImageCanvas3D)Executer.this.univ.getCanvas();
                ((VoltexGroup)content.getContent()).fillRoi(imageCanvas3D, imageCanvas3D.getRoi(), (byte)0);
                Executer.this.univ.fireContentChanged(content);
                Executer.record(Executer.FILL_SELECTION);
            }
        }.start();
    }

    public void smoothMesh(Content content) {
        CustomMesh customMesh;
        ContentNode contentNode;
        if (!this.checkSel(content)) {
            return;
        }
        if ((content.getType() == 2 || content.getType() == 4) && (contentNode = content.getContent()) instanceof CustomMeshNode && (customMesh = ((CustomMeshNode)contentNode).getMesh()) instanceof CustomTriangleMesh) {
            MeshEditor.smooth((CustomTriangleMesh)customMesh, 0.25f);
        }
    }

    public void smoothAllMeshes() {
        Collection collection = this.univ.getContents();
        final Content[] contentArray = new Content[collection.size()];
        collection.toArray(contentArray);
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = new Thread[Runtime.getRuntime().availableProcessors()];
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(){

                public void run() {
                    try {
                        int n = atomicInteger.getAndIncrement();
                        while (n < contentArray.length) {
                            Executer.this.smoothMesh(contentArray[n]);
                            n = atomicInteger.getAndIncrement();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            threadArray[i].start();
        }
    }

    public void displayAs(Content content, int n) {
        if (!this.checkSel(content)) {
            return;
        }
        content.displayAs(n);
        this.univ.clearSelection();
    }

    public void changeColor(final Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        final GenericDialog genericDialog = new GenericDialog("Adjust color ...", (Frame)((Object)this.univ.getWindow()));
        final Color3f color3f = content.color;
        genericDialog.addCheckbox("Use default color", color3f == null);
        genericDialog.addSlider("Red", 0.0, 255.0, color3f == null ? 255.0 : (double)(color3f.x * 255.0f));
        genericDialog.addSlider("Green", 0.0, 255.0, color3f == null ? 0.0 : (double)(color3f.y * 255.0f));
        genericDialog.addSlider("Blue", 0.0, 255.0, color3f == null ? 0.0 : (double)(color3f.z * 255.0f));
        final Scrollbar scrollbar = (Scrollbar)genericDialog.getSliders().get(0);
        final Scrollbar scrollbar2 = (Scrollbar)genericDialog.getSliders().get(1);
        final Scrollbar scrollbar3 = (Scrollbar)genericDialog.getSliders().get(2);
        final Checkbox checkbox = (Checkbox)genericDialog.getCheckboxes().get(0);
        scrollbar.setEnabled(color3f != null);
        scrollbar2.setEnabled(color3f != null);
        scrollbar3.setEnabled(color3f != null);
        checkbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                genericDialog.setCursor(new Cursor(3));
                scrollbar.setEnabled(!checkbox.getState());
                scrollbar2.setEnabled(!checkbox.getState());
                scrollbar3.setEnabled(!checkbox.getState());
                content.setColor(checkbox.getState() ? null : new Color3f((float)scrollbar.getValue() / 255.0f, (float)scrollbar2.getValue() / 255.0f, (float)scrollbar3.getValue() / 255.0f));
                genericDialog.setCursor(new Cursor(0));
                Executer.this.univ.fireContentChanged(content);
            }
        });
        AdjustmentListener adjustmentListener = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                content.setColor(new Color3f((float)scrollbar.getValue() / 255.0f, (float)scrollbar2.getValue() / 255.0f, (float)scrollbar3.getValue() / 255.0f));
                Executer.this.univ.fireContentChanged(content);
            }
        };
        scrollbar.addAdjustmentListener(adjustmentListener);
        scrollbar2.addAdjustmentListener(adjustmentListener);
        scrollbar3.addAdjustmentListener(adjustmentListener);
        genericDialog.setModal(false);
        genericDialog.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (genericDialog.wasCanceled()) {
                    content.setColor(color3f);
                    Executer.this.univ.fireContentChanged(content);
                    return;
                }
                if (checkbox.getState()) {
                    Executer.record(Executer.SET_COLOR, "null", "null", "null");
                } else {
                    Executer.record(Executer.SET_COLOR, Integer.toString(scrollbar.getValue()), Integer.toString(scrollbar2.getValue()), Integer.toString(scrollbar3.getValue()));
                }
                Executer.this.univ.clearSelection();
            }
        });
        genericDialog.showDialog();
    }

    public void changeBackgroundColor() {
        final GenericDialog genericDialog = new GenericDialog("Adjust background color ...", (Frame)((Object)this.univ.getWindow()));
        final Background background = ((ImageCanvas3D)this.univ.getCanvas()).getBG();
        final Label label = this.univ.getWindow().getStatusLabel();
        final Color3f color3f = new Color3f();
        background.getColor(color3f);
        genericDialog.addSlider("Red", 0.0, 255.0, color3f == null ? 255.0 : (double)(color3f.x * 255.0f));
        genericDialog.addSlider("Green", 0.0, 255.0, color3f == null ? 0.0 : (double)(color3f.y * 255.0f));
        genericDialog.addSlider("Blue", 0.0, 255.0, color3f == null ? 0.0 : (double)(color3f.z * 255.0f));
        final Scrollbar scrollbar = (Scrollbar)genericDialog.getSliders().get(0);
        final Scrollbar scrollbar2 = (Scrollbar)genericDialog.getSliders().get(1);
        final Scrollbar scrollbar3 = (Scrollbar)genericDialog.getSliders().get(2);
        scrollbar.setEnabled(color3f != null);
        scrollbar2.setEnabled(color3f != null);
        scrollbar3.setEnabled(color3f != null);
        AdjustmentListener adjustmentListener = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                float f = (float)scrollbar.getValue() / 255.0f;
                float f2 = (float)scrollbar2.getValue() / 255.0f;
                float f3 = (float)scrollbar3.getValue() / 255.0f;
                background.setColor(f, f2, f3);
                label.setBackground(new Color(f, f2, f3));
                ((ImageCanvas3D)Executer.this.univ.getCanvas()).render();
            }
        };
        scrollbar.addAdjustmentListener(adjustmentListener);
        scrollbar2.addAdjustmentListener(adjustmentListener);
        scrollbar3.addAdjustmentListener(adjustmentListener);
        genericDialog.setModal(false);
        genericDialog.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (genericDialog.wasCanceled()) {
                    background.setColor(color3f);
                    label.setBackground(new Color(color3f.x, color3f.y, color3f.z));
                    ((ImageCanvas3D)Executer.this.univ.getCanvas()).render();
                    return;
                }
                float f = (float)scrollbar.getValue() / 255.0f;
                float f2 = (float)scrollbar2.getValue() / 255.0f;
                float f3 = (float)scrollbar3.getValue() / 255.0f;
                background.setColor(f, f2, f3);
                label.setBackground(new Color(f, f2, f3));
                ((ImageCanvas3D)Executer.this.univ.getCanvas()).render();
            }
        });
        genericDialog.showDialog();
    }

    public void changeChannels(Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        GenericDialog genericDialog = new GenericDialog("Adjust channels ...", (Frame)((Object)this.univ.getWindow()));
        genericDialog.addMessage("Channels");
        genericDialog.addCheckboxGroup(1, 3, new String[]{"red", "green", "blue"}, content.getChannels());
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        boolean[] blArray = new boolean[]{genericDialog.getNextBoolean(), genericDialog.getNextBoolean(), genericDialog.getNextBoolean()};
        content.setChannels(blArray);
        this.univ.fireContentChanged(content);
        Executer.record(SET_CHANNELS, Boolean.toString(blArray[0]), Boolean.toString(blArray[1]), Boolean.toString(blArray[2]));
        this.univ.clearSelection();
    }

    public void changeTransparency(final Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        final SliderAdjuster sliderAdjuster = new SliderAdjuster(){

            public final synchronized void setValue(Content content, int n) {
                content.setTransparency((float)n / 100.0f);
            }
        };
        final GenericDialog genericDialog = new GenericDialog("Adjust transparency ...", (Frame)((Object)this.univ.getWindow()));
        final int n = (int)(content.getTransparency() * 100.0f);
        genericDialog.addSlider("Transparency", 0.0, 100.0, (double)n);
        ((Scrollbar)genericDialog.getSliders().get(0)).addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!sliderAdjuster.go) {
                    sliderAdjuster.start();
                }
                sliderAdjuster.exec(adjustmentEvent.getValue(), content, Executer.this.univ);
            }
        });
        ((TextField)genericDialog.getNumericFields().get(0)).addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                if (!sliderAdjuster.go) {
                    sliderAdjuster.start();
                }
                TextField textField = (TextField)textEvent.getSource();
                String string = textField.getText();
                try {
                    int n = Integer.parseInt(string);
                    sliderAdjuster.exec(n, content, Executer.this.univ);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        genericDialog.setModal(false);
        genericDialog.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (genericDialog.wasCanceled()) {
                    float f = (float)n / 100.0f;
                    content.setTransparency(f);
                    Executer.this.univ.fireContentChanged(content);
                    return;
                }
                Executer.record(Executer.SET_TRANSPARENCY, Float.toString((float)((Scrollbar)genericDialog.getSliders().get(0)).getValue() / 100.0f));
                if (null != sliderAdjuster) {
                    sliderAdjuster.quit();
                }
                Executer.this.univ.clearSelection();
            }
        });
        genericDialog.showDialog();
    }

    public void changeThreshold(final Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        if (content.image == null) {
            IJ.error((String)"The selected object contains no image data,\ntherefore the threshold can't be changed");
            return;
        }
        final SliderAdjuster sliderAdjuster = new SliderAdjuster(){

            public final synchronized void setValue(Content content, int n) {
                content.setThreshold(n);
            }
        };
        final int n = content.getThreshold();
        if (content.getType() == 2) {
            int n2 = (int)Math.round(IJ.getNumber((String)"Threshold [0..255]", (double)n));
            n2 = Math.max(0, n2);
            n2 = Math.min(n2, 255);
            content.setThreshold(n2);
            this.univ.fireContentChanged(content);
            Executer.record(SET_THRESHOLD, Integer.toString(n2));
            return;
        }
        final GenericDialog genericDialog = new GenericDialog("Adjust threshold...");
        genericDialog.addSlider("Threshold", 0.0, 255.0, (double)n);
        ((Scrollbar)genericDialog.getSliders().get(0)).addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!sliderAdjuster.go) {
                    sliderAdjuster.start();
                }
                sliderAdjuster.exec(adjustmentEvent.getValue(), content, Executer.this.univ);
            }
        });
        genericDialog.setModal(false);
        genericDialog.addWindowListener((WindowListener)new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosed(WindowEvent windowEvent) {
                try {
                    if (genericDialog.wasCanceled()) {
                        content.setThreshold(n);
                        Executer.this.univ.fireContentChanged(content);
                        return;
                    }
                    Executer.record(Executer.SET_THRESHOLD, Integer.toString(content.threshold));
                }
                finally {
                    if (null != sliderAdjuster) {
                        sliderAdjuster.quit();
                    }
                    Executer.this.univ.clearSelection();
                }
            }
        });
        genericDialog.showDialog();
    }

    public void setShaded(Content content, boolean bl) {
        if (!this.checkSel(content)) {
            return;
        }
        int n = content.getType();
        if (n == 2 || n == 3 || n == 4) {
            content.setShaded(bl);
        }
    }

    public void showCoordinateSystem(Content content, boolean bl) {
        if (!this.checkSel(content)) {
            return;
        }
        content.showCoordinateSystem(bl);
        Executer.record(SET_CS, Boolean.toString(bl));
    }

    public void showContent(Content content, boolean bl) {
        if (!this.checkSel(content)) {
            return;
        }
        this.univ.getSelected().setVisible(bl);
        if (!bl) {
            this.univ.clearSelection();
        }
    }

    public void showAllCoordinateSystems(boolean bl) {
        Iterator iterator = this.univ.contents();
        while (iterator.hasNext()) {
            ((Content)iterator.next()).showCoordinateSystem(bl);
        }
    }

    public void loadPointList(Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        content.loadPointList();
    }

    public void savePointList(Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        content.savePointList();
    }

    public void changePointSize(final Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        final GenericDialog genericDialog = new GenericDialog("Point size", (Frame)((Object)this.univ.getWindow()));
        final float f = content.getLandmarkPointSize();
        genericDialog.addSlider("Size", 0.0, 20.0, (double)f);
        ((Scrollbar)genericDialog.getSliders().get(0)).addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                float f = adjustmentEvent.getValue();
                content.setLandmarkPointSize(f);
            }
        });
        genericDialog.setModal(false);
        genericDialog.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (genericDialog.wasCanceled()) {
                    content.setLandmarkPointSize(f);
                    return;
                }
            }
        });
        genericDialog.showDialog();
    }

    public void showPointList(Content content, boolean bl) {
        if (!this.checkSel(content)) {
            return;
        }
        content.showPointList(bl);
    }

    public void register() {
        Collection collection = this.univ.getContents();
        if (collection.size() < 2) {
            IJ.error((String)"At least two bodies are required for registration");
            return;
        }
        RegistrationMenubar registrationMenubar = this.univ.getRegistrationMenuBar();
        this.univ.setMenubar(registrationMenubar);
        registrationMenubar.register();
    }

    public void contentProperties(Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        content.getContent().getMin((Tuple3d)point3d);
        content.getContent().getMax((Tuple3d)point3d2);
        content.getContent().getCenter((Tuple3d)point3d3);
        TextWindow textWindow = new TextWindow(content.getName(), " \tx\ty\tz", "min\t" + (float)point3d.x + "\t" + (float)point3d.y + "\t" + (float)point3d.z + "\n" + "max\t" + (float)point3d2.x + "\t" + (float)point3d2.y + "\t" + (float)point3d2.z + "\n" + "cog\t" + (float)point3d3.x + "\t" + (float)point3d3.y + "\t" + (float)point3d3.z + "\n\n" + "volume\t" + content.getContent().getVolume(), 512, 512);
    }

    public void select(String string) {
        Content content = this.univ.getContent(string);
        if (content != null) {
            this.univ.select(content);
        }
    }

    public void setLocked(Content content, boolean bl) {
        if (!this.checkSel(content)) {
            return;
        }
        content.setLocked(bl);
        if (bl) {
            Executer.record(LOCK);
        } else {
            Executer.record(UNLOCK);
        }
    }

    public void resetTransform(Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        if (content.isLocked()) {
            IJ.error((String)(content.name + " is locked"));
            return;
        }
        this.univ.fireTransformationStarted();
        content.setTransform(new Transform3D());
        this.univ.fireTransformationFinished();
        Executer.record(RESET_TRANSFORM);
    }

    public void setTransform(Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        if (content.isLocked()) {
            IJ.error((String)(content.name + " is locked"));
            return;
        }
        this.univ.fireTransformationStarted();
        float[] fArray = this.readTransform(content);
        if (fArray != null) {
            content.setTransform(new Transform3D(fArray));
            this.univ.fireTransformationFinished();
            Executer.record(SET_TRANSFORM, this.affine2string(fArray));
        }
    }

    public void applyTransform(Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        if (content.isLocked()) {
            IJ.error((String)(content.name + " is locked"));
            return;
        }
        this.univ.fireTransformationStarted();
        float[] fArray = this.readTransform(content);
        if (fArray != null) {
            content.applyTransform(new Transform3D(fArray));
            this.univ.fireTransformationFinished();
            Executer.record(APPLY_TRANSFORM, this.affine2string(fArray));
        }
    }

    public void saveTransform(Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        Transform3D transform3D = new Transform3D();
        content.getLocalTranslate().getTransform(transform3D);
        Transform3D transform3D2 = new Transform3D();
        content.getLocalRotate().getTransform(transform3D2);
        transform3D.mul(transform3D2);
        float[] fArray = new float[16];
        transform3D.get(fArray);
        if (new Transform_IO().saveAffineTransform(fArray)) {
            Executer.record(SAVE_TRANSFORM, this.affine2string(fArray));
        }
    }

    public void exportTransformed(final Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                Executer.this.exportTr(content);
            }
        }).start();
    }

    private void exportTr(Content content) {
        ImagePlus imagePlus = content.getImage();
        if (imagePlus == null) {
            IJ.error((String)("No greyscale image exists for " + content.getName()));
            return;
        }
        Transform3D transform3D = new Transform3D();
        content.getLocalTranslate().getTransform(transform3D);
        Transform3D transform3D2 = new Transform3D();
        content.getLocalRotate().getTransform(transform3D2);
        transform3D.mul(transform3D2);
        FastMatrix fastMatrix = FastMatrix.fromCalibration(imagePlus);
        FastMatrix fastMatrix2 = fastMatrix.inverse().times(this.toFastMatrix(transform3D).inverse()).times(fastMatrix);
        InterpolatedImage interpolatedImage = new InterpolatedImage(imagePlus);
        InterpolatedImage interpolatedImage2 = interpolatedImage.cloneDimensionsOnly();
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getStackSize();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    fastMatrix2.apply(k, j, i);
                    interpolatedImage2.set(k, j, i, (byte)interpolatedImage.interpol.get(fastMatrix2.x, fastMatrix2.y, fastMatrix2.z));
                }
                IJ.showProgress((int)(i + 1), (int)n3);
            }
        }
        interpolatedImage2.getImage().setTitle(imagePlus.getTitle() + "_transformed");
        interpolatedImage2.getImage().show();
    }

    public void resetView() {
        this.univ.resetView();
        Executer.record(RESET_VIEW);
    }

    public void centerSelected(Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        this.univ.centerSelected(content);
    }

    public void centerUniverse() {
        Point3d point3d = new Point3d();
        this.univ.getGlobalCenterPoint(point3d);
        this.univ.centerAt(point3d);
    }

    public void centerOrigin() {
        this.univ.centerAt(new Point3d());
    }

    public void fitViewToUniverse() {
        this.univ.adjustView();
    }

    public void fitViewToContent(Content content) {
        if (!this.checkSel(content)) {
            return;
        }
        this.univ.adjustView(content);
    }

    public void record360() {
        ImagePlus imagePlus = this.univ.record360();
        if (imagePlus != null) {
            imagePlus.show();
        }
        Executer.record(RECORD_360);
    }

    public void startFreehandRecording() {
        this.univ.startFreehandRecording();
        Executer.record(START_FREEHAND_RECORDING);
    }

    public void stopFreehandRecording() {
        ImagePlus imagePlus = this.univ.stopFreehandRecording();
        if (imagePlus != null) {
            imagePlus.show();
        }
        Executer.record(STOP_FREEHAND_RECORDING);
    }

    public void startAnimation() {
        this.univ.startAnimation();
        Executer.record(START_ANIMATE);
    }

    public void stopAnimation() {
        this.univ.pauseAnimation();
        Executer.record(STOP_ANIMATE);
    }

    public void viewPreferences() {
        UniverseSettings.initFromDialog(this.univ);
    }

    public void editScalebar() {
        Scalebar scalebar = this.univ.getScalebar();
        GenericDialog genericDialog = new GenericDialog("Edit scalebar...", (Frame)((Object)this.univ.getWindow()));
        genericDialog.addNumericField("x position", (double)scalebar.getX(), 2);
        genericDialog.addNumericField("y position", (double)scalebar.getY(), 2);
        genericDialog.addNumericField("length", (double)scalebar.getLength(), 2);
        genericDialog.addStringField("Units", scalebar.getUnit(), 5);
        genericDialog.addChoice("Color", ColorTable.colorNames, ColorTable.getColorName(scalebar.getColor()));
        genericDialog.addCheckbox("show", this.univ.isAttributeVisible(0));
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        scalebar.setPosition((float)genericDialog.getNextNumber(), (float)genericDialog.getNextNumber());
        scalebar.setLength((float)genericDialog.getNextNumber());
        scalebar.setUnit(genericDialog.getNextString());
        scalebar.setColor(ColorTable.getColor(genericDialog.getNextChoice()));
        boolean bl = genericDialog.getNextBoolean();
        this.univ.showAttribute(0, bl);
    }

    public void j3dproperties() {
        TextWindow textWindow = new TextWindow("Java 3D Properties", "Key\tValue", "", 512, 512);
        Map map = Image3DUniverse.getProperties();
        textWindow.append("Java 3D properties\n \n");
        for (Map.Entry entry : map.entrySet()) {
            textWindow.append(entry.getKey() + "\t" + entry.getValue());
        }
        map = this.univ.getCanvas().queryProperties();
        textWindow.append(" \nRendering properties\n \n");
        for (Map.Entry entry : map.entrySet()) {
            textWindow.append(entry.getKey() + "\t" + entry.getValue());
        }
    }

    public static void convert(ImagePlus imagePlus) {
        int n = imagePlus.getType();
        if (n == 0 || n == 3) {
            return;
        }
        int n2 = imagePlus.getStackSize();
        switch (n) {
            case 3: {
                if (n2 == 1) {
                    new ImageConverter(imagePlus).convertToRGB();
                    break;
                }
                new StackConverter(imagePlus).convertToRGB();
                break;
            }
            case 1: 
            case 2: {
                if (n2 == 1) {
                    new ImageConverter(imagePlus).convertToGray8();
                    break;
                }
                new StackConverter(imagePlus).convertToGray8();
            }
        }
    }

    private float[] readTransform(Content content) {
        final GenericDialog genericDialog = new GenericDialog("Read transformation", (Frame)((Object)this.univ.getWindow()));
        Transform3D transform3D = new Transform3D();
        content.getLocalTranslate().getTransform(transform3D);
        Transform3D transform3D2 = new Transform3D();
        content.getLocalRotate().getTransform(transform3D2);
        transform3D.mul(transform3D2);
        float[] fArray = new float[16];
        transform3D.get(fArray);
        String string = this.affine2string(fArray);
        genericDialog.addStringField("Transformation", string, 25);
        Panel panel = new Panel(new FlowLayout());
        Button button = new Button("Open from file");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                float[] fArray = new Transform_IO().openAffineTransform();
                if (fArray != null) {
                    TextField textField = (TextField)genericDialog.getStringFields().get(0);
                    textField.setText(Executer.this.affine2string(fArray));
                    textField.repaint();
                }
            }
        });
        panel.add(button);
        genericDialog.addPanel(panel);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return null;
        }
        string = genericDialog.getNextString();
        float[] fArray2 = this.string2affine(string);
        return fArray2;
    }

    private FastMatrix toFastMatrix(Transform3D transform3D) {
        Matrix4d matrix4d = new Matrix4d();
        transform3D.get(matrix4d);
        return new FastMatrix(new double[][]{{matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m03}, {matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m13}, {matrix4d.m20, matrix4d.m21, matrix4d.m22, matrix4d.m23}});
    }

    private String affine2string(float[] fArray) {
        String string = "";
        for (int i = 0; i < fArray.length; ++i) {
            string = string + fArray[i] + " ";
        }
        return string;
    }

    private float[] string2affine(String string) {
        String[] stringArray = Tools.split((String)string);
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        return fArray;
    }

    private static final int getAutoThreshold(ImagePlus imagePlus) {
        int[] nArray = new int[256];
        int n = imagePlus.getStackSize();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = (byte[])imagePlus.getStack().getPixels(i + 1);
            for (int j = 0; j < byArray.length; ++j) {
                int n2 = byArray[j] & 0xFF;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        return imagePlus.getProcessor().getAutoThreshold(nArray);
    }

    private final boolean checkSel(Content content) {
        if (content == null) {
            IJ.error((String)"Selection required");
            return false;
        }
        return true;
    }

    private static void record(String string) {
        string = "ImageJ_3D_Viewer." + string;
        if (Recorder.record) {
            Recorder.record((String)"call", (String)string);
        }
    }

    private static void record(String string, String string2) {
        string = "ImageJ_3D_Viewer." + string;
        if (Recorder.record) {
            Recorder.record((String)"call", (String)string, (String)string2);
        }
    }

    private static void record(String string, String string2, String string3) {
        string = "ImageJ_3D_Viewer." + string;
        if (Recorder.record) {
            Recorder.record((String)"call", (String)string, (String)string2, (String)string3);
        }
    }

    private static void record(String string, String string2, String string3, String string4) {
        string = "call(\"ImageJ_3D_Viewer." + string + "\", " + "\"" + string2 + "\"," + "\"" + string3 + "\"," + "\"" + string4 + "\")";
        if (Recorder.record) {
            Recorder.recordString((String)string);
        }
    }

    private static void record(String string, String[] stringArray) {
        string = "call(\"ImageJ_3D_Viewer." + string + "\"";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + ", \"" + stringArray[i] + "\"";
        }
        string = string + ");";
        if (Recorder.record) {
            Recorder.recordString((String)string);
        }
    }

    private abstract class SliderAdjuster
    extends Thread {
        boolean go;
        int newV;
        Content content;
        Image3DUniverse univ;
        final Object lock;

        SliderAdjuster() {
            super("VIB-SliderAdjuster");
            this.go = false;
            this.lock = new Object();
            this.setPriority(5);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void exec(int n, Content content, Image3DUniverse image3DUniverse) {
            Object object = this.lock;
            synchronized (object) {
                this.newV = n;
                this.content = content;
                this.univ = image3DUniverse;
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.go = false;
            SliderAdjuster sliderAdjuster = this;
            synchronized (sliderAdjuster) {
                this.notify();
            }
        }

        protected abstract void setValue(Content var1, int var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.go = true;
            while (this.go) {
                try {
                    Image3DUniverse image3DUniverse;
                    Object object;
                    if (null == this.content) {
                        object = this;
                        synchronized (object) {
                            this.wait();
                        }
                    }
                    if (!this.go) {
                        return;
                    }
                    int n = 0;
                    Object object2 = this.lock;
                    synchronized (object2) {
                        object = this.content;
                        n = this.newV;
                        image3DUniverse = this.univ;
                    }
                    if (null != object) {
                        this.setValue((Content)object, n);
                        image3DUniverse.fireContentChanged((Content)object);
                    }
                    object2 = this.lock;
                    synchronized (object2) {
                        if (object == this.content) {
                            this.content = null;
                            this.univ = null;
                        }
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

