/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import customnode.CustomLineMesh;
import customnode.CustomMesh;
import customnode.CustomMeshNode;
import customnode.CustomPointMesh;
import customnode.CustomQuadMesh;
import customnode.CustomTriangleMesh;
import customnode.MeshLoader;
import ij.IJ;
import ij.ImagePlus;
import ij.plugin.frame.Recorder;
import ij3d.Content;
import ij3d.DefaultAnimatableUniverse;
import ij3d.Executer;
import ij3d.Image3DMenubar;
import ij3d.ImageCanvas3D;
import ij3d.RegistrationMenubar;
import ij3d.UniverseSettings;
import ij3d.pointlist.PointListDialog;
import java.awt.Frame;
import java.awt.MenuBar;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import octree.FilePreparer;
import octree.VolumeOctree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image3DUniverse
extends DefaultAnimatableUniverse {
    public static ArrayList<Image3DUniverse> universes = new ArrayList();
    private Content selected;
    private Hashtable<String, Content> contents = new Hashtable();
    private Image3DMenubar menubar;
    private RegistrationMenubar registrationMenubar;
    private ImageCanvas3D canvas;
    private Executer executer;
    private boolean autoAdjustView = true;
    private PointListDialog plDialog;
    private final Object lock = new Object();
    private VolumeOctree octree = null;
    private float oldRange = 2.0f;
    private ExecutorService adder = Executors.newFixedThreadPool(1);

    public Image3DUniverse() {
        this(UniverseSettings.startupWidth, UniverseSettings.startupHeight);
    }

    public Image3DUniverse(int n, int n2) {
        super(n, n2);
        this.canvas = (ImageCanvas3D)this.getCanvas();
        this.executer = new Executer(this);
        BranchGroup branchGroup = new BranchGroup();
        this.scene.addChild((Node)branchGroup);
        this.resetView();
        this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Content content = Image3DUniverse.this.picker.getPickedContent(mouseEvent.getX(), mouseEvent.getY());
                if (content != null) {
                    IJ.showStatus((String)content.name);
                } else {
                    IJ.showStatus((String)"");
                }
            }
        });
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Content content = Image3DUniverse.this.picker.getPickedContent(mouseEvent.getX(), mouseEvent.getY());
                Image3DUniverse.this.select(content);
            }
        });
        universes.add(this);
    }

    @Override
    public void show() {
        super.show();
        this.plDialog = new PointListDialog((Frame)((Object)this.win));
        this.menubar = new Image3DMenubar(this);
        this.registrationMenubar = new RegistrationMenubar(this);
        this.setMenubar(this.menubar);
    }

    @Override
    public void close() {
        super.close();
        this.removeAllContents();
        this.contents = null;
        universes.remove(this);
        this.adder.shutdownNow();
    }

    public void setStatus(String string) {
        if (this.win != null) {
            this.win.getStatusLabel().setText("  " + string);
        }
    }

    public void setMenubar(MenuBar menuBar) {
        if (this.win != null) {
            this.win.setMenuBar(menuBar);
        }
    }

    public MenuBar getMenuBar() {
        return this.menubar;
    }

    public RegistrationMenubar getRegistrationMenuBar() {
        return this.registrationMenubar;
    }

    public Executer getExecuter() {
        return this.executer;
    }

    public PointListDialog getPointListDialog() {
        return this.plDialog;
    }

    public void select(Content content) {
        if (this.selected != null) {
            this.selected.setSelected(false);
            this.selected = null;
        }
        if (content != null) {
            content.setSelected(true);
            this.selected = content;
        }
        String string = content != null ? content.name : "none";
        IJ.showStatus((String)("selected: " + string));
        this.fireContentSelected(content);
        if (content != null && Recorder.record) {
            Recorder.record((String)"call", (String)"ImageJ_3D_Viewer.select", (String)content.name);
        }
    }

    @Override
    public Content getSelected() {
        return this.selected;
    }

    public void clearSelection() {
        if (this.selected != null) {
            this.selected.setSelected(false);
        }
        this.selected = null;
        this.fireContentSelected(null);
    }

    public void setAutoAdjustView(boolean bl) {
        this.autoAdjustView = bl;
    }

    public boolean getAutoAdjustView() {
        return this.autoAdjustView;
    }

    public void recalculateGlobalMinMax() {
        if (this.contents.isEmpty()) {
            return;
        }
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Iterator iterator = this.contents();
        Content content = (Content)iterator.next();
        content.getContent().getMin((Tuple3d)point3d);
        content.getContent().getMax((Tuple3d)point3d2);
        this.globalMin.set((Tuple3d)point3d);
        this.globalMax.set((Tuple3d)point3d2);
        while (iterator.hasNext()) {
            content = (Content)iterator.next();
            content.getContent().getMin((Tuple3d)point3d);
            content.getContent().getMax((Tuple3d)point3d2);
            if (point3d.x < this.globalMin.x) {
                this.globalMin.x = point3d.x;
            }
            if (point3d.y < this.globalMin.y) {
                this.globalMin.y = point3d.y;
            }
            if (point3d.z < this.globalMin.z) {
                this.globalMin.z = point3d.z;
            }
            if (point3d2.x > this.globalMax.x) {
                this.globalMax.x = point3d2.x;
            }
            if (point3d2.y > this.globalMax.y) {
                this.globalMax.y = point3d2.y;
            }
            if (!(point3d2.z > this.globalMax.z)) continue;
            this.globalMax.z = point3d2.z;
        }
        this.globalCenter.x = this.globalMin.x + (this.globalMax.x - this.globalMin.x) / 2.0;
        this.globalCenter.y = this.globalMin.y + (this.globalMax.y - this.globalMin.y) / 2.0;
        this.globalCenter.z = this.globalMin.z + (this.globalMax.z - this.globalMin.z) / 2.0;
    }

    public void recalculateGlobalMinMax(Content content) {
        Point3d point3d = new Point3d();
        content.getContent().getMin((Tuple3d)point3d);
        Point3d point3d2 = new Point3d();
        content.getContent().getMax((Tuple3d)point3d2);
        if (this.contents.size() == 1) {
            this.globalMin.set((Tuple3d)point3d);
            this.globalMax.set((Tuple3d)point3d2);
        } else {
            if (point3d.x < this.globalMin.x) {
                this.globalMin.x = point3d.x;
            }
            if (point3d.y < this.globalMin.y) {
                this.globalMin.y = point3d.y;
            }
            if (point3d.z < this.globalMin.z) {
                this.globalMin.z = point3d.z;
            }
            if (point3d2.x > this.globalMax.x) {
                this.globalMax.x = point3d2.x;
            }
            if (point3d2.y > this.globalMax.y) {
                this.globalMax.y = point3d2.y;
            }
            if (point3d2.z > this.globalMax.z) {
                this.globalMax.z = point3d2.z;
            }
        }
        this.globalCenter.x = this.globalMin.x + (this.globalMax.x - this.globalMin.x) / 2.0;
        this.globalCenter.y = this.globalMin.y + (this.globalMax.y - this.globalMin.y) / 2.0;
        this.globalCenter.z = this.globalMin.z + (this.globalMax.z - this.globalMin.z) / 2.0;
    }

    public Point3d getGlobalCenterPoint() {
        return this.globalCenter;
    }

    public void getGlobalCenterPoint(Point3d point3d) {
        point3d.set((Tuple3d)this.globalCenter);
    }

    public void getGlobalMinPoint(Point3d point3d) {
        point3d.set((Tuple3d)this.globalMin);
    }

    public void getGlobalMaxPoint(Point3d point3d) {
        point3d.set((Tuple3d)this.globalMax);
    }

    public void updateOctree() {
        if (this.octree != null) {
            this.octree.update();
        }
    }

    public void cancelOctree() {
        if (this.octree != null) {
            this.octree.cancel();
        }
    }

    public void removeOctree() {
        if (this.octree != null) {
            this.removeUniverseListener(this.octree);
            this.scene.removeChild((Node)this.octree.getRootBranchGroup());
            this.octree = null;
        }
    }

    public VolumeOctree addOctree(String string, String string2) {
        if (this.octree != null) {
            IJ.error((String)"Only one large volume can be displayed a time.\nPlease remove previously displayed volumes first.");
            return null;
        }
        if (this.contents.containsKey(string2)) {
            IJ.error((String)"Name exists already");
            return null;
        }
        try {
            this.octree = new VolumeOctree(string, this.canvas);
            this.octree.getRootBranchGroup().compile();
            this.scene.addChild((Node)this.octree.getRootBranchGroup());
            this.octree.displayInitial();
            this.addUniverseListener(this.octree);
            this.ensureScale(this.octree.realWorldXDim());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.octree;
    }

    public VolumeOctree createAndAddOctree(String string, String string2, String string3) {
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("Not a directory");
        }
        try {
            new FilePreparer(string, 256, string2).createFiles();
            return this.addOctree(string2, string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    public VolumeOctree createAndAddOctree(ImagePlus imagePlus, String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("Not a directory");
        }
        try {
            new FilePreparer(imagePlus, 256, string).createFiles();
            return this.addOctree(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    public Content addContent(ImagePlus imagePlus, Color3f color3f, String string, int n, boolean[] blArray, int n2, int n3) {
        if (this.contents.containsKey(string)) {
            IJ.error((String)("Content named '" + string + "' exists already"));
            return null;
        }
        Content content = new Content(string);
        content.image = imagePlus;
        content.color = color3f;
        content.threshold = n;
        content.channels = blArray;
        content.resamplingF = n2;
        content.setPointListDialog(this.plDialog);
        content.showCoordinateSystem(UniverseSettings.showLocalCoordinateSystemsByDefault);
        content.displayAs(n3);
        content.compile();
        return this.addContent(content);
    }

    public Content addContent(ImagePlus imagePlus, int n) {
        int n2 = Content.getDefaultResamplingFactor(imagePlus, n);
        int n3 = Content.getDefaultThreshold(imagePlus, n);
        return this.addContent(imagePlus, null, imagePlus.getTitle(), n3, new boolean[]{true, true, true}, n2, n);
    }

    public Content addVoltex(ImagePlus imagePlus) {
        return this.addContent(imagePlus, 0);
    }

    public Content addVoltex(ImagePlus imagePlus, Color3f color3f, String string, int n, boolean[] blArray, int n2) {
        return this.addContent(imagePlus, color3f, string, n, blArray, n2, 0);
    }

    public Content addOrthoslice(ImagePlus imagePlus) {
        return this.addContent(imagePlus, 1);
    }

    public Content addOrthoslice(ImagePlus imagePlus, Color3f color3f, String string, int n, boolean[] blArray, int n2) {
        return this.addContent(imagePlus, color3f, string, n, blArray, n2, 1);
    }

    public Content addSurfacePlot(ImagePlus imagePlus) {
        return this.addContent(imagePlus, 3);
    }

    public Content addSurfacePlot(ImagePlus imagePlus, Color3f color3f, String string, int n, boolean[] blArray, int n2) {
        return this.addContent(imagePlus, color3f, string, n, blArray, n2, 3);
    }

    public Content addMesh(ImagePlus imagePlus) {
        return this.addContent(imagePlus, 2);
    }

    public Content addMesh(ImagePlus imagePlus, Color3f color3f, String string, int n, boolean[] blArray, int n2) {
        return this.addContent(imagePlus, color3f, string, n, blArray, n2, 2);
    }

    public Content addCustomMesh(CustomMesh customMesh, String string) {
        if (this.contents.containsKey(string)) {
            IJ.error((String)("Mesh named '" + string + "' exists already"));
            return null;
        }
        Content content = new Content(string);
        content.color = customMesh.getColor();
        content.transparency = customMesh.getTransparency();
        content.shaded = customMesh.isShaded();
        content.showCoordinateSystem(UniverseSettings.showLocalCoordinateSystemsByDefault);
        content.display(new CustomMeshNode(customMesh, content));
        content.setPointListDialog(this.plDialog);
        return this.addContent(content);
    }

    public Content addLineMesh(List<Point3f> list, Color3f color3f, String string, boolean bl) {
        int n = bl ? 1 : 0;
        CustomLineMesh customLineMesh = new CustomLineMesh(list, n, color3f, 0.0f);
        return this.addCustomMesh(customLineMesh, string);
    }

    public Content addPointMesh(List<Point3f> list, Color3f color3f, String string) {
        CustomPointMesh customPointMesh = new CustomPointMesh(list, color3f, 0.0f);
        return this.addCustomMesh(customPointMesh, string);
    }

    public Content addPointMesh(List<Point3f> list, Color3f color3f, float f, String string) {
        CustomPointMesh customPointMesh = new CustomPointMesh(list, color3f, 0.0f);
        customPointMesh.setPointSize(f);
        return this.addCustomMesh(customPointMesh, string);
    }

    public Content addQuadMesh(List<Point3f> list, Color3f color3f, String string) {
        CustomQuadMesh customQuadMesh = new CustomQuadMesh(list, color3f, 0.0f);
        return this.addCustomMesh(customQuadMesh, string);
    }

    public Content addTriangleMesh(List<Point3f> list, Color3f color3f, String string) {
        CustomTriangleMesh customTriangleMesh = new CustomTriangleMesh(list, color3f, 0.0f);
        return this.addCustomMesh(customTriangleMesh, string);
    }

    public Content addMesh(List list, Color3f color3f, String string, float f, int n) {
        Content content = this.addMesh(list, color3f, string, n);
        return content;
    }

    public Content addMesh(List<Point3f> list, Color3f color3f, String string, int n) {
        return this.addTriangleMesh(list, color3f, string);
    }

    public void removeAllContents() {
        String[] stringArray = new String[this.contents.size()];
        this.contents.keySet().toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            this.removeContent(stringArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContent(String string) {
        Object object = this.lock;
        synchronized (object) {
            Content content = this.contents.get(string);
            if (content == null) {
                return;
            }
            this.scene.removeChild((Node)content);
            this.contents.remove(string);
            if (this.selected == content) {
                this.clearSelection();
            }
            this.fireContentRemoved(content);
            this.removeUniverseListener(content);
        }
    }

    @Override
    public Iterator contents() {
        return this.contents.values().iterator();
    }

    public Collection getContents() {
        return this.contents.values();
    }

    public boolean contains(String string) {
        return this.contents.containsKey(string);
    }

    public Content getContent(String string) {
        if (null == string) {
            return null;
        }
        return this.contents.get(string);
    }

    public void resetView() {
        this.fireTransformationStarted();
        Transform3D transform3D = new Transform3D();
        AxisAngle4d axisAngle4d = new AxisAngle4d(1.0, 0.0, 0.0, Math.PI);
        transform3D.set(axisAngle4d);
        this.getRotationTG().setTransform(transform3D);
        transform3D.setIdentity();
        this.getTranslateTG().setTransform(transform3D);
        this.getZoomTG().setTransform(transform3D);
        this.getZoomTG().setTransform(transform3D);
        this.recalculateGlobalMinMax();
        this.getViewPlatformTransformer().centerAt(this.globalCenter);
        double d = (double)this.oldRange / Math.tan(0.39269908169872414);
        this.getViewPlatformTransformer().zoomTo(d);
        this.fireTransformationUpdated();
        this.fireTransformationFinished();
    }

    public void rotateUniverse(Vector3d vector3d, double d) {
        this.viewTransformer.rotate(vector3d, d);
    }

    public void rotateToNegativeXY() {
        this.fireTransformationStarted();
        this.getRotationTG().setTransform(new Transform3D());
        this.fireTransformationFinished();
    }

    public void rotateToPositiveXY() {
        this.fireTransformationStarted();
        this.getRotationTG().setTransform(new Transform3D());
        this.waitForNextFrame();
        this.rotateUniverse(new Vector3d(0.0, 1.0, 0.0), Math.PI);
    }

    public void rotateToNegativeXZ() {
        this.fireTransformationStarted();
        this.getRotationTG().setTransform(new Transform3D());
        this.waitForNextFrame();
        this.rotateUniverse(new Vector3d(1.0, 0.0, 0.0), 1.5707963267948966);
    }

    public void rotateToPositiveXZ() {
        this.fireTransformationStarted();
        this.getRotationTG().setTransform(new Transform3D());
        this.waitForNextFrame();
        this.rotateUniverse(new Vector3d(0.0, 1.0, 0.0), -1.5707963267948966);
    }

    public void rotateToNegativeYZ() {
        this.fireTransformationStarted();
        this.getRotationTG().setTransform(new Transform3D());
        this.waitForNextFrame();
        this.rotateUniverse(new Vector3d(0.0, 1.0, 0.0), 1.5707963267948966);
    }

    public void rotateToPositiveYZ() {
        this.fireTransformationStarted();
        this.getRotationTG().setTransform(new Transform3D());
        this.waitForNextFrame();
        this.rotateUniverse(new Vector3d(1.0, 0.0, 0.0), -1.5707963267948966);
    }

    public void centerSelected(Content content) {
        Point3d point3d = new Point3d();
        content.getContent().getCenter((Tuple3d)point3d);
        Transform3D transform3D = new Transform3D();
        content.getContent().getLocalToVworld(transform3D);
        transform3D.transform(point3d);
        this.getViewPlatformTransformer().centerAt(point3d);
    }

    public void centerAt(Point3d point3d) {
        this.getViewPlatformTransformer().centerAt(point3d);
    }

    public void adjustView() {
        this.recalculateGlobalMinMax();
        float f = (float)(this.globalMin.x - this.globalMax.x);
        float f2 = (float)(this.globalMin.y - this.globalMax.y);
        float f3 = (float)(this.globalMin.z - this.globalMax.z);
        float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.centerAt(this.globalCenter);
        this.ensureScale(0.5f * f4);
    }

    public void adjustView(Content content) {
        this.centerSelected(content);
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        content.getContent().getMin((Tuple3d)point3d);
        content.getContent().getMax((Tuple3d)point3d2);
        float f = (float)(point3d.x - point3d2.x);
        float f2 = (float)(point3d.y - point3d2.y);
        float f3 = (float)(point3d.z - point3d2.z);
        float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.ensureScale(0.5f * f4);
    }

    private void ensureScale(float f) {
        this.oldRange = f;
        double d = (double)f / Math.tan(0.39269908169872414);
        this.getViewPlatformTransformer().zoomTo(d);
    }

    public String allContentsString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : this.contents.keySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public String getSafeContentName(String string) {
        String string2 = string;
        String string3 = string;
        int n = 2;
        while (this.contains(string3)) {
            string3 = string2 + " (" + n + ")";
            ++n;
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addContentToScene(Content content) {
        Object object = this.lock;
        synchronized (object) {
            if (this.contents.containsKey(content.name)) {
                IJ.log((String)("Mesh named '" + content.name + "' exists already"));
                return false;
            }
            this.scene.addChild((Node)content);
            this.contents.put(content.name, content);
            this.recalculateGlobalMinMax(content);
        }
        return true;
    }

    public Content addContent(Content content) {
        try {
            return this.addContentLater(content).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public Future<Content> addContentLater(final Content content) {
        final Image3DUniverse image3DUniverse = this;
        return this.adder.submit(new Callable<Content>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Content call() {
                Object object = Image3DUniverse.this.lock;
                synchronized (object) {
                    if (!Image3DUniverse.this.addContentToScene(content)) {
                        return null;
                    }
                    if (image3DUniverse.autoAdjustView) {
                        image3DUniverse.getViewPlatformTransformer().centerAt(image3DUniverse.globalCenter);
                        float f = (float)(image3DUniverse.globalMax.x - image3DUniverse.globalMin.x);
                        image3DUniverse.ensureScale(f);
                    }
                }
                image3DUniverse.fireContentAdded(content);
                image3DUniverse.addUniverseListener(content);
                image3DUniverse.fireTransformationUpdated();
                return content;
            }
        });
    }

    public Collection<Future<Content>> addContentLater(String string) {
        Map<String, CustomMesh> map = MeshLoader.load(string);
        if (map == null) {
            return null;
        }
        ArrayList<Content> arrayList = new ArrayList<Content>();
        for (Map.Entry<String, CustomMesh> entry : map.entrySet()) {
            String string2 = entry.getKey();
            string2 = this.getSafeContentName(string2);
            CustomMesh customMesh = entry.getValue();
            Content content = new Content(string2);
            content.color = customMesh.getColor();
            content.transparency = customMesh.getTransparency();
            content.shaded = customMesh.isShaded();
            content.showCoordinateSystem(UniverseSettings.showLocalCoordinateSystemsByDefault);
            content.display(new CustomMeshNode(customMesh, content));
            content.setPointListDialog(this.plDialog);
            arrayList.add(content);
        }
        return this.addContentLater(arrayList);
    }

    public Collection<Future<Content>> addContentLater(Collection<Content> collection) {
        final Image3DUniverse image3DUniverse = this;
        ArrayList<Future<Content>> arrayList = new ArrayList<Future<Content>>();
        for (final Content content : collection) {
            arrayList.add(this.adder.submit(new Callable<Content>(){

                @Override
                public Content call() {
                    if (!Image3DUniverse.this.addContentToScene(content)) {
                        return null;
                    }
                    image3DUniverse.fireContentAdded(content);
                    image3DUniverse.addUniverseListener(content);
                    return content;
                }
            }));
        }
        this.adder.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (image3DUniverse.autoAdjustView) {
                    image3DUniverse.getViewPlatformTransformer().centerAt(image3DUniverse.globalCenter);
                    float f = (float)(image3DUniverse.globalMax.x - image3DUniverse.globalMin.x);
                    image3DUniverse.ensureScale(f);
                }
                image3DUniverse.fireTransformationUpdated();
                return true;
            }
        });
        return arrayList;
    }

    static {
        UniverseSettings.load();
    }
}

