/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import ij.util.Tools;
import ij3d.ColorTable;
import ij3d.Content;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import ij3d.Install_J3D;
import java.awt.Window;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import math3d.Transform_IO;
import orthoslice.OrthoGroup;
import voltex.VoltexGroup;

public class ImageJ3DViewer
implements PlugIn {
    public static void main(String[] stringArray) {
        new ImageJ();
        IJ.runPlugIn((String)"ij3d.ImageJ3DViewer", (String)"");
    }

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (ImageJ3DViewer.checkJava3D()) {
            IJ.showMessage((String)"Please restart ImageJ now");
            return;
        }
        try {
            Image3DUniverse image3DUniverse = new Image3DUniverse();
            image3DUniverse.show();
            GUI.center((Window)((Object)image3DUniverse.getWindow()));
            int n = -1;
            if (imagePlus != null && !IJ.isMacro()) {
                image3DUniverse.getExecuter().addContent(imagePlus, n);
            }
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            stringBuffer.append("An unexpected exception occurred. \nPlease mail me the following lines if you \nneed help.\nbene.schmid@gmail.com\n   \n");
            stringBuffer.append(exception.getClass().getName() + ":" + exception.getMessage() + "\n");
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append("    at " + stackTraceElementArray[i].getClassName() + "." + stackTraceElementArray[i].getMethodName() + "(" + stackTraceElementArray[i].getFileName() + ":" + stackTraceElementArray[i].getLineNumber() + ")\n");
            }
            new TextWindow("Error", stringBuffer.toString(), 500, 400);
        }
    }

    public static boolean checkJava3D() {
        String string = Install_J3D.getJava3DVersion();
        System.out.println("version = " + string);
        if (string != null && (double)Float.parseFloat(string) >= 1.5) {
            return false;
        }
        boolean bl = IJ.showMessageWithCancel((String)"Outdated Java 3D version", (String)("Java 3D version " + string + " detected,\n" + "but version >= 1.5 is required.\n" + "Auto-install new version?"));
        if (bl) {
            Install_J3D.autoInstall();
            return true;
        }
        return false;
    }

    private static Image3DUniverse getUniv() {
        if (Image3DUniverse.universes.size() > 0) {
            return Image3DUniverse.universes.get(0);
        }
        return null;
    }

    public static void resetView() {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null) {
            image3DUniverse.resetView();
        }
    }

    public static void startAnimate() {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null) {
            image3DUniverse.startAnimation();
        }
    }

    public static void stopAnimate() {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null) {
            image3DUniverse.pauseAnimation();
        }
    }

    public static void record360() {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse == null) {
            return;
        }
        ImagePlus imagePlus = image3DUniverse.record360();
        if (imagePlus != null) {
            imagePlus.show();
        }
    }

    public static void startFreehandRecording() {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null) {
            image3DUniverse.startFreehandRecording();
        }
    }

    public static void stopFreehandRecording() {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse == null) {
            return;
        }
        ImagePlus imagePlus = image3DUniverse.stopFreehandRecording();
        if (imagePlus != null) {
            imagePlus.show();
        }
    }

    public static void close() {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null) {
            image3DUniverse.close();
        }
    }

    public static void select(String string) {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null) {
            image3DUniverse.select(image3DUniverse.getContent(string));
        }
    }

    public static void add(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        ImagePlus imagePlus = WindowManager.getImage((String)string);
        Color3f color3f = ColorTable.getColor(string2);
        int n = ImageJ3DViewer.getInt(string8);
        int n2 = ImageJ3DViewer.getInt(string4);
        boolean[] blArray = new boolean[]{ImageJ3DViewer.getBoolean(string5), ImageJ3DViewer.getBoolean(string6), ImageJ3DViewer.getBoolean(string7)};
        int n3 = ImageJ3DViewer.getInt(string9);
        image3DUniverse.addContent(imagePlus, color3f, string3, n2, blArray, n, n3);
    }

    public static void addVolume(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        ImagePlus imagePlus = WindowManager.getImage((String)string);
        Color3f color3f = ColorTable.getColor(string2);
        int n = ImageJ3DViewer.getInt(string7);
        boolean[] blArray = new boolean[]{ImageJ3DViewer.getBoolean(string4), ImageJ3DViewer.getBoolean(string5), ImageJ3DViewer.getBoolean(string6)};
        image3DUniverse.addVoltex(imagePlus, color3f, string3, 0, blArray, n);
    }

    public static void addOrthoslice(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        ImagePlus imagePlus = WindowManager.getImage((String)string);
        Color3f color3f = ColorTable.getColor(string2);
        int n = ImageJ3DViewer.getInt(string7);
        boolean[] blArray = new boolean[]{ImageJ3DViewer.getBoolean(string4), ImageJ3DViewer.getBoolean(string5), ImageJ3DViewer.getBoolean(string6)};
        image3DUniverse.addOrthoslice(imagePlus, color3f, string3, 0, blArray, n);
    }

    public static void delete() {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null && image3DUniverse.getSelected() != null) {
            image3DUniverse.removeContent(image3DUniverse.getSelected().getName());
        }
    }

    public static void setSlices(String string, String string2, String string3) {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null && image3DUniverse.getSelected() != null && image3DUniverse.getSelected().getType() == 1) {
            OrthoGroup orthoGroup = (OrthoGroup)image3DUniverse.getSelected().getContent();
            orthoGroup.setSlice(0, ImageJ3DViewer.getInt(string));
            orthoGroup.setSlice(1, ImageJ3DViewer.getInt(string2));
            orthoGroup.setSlice(2, ImageJ3DViewer.getInt(string3));
        }
    }

    public static void fillSelection() {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null && image3DUniverse.getSelected() != null && image3DUniverse.getSelected().getType() == 0) {
            VoltexGroup voltexGroup = (VoltexGroup)image3DUniverse.getSelected().getContent();
            ImageCanvas3D imageCanvas3D = (ImageCanvas3D)image3DUniverse.getCanvas();
            voltexGroup.fillRoi(imageCanvas3D, imageCanvas3D.getRoi(), (byte)0);
        }
    }

    public static void lock() {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null && image3DUniverse.getSelected() != null) {
            image3DUniverse.getSelected().setLocked(true);
        }
    }

    public static void unlock() {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null && image3DUniverse.getSelected() != null) {
            image3DUniverse.getSelected().setLocked(false);
        }
    }

    public static void setChannels(String string, String string2, String string3) {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        boolean bl = Boolean.valueOf(string);
        boolean bl2 = Boolean.valueOf(string2);
        boolean bl3 = Boolean.valueOf(string3);
        if (image3DUniverse != null && image3DUniverse.getSelected() != null) {
            image3DUniverse.getSelected().setChannels(new boolean[]{bl, bl2, bl3});
        }
    }

    public static void setColor(String string, String string2, String string3) {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse == null || image3DUniverse.getSelected() == null) {
            return;
        }
        Content content = image3DUniverse.getSelected();
        try {
            float f = (float)ImageJ3DViewer.getInt(string) / 256.0f;
            float f2 = (float)ImageJ3DViewer.getInt(string2) / 256.0f;
            float f3 = (float)ImageJ3DViewer.getInt(string3) / 256.0f;
            if (image3DUniverse != null && image3DUniverse.getSelected() != null) {
                content.setColor(new Color3f(f, f2, f3));
            }
        }
        catch (NumberFormatException numberFormatException) {
            content.setColor(null);
        }
    }

    public static void setTransparency(String string) {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        float f = Float.parseFloat(string);
        if (image3DUniverse != null && image3DUniverse.getSelected() != null) {
            image3DUniverse.getSelected().setTransparency(f);
        }
    }

    public static void setCoordinateSystem(String string) {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null && image3DUniverse.getSelected() != null) {
            image3DUniverse.getSelected().showCoordinateSystem(ImageJ3DViewer.getBoolean(string));
        }
    }

    public static void setThreshold(String string) {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null && image3DUniverse.getSelected() != null) {
            image3DUniverse.getSelected().setThreshold(ImageJ3DViewer.getInt(string));
        }
    }

    public static void applyTransform(String string) {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null && image3DUniverse.getSelected() != null) {
            String[] stringArray = Tools.split((String)string);
            float[] fArray = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[i] = Float.parseFloat(stringArray[i]);
            }
            image3DUniverse.getSelected().applyTransform(new Transform3D(fArray));
        }
    }

    public static void resetTransform() {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null && image3DUniverse.getSelected() != null) {
            image3DUniverse.getSelected().setTransform(new Transform3D());
        }
    }

    public static void saveTransform(String string, String string2) {
        String[] stringArray = Tools.split((String)string);
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        new Transform_IO().saveAffineTransform(fArray);
    }

    public static void setTransform(String string) {
        Image3DUniverse image3DUniverse = ImageJ3DViewer.getUniv();
        if (image3DUniverse != null && image3DUniverse.getSelected() != null) {
            String[] stringArray = Tools.split((String)string);
            float[] fArray = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[i] = Float.parseFloat(stringArray[i]);
            }
            image3DUniverse.getSelected().setTransform(new Transform3D(fArray));
        }
    }

    private static int getInt(String string) {
        return Integer.parseInt(string);
    }

    private static boolean getBoolean(String string) {
        return new Boolean(string);
    }
}

