/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij.gui.YesNoCancelDialog;
import ij.plugin.PlugIn;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.media.j3d.VirtualUniverse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Install_J3D
implements PlugIn {
    private static final String JAVA3D_BASE_URL = "http://download.java.net/media/java3d/builds/release/1.5.2/";
    private static final String JOGL_BASE_URL = "http://download.java.net/media/jogl/builds/archive/jsr-231-1.1.1/";
    private static final String WIN_32 = "j3d-1_5_2-windows-i586.zip";
    private static final String WIN_64 = "j3d-1_5_2-windows-amd64.zip";
    private static final String LIN_32 = "j3d-1_5_2-linux-i586.zip";
    private static final String LIN_64 = "j3d-1_5_2-linux-amd64.zip";
    private static final String MAC = "j3d-1_5_2-macosx.zip";
    private static final String JOGL_PPC = "jogl-1.1.1-macosx-ppc.zip";
    private static final String JOGL_ITL = "jogl-1.1.1-macosx-universal.zip";
    private static final String TMP = System.getProperty("java.io.tmpdir");
    private static final String JRE = System.getProperty("java.home");

    public static void main(String[] stringArray) {
        new Install_J3D();
        Install_J3D.autoInstall();
    }

    public void run(String string) {
        Install_J3D.autoInstall();
    }

    public static String getJava3DVersion() {
        try {
            Class.forName("javax.media.j3d.VirtualUniverse");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        VirtualUniverse virtualUniverse = new VirtualUniverse();
        return (String)virtualUniverse.getProperties().get("j3d.specification.version");
    }

    public static void autoInstall() {
        String string = null;
        if (IJ.isLinux()) {
            string = IJ.is64Bit() ? LIN_64 : LIN_32;
        } else if (IJ.isWindows()) {
            string = IJ.is64Bit() ? WIN_64 : WIN_32;
        } else if (IJ.isMacOSX()) {
            string = MAC;
        }
        if (string == null) {
            Install_J3D.println("could not detect operating system");
            return;
        }
        try {
            Install_J3D.installJava3D(string);
            if (IJ.isMacOSX()) {
                string = Install_J3D.isPPC() ? JOGL_PPC : JOGL_ITL;
                Install_J3D.installJogl(string);
            }
        }
        catch (Exception exception) {
            IJ.error((String)exception.getMessage());
            Install_J3D.println(exception.getMessage());
            exception.printStackTrace();
            return;
        }
        Install_J3D.print("Installation successful!");
    }

    public static boolean isPPC() {
        String string = System.getProperty("os.arch");
        return string.startsWith("ppc");
    }

    public static void installJogl(String string) throws Exception {
        Install_J3D.println("Detecting Mac OS X operating system, installing Jogl");
        File file = Install_J3D.download(JOGL_BASE_URL + string);
        File file2 = Install_J3D.createFolder(TMP, "jogl", false);
        List<File> list = Install_J3D.unzip(file, file2, null);
        String string2 = Install_J3D.getFirstExtDir();
        if (!new File(string2).canWrite()) {
            throw new Exception("No permissions to write to " + string2);
        }
        for (File file3 : list) {
            if (!file3.getName().endsWith(".jar") && !file3.getName().endsWith(".jnilib")) continue;
            File file4 = new File(string2, file3.getName());
            Install_J3D.println("moving " + file3.getAbsolutePath() + " to " + file4.getAbsolutePath());
            if (file3.renameTo(file4)) continue;
            Install_J3D.println("could not move " + file3.getAbsolutePath() + " to " + file4.getAbsolutePath());
        }
        Install_J3D.rm(file2);
    }

    public static String getFirstExtDir() throws Exception {
        String string = System.getProperty("java.ext.dirs");
        if (string == null) {
            throw new Exception("Can't detect java extension directory");
        }
        return string.split(File.pathSeparator)[0];
    }

    public static void installJava3D(String string) throws Exception {
        File file;
        File file2 = Install_J3D.download(JAVA3D_BASE_URL + string);
        List<File> list = Install_J3D.unzip(file2, file = Install_J3D.createFolder(TMP, "java3d", false), "j3d-jre.zip");
        if (list.size() == 0) {
            throw new Exception("Could not find j3d-jre.zip in " + file2);
        }
        File file3 = list.get(0);
        if (!IJ.isMacOSX()) {
            list = Install_J3D.unzip(file3, new File(JRE), null);
            return;
        }
        list = Install_J3D.unzip(file3, file, null);
        String string2 = Install_J3D.getFirstExtDir();
        Install_J3D.println("Found java extension folder: " + string2);
        if (!new File(string2).canWrite()) {
            throw new Exception("No permissions to write to " + string2);
        }
        for (File file4 : list) {
            File file5 = new File(string2, file4.getName());
            Install_J3D.println("moving " + file4.getAbsolutePath() + " to " + file5.getAbsolutePath());
            if (file4.renameTo(file5)) continue;
            Install_J3D.println("could not move " + file4.getAbsolutePath() + " to " + file5.getAbsolutePath());
        }
        Install_J3D.rm(file);
    }

    public static File createFolder(String string, String string2, boolean bl) throws Exception {
        Install_J3D.println("create folder " + string + "/" + string2);
        File file = new File(string);
        if (!file.canWrite()) {
            throw new Exception("No permissions to write to folder " + string);
        }
        File file2 = new File(string, string2);
        if (!file2.exists()) {
            if (!file2.mkdir()) {
                throw new Exception("Can't create directory " + file2.getAbsolutePath());
            }
            return file2;
        }
        if (bl) {
            throw new Exception("Can't create directory " + file2.getAbsolutePath() + ": File exists already");
        }
        Install_J3D.println(file2.getAbsolutePath() + " not created; exists already");
        return file2;
    }

    public static File download(String string) throws Exception {
        Object object;
        Install_J3D.print("downloading " + string);
        InputStream inputStream = null;
        URL uRL = null;
        try {
            uRL = new URL(string);
            object = uRL.openConnection();
            inputStream = ((URLConnection)object).getInputStream();
        }
        catch (MalformedURLException malformedURLException) {
            throw new Exception(string + " is not a valid URL");
        }
        catch (IOException iOException) {
            throw new Exception("Can't open connection to " + string);
        }
        object = Install_J3D.readFully(inputStream);
        File file = new File(TMP, new File(uRL.getFile()).getName());
        Install_J3D.println(" to " + file.getAbsolutePath());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write((byte[])object);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Exception("Could not open " + file.getAbsolutePath() + " for writing. " + "Maybe not enough permissions?");
        }
        catch (IOException iOException) {
            throw new Exception("Error writing to " + file.getAbsolutePath());
        }
        return file;
    }

    public static List<File> unzip(File file, File file2, String string) throws Exception {
        Install_J3D.println("Extracting " + (string != null ? string : "all") + " to " + file2.getAbsolutePath());
        if (!file2.canWrite()) {
            throw new Exception("No permissions to write to folder " + file2);
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException zipException) {
            throw new Exception(file.getAbsolutePath() + " is not a valid zip file.");
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ArrayList<File> arrayList = new ArrayList<File>();
        while (enumeration.hasMoreElements()) {
            Object object;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) {
                object = Install_J3D.createFolder(file2.getAbsolutePath(), zipEntry.getName(), false);
                continue;
            }
            if (string != null && !zipEntry.getName().endsWith(string)) continue;
            Install_J3D.println("Extracting " + zipEntry.getName() + " to " + file2);
            object = null;
            try {
                object = zipFile.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                throw new Exception("Can't extract " + zipEntry.getName());
            }
            byte[] byArray = Install_J3D.readFully((InputStream)object);
            File file3 = new File(file2, zipEntry.getName());
            if (!Install_J3D.overwrite(file3)) continue;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Exception("Could not open " + file3.getAbsolutePath() + " for writing. " + "Maybe not enough permissions?");
            }
            catch (IOException iOException) {
                throw new Exception("Error writing to " + file3.getAbsolutePath());
            }
            arrayList.add(file3);
        }
        return arrayList;
    }

    public static byte[] readFully(InputStream inputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        try {
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new Exception("Error reading from " + inputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static boolean overwrite(File file) {
        if (!file.exists()) {
            return true;
        }
        YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)(IJ.getInstance() != null ? IJ.getInstance() : new Frame()), "Overwrite?", file.getAbsolutePath() + " exists already\n" + "Press OK to overwrite, or Cancel/No to skip");
        return yesNoCancelDialog.yesPressed();
    }

    static void println(String string) {
        IJ.log((String)string);
    }

    static void print(String string) {
        IJ.log((String)string);
    }

    static void rm(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                Install_J3D.rm(file2);
            }
        }
        file.delete();
    }
}

