/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import java.awt.Frame;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

public class ScenegraphDebugger {
    public static void displayTree(Node node) {
        ScenegraphDebugger.displayTree(node, "");
    }

    private static void displayTree(Node node, String string) {
        System.out.println(string + node);
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                ScenegraphDebugger.displayTree((Node)enumeration.nextElement(), string + "   ");
            }
        }
    }

    public static void showTree(Node node) {
        JTree jTree = new JTree(new J3DNode(node, null));
        Frame frame = null;
        JDialog jDialog = new JDialog(frame, "Scenegraph");
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jDialog.getContentPane().add(jScrollPane);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    private static class J3DNode
    implements TreeNode {
        private Node node;
        private J3DNode parent;
        private J3DNode[] children = null;

        public J3DNode(Node node, J3DNode j3DNode) {
            this.node = node;
            this.parent = j3DNode;
            if (this.node instanceof Group) {
                Group group = (Group)this.node;
                this.children = new J3DNode[group.numChildren()];
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i] = new J3DNode(group.getChild(i), this);
                }
            }
        }

        public Enumeration children() {
            if (this.children != null) {
                return Collections.enumeration(Arrays.asList(this.children));
            }
            return null;
        }

        public boolean getAllowsChildren() {
            return this.node instanceof Group;
        }

        public TreeNode getChildAt(int n) {
            if (!(this.node instanceof Group)) {
                return null;
            }
            return this.children[n];
        }

        public int getChildCount() {
            return this.children.length;
        }

        public int getIndex(TreeNode treeNode) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!this.children[i].equals(treeNode)) continue;
                return i;
            }
            return -1;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            return !(this.node instanceof Group);
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

