/*
 * Decompiled with CFR 0.152.
 */
package ij3d.behaviors;

import ij3d.Content;
import ij3d.DefaultUniverse;
import ij3d.ImageCanvas3D;
import ij3d.behaviors.BehaviorCallback;
import java.awt.event.MouseEvent;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ContentTransformer {
    private Initializer initializer;
    private DefaultUniverse univ;
    private ImageCanvas3D canvas;
    private BehaviorCallback callback;
    private Content content;
    private Vector3d axisPerDx = new Vector3d();
    private Vector3d axisPerDy = new Vector3d();
    private double anglePerPix;
    private AxisAngle4d aaX = new AxisAngle4d();
    private AxisAngle4d aaY = new AxisAngle4d();
    private Transform3D transX = new Transform3D();
    private Transform3D transY = new Transform3D();
    private Transform3D transl = new Transform3D();
    private Transform3D transl_inv = new Transform3D();
    private Vector3d translationPerDx = new Vector3d();
    private Vector3d translationPerDy = new Vector3d();
    private TransformGroup translateTG;
    private TransformGroup rotateTG;
    private int xLast;
    private int yLast;
    private Transform3D translateNew = new Transform3D();
    private Transform3D translateOld = new Transform3D();
    private Vector3d translation = new Vector3d();
    private Point3d v1 = new Point3d();
    private Point3d v2 = new Point3d();
    private Transform3D rotateNew = new Transform3D();
    private Transform3D rotateOld = new Transform3D();

    public ContentTransformer(DefaultUniverse defaultUniverse, BehaviorCallback behaviorCallback) {
        this.univ = defaultUniverse;
        this.canvas = (ImageCanvas3D)defaultUniverse.getCanvas();
        this.callback = behaviorCallback;
        this.initializer = new Initializer();
    }

    public void init(Content content, int n, int n2) {
        this.initializer.init(content, n, n2);
    }

    public void translate(MouseEvent mouseEvent) {
        this.translate(mouseEvent.getX(), mouseEvent.getY());
    }

    public void rotate(MouseEvent mouseEvent) {
        this.rotate(mouseEvent.getX(), mouseEvent.getY());
    }

    private void translate(int n, int n2) {
        if (this.content == null || this.content.isLocked()) {
            return;
        }
        int n3 = n - this.xLast;
        int n4 = n2 - this.yLast;
        this.translateTG.getTransform(this.translateOld);
        this.v1.scale((double)n3, (Tuple3d)this.translationPerDx);
        this.v2.scale((double)(-n4), (Tuple3d)this.translationPerDy);
        this.translation.add((Tuple3d)this.v1, (Tuple3d)this.v2);
        this.translateNew.set(this.translation);
        this.translateNew.mul(this.translateOld);
        this.translateTG.setTransform(this.translateNew);
        this.transformChanged(0, this.translateNew);
        this.xLast = n;
        this.yLast = n2;
    }

    private void rotate(int n, int n2) {
        if (this.content == null || this.content.isLocked()) {
            return;
        }
        int n3 = n - this.xLast;
        int n4 = n2 - this.yLast;
        this.aaX.set(this.axisPerDx, (double)n3 * this.anglePerPix);
        this.aaY.set(this.axisPerDy, (double)n4 * this.anglePerPix);
        this.transX.set(this.aaX);
        this.transY.set(this.aaY);
        this.rotateTG.getTransform(this.rotateOld);
        this.rotateNew.set(this.transl_inv);
        this.rotateNew.mul(this.transY);
        this.rotateNew.mul(this.transX);
        this.rotateNew.mul(this.transl);
        this.rotateNew.mul(this.rotateOld);
        this.rotateTG.setTransform(this.rotateNew);
        this.xLast = n;
        this.yLast = n2;
        this.transformChanged(0, this.rotateNew);
    }

    private void transformChanged(int n, Transform3D transform3D) {
        if (this.callback != null) {
            this.callback.transformChanged(n, transform3D);
        }
    }

    private class Initializer {
        private Point3d centerInVWorld = new Point3d();
        private Point3d centerInIp = new Point3d();
        private Transform3D ipToVWorld = new Transform3D();
        private Transform3D ipToVWorldInverse = new Transform3D();
        private Transform3D localToVWorld = new Transform3D();
        private Transform3D localToVWorldInverse = new Transform3D();
        private Point3d eyePtInVWorld = new Point3d();
        private Point3d pickPtInVWorld = new Point3d();
        private Point3d p1 = new Point3d();
        private Point3d p2 = new Point3d();
        private Point3d p3 = new Point3d();
        private Vector3d vec = new Vector3d();

        private Initializer() {
        }

        private void init(Content content, int n, int n2) {
            ContentTransformer.this.xLast = n;
            ContentTransformer.this.yLast = n2;
            ContentTransformer.this.content = content;
            content.getLocalToVworld(this.localToVWorld);
            this.localToVWorldInverse.invert(this.localToVWorld);
            ContentTransformer.this.canvas.getImagePlateToVworld(this.ipToVWorld);
            this.ipToVWorldInverse.invert(this.ipToVWorld);
            content.getContent().getCenter((Tuple3d)this.centerInVWorld);
            this.localToVWorld.transform(this.centerInVWorld);
            this.ipToVWorldInverse.transform(this.centerInVWorld, this.centerInIp);
            ContentTransformer.this.canvas.getCenterEyeInImagePlate(this.eyePtInVWorld);
            this.ipToVWorld.transform(this.eyePtInVWorld);
            Point3d point3d = ContentTransformer.this.univ.getPicker().getPickPointGeometry(content, n, n2);
            float f = 0.0f;
            float f2 = 0.0f;
            if (point3d != null) {
                this.pickPtInVWorld.set((Tuple3d)point3d);
                this.localToVWorld.transform(this.pickPtInVWorld);
                f = (float)this.pickPtInVWorld.distance(this.centerInVWorld);
            } else {
                content.getContent().getMin((Tuple3d)this.p1);
                this.localToVWorld.transform(this.p1);
                f = (float)this.p1.distance(this.centerInVWorld);
                this.vec.sub((Tuple3d)this.centerInVWorld, (Tuple3d)this.eyePtInVWorld);
                this.vec.normalize();
                this.vec.scale((double)(-f));
                this.pickPtInVWorld.add((Tuple3d)this.centerInVWorld, (Tuple3d)this.vec);
            }
            f2 = (float)this.pickPtInVWorld.distance(this.eyePtInVWorld);
            ContentTransformer.this.canvas.getPixelLocationInImagePlate(n, n2, this.p1);
            this.ipToVWorld.transform(this.p1);
            float f3 = (float)this.p1.distance(this.eyePtInVWorld);
            ContentTransformer.this.canvas.getPixelLocationInImagePlate(n + 1, n2, this.p2);
            this.ipToVWorld.transform(this.p2);
            float f4 = (float)this.p1.distance(this.p2);
            ContentTransformer.this.canvas.getPixelLocationInImagePlate(n, n2 + 1, this.p3);
            this.ipToVWorld.transform(this.p3);
            float f5 = (float)this.p1.distance(this.p3);
            float f6 = f2 / f3 * f4;
            float f7 = f2 / f3 * f5;
            ContentTransformer.this.anglePerPix = Math.atan2(f6, f);
            ContentTransformer.this.univ.getViewPlatformTransformer().getYDir(ContentTransformer.this.axisPerDx, this.ipToVWorld);
            ContentTransformer.this.univ.getViewPlatformTransformer().getXDir(ContentTransformer.this.axisPerDy, this.ipToVWorld);
            ContentTransformer.this.translationPerDx.set((Tuple3d)ContentTransformer.this.axisPerDy);
            ContentTransformer.this.translationPerDx.scale((double)f6);
            ContentTransformer.this.translationPerDy.set((Tuple3d)ContentTransformer.this.axisPerDx);
            ContentTransformer.this.translationPerDy.scale((double)f7);
            ContentTransformer.this.rotateTG = content.getLocalRotate();
            ContentTransformer.this.translateTG = content.getLocalTranslate();
            content.getContent().getCenter((Tuple3d)this.vec);
            ContentTransformer.this.transl_inv.set(this.vec);
            this.vec.set(-this.vec.x, -this.vec.y, -this.vec.z);
            ContentTransformer.this.transl.set(this.vec);
        }
    }
}

