/*
 * Decompiled with CFR 0.152.
 */
package ij3d.behaviors;

import com.sun.j3d.utils.pickfast.PickCanvas;
import com.sun.j3d.utils.pickfast.PickTool;
import ij.IJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij3d.Content;
import ij3d.DefaultUniverse;
import ij3d.ImageCanvas3D;
import java.awt.event.MouseEvent;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.PickInfo;
import javax.media.j3d.SceneGraphPath;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import vib.BenesNamedPoint;
import vib.PointList;

public class Picker {
    private DefaultUniverse univ;
    private ImageCanvas3D canvas;
    private int movingIndex = -1;

    public Picker(DefaultUniverse defaultUniverse) {
        this.univ = defaultUniverse;
        this.canvas = (ImageCanvas3D)defaultUniverse.getCanvas();
    }

    public void deletePoint(Content content, MouseEvent mouseEvent) {
        float f;
        if (content == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Point3d point3d = this.getPickPointGeometry(content, mouseEvent);
        if (point3d == null) {
            return;
        }
        PointList pointList = content.getPointList();
        int n = pointList.indexOfPointAt(point3d.x, point3d.y, point3d.z, f = content.getLandmarkPointSize());
        if (n != -1) {
            pointList.remove(n);
        }
    }

    public synchronized void movePoint(Content content, MouseEvent mouseEvent) {
        if (content == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Point3d point3d = this.getPickPointGeometry(content, mouseEvent);
        if (point3d == null) {
            return;
        }
        PointList pointList = content.getPointList();
        if (this.movingIndex == -1) {
            this.movingIndex = pointList.indexOfPointAt(point3d.x, point3d.y, point3d.z, content.getLandmarkPointSize());
        }
        if (this.movingIndex != -1) {
            pointList.placePoint(pointList.get(this.movingIndex), point3d.x, point3d.y, point3d.z);
        }
    }

    public synchronized void stopMoving() {
        this.movingIndex = -1;
    }

    public void addPoint(Content content, int n, int n2) {
        float f;
        if (content == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Point3d point3d = this.getPickPointGeometry(content, n, n2);
        if (point3d == null) {
            return;
        }
        PointList pointList = content.getPointList();
        BenesNamedPoint benesNamedPoint = pointList.pointAt(point3d.x, point3d.y, point3d.z, f = content.getLandmarkPointSize());
        if (benesNamedPoint == null) {
            pointList.add(point3d.x, point3d.y, point3d.z);
        }
    }

    public void addPoint(Content content, MouseEvent mouseEvent) {
        float f;
        if (content == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Point3d point3d = this.getPickPointGeometry(content, mouseEvent);
        if (point3d == null) {
            return;
        }
        PointList pointList = content.getPointList();
        BenesNamedPoint benesNamedPoint = pointList.pointAt(point3d.x, point3d.y, point3d.z, f = content.getLandmarkPointSize());
        if (benesNamedPoint == null) {
            pointList.add(point3d.x, point3d.y, point3d.z);
        }
    }

    public Point3d getPickPointGeometry(Content content, Point3d point3d, Vector3d vector3d) {
        PickTool pickTool = new PickTool((BranchGroup)content);
        pickTool.setShapeRay(point3d, vector3d);
        pickTool.setMode(2);
        pickTool.setFlags(8);
        try {
            PickInfo[] pickInfoArray = pickTool.pickAllSorted();
            if (pickInfoArray == null || pickInfoArray.length == 0) {
                return null;
            }
            for (int i = 0; i < pickInfoArray.length; ++i) {
                Point3d point3d2 = pickInfoArray[i].getClosestIntersectionPoint();
                if (content.getType() != 0) {
                    return point3d2;
                }
                float f = Picker.getVolumePoint(content, point3d2);
                if (!(f > 20.0f)) continue;
                return point3d2;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Point3d getPickPointGeometry(Content content, MouseEvent mouseEvent) {
        return this.getPickPointGeometry(content, mouseEvent.getX(), mouseEvent.getY());
    }

    public Point3d getPickPointGeometry(Content content, int n, int n2) {
        PickCanvas pickCanvas = new PickCanvas((Canvas3D)this.canvas, this.univ.getScene());
        pickCanvas.setMode(2);
        pickCanvas.setFlags(8);
        pickCanvas.setTolerance(3.0f);
        pickCanvas.setShapeLocation(n, n2);
        try {
            PickInfo[] pickInfoArray = pickCanvas.pickAllSorted();
            if (pickInfoArray == null || pickInfoArray.length == 0) {
                return null;
            }
            for (int i = 0; i < pickInfoArray.length; ++i) {
                Point3d point3d = pickInfoArray[i].getClosestIntersectionPoint();
                if (content.getType() != 0) {
                    return point3d;
                }
                float f = Picker.getVolumePoint(content, point3d);
                if (!(f > 20.0f)) continue;
                return point3d;
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Content getPickedContent(int n, int n2) {
        PickCanvas pickCanvas = new PickCanvas((Canvas3D)this.canvas, this.univ.getScene());
        pickCanvas.setMode(2);
        pickCanvas.setFlags(9);
        pickCanvas.setTolerance(3.0f);
        pickCanvas.setShapeLocation(n, n2);
        try {
            PickInfo[] pickInfoArray = pickCanvas.pickAllSorted();
            if (pickInfoArray == null) {
                return null;
            }
            for (int i = 0; i < pickInfoArray.length; ++i) {
                SceneGraphPath sceneGraphPath = pickInfoArray[i].getSceneGraphPath();
                Content content = null;
                for (int j = sceneGraphPath.nodeCount() - 1; j >= 0; --j) {
                    if (!(sceneGraphPath.getNode(j) instanceof Content)) continue;
                    content = (Content)sceneGraphPath.getNode(j);
                }
                if (content == null) continue;
                if (content.getType() != 0) {
                    return content;
                }
                Point3d point3d = pickInfoArray[i].getClosestIntersectionPoint();
                float f = Picker.getVolumePoint(content, point3d);
                if (!(f > 20.0f)) continue;
                return content;
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static float getVolumePoint(Content content, Point3d point3d) {
        ImagePlus imagePlus = content.getImage();
        Calibration calibration = imagePlus.getCalibration();
        double d = calibration.pixelWidth;
        double d2 = calibration.pixelHeight;
        double d3 = calibration.pixelDepth;
        int n = (int)Math.round(point3d.x / d);
        int n2 = (int)Math.round(point3d.y / d2);
        int n3 = (int)Math.round(point3d.z / d3);
        if (n3 < 0 || n3 >= imagePlus.getStackSize() || n2 < 0 || n2 >= imagePlus.getHeight() || n < 0 || n >= imagePlus.getWidth()) {
            return 0.0f;
        }
        return imagePlus.getStack().getProcessor(n3 + 1).getf(n, n2);
    }
}

