/*
 * Decompiled with CFR 0.152.
 */
package ij3d.behaviors;

import ij3d.DefaultUniverse;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import ij3d.behaviors.BehaviorCallback;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ViewPlatformTransformer {
    protected DefaultUniverse univ;
    protected ImageCanvas3D canvas;
    protected final Point3d rotCenter = new Point3d();
    private BehaviorCallback callback;
    private TransformGroup centerTG;
    private TransformGroup rotationTG;
    private TransformGroup zoomTG;
    private TransformGroup translateTG;
    private Transform3D centerXform = new Transform3D();
    private Transform3D rotationXform = new Transform3D();
    private Transform3D zoomXform = new Transform3D();
    private Transform3D translateXform = new Transform3D();
    private Point3d origin = new Point3d(0.0, 0.0, 0.0);
    private Point3d eyePos = new Point3d();
    private final Point3d oneInX = new Point3d(1.0, 0.0, 0.0);
    private final Point3d oneInY = new Point3d(0.0, 1.0, 0.0);
    private final Point3d oneInZ = new Point3d(0.0, 0.0, 1.0);
    private Vector3d zDir = new Vector3d();
    private Vector3d xDir = new Vector3d();
    private Vector3d yDir = new Vector3d();
    private Vector3d centerV = new Vector3d();
    private Transform3D ipToVWorld = new Transform3D();
    private Transform3D tmp = new Transform3D();
    private Point2d originInCanvas = new Point2d();
    private Point3d originOnIp = new Point3d();
    private Point3d currentPtOnIp = new Point3d();
    private AxisAngle4d aa = new AxisAngle4d();
    private Vector3d tmpV = new Vector3d();
    private AxisAngle4d aa2 = new AxisAngle4d();
    private Transform3D tmp2 = new Transform3D();
    private Point3d tmpP = new Point3d();
    private Transform3D ipToVWorldInverse = new Transform3D();

    public ViewPlatformTransformer(DefaultUniverse defaultUniverse, BehaviorCallback behaviorCallback) {
        this.univ = defaultUniverse;
        this.canvas = (ImageCanvas3D)defaultUniverse.getCanvas();
        this.callback = behaviorCallback;
        this.centerTG = defaultUniverse.getCenterTG();
        this.rotationTG = defaultUniverse.getRotationTG();
        this.zoomTG = defaultUniverse.getZoomTG();
        this.translateTG = defaultUniverse.getTranslateTG();
        ((Image3DUniverse)defaultUniverse).getGlobalCenterPoint(this.rotCenter);
    }

    public void getRotationCenter(Tuple3d tuple3d) {
        tuple3d.set((Tuple3d)this.rotCenter);
    }

    public void zoomTo(double d) {
        this.zDir.set(0.0, 0.0, 1.0);
        this.zDir.scale(d);
        this.zoomXform.set(this.zDir);
        this.zoomTG.setTransform(this.zoomXform);
        this.univ.getViewer().getView().setBackClipDistance(5.0 * d);
        this.univ.getViewer().getView().setFrontClipDistance(5.0 * d / 100.0);
        this.transformChanged(0, this.zoomXform);
    }

    public void zoom(int n) {
        this.origin.set(0.0, 0.0, 0.0);
        this.canvas.getCenterEyeInImagePlate(this.eyePos);
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.ipToVWorld.transform(this.eyePos);
        float f = (float)this.eyePos.distance(this.origin);
        this.originInCanvas(this.originInCanvas);
        this.canvas.getPixelLocationInImagePlate(this.originInCanvas, this.originOnIp);
        this.ipToVWorld.transform(this.originOnIp);
        float f2 = (float)this.eyePos.distance(this.originOnIp);
        this.canvas.getPixelLocationInImagePlate((int)Math.round(this.originInCanvas.x + 5.0), (int)Math.round(this.originInCanvas.y), this.currentPtOnIp);
        this.ipToVWorld.transform(this.currentPtOnIp);
        float f3 = (float)this.originOnIp.distance(this.currentPtOnIp);
        this.zDir.set(0.0, 0.0, -1.0);
        float f4 = f3 * f / f2;
        this.zDir.scale((double)((float)n * f4));
        this.zoomTG.getTransform(this.zoomXform);
        this.tmp.set(this.zDir);
        this.zoomXform.mul(this.tmp, this.zoomXform);
        this.zoomTG.setTransform(this.zoomXform);
        this.zoomXform.get(this.centerV);
        double d = this.centerV.length();
        this.univ.getViewer().getView().setBackClipDistance(5.0 * d);
        this.univ.getViewer().getView().setFrontClipDistance(5.0 * d / 100.0);
        this.transformChanged(0, this.zoomXform);
    }

    public void centerAt(Point3d point3d) {
        this.centerV.set(point3d.x, point3d.y, point3d.z);
        this.centerXform.set(this.centerV);
        this.centerTG.setTransform(this.centerXform);
        this.centerXform.setIdentity();
        this.translateTG.setTransform(this.centerXform);
        this.transformChanged(0, this.centerXform);
        this.rotCenter.set((Tuple3d)point3d);
    }

    public void translateXY(int n, int n2) {
        this.origin.set(0.0, 0.0, 0.0);
        this.canvas.getCenterEyeInImagePlate(this.eyePos);
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.ipToVWorld.transform(this.eyePos);
        float f = (float)this.eyePos.distance(this.origin);
        this.originInCanvas(this.originInCanvas);
        this.canvas.getPixelLocationInImagePlate(this.originInCanvas, this.originOnIp);
        this.ipToVWorld.transform(this.originOnIp);
        float f2 = (float)this.eyePos.distance(this.originOnIp);
        this.canvas.getPixelLocationInImagePlate((int)Math.round(this.originInCanvas.x + 1.0), (int)Math.round(this.originInCanvas.y), this.currentPtOnIp);
        this.ipToVWorld.transform(this.currentPtOnIp);
        float f3 = (float)this.originOnIp.distance(this.currentPtOnIp);
        this.canvas.getPixelLocationInImagePlate((int)Math.round(this.originInCanvas.x), (int)Math.round(this.originInCanvas.y + 1.0), this.currentPtOnIp);
        this.ipToVWorld.transform(this.currentPtOnIp);
        float f4 = (float)this.originOnIp.distance(this.currentPtOnIp);
        float f5 = f3 * (float)n * f / f2;
        float f6 = f4 * (float)n2 * f / f2;
        this.translateXY(f5, f6);
    }

    public void translate(Vector3d vector3d) {
        this.getTranslateTranslation(this.tmpV);
        this.tmpV.sub((Tuple3d)vector3d);
        this.translateXform.set(this.tmpV);
        this.translateTG.setTransform(this.translateXform);
        this.transformChanged(0, this.translateXform);
    }

    public void translateXY(double d, double d2) {
        this.getXDir(this.xDir);
        this.getYDir(this.yDir);
        this.xDir.scale(d);
        this.yDir.scale(d2);
        this.xDir.add((Tuple3d)this.yDir);
        this.translate(this.xDir);
    }

    public void rotateX(double d) {
        this.xDir.set(1.0, 0.0, 0.0);
        this.rotate(this.xDir, d);
    }

    public void rotateY(double d) {
        this.yDir.set(0.0, 1.0, 0.0);
        this.rotate(this.yDir, d);
    }

    public void rotateZ(double d) {
        this.zDir.set(0.0, 0.0, 1.0);
        this.rotate(this.zDir, d);
    }

    public void rotate(Vector3d vector3d, double d) {
        Vector3d vector3d2 = new Vector3d();
        this.getAxisVworld(vector3d, vector3d2);
        this.aa.set(vector3d2, d);
        this.tmp.set(this.aa);
        this.rotationTG.getTransform(this.rotationXform);
        this.rotationXform.mul(this.tmp, this.rotationXform);
        this.rotationTG.setTransform(this.rotationXform);
        this.transformChanged(0, this.rotationXform);
    }

    public void rotateXY(double d, double d2) {
        this.getXDir(this.xDir);
        this.aa.set(this.xDir, d);
        this.tmp.set(this.aa);
        this.getYDir(this.yDir);
        this.aa2.set(this.yDir, d2);
        this.tmp2.set(this.aa2);
        this.rotationTG.getTransform(this.rotationXform);
        this.rotationXform.mul(this.tmp, this.rotationXform);
        this.rotationXform.mul(this.tmp2, this.rotationXform);
        this.rotationTG.setTransform(this.rotationXform);
        this.transformChanged(0, this.rotationXform);
    }

    public void getTranslateTranslation(Vector3d vector3d) {
        this.translateTG.getTransform(this.tmp);
        this.tmp.get(vector3d);
    }

    public void getCenterTranslation(Vector3d vector3d) {
        this.centerTG.getTransform(this.tmp);
        this.tmp.get(vector3d);
    }

    public void getZoomTranslation(Vector3d vector3d) {
        this.zoomTG.getTransform(this.tmp);
        this.tmp.get(vector3d);
    }

    public void originInCanvas(Point2d point2d) {
        this.origin.set(0.0, 0.0, 0.0);
        this.pointInCanvas(this.origin, point2d);
    }

    public void pointInCanvas(Point3d point3d, Point2d point2d) {
        this.tmpP.set((Tuple3d)point3d);
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.ipToVWorldInverse.invert(this.ipToVWorld);
        this.ipToVWorldInverse.transform(point3d);
        this.canvas.getPixelLocationFromImagePlate(point3d, point2d);
    }

    public double distanceEyeTo(Point3d point3d) {
        this.canvas.getCenterEyeInImagePlate(this.eyePos);
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.ipToVWorld.transform(this.eyePos);
        return this.eyePos.distance(point3d);
    }

    public double distanceEyeOrigin() {
        this.origin.set(0.0, 0.0, 0.0);
        return this.distanceEyeTo(this.origin);
    }

    public void getAxisVworld(Vector3d vector3d, Vector3d vector3d2) {
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.origin.set(0.0, 0.0, 0.0);
        this.oneInX.set((Tuple3d)vector3d);
        this.ipToVWorld.transform(this.oneInX);
        this.ipToVWorld.transform(this.origin);
        vector3d2.sub((Tuple3d)this.oneInX, (Tuple3d)this.origin);
        vector3d2.normalize();
    }

    public void getXDir(Vector3d vector3d) {
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.getXDir(vector3d, this.ipToVWorld);
    }

    public void getXDir(Vector3d vector3d, Transform3D transform3D) {
        this.origin.set(0.0, 0.0, 0.0);
        this.oneInX.set(1.0, 0.0, 0.0);
        transform3D.transform(this.oneInX);
        transform3D.transform(this.origin);
        vector3d.sub((Tuple3d)this.oneInX, (Tuple3d)this.origin);
        vector3d.normalize();
    }

    public void getYDir(Vector3d vector3d) {
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.getYDir(vector3d, this.ipToVWorld);
    }

    public void getYDir(Vector3d vector3d, Transform3D transform3D) {
        this.origin.set(0.0, 0.0, 0.0);
        this.oneInY.set(0.0, 1.0, 0.0);
        transform3D.transform(this.oneInY);
        transform3D.transform(this.origin);
        vector3d.sub((Tuple3d)this.oneInY, (Tuple3d)this.origin);
        vector3d.normalize();
    }

    public void getZDir(Vector3d vector3d) {
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.getZDir(vector3d, this.ipToVWorld);
    }

    public void getZDir(Vector3d vector3d, Transform3D transform3D) {
        this.origin.set(0.0, 0.0, 0.0);
        this.oneInZ.set(0.0, 0.0, 1.0);
        transform3D.transform(this.oneInZ);
        transform3D.transform(this.origin);
        vector3d.sub((Tuple3d)this.origin, (Tuple3d)this.oneInZ);
        vector3d.normalize();
    }

    private void transformChanged(int n, Transform3D transform3D) {
        if (this.callback != null) {
            this.callback.transformChanged(n, transform3D);
        }
    }
}

