/*
 * Decompiled with CFR 0.152.
 */
package ij3d.pointlist;

import ij3d.pointlist.PointListPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.ScrollPane;

public class PointListDialog
extends Dialog {
    private GridBagConstraints c;
    private GridBagLayout gridbag;
    private Panel panel = new Panel();
    private Panel extraPanel;

    public PointListDialog(Frame frame) {
        super(frame, "Point list");
        this.gridbag = new GridBagLayout();
        this.panel.setLayout(this.gridbag);
        this.panel.setBackground(Color.WHITE);
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.anchor = 18;
        this.c.weighty = 0.1f;
        this.c.fill = 0;
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(this.panel);
        this.add(scrollPane);
    }

    public void addPointList(String string, PointListPanel pointListPanel) {
        if (!this.containsPointList(pointListPanel)) {
            pointListPanel.setName(string);
            this.gridbag.setConstraints(pointListPanel, this.c);
            this.panel.add(pointListPanel);
            ++this.c.gridx;
            if (!this.isVisible()) {
                this.setSize(250, 200);
                this.setVisible(true);
            }
        }
    }

    public void removePointList(PointListPanel pointListPanel) {
        if (this.containsPointList(pointListPanel)) {
            this.panel.remove(pointListPanel);
            --this.c.gridx;
            if (this.panel.getComponentCount() == 0) {
                this.setVisible(false);
            }
        }
    }

    public boolean containsPointList(PointListPanel pointListPanel) {
        Component[] componentArray = this.panel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] != pointListPanel) continue;
            return true;
        }
        return false;
    }

    public void addPanel(Panel panel) {
        if (this.extraPanel != null) {
            this.remove(this.extraPanel);
        }
        this.extraPanel = panel;
        this.add((Component)panel, "South");
        this.update();
    }

    public void removeExtraPanel() {
        if (this.extraPanel != null) {
            this.remove(this.extraPanel);
            this.extraPanel = null;
            this.update();
        }
    }

    public void update() {
        this.validateTree();
    }
}

