/*
 * Decompiled with CFR 0.152.
 */
package inference;

import inference.BinBoundariesInference;
import inference.BinClassificationInference;
import inference.DistributionInference;
import inference.InferenceCaller;
import inference.LogFuncs;
import inference.ModelInference;
import java.util.Vector;

public class Inference {
    public int[] data;
    public int[] count;
    public double[] subEvidences;
    public InferenceCaller caller;
    double[] logA;
    double[] logEvidences;

    public void setData(int[] nArray) {
        this.data = nArray;
        this.initCount();
    }

    public void setData(Vector vector) {
        int n = vector.size();
        this.data = new int[n];
        for (int i = 0; i < n; ++i) {
            this.data[i] = (Integer)vector.get(i);
        }
        this.initCount();
    }

    public void initCount() {
        int n;
        this.count = new int[this.K() + 1];
        this.subEvidences = new double[this.K() * this.K()];
        this.count[0] = 0;
        for (n = 1; n <= this.K(); ++n) {
            this.count[n] = this.count[n - 1] + this.data[n - 1];
        }
        for (n = -1; n < this.K() - 1; ++n) {
            for (int i = n + 1; i < this.K(); ++i) {
                int n2 = this.getCount(n, i);
                this.subEvidences[i + (n + 1) * this.K()] = LogFuncs.LogFactorial(n2) - LogFuncs.LogPow(i - n, n2);
            }
        }
    }

    public int getCount(int n, int n2) {
        return this.count[n2 + 1] - this.count[n + 1];
    }

    public int K() {
        return this.data.length;
    }

    public int N() {
        return this.count[this.K()];
    }

    private void init(int n) {
        this.logA = new double[this.K()];
        this.logEvidences = new double[n + 1];
        for (int i = 0; i < this.K(); ++i) {
            this.logA[i] = this.subEvidences[i] + this.caller.logExpectationFactor(0, -1, i);
        }
        this.logEvidences[0] = this.substep4b(0);
    }

    private double substep4aii(int n, int n2) {
        double d = -1.0E300;
        for (int i = n2; i < n; ++i) {
            d = LogFuncs.LogAddLogLog(d, this.logA[i] + this.subEvidences[n + (i + 1) * this.K()] + this.caller.logExpectationFactor(n2 + 1, i, n));
        }
        return d;
    }

    private double substep4b(int n) {
        return this.logA[this.K() - 1] + this.caller.logPrior(n);
    }

    private void step4(int n) {
        for (int i = 1; i < n; ++i) {
            for (int j = this.K() - 1; j >= i; --j) {
                this.logA[j] = this.substep4aii(j, i - 1);
            }
            this.logEvidences[i] = this.substep4b(i);
        }
    }

    void step6(int n) {
        this.logA[this.K() - 1] = this.substep4aii(this.K() - 1, n - 1);
        this.logEvidences[n] = this.substep4b(n);
    }

    public void doit(int n) {
        this.init(n);
        this.step4(n);
        this.step6(n);
    }

    public double defaultLogPrior(int n) {
        return LogFuncs.LogFactorial(this.K() - 1 - n) + 2.0 * LogFuncs.LogFactorial(n) - LogFuncs.LogFactorial(this.K() - 1) - LogFuncs.LogFactorial(this.N() + n);
    }

    public static void main(String[] stringArray) {
        BinBoundariesInference binBoundariesInference = new BinBoundariesInference();
        ModelInference modelInference = new ModelInference();
        int[] nArray = new int[]{0, 0, 0, 100, 30, 100, 0, 0};
        modelInference.setData(nArray);
        modelInference.doit(7, 0.03);
        binBoundariesInference.setData(nArray);
        binBoundariesInference.doit(2);
        for (int i = 0; i < nArray.length; ++i) {
            System.err.println(i + " -> " + binBoundariesInference.rebin(i));
        }
        BinClassificationInference binClassificationInference = new BinClassificationInference();
        binClassificationInference.setData(nArray);
        binClassificationInference.doit(2);
        for (int i = 0; i < nArray.length; ++i) {
            System.err.println(i + " -> " + binClassificationInference.rebin(i));
        }
        DistributionInference distributionInference = new DistributionInference();
        distributionInference.setData(nArray);
        distributionInference.doit(4);
    }
}

