/*
 * Decompiled with CFR 0.152.
 */
package isosurface;

import customnode.CustomTriangleMesh;
import ij.IJ;
import ij3d.Content;
import ij3d.ContentNode;
import isosurface.Triangulator;
import java.awt.Color;
import java.util.List;
import javax.media.j3d.Node;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import marchingcubes.MCTriangulator;

public class MeshGroup
extends ContentNode {
    private CustomTriangleMesh mesh;
    private Triangulator triangulator = new MCTriangulator();
    private Content c;
    private Point3f min;
    private Point3f max;
    private Point3f center;

    public MeshGroup(Content content) {
        this.c = content;
        Color3f color3f = content.getColor();
        List list = this.triangulator.getTriangles(content.getImage(), content.getThreshold(), content.getChannels(), content.getResamplingFactor());
        if (color3f == null) {
            int n = content.getImage().getProcessor().getColorModel().getRGB(content.getThreshold());
            color3f = new Color3f(new Color(n));
        }
        this.mesh = new CustomTriangleMesh(list, color3f, content.getTransparency());
        this.calculateMinMaxCenterPoint();
        this.addChild((Node)this.mesh);
    }

    public CustomTriangleMesh getMesh() {
        return this.mesh;
    }

    public void getMin(Tuple3d tuple3d) {
        tuple3d.set((Tuple3f)this.min);
    }

    public void getMax(Tuple3d tuple3d) {
        tuple3d.set((Tuple3f)this.max);
    }

    public void getCenter(Tuple3d tuple3d) {
        tuple3d.set((Tuple3f)this.center);
    }

    public void eyePtChanged(View view) {
    }

    public void thresholdUpdated() {
        if (this.c.getImage() == null) {
            IJ.error((String)"Mesh was not calculated of a grayscale image. Can't change threshold");
            return;
        }
        List list = this.triangulator.getTriangles(this.c.getImage(), this.c.getThreshold(), this.c.getChannels(), this.c.getResamplingFactor());
        this.mesh.setMesh(list);
    }

    public void channelsUpdated() {
        if (this.c.getImage() == null) {
            IJ.error((String)"Mesh was not calculated of a grayscale image. Can't change channels");
            return;
        }
        List list = this.triangulator.getTriangles(this.c.getImage(), this.c.getThreshold(), this.c.getChannels(), this.c.getResamplingFactor());
        this.mesh.setMesh(list);
    }

    public void calculateMinMaxCenterPoint() {
        this.min = new Point3f();
        this.max = new Point3f();
        this.center = new Point3f();
        if (this.mesh != null) {
            this.mesh.calculateMinMaxCenterPoint(this.min, this.max, this.center);
        }
    }

    public float getVolume() {
        if (this.mesh == null) {
            return -1.0f;
        }
        return this.mesh.getVolume();
    }

    public void shadeUpdated() {
        this.mesh.setShaded(this.c.isShaded());
    }

    public void colorUpdated() {
        Color3f color3f = this.c.getColor();
        if (color3f == null) {
            int n = this.c.getImage().getProcessor().getColorModel().getRGB(this.c.getThreshold());
            color3f = new Color3f(new Color(n));
        }
        this.mesh.setColor(color3f);
    }

    public void transparencyUpdated() {
        this.mesh.setTransparency(this.c.getTransparency());
    }
}

