/*
 * Decompiled with CFR 0.152.
 */
package isosurface;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.Image3DUniverse;
import java.awt.Window;
import java.awt.image.IndexColorModel;
import java.util.HashMap;
import javax.vecmath.Color3f;
import process3d.Smooth_;
import vib.Resample_;

public class Show_Colour_Surfaces
implements PlugIn {
    public void displayAsSurfaces(Image3DUniverse image3DUniverse, ImagePlus imagePlus, int n, double d) {
        this.displayAsSurfaces(image3DUniverse, imagePlus, n, d, -1);
    }

    public void displayAsSurfaces(Image3DUniverse image3DUniverse, ImagePlus imagePlus, int n, double d, int n2) {
        int n3;
        int n4;
        Object object;
        ImageStack imageStack;
        IndexColorModel indexColorModel;
        if (imagePlus == null) {
            IJ.error((String)"Show_Colour_Surfaces.displayAsSurfaces was passed a null 'image'");
            return;
        }
        if (image3DUniverse == null) {
            IJ.error((String)"Show_Colour_Surfaces.displayAsSurfaces was passed a null 'univ'");
            return;
        }
        int n5 = imagePlus.getType();
        if (n5 != 3) {
            IJ.error((String)"Show_Colour_Surfaces only works with 8-bit indexed color images.");
            return;
        }
        int n6 = imagePlus.getWidth();
        int n7 = imagePlus.getHeight();
        int n8 = imagePlus.getStackSize();
        Calibration calibration = imagePlus.getCalibration();
        if (calibration == null) {
            calibration = new Calibration(imagePlus);
        }
        int n9 = Math.max(n6, Math.max(n7, n8));
        int n10 = 1;
        if (n2 < 0) {
            System.out.println("resamplingFactor is now: " + n10);
            while (n9 / n10 > 512) {
                n10 *= 2;
            }
        } else {
            n10 = n2;
        }
        if (n10 != 1) {
            imagePlus = Resample_.resample(imagePlus, n10);
            n6 = imagePlus.getWidth();
            n7 = imagePlus.getHeight();
            n8 = imagePlus.getStackSize();
            calibration = imagePlus.getCalibration();
            if (calibration == null) {
                calibration = new Calibration(imagePlus);
            }
            n9 = Math.max(n6, Math.max(n7, n8));
        }
        if ((indexColorModel = (IndexColorModel)(imageStack = imagePlus.getStack()).getColorModel()) == null) {
            IJ.error((String)"The color model for this image stack was null");
            return;
        }
        int n11 = indexColorModel.getMapSize();
        byte[] byArray = new byte[n11];
        byte[] byArray2 = new byte[n11];
        byte[] byArray3 = new byte[n11];
        indexColorModel.getReds(byArray);
        indexColorModel.getBlues(byArray3);
        indexColorModel.getGreens(byArray2);
        if (n < 0) {
            object = new GenericDialog("Show Colour Surfaces");
            object.addNumericField("Index of background colour (from 0 to " + (n11 - 1) + " inclusive):", 0.0, 3);
            object.showDialog();
            if (object.wasCanceled()) {
                return;
            }
            n = (int)object.getNextNumber();
        }
        if (n < 0 || n >= n11) {
            IJ.error((String)("The background colour must have an index from 0 to " + (n11 - 1) + " inclusive"));
            return;
        }
        object = new HashMap();
        for (n4 = 0; n4 < n11; ++n4) {
            ((HashMap)object).put(n4, false);
        }
        for (n4 = 0; n4 < n8; ++n4) {
            byte[] byArray4 = (byte[])imageStack.getPixels(n4 + 1);
            for (int i = 0; i < byArray4.length; ++i) {
                n3 = byArray4[i] & 0xFF;
                ((HashMap)object).put(n3, true);
            }
        }
        for (n4 = 0; n4 < n11; ++n4) {
            Object object2;
            Object object3;
            boolean bl = (Boolean)((HashMap)object).get(n4);
            if (!bl) {
                System.out.println("Skipping colour index " + n4 + ", since it's not used in the image");
                continue;
            }
            if (n4 == n) continue;
            Color3f color3f = new Color3f((float)(byArray[n4] & 0xFF) / 255.0f, (float)(byArray2[n4] & 0xFF) / 255.0f, (float)(byArray3[n4] & 0xFF) / 255.0f);
            n3 = (byte)n4;
            ImageStack imageStack2 = new ImageStack(n6, n7);
            for (int i = 0; i < n8; ++i) {
                object3 = (byte[])imageStack.getPixels(i + 1);
                object2 = new byte[((byte[])object3).length];
                for (int j = 0; j < ((byte[])object3).length; ++j) {
                    if (object3[j] != n3) continue;
                    object2[j] = -1;
                }
                ByteProcessor byteProcessor = new ByteProcessor(n6, n7);
                byteProcessor.setPixels(object2);
                imageStack2.addSlice("", (ImageProcessor)byteProcessor);
            }
            Object object4 = new ImagePlus("Image for colour index: " + n4, imageStack2);
            object4.setCalibration(calibration);
            if (d > 0.0) {
                object3 = Smooth_.smooth(object4, true, (float)d, true);
                object3.setTitle("Smoothed image for colour index: " + n4);
                object4.close();
                object4 = object3;
            }
            object3 = new boolean[]{true, true, true};
            object2 = image3DUniverse.addContent((ImagePlus)object4, color3f, object4.getTitle(), 40, (boolean[])object3, n10, 2);
            ((Content)object2).setLocked(true);
            object4.close();
        }
    }

    public void run(String string) {
        Image3DUniverse image3DUniverse;
        int n;
        String string2;
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            IJ.error((String)"There is no image to view.");
            return;
        }
        Calibration calibration = imagePlus.getCalibration();
        if (calibration == null) {
            calibration = new Calibration(imagePlus);
        }
        double d = Math.max(Math.max(Math.abs(calibration.pixelWidth), Math.abs(calibration.pixelHeight)), Math.abs(calibration.pixelDepth));
        int n2 = imagePlus.getType();
        if (n2 != 3) {
            IJ.error((String)"Show_Colour_Surfaces only works with 8-bit indexed color images.");
            return;
        }
        ImageStack imageStack = imagePlus.getStack();
        IndexColorModel indexColorModel = (IndexColorModel)imageStack.getColorModel();
        if (indexColorModel == null) {
            IJ.error((String)"The color model for this image stack was null");
            return;
        }
        int n3 = indexColorModel.getMapSize();
        int n4 = Math.max(Math.max(imagePlus.getWidth(), imagePlus.getHeight()), imagePlus.getStackSize());
        int n5 = 1;
        while (n4 / n5 > 512) {
            n5 *= 2;
        }
        GenericDialog genericDialog = new GenericDialog("Show Colour Surfaces");
        String[] stringArray = new String[Image3DUniverse.universes.size() + 1];
        stringArray[stringArray.length - 1] = string2 = "Create New 3D Viewer";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String string3 = Image3DUniverse.universes.get(i).allContentsString();
            String string4 = string3.length() == 0 ? "[Empty]" : string3.substring(0, Math.min(20, string3.length() - 1));
            stringArray[i] = "[" + i + "] containing " + string4;
        }
        genericDialog.addChoice("Use 3D Viewer", stringArray, string2);
        genericDialog.addNumericField("Resampling factor: ", (double)n5, 0);
        genericDialog.addNumericField("Index of background colour (from 0 to " + (n3 - 1) + " inclusive):", 0.0, 0);
        genericDialog.addNumericField("Radius of smoothing, or -1 for no smoothing (much faster)", d, 2);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        String string5 = genericDialog.getNextChoice();
        for (n = 0; n < stringArray.length && !stringArray[n].equals(string5); ++n) {
        }
        int n6 = (int)genericDialog.getNextNumber();
        int n7 = (int)genericDialog.getNextNumber();
        double d2 = genericDialog.getNextNumber();
        if (n == stringArray.length - 1) {
            image3DUniverse = new Image3DUniverse(512, 512);
            image3DUniverse.show();
            GUI.center((Window)((Object)image3DUniverse.getWindow()));
        } else {
            image3DUniverse = Image3DUniverse.universes.get(n);
        }
        this.displayAsSurfaces(image3DUniverse, imagePlus, n7, d2, n6);
    }
}

