/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import landmarks.NamedPointSet;
import landmarks.NamedPointWorld;
import math3d.Bookstein;
import math3d.Point3d;
import util.Overlay_Registered;
import vib.oldregistration.RegistrationAlgorithm;

public class Bookstein_From_Landmarks
extends RegistrationAlgorithm
implements PlugIn {
    double xSpacingTemplate;
    double xSpacingDomain;
    double ySpacingTemplate;
    double ySpacingDomain;
    double zSpacingTemplate;
    double zSpacingDomain;
    int templateWidth;
    int templateHeight;
    int templateDepth;
    int domainWidth;
    int domainHeight;
    int domainDepth;
    Bookstein templateToDomain;
    Bookstein domainToTemplate;
    Calibration templateCalibration;
    Calibration domainCalibration;
    Point3d p = new Point3d();

    public void run(String string) {
        String string2;
        ImagePlus imagePlus;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error((String)"Bookstein_From_Landmarks.run(): No images are open");
            return;
        }
        String[] stringArray = new String[nArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            imagePlus = WindowManager.getImage((int)nArray[i]);
            stringArray[i] = imagePlus != null ? imagePlus.getTitle() : "";
        }
        stringArray[nArray.length] = string2 = "*None*";
        imagePlus = new GenericDialog("Thin Plate Spline Registration from Landmarks");
        imagePlus.addChoice("Template stack:", stringArray, stringArray[0]);
        imagePlus.addChoice("Stack to transform:", stringArray, stringArray[1]);
        imagePlus.addCheckbox("Keep source images", true);
        imagePlus.addCheckbox("Overlay result", true);
        imagePlus.showDialog();
        if (imagePlus.wasCanceled()) {
            return;
        }
        int[] nArray2 = new int[]{imagePlus.getNextChoiceIndex(), imagePlus.getNextChoiceIndex()};
        this.keepSourceImages = imagePlus.getNextBoolean();
        boolean bl = imagePlus.getNextBoolean();
        this.setImages(WindowManager.getImage((int)nArray[nArray2[0]]), WindowManager.getImage((int)nArray[nArray2[1]]));
        ImagePlus imagePlus2 = this.register();
        if (bl) {
            ImagePlus imagePlus3 = Overlay_Registered.overlayToImagePlus(this.sourceImages[0], imagePlus2);
            imagePlus3.setTitle("Registered and Overlayed");
            imagePlus3.show();
        } else {
            imagePlus2.show();
        }
    }

    public void generateTransformation() {
        NamedPointSet namedPointSet = null;
        NamedPointSet namedPointSet2 = null;
        try {
            namedPointSet = NamedPointSet.forImage(this.sourceImages[0]);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            throw new RuntimeException("No corresponding .points file found for image: \"" + this.sourceImages[0].getTitle() + "\"");
        }
        try {
            namedPointSet2 = NamedPointSet.forImage(this.sourceImages[1]);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            throw new RuntimeException("No corresponding .points file found for image: \"" + this.sourceImages[1].getTitle() + "\"");
        }
        this.generateTransformation(namedPointSet, namedPointSet2);
    }

    public void generateTransformation(NamedPointSet namedPointSet, NamedPointSet namedPointSet2) {
        String string2;
        if (this.sourceImages == null) {
            throw new RuntimeException("Bookstein_From_Landmarks: The source images must be set before calling generateTransformation()");
        }
        if (this.sourceImages[0] == null) {
            throw new RuntimeException("Bookstein_From_Landmarks: The template image is null in generateTransformation()");
        }
        if (this.sourceImages[1] == null) {
            throw new RuntimeException("Bookstein_From_Landmarks: The image to transform is null in generateTransformation()");
        }
        ArrayList<String> arrayList = namedPointSet.namesSharedWith(namedPointSet2, true);
        Point3d[] point3dArray = new Point3d[arrayList.size()];
        Point3d[] point3dArray2 = new Point3d[arrayList.size()];
        int n = 0;
        for (String string2 : arrayList) {
            Point3d point3d;
            for (NamedPointWorld namedPointWorld : namedPointSet.pointsWorld) {
                if (!string2.equals(namedPointWorld.getName())) continue;
                point3dArray2[n] = point3d = new Point3d(namedPointWorld.x, namedPointWorld.y, namedPointWorld.z);
                break;
            }
            for (NamedPointWorld namedPointWorld : namedPointSet2.pointsWorld) {
                if (!string2.equals(namedPointWorld.getName())) continue;
                point3dArray[n] = point3d = new Point3d(namedPointWorld.x, namedPointWorld.y, namedPointWorld.z);
                break;
            }
            ++n;
        }
        this.templateToDomain = new Bookstein(point3dArray2, point3dArray);
        ImagePlus imagePlus = this.sourceImages[0];
        string2 = this.sourceImages[1];
        this.xSpacingTemplate = 1.0;
        this.ySpacingTemplate = 1.0;
        this.zSpacingTemplate = 1.0;
        this.templateCalibration = imagePlus.getCalibration();
        if (this.templateCalibration != null) {
            this.xSpacingTemplate = this.templateCalibration.pixelWidth;
            this.ySpacingTemplate = this.templateCalibration.pixelHeight;
            this.zSpacingTemplate = this.templateCalibration.pixelDepth;
        }
        this.xSpacingDomain = 1.0;
        this.ySpacingDomain = 1.0;
        this.zSpacingDomain = 1.0;
        this.domainCalibration = string2.getCalibration();
        if (this.domainCalibration != null) {
            this.xSpacingDomain = this.domainCalibration.pixelWidth;
            this.ySpacingDomain = this.domainCalibration.pixelHeight;
            this.zSpacingDomain = this.domainCalibration.pixelDepth;
        }
        this.templateWidth = imagePlus.getWidth();
        this.templateHeight = imagePlus.getHeight();
        this.templateDepth = imagePlus.getStackSize();
        this.domainWidth = string2.getWidth();
        this.domainHeight = string2.getHeight();
        this.domainDepth = string2.getStackSize();
        this.validateTransformation();
    }

    public void transformTemplateToDomainWorld(double d, double d2, double d3, Point3d point3d) {
        if (!this.isTransformationValid()) {
            throw new RuntimeException("Trying to use Bookstein_From_Landmarks.transformWorld() with an invalid transformation.");
        }
        this.p.x = d;
        this.p.y = d2;
        this.p.z = d3;
        this.templateToDomain.apply(this.p);
        point3d.x = this.templateToDomain.x;
        point3d.y = this.templateToDomain.y;
        point3d.z = this.templateToDomain.z;
    }

    public void transformTemplateToDomain(int n, int n2, int n3, RegistrationAlgorithm.ImagePoint imagePoint) {
        if (!this.isTransformationValid()) {
            throw new RuntimeException("Trying to use Bookstein_From_Landmarks.transform() with an invalid transformation.");
        }
        this.p.x = (double)n * this.xSpacingTemplate;
        this.p.y = (double)n2 * this.ySpacingTemplate;
        this.p.z = (double)n3 * this.zSpacingTemplate;
        this.templateToDomain.apply(this.p);
        double d = this.templateToDomain.x / this.xSpacingDomain;
        double d2 = this.templateToDomain.y / this.ySpacingDomain;
        double d3 = this.templateToDomain.z / this.zSpacingDomain;
        imagePoint.x = (int)Math.round(d);
        imagePoint.y = (int)Math.round(d2);
        imagePoint.z = (int)Math.round(d3);
    }

    public void transformDomainToTemplateWorld(double d, double d2, double d3, Point3d point3d) {
        if (!this.isTransformationValid()) {
            throw new RuntimeException("Trying to use Bookstein_From_Landmarks.transformWorld() with an invalid transformation.");
        }
        this.p.x = d;
        this.p.y = d2;
        this.p.z = d3;
        this.domainToTemplate.apply(this.p);
        point3d.x = this.domainToTemplate.x;
        point3d.y = this.domainToTemplate.y;
        point3d.z = this.domainToTemplate.z;
    }

    public void transformDomainToTemplate(int n, int n2, int n3, RegistrationAlgorithm.ImagePoint imagePoint) {
        if (!this.isTransformationValid()) {
            throw new RuntimeException("Trying to use Bookstein_From_Landmarks.transform() with an invalid transformation.");
        }
        this.p.x = (double)n * this.xSpacingDomain;
        this.p.y = (double)n2 * this.ySpacingDomain;
        this.p.z = (double)n3 * this.zSpacingDomain;
        this.domainToTemplate.apply(this.p);
        double d = this.domainToTemplate.x / this.xSpacingTemplate;
        double d2 = this.domainToTemplate.y / this.ySpacingTemplate;
        double d3 = this.domainToTemplate.z / this.zSpacingTemplate;
        imagePoint.x = (int)Math.round(d);
        imagePoint.y = (int)Math.round(d2);
        imagePoint.z = (int)Math.round(d3);
    }

    public ImagePlus register() {
        NamedPointSet namedPointSet = null;
        NamedPointSet namedPointSet2 = null;
        try {
            namedPointSet = NamedPointSet.forImage(this.sourceImages[0]);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            throw new RuntimeException("No corresponding .points file found for image: \"" + this.sourceImages[0].getTitle() + "\"");
        }
        try {
            namedPointSet2 = NamedPointSet.forImage(this.sourceImages[1]);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            throw new RuntimeException("No corresponding .points file found for image: \"" + this.sourceImages[1].getTitle() + "\"");
        }
        return this.register(namedPointSet, namedPointSet2);
    }

    public ImagePlus register(NamedPointSet namedPointSet, NamedPointSet namedPointSet2) {
        this.generateTransformation(namedPointSet, namedPointSet2);
        ImageStack imageStack = new ImageStack(this.templateWidth, this.templateHeight);
        ImageStack imageStack2 = this.sourceImages[1].getStack();
        byte[][] byArrayArray = new byte[this.domainDepth][];
        for (int i = 0; i < this.domainDepth; ++i) {
            byArrayArray[i] = (byte[])imageStack2.getPixels(i + 1);
        }
        RegistrationAlgorithm.ImagePoint imagePoint = new RegistrationAlgorithm.ImagePoint();
        IJ.showProgress((double)0.0);
        for (int i = 0; i < this.templateDepth; ++i) {
            byte[] byArray = new byte[this.templateWidth * this.templateHeight];
            for (int j = 0; j < this.templateHeight; ++j) {
                for (int k = 0; k < this.templateWidth; ++k) {
                    this.transformTemplateToDomain(k, j, i, imagePoint);
                    int n = imagePoint.x;
                    int n2 = imagePoint.y;
                    int n3 = imagePoint.z;
                    if (n < 0 || n2 < 0 || n3 < 0 || n >= this.domainWidth || n2 >= this.domainHeight || n3 >= this.domainDepth) continue;
                    byArray[j * this.templateWidth + k] = byArrayArray[n3][n2 * this.domainWidth + n];
                }
            }
            ByteProcessor byteProcessor = new ByteProcessor(this.templateWidth, this.templateHeight);
            byteProcessor.setPixels((Object)byArray);
            imageStack.addSlice("", (ImageProcessor)byteProcessor);
            IJ.showProgress((double)((double)(i + 1) / (double)this.templateDepth));
        }
        IJ.showProgress((double)1.0);
        ImagePlus imagePlus = new ImagePlus("Transformed", imageStack);
        if (this.templateCalibration != null) {
            imagePlus.setCalibration(this.templateCalibration);
        }
        return imagePlus;
    }
}

