/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import client.ArchiveClient;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.applet.Applet;
import java.awt.Frame;
import java.awt.Polygon;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import landmarks.Affine_From_Landmarks;
import landmarks.Bookstein_From_Landmarks;
import landmarks.FineTuneProgressListener;
import landmarks.FineTuneThread;
import landmarks.NamedPointSet;
import landmarks.NamedPointWorld;
import landmarks.PointsDialog;
import landmarks.ProgressCanvas;
import landmarks.ProgressWindow;
import landmarks.RegistrationResult;
import landmarks.Rigid_From_Landmarks;
import stacks.ThreePaneCrop;
import util.BatchOpener;
import util.Overlay_Registered;
import util.Penalty;
import vib.FastMatrix;
import vib.oldregistration.RegistrationAlgorithm;

public class Name_Points
implements PlugIn,
FineTuneProgressListener {
    boolean unsaved = false;
    static final boolean offerFineTuning = false;
    String templateImageFilename = Prefs.get((String)"landmarks.Name_Points.templateImageFilename", (String)"");
    ImagePlus templateImage;
    NamedPointSet templatePoints;
    String templateUnits;
    int numberOfFineTuneThreads = 2;
    double x_spacing;
    double y_spacing;
    double z_spacing;
    ProgressWindow progressWindow;
    int maxThreads = Runtime.getRuntime().availableProcessors();
    LinkedList<FineTuneThread> fineTuneThreadQueue = new LinkedList();
    LinkedList<FineTuneThread> fineTuneThreadsStarted = new LinkedList();
    boolean fineTuning = false;
    boolean startedAdditionalRefinement = false;
    int indexOfPointBeingFineTuned = -1;
    FineTuneThread finalRefinementThread;
    RegistrationResult bestSoFar;
    int currentlyRunningFineTuneThreads;
    Object latch;
    public static final int MEAN_ABSOLUTE_DIFFERENCES = 1;
    public static final int MEAN_SQUARED_DIFFERENCES = 2;
    public static final int CORRELATION = 3;
    public static final int NORMALIZED_MUTUAL_INFORMATION = 4;
    public static final String[] methodName = new String[]{"UNSET!", "mean abs diffs", "mean squ diffs", "correlation", "norm mut inf"};
    PointsDialog dialog;
    ImagePlus imp;
    NamedPointSet points;
    ArchiveClient archiveClient;
    ImageCanvas canvas;
    boolean batchFineTuning = false;
    static final int AFFINE = 1;
    static final int RIGID = 2;
    static final int BOOKSTEIN = 3;

    public void show(int n) {
        this.points.showAsROI(n, this.imp);
    }

    void rename(int n) {
        NamedPointWorld namedPointWorld = this.points.get(n);
        GenericDialog genericDialog = new GenericDialog("Rename Point");
        genericDialog.addStringField("Rename point to:", namedPointWorld.getName());
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        String string = genericDialog.getNextString();
        boolean bl = this.points.renamePointTo(n, string);
        if (bl) {
            this.dialog.markButtons[n].setLabel(string);
            this.dialog.pack();
        } else {
            IJ.error((String)("Couldn't rename point: there already is one called \"" + string + "\""));
        }
    }

    void delete(int n) {
        String string = this.points.get(n).getName();
        YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Really delete?", "Do you really want to delete the point \"" + string + "\"?");
        if (yesNoCancelDialog.yesPressed()) {
            this.points.delete(n);
            this.dialog.recreatePointsPanel();
            this.dialog.pack();
        }
    }

    void addNewPoint() {
        NamedPointWorld namedPointWorld = this.points.addNewPoint();
        this.dialog.recreatePointsPanel();
        this.dialog.pack();
    }

    boolean fineTune(int n) {
        NamedPointWorld namedPointWorld = this.points.get(n);
        if (namedPointWorld == null) {
            IJ.error((String)"You must have set a point in order to fine-tune it.");
            return false;
        }
        return this.fineTune(namedPointWorld);
    }

    boolean fineTune(NamedPointWorld namedPointWorld) {
        int n = this.points.getIndexOfPoint(namedPointWorld.getName());
        return this.fineTune(namedPointWorld, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fineTune(NamedPointWorld namedPointWorld, int n) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        double[] dArray;
        double[] dArray2;
        Object object5;
        Object object6;
        String[] stringArray;
        Object object7;
        Object object8 = this.fineTuneThreadQueue;
        synchronized (object8) {
            if (this.fineTuning) {
                IJ.error((String)"Already fine-tuning some points");
                return false;
            }
            this.fineTuning = true;
            this.indexOfPointBeingFineTuned = n;
            this.startedAdditionalRefinement = false;
            this.bestSoFar = null;
            this.fineTuneThreadQueue.clear();
            this.fineTuneThreadsStarted.clear();
        }
        object8 = namedPointWorld.getName();
        if (this.templatePoints == null) {
            IJ.error((String)"You must have a template file loaded in order to fine tune.");
            return false;
        }
        NamedPointWorld namedPointWorld2 = this.templatePoints.getPoint((String)object8);
        if (namedPointWorld2 == null) {
            IJ.error((String)("The point you want to fine-tune must be set both in this image and the template.  \"" + (String)object8 + "\" is not set in the template."));
            return false;
        }
        ArrayList<String> arrayList = this.points.namesSharedWith(this.templatePoints, true);
        System.out.println("namedInCommon are: " + arrayList.toString());
        boolean bl = arrayList.size() >= 3;
        boolean bl2 = true;
        if (this.dialog != null) {
            this.dialog.setFineTuning(true);
        }
        if (!this.loadTemplateImage()) {
            return false;
        }
        int n2 = this.templateImage.getWidth();
        int n3 = this.templateImage.getHeight();
        int n4 = this.templateImage.getStackSize();
        Calibration calibration = this.templateImage.getCalibration();
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        this.templateUnits = "pixels";
        if (calibration != null) {
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
            d3 = calibration.pixelDepth;
            this.templateUnits = calibration.getUnits();
        }
        double d4 = namedPointWorld2.x;
        double d5 = namedPointWorld2.y;
        double d6 = namedPointWorld2.z;
        int n5 = (int)Math.round(d4 / d);
        int n6 = (int)Math.round(d5 / d2);
        int n7 = (int)Math.round(d6 / d3);
        int[] nArray = new int[]{40, n5 * 2, (n2 - n5) * 2, n6 * 2, (n3 - n6) * 2, n7 * 2, (n4 - n7) * 2};
        int n8 = Integer.MAX_VALUE;
        for (int n9 : nArray) {
            if (n9 >= n8) continue;
            n8 = n9;
        }
        System.out.println("Decided on maxCubeSideSamples: " + n8);
        double d7 = Math.min(Math.abs(d), Math.min(Math.abs(d2), Math.abs(d3)));
        double d8 = (double)n8 * d7;
        System.out.println("Using cube side in template of " + d8 + " " + this.templateUnits);
        System.out.println("   So template samples in x are: " + (int)(d8 / d));
        System.out.println("   So template samples in y are: " + (int)(d8 / d2));
        System.out.println("   So template samples in z are: " + (int)(d8 / d3));
        double d9 = d4 - d8 / 2.0;
        double d10 = d4 + d8 / 2.0;
        double d11 = d5 - d8 / 2.0;
        double d12 = d5 + d8 / 2.0;
        double d13 = d6 - d8 / 2.0;
        double d14 = d6 + d8 / 2.0;
        int n10 = (int)Math.round(d9 / d);
        int n11 = (int)Math.round(d10 / d);
        int n12 = (int)Math.round(d11 / d2);
        int n13 = (int)Math.round(d12 / d2);
        int n14 = (int)Math.round(d13 / d3);
        int n15 = (int)Math.round(d14 / d3);
        ImagePlus imagePlus = ThreePaneCrop.performCrop(this.templateImage, n10, n11, n12, n13, n14, n15, false);
        if (!this.batchFineTuning) {
            object7 = new ImageStack(100, 100);
            stringArray = new ColorProcessor(100, 100);
            stringArray.setRGB(new byte[10000], new byte[10000], new byte[10000]);
            object7.addSlice("", (ImageProcessor)stringArray);
            object7.addSlice("", (ImageProcessor)stringArray);
            object6 = new ImagePlus("Fine-Tuning Progress", object7);
            object5 = new ProgressCanvas((ImagePlus)object6);
            this.progressWindow = new ProgressWindow((ImagePlus)object6, (ImageCanvas)object5, this);
        }
        this.fineTuneThreadQueue = new LinkedList();
        object7 = null;
        if (bl) {
            stringArray = new String[2];
            int n16 = 0;
            for (String object92 : arrayList) {
                if (((String)object8).equals(object92)) continue;
                stringArray[n16++] = object92;
                if (n16 < 2) continue;
                break;
            }
            System.out.println("... calculating vector to: " + stringArray[0]);
            System.out.println("... and: " + stringArray[1]);
            object5 = this.points.getPoint(stringArray[0]);
            NamedPointWorld n18 = this.points.getPoint(stringArray[1]);
            NamedPointWorld n19 = this.templatePoints.getPoint(stringArray[0]);
            NamedPointWorld n20 = this.templatePoints.getPoint(stringArray[1]);
            double[] n21 = new double[3];
            double[] n22 = new double[3];
            dArray2 = new double[3];
            dArray = new double[3];
            n21[0] = ((NamedPointWorld)object5).x - namedPointWorld.x;
            n21[1] = ((NamedPointWorld)object5).y - namedPointWorld.y;
            n21[2] = ((NamedPointWorld)object5).z - namedPointWorld.z;
            n22[0] = n18.x - namedPointWorld.x;
            n22[1] = n18.y - namedPointWorld.y;
            n22[2] = n18.z - namedPointWorld.z;
            dArray2[0] = n19.x - namedPointWorld2.x;
            dArray2[1] = n19.y - namedPointWorld2.y;
            dArray2[2] = n19.z - namedPointWorld2.z;
            dArray[0] = n20.x - namedPointWorld2.x;
            dArray[1] = n20.y - namedPointWorld2.y;
            dArray[2] = n20.z - namedPointWorld2.z;
            object4 = FastMatrix.rotateToAlignVectors(dArray2, dArray, n21, n22);
            object7 = new double[6];
            ((FastMatrix)object4).guessEulerParameters((double[])object7);
            System.out.println("guessed euler 0 degrees: " + 180.0 * object7[0] / Math.PI);
            System.out.println("guessed euler 1 degrees: " + 180.0 * object7[1] / Math.PI);
            System.out.println("guessed euler 2 degrees: " + 180.0 * object7[2] / Math.PI);
            System.out.println("my inferred r is: " + object4);
            object3 = FastMatrix.rotateEuler((double)object7[0], (double)object7[1], (double)object7[2]);
            System.out.println("another r is:   " + object3);
            object2 = new double[]{(double)object7[0], (double)object7[1], (double)object7[2], namedPointWorld.x, namedPointWorld.y, namedPointWorld.z};
            object = new FineTuneThread(3, d8, imagePlus, this.templateImage, namedPointWorld2, this.imp, namedPointWorld, (double[])object2, (double[])object7, this.progressWindow, this);
            this.fineTuneThreadQueue.addLast((FineTuneThread)object);
        }
        for (int i = 0; i < 24; ++i) {
            object6 = new double[6];
            int n17 = i / 8;
            int n9 = 2 * (i / 4 % 2) - 1;
            int n16 = i % 4;
            int n18 = 1 + n16 / 2;
            int n19 = 2 * (n16 % 2) - 1;
            int n20 = (n17 + n18) % 3;
            dArray2 = new double[3];
            dArray = new double[3];
            dArray2[n17] = n9;
            dArray[n20] = n19;
            object4 = FastMatrix.crossProduct(dArray2, dArray);
            System.out.println("x axis mapped to: " + dArray2[0] + "," + dArray2[1] + "," + dArray2[2]);
            System.out.println("y axis mapped to: " + dArray[0] + "," + dArray[1] + "," + dArray[2]);
            System.out.println("z axis mapped to: " + object4[0] + "," + object4[1] + "," + object4[2]);
            object3 = new double[3][4];
            object3[0][0] = dArray2[0];
            object3[1][0] = dArray2[1];
            object3[2][0] = dArray2[2];
            object3[0][1] = dArray[0];
            object3[1][1] = dArray[1];
            object3[2][1] = dArray[2];
            object3[0][2] = (double)object4[0];
            object3[1][2] = (double)object4[1];
            object3[2][2] = (double)object4[2];
            object2 = new FastMatrix((double[][])object3);
            object = new double[6];
            ((FastMatrix)object2).guessEulerParameters((double[])object);
            double d15 = object[0];
            double d16 = object[1];
            double d17 = object[2];
            object6[0] = d15;
            object6[1] = d16;
            object6[2] = d17;
            object6[3] = namedPointWorld.x;
            object6[4] = namedPointWorld.y;
            object6[5] = namedPointWorld.z;
            FineTuneThread fineTuneThread = new FineTuneThread(3, d8, imagePlus, this.templateImage, namedPointWorld2, this.imp, namedPointWorld, (double[])object6, (double[])object7, this.progressWindow, this);
            this.fineTuneThreadQueue.addLast(fineTuneThread);
        }
        LinkedList<FineTuneThread> linkedList = this.fineTuneThreadQueue;
        synchronized (linkedList) {
            this.finalRefinementThread = new FineTuneThread(3, d8, imagePlus, this.templateImage, namedPointWorld2, this.imp, namedPointWorld, null, (double[])object7, this.progressWindow, this);
            for (int i = Math.min(this.fineTuneThreadQueue.size(), this.maxThreads); i > 0; --i) {
                System.out.println("========== Starting an initial thread ==========");
                this.startNextThread();
            }
        }
        return true;
    }

    boolean loadTemplateImage() {
        if (this.templateImage == null) {
            File file = new File(this.templateImageFilename);
            if (!file.exists()) {
                IJ.error((String)("The template file ('" + file.getAbsolutePath() + "') does not exist"));
                return false;
            }
            this.templateImage = BatchOpener.openFirstChannel(file.getAbsolutePath());
            if (this.templateImage == null) {
                IJ.error((String)("Couldn't load the template image from: " + this.templateImageFilename));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startNextThread() {
        LinkedList<FineTuneThread> linkedList = this.fineTuneThreadQueue;
        synchronized (linkedList) {
            if (this.fineTuning) {
                FineTuneThread fineTuneThread = this.fineTuneThreadQueue.removeFirst();
                fineTuneThread.start();
                this.fineTuneThreadsStarted.addLast(fineTuneThread);
                ++this.currentlyRunningFineTuneThreads;
            }
        }
    }

    static void printParameters(double[] dArray) {
        System.out.println("  z1: " + dArray[0]);
        System.out.println("  x1: " + dArray[1]);
        System.out.println("  z2: " + dArray[2]);
        System.out.println("  z1 degrees: " + 180.0 * dArray[0] / Math.PI);
        System.out.println("  z1 degrees: " + 180.0 * dArray[1] / Math.PI);
        System.out.println("  z1 degrees: " + 180.0 * dArray[2] / Math.PI);
        System.out.println("  tx: " + dArray[3]);
        System.out.println("  ty: " + dArray[4]);
        System.out.println("  tz: " + dArray[5]);
    }

    static RegistrationResult mapImageWith(ImagePlus imagePlus, ImagePlus imagePlus2, NamedPointWorld namedPointWorld, NamedPointWorld namedPointWorld2, double[] dArray, double d, int n, String string) {
        double d2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        double d3 = 0.0;
        double d4 = 0.0;
        long l = 0L;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        FastMatrix fastMatrix = FastMatrix.fromCalibration(imagePlus);
        FastMatrix fastMatrix2 = FastMatrix.fromCalibration(imagePlus2);
        FastMatrix fastMatrix3 = fastMatrix2.inverse();
        FastMatrix fastMatrix4 = FastMatrix.translate(-d / 2.0, -d / 2.0, -d / 2.0);
        double d10 = dArray[0];
        double d11 = dArray[1];
        double d12 = dArray[2];
        double d13 = dArray[3];
        double d14 = dArray[4];
        double d15 = dArray[5];
        FastMatrix fastMatrix5 = FastMatrix.rotateEuler(d10, d11, d12);
        FastMatrix fastMatrix6 = FastMatrix.translate(d13, d14, d15);
        FastMatrix fastMatrix7 = new FastMatrix(fastMatrix);
        fastMatrix7 = fastMatrix4.times(fastMatrix7);
        fastMatrix7 = fastMatrix5.times(fastMatrix7);
        fastMatrix7 = fastMatrix6.times(fastMatrix7);
        fastMatrix7 = fastMatrix3.times(fastMatrix7);
        int n7 = imagePlus.getWidth();
        int n8 = imagePlus.getHeight();
        int n9 = imagePlus.getStackSize();
        int[][] nArrayArray = new int[][]{{0, 0, 0}, {n7, 0, 0}, {0, n8, 0}, {0, 0, n9}, {n7, 0, n9}, {0, n8, n9}, {n7, n8, 0}, {n7, n8, n9}};
        double d16 = Double.MAX_VALUE;
        double d17 = Double.MIN_VALUE;
        double d18 = Double.MAX_VALUE;
        double d19 = Double.MIN_VALUE;
        double d20 = Double.MAX_VALUE;
        double d21 = Double.MIN_VALUE;
        for (n6 = 0; n6 < nArrayArray.length; ++n6) {
            fastMatrix7.apply(nArrayArray[n6][0], nArrayArray[n6][1], nArrayArray[n6][2]);
            if (fastMatrix7.x < d16) {
                d16 = fastMatrix7.x;
            }
            if (fastMatrix7.x > d17) {
                d17 = fastMatrix7.x;
            }
            if (fastMatrix7.y < d18) {
                d18 = fastMatrix7.y;
            }
            if (fastMatrix7.y > d19) {
                d19 = fastMatrix7.y;
            }
            if (fastMatrix7.z < d20) {
                d20 = fastMatrix7.z;
            }
            if (!(fastMatrix7.z > d21)) continue;
            d21 = fastMatrix7.z;
        }
        n6 = (int)Math.floor(d16);
        int n10 = (int)Math.floor(d18);
        int n11 = (int)Math.floor(d20);
        int n12 = (int)Math.ceil(d17);
        int n13 = (int)Math.ceil(d19);
        int n14 = (int)Math.ceil(d21);
        int n15 = n12 - n6 + 1;
        int n16 = n13 - n10 + 1;
        int n17 = n14 - n11 + 1;
        if (n15 < 0 || n16 < 0 || n17 < 0) {
            System.out.println("=== Error ==================");
            System.out.println("transformed dimensions: " + n15 + "," + n16 + "," + n17);
        }
        int n18 = imagePlus2.getWidth();
        int n19 = imagePlus2.getHeight();
        int n20 = imagePlus2.getStackSize();
        byte[][] byArray = new byte[n17][n16 * n15];
        ImageStack imageStack = imagePlus2.getStack();
        for (int i = 0; i < n17; ++i) {
            int n21 = i + n11;
            if (n21 < 0 || n21 >= n20) continue;
            byte[] byArray2 = (byte[])imageStack.getPixels(n21 + 1);
            for (int j = 0; j < n16; ++j) {
                for (n5 = 0; n5 < n15; ++n5) {
                    n4 = n6 + n5;
                    n3 = n10 + j;
                    if (n4 < 0 || n4 >= n18 || n3 < 0 || n3 >= n19) continue;
                    byArray[i][j * n15 + n5] = byArray2[n3 * n18 + n4];
                }
            }
        }
        ImageStack imageStack2 = imagePlus.getStack();
        byte[][] byArrayArray = new byte[n9][];
        for (int i = 0; i < n9; ++i) {
            byArrayArray[i] = (byte[])imageStack2.getPixels(i + 1);
        }
        FastMatrix fastMatrix8 = fastMatrix7.inverse();
        byte[][] byArray3 = new byte[n17][n16 * n15];
        for (n5 = 0; n5 < n17; ++n5) {
            for (n4 = 0; n4 < n16; ++n4) {
                for (n3 = 0; n3 < n15; ++n3) {
                    int n22 = n3 + n6;
                    int n23 = n4 + n10;
                    int n24 = n5 + n11;
                    fastMatrix8.apply(n22, n23, n24);
                    int n25 = (int)fastMatrix8.x;
                    int n26 = (int)fastMatrix8.y;
                    int n27 = (int)fastMatrix8.z;
                    if (n25 < 0 || n25 >= n7 || n26 < 0 || n26 >= n8 || n27 < 0 || n27 >= n9) continue;
                    int n28 = byArrayArray[n27][n26 * n7 + n25] & 0xFF;
                    byArray3[n5][n4 * n15 + n3] = (byte)n28;
                    int n29 = byArray[n5][n4 * n15 + n3] & 0xFF;
                    int n30 = Math.abs(n28 - n29);
                    n2 = n30 * n30;
                    d4 += (double)n30;
                    d3 += (double)n2;
                    d5 += (double)n28;
                    d8 += (double)(n28 * n28);
                    d6 += (double)n29;
                    d9 += (double)(n29 * n29);
                    d7 += (double)(n28 * n29);
                    ++l;
                }
            }
        }
        RegistrationResult registrationResult = new RegistrationResult();
        registrationResult.overlay_width = n15;
        registrationResult.overlay_height = n16;
        registrationResult.overlay_depth = n17;
        registrationResult.transformed_bytes = byArray3;
        registrationResult.fixed_bytes = byArray;
        registrationResult.parameters = dArray;
        double d22 = 0.0;
        switch (n) {
            case 1: {
                d22 = 255.0;
                break;
            }
            case 2: {
                d22 = 65025.0;
                break;
            }
            case 3: {
                d22 = 2.0;
                break;
            }
            case 4: {
                d22 = 1.0;
                break;
            }
            default: {
                assert (false) : "Unknown similarity measure: " + n;
                break;
            }
        }
        Calibration calibration = imagePlus2.getCalibration();
        double d23 = 1.0;
        double d24 = 1.0;
        double d25 = 1.0;
        if (calibration != null) {
            d23 = calibration.pixelWidth;
            d24 = calibration.pixelHeight;
            d25 = calibration.pixelDepth;
        }
        n2 = imagePlus.getWidth() / 2;
        int n31 = imagePlus.getHeight() / 2;
        int n32 = imagePlus.getStackSize() / 2;
        fastMatrix7.apply(n2, n31, n32);
        registrationResult.point_would_be_moved_to_x = fastMatrix7.x * d23;
        registrationResult.point_would_be_moved_to_y = fastMatrix7.y * d24;
        registrationResult.point_would_be_moved_to_z = fastMatrix7.z * d25;
        double d26 = registrationResult.point_would_be_moved_to_x - namedPointWorld2.x;
        double d27 = registrationResult.point_would_be_moved_to_y - namedPointWorld2.y;
        double d28 = registrationResult.point_would_be_moved_to_z - namedPointWorld2.z;
        double d29 = d26 * d26 + d27 * d27 + d28 * d28;
        registrationResult.pointMoved = d2 = Math.sqrt(d29);
        registrationResult.fixed_point_x = (int)(namedPointWorld2.x / d23 - (double)n6);
        registrationResult.fixed_point_y = (int)(namedPointWorld2.y / d24 - (double)n10);
        registrationResult.fixed_point_z = (int)(namedPointWorld2.z / d25 - (double)n11);
        registrationResult.transformed_point_x = (int)(registrationResult.point_would_be_moved_to_x / d23 - (double)n6);
        registrationResult.transformed_point_y = (int)(registrationResult.point_would_be_moved_to_y / d24 - (double)n10);
        registrationResult.transformed_point_z = (int)(registrationResult.point_would_be_moved_to_z / d25 - (double)n11);
        double d30 = d2 / d;
        double d31 = Penalty.logisticPenalty(d30, 0.8, 1.0, d22);
        double d32 = Math.abs(d10);
        double d33 = Math.abs(d11);
        double d34 = Math.abs(d12);
        double d35 = Math.max(Math.max(d32, d33), d34);
        double d36 = Penalty.logisticPenalty(d35, 10.995574287564276, Math.PI * 4, d22);
        if (l == 0L) {
            registrationResult.score = d22;
        } else {
            switch (n) {
                case 1: {
                    registrationResult.score = d4 / (double)l;
                    break;
                }
                case 2: {
                    registrationResult.score = d3 / (double)l;
                    break;
                }
                case 3: {
                    double d37 = l * l;
                    double d38 = d7 / (double)l - d5 * d6 / d37;
                    double d39 = d8 / (double)l - d5 * d5 / d37;
                    double d40 = d9 / (double)l - d6 * d6 / d37;
                    double d41 = Math.sqrt(d39) * Math.sqrt(d40);
                    registrationResult.score = d41 <= 1.0E-8 ? 0.0 : d38 / d41;
                    registrationResult.score = 1.0 - registrationResult.score;
                    break;
                }
                case 4: {
                    assert (false) : "Mutual information measure not implemented yet";
                    break;
                }
            }
        }
        registrationResult.score += d36;
        registrationResult.score += d31;
        return registrationResult;
    }

    public void save(String string) {
        FileInfo fileInfo = this.imp.getOriginalFileInfo();
        if (fileInfo == null) {
            IJ.error((String)"There's no original file name that these points refer to.");
            return;
        }
        String string2 = fileInfo.fileName;
        String string3 = fileInfo.url;
        String string4 = fileInfo.directory;
        SaveDialog saveDialog = new SaveDialog("Save points annotation file as...", string4, string2, string);
        if (saveDialog.getFileName() == null) {
            return;
        }
        String string5 = saveDialog.getDirectory() + saveDialog.getFileName();
        File file = new File(string5);
        if (file != null && file.exists() && !IJ.showMessageWithCancel((String)"Save points annotation file", (String)("The file " + string5 + " already exists.\n" + "Do you want to replace it?"))) {
            return;
        }
        IJ.showStatus((String)("Saving point annotations to " + string5));
        boolean bl = false;
        bl = string.equalsIgnoreCase(".landmarks") ? this.points.saveIGSPointsFile(string5) : this.points.savePointsFile(string5);
        if (!bl) {
            IJ.error((String)("Error saving to: " + string5 + "\n"));
        }
        this.unsaved = false;
        IJ.showStatus((String)"Saved point annotations.");
    }

    public void reset(int n) {
        this.points.unset(n);
        this.dialog.reset(n);
        this.unsaved = true;
    }

    public void reset() {
        for (int i = 0; i < this.points.size(); ++i) {
            this.reset(i);
        }
    }

    public void mark(int n) {
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 10) {
            Polygon polygon = roi.getPolygon();
            if (polygon.npoints > 1) {
                IJ.error((String)"You can only have one point selected to mark.");
                return;
            }
            System.out.println("Fetched ROI with co-ordinates: " + polygon.xpoints[0] + ", " + polygon.ypoints[0]);
            int n2 = polygon.xpoints[0];
            int n3 = polygon.ypoints[0];
            int n4 = this.imp.getCurrentSlice() - 1;
            int n5 = this.imp.getNChannels();
            Calibration calibration = this.imp.getCalibration();
            double d = n2;
            double d2 = n3;
            double d3 = n4 /= n5;
            if (calibration != null) {
                d = (double)n2 * calibration.pixelWidth;
                d2 = (double)n3 * calibration.pixelHeight;
                d3 = (double)n4 * calibration.pixelDepth;
            }
            System.out.println("Converted to our co-ordinates: " + d + "," + d2 + "," + d3);
            this.dialog.setCoordinateLabel(n, d, d2, d3);
            this.dialog.pack();
            NamedPointWorld namedPointWorld = this.points.get(n);
            namedPointWorld.set(d, d2, d3);
            this.unsaved = true;
        } else {
            IJ.error((String)("You must have a current point selection in " + this.imp.getTitle() + " in order to mark points."));
        }
    }

    public void get(boolean bl) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("method", "most-recent-annotation");
        hashtable.put("type", "points");
        hashtable.put("variant", "around-central-complex");
        hashtable.put("md5sum", this.archiveClient.getValue("md5sum"));
        if (bl) {
            hashtable.put("for_user", this.archiveClient.getValue("user"));
        } else {
            hashtable.put("for_user", "");
        }
        ArrayList<String[]> arrayList = this.archiveClient.synchronousRequest(hashtable, null);
        String[] stringArray = arrayList.get(0);
        String string = null;
        if (stringArray[0].equals("success")) {
            int n = Integer.parseInt(stringArray[1]);
            if (n == 0) {
                IJ.error((String)("No anntation files by " + (bl ? this.archiveClient.getValue("user") : "any user") + " found."));
            } else {
                string = arrayList.get(1)[1];
            }
        } else if (stringArray[0].equals("error")) {
            IJ.error((String)("There was an error while getting the most recent annotation: " + stringArray[1]));
        } else {
            IJ.error((String)("There was an unknown response to request for an annotation file: " + stringArray[0]));
        }
        if (string == null) {
            return;
        }
        String string2 = ArchiveClient.justGetFileAsString(string);
        if (string2 == null) {
            IJ.error((String)("Failed to fetch URL: " + string));
        } else {
            NamedPointSet namedPointSet;
            this.points = namedPointSet = NamedPointSet.fromString(string2);
            this.dialog.recreatePointsPanel();
            this.dialog.pack();
            this.unsaved = false;
        }
    }

    public void upload() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("method", "upload-annotation");
        hashtable.put("type", "points");
        hashtable.put("variant", "around-central-complex");
        hashtable.put("md5sum", this.archiveClient.getValue("md5sum"));
        byte[] byArray = this.points.xmlDataAsBytes();
        ArrayList<String[]> arrayList = this.archiveClient.synchronousRequest(hashtable, byArray);
        String[] stringArray = arrayList.get(0);
        if (stringArray[0].equals("success")) {
            IJ.error((String)"Annotations uploaded successfully!");
        } else if (stringArray[0].equals("error")) {
            IJ.error((String)("There was an error while uploading the annotation file: " + stringArray[1]));
        } else {
            IJ.error((String)("There was an unknown response to the annotation file upload request: " + stringArray[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchFineTune(String string, String string2, String string3) {
        boolean bl = this.useTemplate(string);
        if (!bl) {
            return;
        }
        this.imp = BatchOpener.openFirstChannel(string2);
        if (this.imp == null) {
            IJ.error((String)("Couldn't open the input image file '" + string2 + "'"));
            return;
        }
        Calibration calibration = this.imp.getCalibration();
        this.x_spacing = calibration.pixelWidth;
        this.y_spacing = calibration.pixelHeight;
        this.z_spacing = calibration.pixelDepth;
        try {
            this.points = NamedPointSet.forImage(this.imp);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            IJ.error((String)("Couldn't load points file for image '" + this.imp.getTitle() + "': " + pointsFileException));
            return;
        }
        ArrayList<String> arrayList = this.points.namesSharedWith(this.templatePoints, true);
        this.latch = new Object();
        for (String string4 : arrayList) {
            NamedPointWorld namedPointWorld = this.points.get(string4);
            boolean bl2 = this.fineTune(namedPointWorld);
            if (!bl2) {
                IJ.error((String)"Failed to start a fineTuneThread");
                return;
            }
            Object object = this.latch;
            synchronized (object) {
                try {
                    this.latch.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!this.points.savePointsFile(string3)) {
            IJ.error((String)("Saving the points file to: " + string3));
        }
    }

    public void run(String string) {
        boolean bl;
        Applet applet;
        Object object;
        Object object2;
        boolean bl2 = IJ.altKeyDown();
        String string2 = Macro.getOptions();
        String string3 = null;
        if (string2 != null) {
            string3 = Macro.getValue((String)string2, (String)"template", null);
            object2 = Macro.getValue((String)string2, (String)"action", null);
            if (object2 != null) {
                if (((String)object2).equals("finetunetofile")) {
                    this.batchFineTuning = true;
                    String string4 = Macro.getValue((String)string2, (String)"inputimage", null);
                    if (string4 == null) {
                        IJ.error((String)"You must supply an 'inputimage' parameter when using the macro action 'finetunetofile'");
                        return;
                    }
                    String string5 = Macro.getValue((String)string2, (String)"templateimage", null);
                    if (string5 == null) {
                        IJ.error((String)"You must supply an 'templateimage' parameter when using the macro action 'finetunetofile'");
                        return;
                    }
                    String string6 = Macro.getValue((String)string2, (String)"outputpointsfile", null);
                    if (string6 == null) {
                        IJ.error((String)"You must supply an 'outputpointsfile' parameter when using the macro action 'finetunetofile'");
                        return;
                    }
                    this.batchFineTune(string5, string4, string6);
                    return;
                }
                IJ.error((String)("Unknown macro action '" + (String)object2 + "'"));
                return;
            }
        }
        object2 = null;
        if (this.templateImageFilename != null && this.templateImageFilename.length() > 0) {
            object2 = new File(this.templateImageFilename);
        }
        if (bl2) {
            object = "Select template image file...";
            applet = object2 == null ? new OpenDialog((String)object, null) : new OpenDialog((String)object, ((File)object2).getParent(), ((File)object2).getName());
            if (applet.getFileName() != null) {
                this.templateImageFilename = applet.getDirectory() + applet.getFileName();
                this.useTemplate(this.templateImageFilename);
                this.setDefaultTemplate(this.templateImageFilename);
            }
        } else if (this.templateImageFilename != null && this.templateImageFilename.length() > 0) {
            if (((File)object2).exists()) {
                this.useTemplate(this.templateImageFilename);
            } else {
                IJ.error((String)("The default template file ('" + this.templateImageFilename + "') did not exist."));
            }
        }
        applet = IJ.getApplet();
        if (applet != null) {
            this.archiveClient = new ArchiveClient(applet);
        }
        if (this.archiveClient != null) {
            Object[] objectArray;
            object = new Hashtable();
            ((Hashtable)object).put("method", "channel-tags");
            ((Hashtable)object).put("md5sum", this.archiveClient.getValue("md5sum"));
            ArrayList<String[]> arrayList = this.archiveClient.synchronousRequest((Hashtable)object, null);
            int n = Integer.parseInt(arrayList.get(0)[1]);
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                objectArray = arrayList.get(i);
                if (!"nc82".equals(objectArray[1])) continue;
                n2 = Integer.parseInt(objectArray[0]);
                break;
            }
            if (n2 < 0) {
                this.imp = IJ.getImage();
                if (this.imp == null) {
                    IJ.error((String)"There's no image to annotate.");
                    return;
                }
            } else {
                String string7 = "Ch" + (n2 + 1);
                objectArray = WindowManager.getIDList();
                if (objectArray == null) {
                    IJ.error((String)"Name_Points: no images have been loaded");
                    return;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    ImagePlus imagePlus = WindowManager.getImage((int)objectArray[i]);
                    String string8 = imagePlus != null ? imagePlus.getTitle() : "";
                    int n3 = string8.indexOf(string7);
                    if (n3 >= 0) continue;
                    imagePlus.close();
                }
                this.imp = IJ.getImage();
                if (this.imp == null) {
                    IJ.error((String)"There's no image to annotate.");
                    return;
                }
            }
        } else {
            this.imp = IJ.getImage();
            if (this.imp == null) {
                IJ.error((String)"There's no image to annotate.");
                return;
            }
        }
        object = this.imp.getCalibration();
        this.x_spacing = ((Calibration)object).pixelWidth;
        this.y_spacing = ((Calibration)object).pixelHeight;
        this.z_spacing = ((Calibration)object).pixelDepth;
        this.canvas = this.imp.getCanvas();
        if (applet == null && !(bl = this.loadAtStart())) {
            this.points = new NamedPointSet();
            if (object2 != null && ((File)object2).exists()) {
                try {
                    this.templatePoints = NamedPointSet.forImage(this.templateImageFilename);
                }
                catch (NamedPointSet.PointsFileException pointsFileException) {
                    IJ.error((String)("Couldn't load points file for template image.  The error was: " + pointsFileException));
                }
            }
            if (this.templatePoints == null) {
                this.points.addNewPoint();
            } else {
                String[] stringArray;
                for (String string9 : stringArray = this.templatePoints.getPointNames()) {
                    this.points.add(new NamedPointWorld(string9));
                }
            }
        }
        boolean bl3 = false;
        if (string3 != null && this.useTemplate(string3)) {
            bl3 = true;
        }
        this.dialog = new PointsDialog("Marking up: " + this.imp.getTitle(), this.archiveClient, bl3 ? string3 : null, this);
    }

    public void load() {
        String string;
        FileInfo fileInfo = this.imp.getOriginalFileInfo();
        if (fileInfo == null) {
            Object var3_2 = null;
            Object var4_4 = null;
            string = null;
        } else {
            String string2 = fileInfo.fileName;
            String string3 = fileInfo.url;
            string = fileInfo.directory;
        }
        String string4 = "Select points file...";
        OpenDialog openDialog = string == null ? new OpenDialog(string4, null) : new OpenDialog(string4, string, null);
        if (openDialog.getFileName() == null) {
            return;
        }
        File file = new File(openDialog.getDirectory(), openDialog.getFileName());
        NamedPointSet namedPointSet = null;
        try {
            namedPointSet = NamedPointSet.fromFile(file.getAbsolutePath());
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            IJ.error((String)("Failed to load points file: " + pointsFileException));
        }
        if (namedPointSet == null) {
            return;
        }
        this.points = namedPointSet;
        this.dialog.recreatePointsPanel();
        this.dialog.pack();
    }

    public boolean loadAtStart() {
        NamedPointSet namedPointSet = null;
        try {
            namedPointSet = NamedPointSet.forImage(this.imp);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            return false;
        }
        if (this.points == null) {
            this.points = new NamedPointSet();
        }
        if (namedPointSet == null) {
            return false;
        }
        ListIterator listIterator = namedPointSet.listIterator();
        while (listIterator.hasNext()) {
            NamedPointWorld namedPointWorld = (NamedPointWorld)listIterator.next();
            boolean bl = false;
            ListIterator listIterator2 = this.points.listIterator();
            while (listIterator2.hasNext()) {
                NamedPointWorld namedPointWorld2 = (NamedPointWorld)listIterator2.next();
                if (!namedPointWorld.getName().equals(namedPointWorld2.getName())) continue;
                namedPointWorld2.x = namedPointWorld.x;
                namedPointWorld2.y = namedPointWorld.y;
                namedPointWorld2.z = namedPointWorld.z;
                namedPointWorld2.set = true;
                bl = true;
            }
            if (bl) continue;
            this.points.add(namedPointWorld);
        }
        this.unsaved = false;
        return true;
    }

    public void setDefaultTemplate() {
        this.setDefaultTemplate(this.templateImageFilename);
    }

    public void setDefaultTemplate(String string) {
        if (string == null) {
            string = "";
        }
        System.out.println("setDefaultTemplate called with: " + string);
        Prefs.set((String)"landmarks.Name_Points.templateImageFilename", (String)string);
        System.out.println("After setting preference, the value got back was: " + Prefs.get((String)"landmarks.Name_Points.templateImageFilename", null));
    }

    public boolean useTemplate(String string) {
        if (string == null) {
            this.templateImageFilename = null;
            this.templateImage = null;
            this.templatePoints = null;
            return true;
        }
        File file = new File(string);
        if (!file.exists()) {
            IJ.error((String)("The file " + string + " doesn't exist."));
            return false;
        }
        this.templateImageFilename = string;
        this.templateImage = null;
        NamedPointSet namedPointSet = null;
        try {
            namedPointSet = NamedPointSet.forImage(this.templateImageFilename);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            IJ.error((String)("Warning: Couldn't load a points file corresponding to this template: " + pointsFileException));
            return true;
        }
        this.templatePoints = namedPointSet;
        return true;
    }

    public void fineTuneNewBestResult(RegistrationResult registrationResult) {
        if (this.progressWindow != null) {
            this.progressWindow.offerNewResult(registrationResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFineTuneThreads() {
        LinkedList<FineTuneThread> linkedList = this.fineTuneThreadQueue;
        synchronized (linkedList) {
            for (FineTuneThread fineTuneThread : this.fineTuneThreadsStarted) {
                fineTuneThread.askToFinish();
            }
            this.fineTuning = false;
        }
        for (FineTuneThread fineTuneThread : this.fineTuneThreadsStarted) {
            System.out.println("Waiting for thread " + fineTuneThread + " to finish...");
            try {
                fineTuneThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("... done waiting for thread.");
        }
        if (this.dialog != null) {
            this.dialog.setFineTuning(false);
        }
        if (this.progressWindow != null && this.progressWindow.useTheResult) {
            this.useFineTuneResult(this.progressWindow.bestSoFar);
        }
        System.out.println("FINISHED! (in stopFineTuneThreads)");
    }

    public void useFineTuneResult() {
        this.useFineTuneResult(this.bestSoFar);
    }

    public void useFineTuneResult(RegistrationResult registrationResult) {
        if (registrationResult != null) {
            NamedPointWorld namedPointWorld = this.points.get(this.indexOfPointBeingFineTuned);
            namedPointWorld.x = registrationResult.point_would_be_moved_to_x;
            namedPointWorld.y = registrationResult.point_would_be_moved_to_y;
            namedPointWorld.z = registrationResult.point_would_be_moved_to_z;
            namedPointWorld.set = true;
            System.out.println("Got a result, changed point to: " + namedPointWorld);
            this.unsaved = true;
            if (this.dialog != null) {
                this.dialog.setCoordinateLabel(this.indexOfPointBeingFineTuned, namedPointWorld.x, namedPointWorld.y, namedPointWorld.z);
                this.dialog.pack();
            }
        }
        this.progressWindow = null;
    }

    public void updateBest(RegistrationResult registrationResult) {
        if (this.bestSoFar == null || registrationResult.score < this.bestSoFar.score) {
            this.bestSoFar = registrationResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fineTuneThreadFinished(int n, RegistrationResult registrationResult, FineTuneThread fineTuneThread) {
        LinkedList<FineTuneThread> linkedList = this.fineTuneThreadQueue;
        synchronized (linkedList) {
            if (registrationResult != null) {
                if (this.progressWindow != null) {
                    this.progressWindow.offerNewResult(registrationResult);
                }
                this.updateBest(registrationResult);
            }
            if (this.currentlyRunningFineTuneThreads <= this.maxThreads && n == 1 && this.fineTuneThreadQueue.size() > 0) {
                System.out.println("========== A thread finished, and with currentlyRunningFineTuneThreads = " + this.currentlyRunningFineTuneThreads + ", starting a thread ==========");
                this.startNextThread();
            }
            --this.currentlyRunningFineTuneThreads;
            if (this.currentlyRunningFineTuneThreads == 0) {
                if (this.fineTuning && !this.startedAdditionalRefinement) {
                    System.out.println("Starting refinement thread!");
                    this.startedAdditionalRefinement = true;
                    this.finalRefinementThread.setInitialTransformation(this.bestSoFar.parameters);
                    this.fineTuneThreadQueue.addLast(this.finalRefinementThread);
                    this.startNextThread();
                } else {
                    if (n == 1) {
                        if (this.dialog != null) {
                            this.dialog.instructions.setText("Completed: select 'Use this' or 'Cancel' in the fine-tune window.");
                            this.dialog.pack();
                        }
                        if (this.batchFineTuning) {
                            System.out.println("########################################################################");
                            System.out.println("Finished batchFineTuning one point, was: " + fineTuneThread.guessedPoint.toString());
                            this.useFineTuneResult();
                            System.out.println("Point is now: " + this.points.get(this.indexOfPointBeingFineTuned).toString());
                            this.fineTuning = false;
                        }
                    }
                    if (this.latch != null) {
                        Object object = this.latch;
                        synchronized (object) {
                            this.latch.notifyAll();
                        }
                    }
                }
            }
        }
    }

    public void doRegistration(int n) {
        RegistrationAlgorithm registrationAlgorithm = null;
        switch (n) {
            case 1: {
                registrationAlgorithm = new Affine_From_Landmarks();
                break;
            }
            case 2: {
                registrationAlgorithm = new Rigid_From_Landmarks();
                break;
            }
            case 3: {
                registrationAlgorithm = new Bookstein_From_Landmarks();
                break;
            }
            default: {
                IJ.error((String)"BUG: unknown registration method requested");
                return;
            }
        }
        if (this.templatePoints == null) {
            IJ.error((String)"You must have a template file loaded in order to perform register the images");
            return;
        }
        if (!this.loadTemplateImage()) {
            return;
        }
        boolean bl = this.dialog.overlayResult.getState();
        registrationAlgorithm.setImages(this.templateImage, this.imp);
        ImagePlus imagePlus = registrationAlgorithm.register(this.templatePoints, this.points);
        if (imagePlus == null) {
            return;
        }
        if (bl) {
            ImagePlus imagePlus2 = Overlay_Registered.overlayToImagePlus(this.templateImage, imagePlus);
            imagePlus2.setTitle("Registered and Overlayed");
            imagePlus2.show();
        } else {
            imagePlus.show();
        }
    }
}

