/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.measure.Calibration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import landmarks.NamedPointWorld;
import math3d.Point3d;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import util.BatchOpener;
import util.opencsv.CSVReader;
import vib.transforms.OrderedTransformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedPointSet {
    ArrayList<NamedPointWorld> pointsWorld = new ArrayList();
    static boolean verbose = true;

    public int size() {
        return this.pointsWorld.size();
    }

    public ListIterator listIterator() {
        return this.pointsWorld.listIterator();
    }

    public NamedPointSet transformPointsWith(OrderedTransformations orderedTransformations) {
        NamedPointSet namedPointSet = new NamedPointSet();
        ListIterator<NamedPointWorld> listIterator = this.pointsWorld.listIterator();
        while (listIterator.hasNext()) {
            NamedPointWorld namedPointWorld = (NamedPointWorld)listIterator.next();
            NamedPointWorld namedPointWorld2 = namedPointWorld.transformWith(orderedTransformations);
            namedPointSet.add(namedPointWorld2);
        }
        return namedPointSet;
    }

    public NamedPointWorld getPoint(String string) {
        ListIterator listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            NamedPointWorld namedPointWorld = (NamedPointWorld)listIterator.next();
            if (!namedPointWorld.name.equals(string)) continue;
            return namedPointWorld;
        }
        return null;
    }

    public synchronized NamedPointWorld delete(int n) {
        return this.pointsWorld.remove(n);
    }

    public NamedPointWorld get(int n) {
        return this.pointsWorld.get(n);
    }

    public NamedPointWorld get(String string) {
        ListIterator<NamedPointWorld> listIterator = this.pointsWorld.listIterator();
        while (listIterator.hasNext()) {
            NamedPointWorld namedPointWorld = (NamedPointWorld)listIterator.next();
            if (!namedPointWorld.getName().equals(string)) continue;
            return namedPointWorld;
        }
        return null;
    }

    public String[] getPointNames() {
        String[] stringArray = new String[this.pointsWorld.size()];
        int n = 0;
        ListIterator listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            NamedPointWorld namedPointWorld = (NamedPointWorld)listIterator.next();
            stringArray[n++] = namedPointWorld.name;
        }
        return stringArray;
    }

    public int getIndexOfPoint(String string) {
        int n = 0;
        for (NamedPointWorld namedPointWorld : this.pointsWorld) {
            if (namedPointWorld.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void showAsROI(int n, ImagePlus imagePlus) {
        NamedPointWorld namedPointWorld = this.pointsWorld.get(n);
        assert (namedPointWorld.set);
        double d = namedPointWorld.x;
        double d2 = namedPointWorld.y;
        double d3 = namedPointWorld.z;
        Calibration calibration = imagePlus.getCalibration();
        if (calibration != null) {
            d /= calibration.pixelWidth;
            d2 /= calibration.pixelHeight;
            d3 /= calibration.pixelDepth;
        }
        int n2 = (int)d3;
        System.out.println("sliceAllChannels: " + n2);
        int n3 = imagePlus.getNChannels();
        int n4 = imagePlus.getChannel();
        int n5 = n2 * n3 + n4;
        System.out.println("slice: " + n5);
        imagePlus.setSlice(n5);
        PointRoi pointRoi = new PointRoi((int)d, (int)d2);
        imagePlus.setRoi((Roi)pointRoi);
    }

    public boolean savePointsFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            byte[] byArray = this.xmlDataAsBytes();
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String xmlDataAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuffer.append("<!DOCTYPE namedpointset [\n");
        stringBuffer.append("  <!ELEMENT namedpointset (pointworld*)>\n");
        stringBuffer.append("  <!ELEMENT pointworld EMPTY>\n");
        stringBuffer.append("  <!ATTLIST namedpointset version CDATA #REQUIRED>\n");
        stringBuffer.append("  <!ATTLIST pointworld set (true|false) #REQUIRED>\n");
        stringBuffer.append("  <!ATTLIST pointworld name CDATA #REQUIRED>\n");
        stringBuffer.append("  <!ATTLIST pointworld x CDATA #IMPLIED>\n");
        stringBuffer.append("  <!ATTLIST pointworld y CDATA #IMPLIED>\n");
        stringBuffer.append("  <!ATTLIST pointworld z CDATA #IMPLIED>\n");
        stringBuffer.append("]>\n\n");
        stringBuffer.append("<namedpointset version=\"1.0\">\n");
        for (NamedPointWorld namedPointWorld : this.pointsWorld) {
            stringBuffer.append("  ");
            stringBuffer.append(namedPointWorld.toXMLElement());
            stringBuffer.append("\n");
        }
        stringBuffer.append("</namedpointset>\n");
        return stringBuffer.toString();
    }

    public byte[] xmlDataAsBytes() {
        try {
            return this.xmlDataAsString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IJ.error((String)"UTF-8 isn't available (!)");
            return null;
        }
    }

    public boolean saveIGSPointsFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            StringBuffer stringBuffer = new StringBuffer("! TYPEDSTREAM 1.1\n");
            ListIterator listIterator = this.listIterator();
            while (listIterator.hasNext()) {
                NamedPointWorld namedPointWorld = (NamedPointWorld)listIterator.next();
                if (!namedPointWorld.set) continue;
                stringBuffer.append(namedPointWorld.toIGS() + "\n");
            }
            fileOutputStream.write(stringBuffer.toString().getBytes("UTF-8"));
            fileOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NamedPointWorld namedPointWorld) {
        NamedPointSet namedPointSet = this;
        synchronized (namedPointSet) {
            String string = namedPointWorld.getName();
            NamedPointWorld namedPointWorld2 = this.get(string);
            if (namedPointWorld2 != null) {
                throw new RuntimeException("Trying to add a point of name '" + string + "', but this NamedPointSet already has one.");
            }
            this.pointsWorld.add(namedPointWorld);
        }
    }

    public static NamedPointSet forImage(ImagePlus imagePlus) throws PointsFileException {
        FileInfo fileInfo = imagePlus.getOriginalFileInfo();
        if (fileInfo == null) {
            throw new PointsFileException("Could not find original file for the image: " + imagePlus.getTitle());
        }
        String string = fileInfo.fileName;
        String string2 = fileInfo.url;
        String string3 = fileInfo.directory;
        File file = new File(string3, string);
        return NamedPointSet.forImage(imagePlus, file.getAbsolutePath());
    }

    public static NamedPointSet forImage(String string) throws PointsFileException {
        return NamedPointSet.forImage(null, string);
    }

    public static NamedPointSet forImage(ImagePlus imagePlus, String string) throws PointsFileException {
        String[] stringArray = new String[]{".points.xml", ".points.R", ".points"};
        int n = string.lastIndexOf(".");
        String string2 = null;
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        for (String string3 : stringArray) {
            for (int i = 0; i < 2; ++i) {
                String string4 = null;
                if (i == 0 && n >= 0) {
                    string4 = string2 + string3;
                } else if (i == 1) {
                    string4 = string + string3;
                }
                try {
                    return NamedPointSet.fromFile(string4, imagePlus, string);
                }
                catch (PointsFileException pointsFileException) {
                    continue;
                }
            }
        }
        throw new PointsFileException("None of the points filenames corresponding to '" + string + "' could be loaded.");
    }

    public static NamedPointSet fromFile(String string) throws PointsFileException {
        return NamedPointSet.fromFile(string, null, null);
    }

    public static NamedPointSet fromFile(String string, ImagePlus imagePlus, String string2) throws PointsFileException {
        File file = new File(string);
        if (!file.exists()) {
            throw new PointsFileException("File not found: " + string);
        }
        return NamedPointSet.fromFile(file, imagePlus, string2);
    }

    public static NamedPointSet fromFile(File file) throws PointsFileException {
        return NamedPointSet.fromFile(file, null, null);
    }

    public static NamedPointSet fromFile(File file, ImagePlus imagePlus, String string) throws PointsFileException {
        try {
            return NamedPointSet.fromBufferedReader(new BufferedReader(new FileReader(file)), imagePlus, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PointsFileException("Couldn't find the file: " + file.getAbsolutePath());
        }
    }

    public static NamedPointSet fromString(String string) {
        return NamedPointSet.fromString(string);
    }

    public static NamedPointSet fromString(String string, ImagePlus imagePlus, String string2) throws PointsFileException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            NamedPointSet namedPointSet = new NamedPointSet();
            Handler handler = new Handler(namedPointSet);
            sAXParser.parse(inputSource, (DefaultHandler)handler);
            stringReader.close();
            return namedPointSet;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new PointsFileException("There was a ParserConfigurationException when trying to parse as XML: " + parserConfigurationException);
        }
        catch (SAXException sAXException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PointsFileException("BUG: FileNotFoundException while parsing XML from a String: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new PointsFileException("BUG: IOException while parsing XML from a String: " + iOException);
        }
        try {
            NamedPointSet namedPointSet = new NamedPointSet();
            Pattern pattern = Pattern.compile("^ *$");
            Pattern pattern2 = Pattern.compile("[eE0-9\\.\\-]+");
            StringReader stringReader = new StringReader(string);
            CSVReader cSVReader = new CSVReader(stringReader, '\t');
            List list = cSVReader.readAll();
            for (String[] stringArray : list) {
                boolean bl;
                if (stringArray.length != 4) {
                    throw new PointsFileException("There must be 4 fields per line of the tab-separated values file");
                }
                String string3 = stringArray[0];
                String string4 = stringArray[1];
                String string5 = stringArray[2];
                String string6 = stringArray[3];
                Matcher matcher = pattern.matcher(string3);
                Matcher matcher2 = pattern.matcher(string4);
                Matcher matcher3 = pattern.matcher(string5);
                Matcher matcher4 = pattern2.matcher(string3);
                Matcher matcher5 = pattern2.matcher(string4);
                Matcher matcher6 = pattern2.matcher(string5);
                if (matcher.matches() && matcher2.matches() && matcher3.matches()) {
                    bl = false;
                } else if (matcher4.matches() && matcher5.matches() && matcher6.matches()) {
                    bl = true;
                } else {
                    throw new PointsFileException("In tab-separated format, the first three columns must all be empty or all be numbers");
                }
                if (bl) {
                    double d = Double.parseDouble(string3);
                    double d2 = Double.parseDouble(string4);
                    double d3 = Double.parseDouble(string5);
                    namedPointSet.add(new NamedPointWorld(string6, d, d2, d3));
                    continue;
                }
                namedPointSet.add(new NamedPointWorld(string6));
            }
            return namedPointSet;
        }
        catch (PointsFileException pointsFileException) {
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            String[] stringArray;
            ImagePlus imagePlus2;
            NamedPointSet namedPointSet = new NamedPointSet();
            Pattern pattern = Pattern.compile("^\"(.*)\": *\\[ *([eE0-9\\.\\-]+) *, *([eE0-9\\.\\-]+) *, *([eE0-9\\.\\-]+) *\\] *$");
            Pattern pattern3 = Pattern.compile("^ *#.*$");
            Pattern pattern4 = Pattern.compile("^\"(.*)\":.*$");
            Calibration calibration = null;
            if (imagePlus != null) {
                calibration = imagePlus.getCalibration();
            } else if (string2 != null && (imagePlus2 = BatchOpener.openFirstChannel(string2)) != null) {
                calibration = imagePlus2.getCalibration();
                imagePlus2.close();
            }
            double d = 1.0;
            double d4 = 1.0;
            double d5 = 1.0;
            if (calibration != null) {
                d = calibration.pixelWidth;
                d4 = calibration.pixelHeight;
                d5 = calibration.pixelDepth;
            }
            for (String string7 : stringArray = string.split("[\\r\\n]+")) {
                if ((string7 = string7.trim()).length() == 0) continue;
                Matcher matcher = pattern.matcher(string7);
                Matcher matcher7 = pattern3.matcher(string7);
                Matcher matcher8 = pattern4.matcher(string7);
                if (matcher.matches()) {
                    namedPointSet.add(new NamedPointWorld(matcher.group(1), Double.parseDouble(matcher.group(2)) * d, Double.parseDouble(matcher.group(3)) * d4, Double.parseDouble(matcher.group(4)) * d5));
                    continue;
                }
                if (matcher8.matches()) {
                    namedPointSet.add(new NamedPointWorld(matcher8.group(1)));
                    continue;
                }
                if (matcher7.matches()) continue;
                throw new PointsFileException("Couldn't parse the points file; the problematic line is '" + string7 + "'");
            }
            if (calibration == null) {
                IJ.error((String)"Warning: no calibration data found for a pseudo-YAML points file; assuming that voxel spacing is ( 1, 1, 1 )");
            }
            return namedPointSet;
        }
        catch (NumberFormatException numberFormatException) {
            throw new PointsFileException("Failed to load the points file by any method; the last error was: " + numberFormatException);
        }
        catch (PointsFileException pointsFileException) {
            throw new PointsFileException("Failed to load the points file by any method; the last error was: " + pointsFileException);
        }
    }

    public static NamedPointSet fromBufferedReader(BufferedReader bufferedReader, ImagePlus imagePlus, String string) throws PointsFileException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = null;
        try {
            while (true) {
                if ((string2 = bufferedReader.readLine()) == null) {
                    return NamedPointSet.fromString(stringBuffer.toString(), imagePlus, string);
                }
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
        }
        catch (IOException iOException) {
            throw new PointsFileException("There was an IOException while reading points file data: " + iOException);
        }
    }

    public ArrayList<String> namesSharedWith(NamedPointSet namedPointSet) {
        return this.namesSharedWith(namedPointSet, false);
    }

    public ArrayList<String> namesSharedWith(NamedPointSet namedPointSet, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (NamedPointWorld namedPointWorld : this.pointsWorld) {
            String string = namedPointWorld.name;
            for (NamedPointWorld namedPointWorld2 : namedPointSet.pointsWorld) {
                if ((!namedPointWorld.set || !namedPointWorld2.set) && bl || !string.equals(namedPointWorld2.name)) continue;
                arrayList.add(new String(string));
                continue block0;
            }
        }
        return arrayList;
    }

    public Point3d[] getPoint3DArrayForNames(String[] stringArray) {
        Point3d[] point3dArray = new Point3d[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            NamedPointWorld namedPointWorld = this.get(stringArray[i]);
            if (namedPointWorld == null) {
                return null;
            }
            point3dArray[i] = new Point3d(namedPointWorld.x, namedPointWorld.y, namedPointWorld.z);
        }
        return point3dArray;
    }

    public Set<String> getNamesAsSet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (NamedPointWorld namedPointWorld : this.pointsWorld) {
            hashSet.add(namedPointWorld.getName());
        }
        return hashSet;
    }

    public boolean equals(NamedPointSet namedPointSet) {
        Set<String> set;
        Set<String> set2 = this.getNamesAsSet();
        if (!((Object)set2).equals(set = namedPointSet.getNamesAsSet())) {
            return false;
        }
        double d = 1.0E-5;
        for (String string : set2) {
            NamedPointWorld namedPointWorld = this.get(string);
            NamedPointWorld namedPointWorld2 = namedPointSet.get(string);
            if (namedPointWorld.set != namedPointWorld2.set) {
                return false;
            }
            if (!namedPointWorld.set) continue;
            if (Math.abs(namedPointWorld.x - namedPointWorld2.x) > d) {
                return false;
            }
            if (Math.abs(namedPointWorld.y - namedPointWorld2.y) > d) {
                return false;
            }
            if (!(Math.abs(namedPointWorld.z - namedPointWorld2.z) > d)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (NamedPointWorld namedPointWorld : this.pointsWorld) {
            stringBuffer.append(namedPointWorld.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public synchronized boolean renamePointTo(int n, String string) {
        NamedPointWorld namedPointWorld = this.get(string);
        if (namedPointWorld == null) {
            this.pointsWorld.get(n).setName(string);
            return true;
        }
        return false;
    }

    public synchronized NamedPointWorld addNewPoint() {
        int n = this.pointsWorld.size();
        boolean bl = true;
        String string = null;
        while (bl) {
            string = "Named Point (" + n + ")";
            bl = this.get(string) != null;
            ++n;
        }
        NamedPointWorld namedPointWorld = new NamedPointWorld(string);
        this.pointsWorld.add(namedPointWorld);
        return namedPointWorld;
    }

    void unset(int n) {
        NamedPointWorld namedPointWorld = this.pointsWorld.get(n);
        namedPointWorld.unset();
    }

    public static class PointsFileException
    extends Exception {
        PointsFileException(String string) {
            super(string);
        }
    }

    private static class Handler
    extends DefaultHandler {
        protected NamedPointSet nps;
        String version = "";

        public Handler(NamedPointSet namedPointSet) {
            this.nps = namedPointSet;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("namedpointset")) {
                this.version = attributes.getValue("version");
                if (this.version == null) {
                    throw new SAXException("No 'version' attribute in <namedpointset>");
                }
            }
            if (string3.equals("pointworld")) {
                boolean bl;
                String string4 = attributes.getValue("set");
                String string5 = attributes.getValue("name");
                String string6 = attributes.getValue("x");
                String string7 = attributes.getValue("y");
                String string8 = attributes.getValue("z");
                if (string4 == null) {
                    throw new SAXException("No 'set' attribute in <pointworld>");
                }
                if (string4.equals("true")) {
                    bl = true;
                } else if (string4.equals("false")) {
                    bl = false;
                } else {
                    throw new SAXException("The 'set' attribute must be 'true' or 'false'");
                }
                if (string5 == null) {
                    throw new SAXException("No 'name' attribute in <pointworld");
                }
                String string9 = string5;
                if (bl && (string6 == null || string7 == null || string8 == null)) {
                    throw new SAXException("If 'set' is true then all of 'x', 'y' and 'z' must be specified.");
                }
                if (!(bl || string6 == null && string7 == null && string8 == null)) {
                    throw new SAXException("If 'set' is false then none of 'x', 'y' or 'z' may be specified.");
                }
                double d = -1.0;
                double d2 = -1.0;
                double d3 = -1.0;
                if (bl) {
                    try {
                        d = Double.parseDouble(string6);
                        d2 = Double.parseDouble(string7);
                        d3 = Double.parseDouble(string8);
                        this.nps.add(new NamedPointWorld(string9, d, d2, d3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXException("One of 'x', 'y' and 'z' couldn't be parsed as a number");
                    }
                } else {
                    this.nps.add(new NamedPointWorld(string9));
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }
    }
}

