/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import client.ArchiveClient;
import ij.IJ;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.ListIterator;
import landmarks.Name_Points;
import landmarks.NamedPointSet;
import landmarks.NamedPointWorld;

class PointsDialog
extends Dialog
implements ActionListener,
WindowListener {
    Label[] coordinateLabels;
    Button[] markButtons;
    Button[] showButtons;
    Button[] resetButtons;
    Button[] fineTuneButtons;
    Button[] renameButtons;
    Button[] deleteButtons;
    Button registerRigid;
    Button registerAffine;
    Button registerBookstein;
    HashMap<Button, Integer> buttonToAction;
    HashMap<Button, Integer> buttonToIndex;
    static final int MARK = 1;
    static final int SHOW = 2;
    static final int RESET = 3;
    static final int FINE_TUNE = 4;
    static final int RENAME = 5;
    static final int DELETE = 6;
    Label instructions;
    Panel pointsPanel;
    Panel buttonsPanel;
    Panel templatePanel;
    Panel registrationPanel;
    Checkbox overlayResult;
    Name_Points plugin;
    ArchiveClient archiveClient;
    Label templateFileName;
    Button chooseTemplate;
    Button setAsDefaultTemplate;
    Button clearTemplate;
    String defaultInstructions = "Mark the current point selection as:";
    Button saveButton;
    Button loadButton;
    Button igsSaveButton;
    Button resetButton;
    Button closeButton;
    Button getMyButton;
    Button getAnyButton;
    Button uploadButton;
    Button addButton;

    public void recreatePointsPanel() {
        NamedPointSet namedPointSet = this.plugin.points;
        for (Component component : this.pointsPanel.getComponents()) {
            if (!(component instanceof Button)) continue;
            ((Button)component).removeActionListener(this);
        }
        this.pointsPanel.removeAll();
        this.coordinateLabels = new Label[namedPointSet.size()];
        this.markButtons = new Button[namedPointSet.size()];
        this.showButtons = new Button[namedPointSet.size()];
        this.resetButtons = new Button[namedPointSet.size()];
        this.fineTuneButtons = new Button[namedPointSet.size()];
        this.renameButtons = new Button[namedPointSet.size()];
        this.deleteButtons = new Button[namedPointSet.size()];
        this.buttonToIndex = new HashMap();
        this.buttonToAction = new HashMap();
        this.pointsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        ListIterator listIterator = namedPointSet.listIterator();
        while (listIterator.hasNext()) {
            Button button;
            NamedPointWorld namedPointWorld = (NamedPointWorld)listIterator.next();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.anchor = 22;
            this.markButtons[n] = button = new Button(namedPointWorld.getName());
            button.addActionListener(this);
            this.buttonToIndex.put(button, n);
            this.buttonToAction.put(button, 1);
            this.pointsPanel.add((Component)button, gridBagConstraints);
            gridBagConstraints.anchor = 21;
            ++gridBagConstraints.gridx;
            this.coordinateLabels[n] = new Label("<unset>");
            this.pointsPanel.add((Component)this.coordinateLabels[n], gridBagConstraints);
            gridBagConstraints.anchor = 21;
            ++gridBagConstraints.gridx;
            this.showButtons[n] = button = new Button("Show");
            button.addActionListener(this);
            button.setEnabled(false);
            this.buttonToIndex.put(button, n);
            this.buttonToAction.put(button, 2);
            this.pointsPanel.add((Component)button, gridBagConstraints);
            gridBagConstraints.anchor = 21;
            ++gridBagConstraints.gridx;
            this.resetButtons[n] = button = new Button("Reset");
            button.addActionListener(this);
            button.setEnabled(false);
            this.buttonToIndex.put(button, n);
            this.buttonToAction.put(button, 3);
            this.pointsPanel.add((Component)button, gridBagConstraints);
            gridBagConstraints.anchor = 21;
            ++gridBagConstraints.gridx;
            this.renameButtons[n] = button = new Button("Rename");
            button.addActionListener(this);
            button.setEnabled(true);
            this.buttonToIndex.put(button, n);
            this.buttonToAction.put(button, 5);
            this.pointsPanel.add((Component)button, gridBagConstraints);
            gridBagConstraints.anchor = 21;
            ++gridBagConstraints.gridx;
            this.deleteButtons[n] = button = new Button("Delete");
            button.addActionListener(this);
            button.setEnabled(true);
            this.buttonToIndex.put(button, n);
            this.buttonToAction.put(button, 6);
            this.pointsPanel.add((Component)button, gridBagConstraints);
            if (namedPointWorld.set) {
                this.setCoordinateLabel(n, namedPointWorld.x, namedPointWorld.y, namedPointWorld.z);
            }
            ++n;
        }
    }

    public PointsDialog(String string, ArchiveClient archiveClient, String string2, Name_Points name_Points) {
        super((Frame)IJ.getInstance(), string, false);
        this.addWindowListener(this);
        this.plugin = name_Points;
        this.archiveClient = archiveClient;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel();
        this.pointsPanel = new Panel();
        this.buttonsPanel = new Panel();
        this.instructions = new Label(this.defaultInstructions);
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.instructions, "West");
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        this.add((Component)panel, gridBagConstraints);
        this.recreatePointsPanel();
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.pointsPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new Label(""), gridBagConstraints);
        this.addButton = new Button("Add New Point");
        this.addButton.addActionListener(this);
        this.buttonsPanel.add(this.addButton);
        if (archiveClient == null) {
            this.saveButton = new Button("Save");
            this.saveButton.addActionListener(this);
            this.loadButton = new Button("Load");
            this.loadButton.addActionListener(this);
            this.igsSaveButton = new Button("Export to IGS");
            this.igsSaveButton.addActionListener(this);
            this.resetButton = new Button("Reset All");
            this.resetButton.addActionListener(this);
            this.closeButton = new Button("Close");
            this.closeButton.addActionListener(this);
            this.buttonsPanel.add(this.saveButton);
            this.buttonsPanel.add(this.loadButton);
            this.buttonsPanel.add(this.igsSaveButton);
            this.buttonsPanel.add(this.resetButton);
            this.buttonsPanel.add(this.closeButton);
        } else {
            this.getMyButton = new Button("Get My Most Recent Annotation");
            this.getMyButton.addActionListener(this);
            this.getAnyButton = new Button("Get Most Recent Annotation");
            this.getAnyButton.addActionListener(this);
            this.uploadButton = new Button("Upload");
            this.uploadButton.addActionListener(this);
            this.buttonsPanel.add(this.getMyButton);
            this.buttonsPanel.add(this.getAnyButton);
            this.buttonsPanel.add(this.uploadButton);
        }
        ++gridBagConstraints.gridy;
        this.add((Component)this.buttonsPanel, gridBagConstraints);
        this.templatePanel = new Panel();
        this.templatePanel.add(new Label("Template File:"));
        this.templateFileName = name_Points.templateImageFilename == null || name_Points.templateImageFilename.length() == 0 ? new Label("[None chosen]") : new Label(name_Points.templateImageFilename);
        if (string2 != null) {
            this.templateFileName.setText(string2);
        }
        this.templatePanel.add(this.templateFileName);
        this.chooseTemplate = new Button("Choose");
        this.chooseTemplate.addActionListener(this);
        this.templatePanel.add(this.chooseTemplate);
        this.setAsDefaultTemplate = new Button("Set As Default");
        this.setAsDefaultTemplate.addActionListener(this);
        this.templatePanel.add(this.setAsDefaultTemplate);
        this.clearTemplate = new Button("Clear Template");
        this.clearTemplate.addActionListener(this);
        this.templatePanel.add(this.clearTemplate);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        this.add((Component)this.templatePanel, gridBagConstraints);
        this.registrationPanel = new Panel();
        this.registrationPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        this.registrationPanel.add((Component)new Label("Register to template based on common points:"), gridBagConstraints2);
        this.registerRigid = new Button("Best Rigid Registration");
        this.registerAffine = new Button("Affine Registration From Best 4 Points");
        this.registerBookstein = new Button("Thin-Plate Spline Registration");
        ++gridBagConstraints2.gridx;
        this.registrationPanel.add((Component)this.registerRigid, gridBagConstraints2);
        this.registerRigid.addActionListener(this);
        ++gridBagConstraints2.gridx;
        this.registrationPanel.add((Component)this.registerAffine, gridBagConstraints2);
        this.registerAffine.addActionListener(this);
        ++gridBagConstraints2.gridx;
        this.registrationPanel.add((Component)this.registerBookstein, gridBagConstraints2);
        this.registerBookstein.addActionListener(this);
        this.overlayResult = new Checkbox("Overlay result");
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        this.registrationPanel.add((Component)this.overlayResult, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        this.add((Component)this.registrationPanel, gridBagConstraints);
        this.pack();
        this.setVisible(true);
    }

    public void reset(int n) {
        assert (n > 0);
        assert (n < this.coordinateLabels.length);
        this.coordinateLabels[n].setText("<unset>");
        this.showButtons[n].setEnabled(false);
        this.resetButtons[n].setEnabled(false);
        this.pack();
    }

    public void setCoordinateLabel(int n, double d, double d2, double d3) {
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        String string = "";
        string = string + "x: " + decimalFormat.format(d) + ", y: " + decimalFormat.format(d2) + ", z: " + decimalFormat.format(d3);
        this.coordinateLabels[n].setText(string);
        this.showButtons[n].setEnabled(true);
        this.resetButtons[n].setEnabled(true);
    }

    public void setFineTuning(boolean bl) {
        if (bl) {
            this.instructions.setText("Fine tuning... (may take some time)");
            this.pointsPanel.setEnabled(false);
            this.buttonsPanel.setEnabled(false);
            this.templatePanel.setEnabled(false);
            this.registrationPanel.setEnabled(false);
        } else {
            this.instructions.setText(this.defaultInstructions);
            this.pointsPanel.setEnabled(true);
            this.buttonsPanel.setEnabled(true);
            this.templatePanel.setEnabled(true);
            this.registrationPanel.setEnabled(true);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Integer n = this.buttonToIndex.get(object);
        if (n != null) {
            int n2 = n;
            int n3 = this.buttonToAction.get(object);
            switch (n3) {
                case 1: {
                    this.plugin.mark(n2);
                    return;
                }
                case 2: {
                    this.plugin.show(n2);
                    return;
                }
                case 3: {
                    this.plugin.reset(n2);
                    return;
                }
                case 4: {
                    this.plugin.fineTune(n2);
                    return;
                }
                case 5: {
                    this.plugin.rename(n2);
                    return;
                }
                case 6: {
                    this.plugin.delete(n2);
                    return;
                }
            }
        }
        if (object == this.addButton) {
            this.plugin.addNewPoint();
        } else if (object == this.closeButton) {
            this.closeSafely();
        } else if (object == this.saveButton) {
            this.plugin.save(".points");
        } else if (object == this.loadButton) {
            this.plugin.load();
        } else if (object == this.igsSaveButton) {
            this.plugin.save(".landmarks");
        } else if (object == this.resetButton) {
            this.plugin.reset();
        } else if (object == this.uploadButton) {
            this.plugin.upload();
        } else if (object == this.chooseTemplate) {
            String string;
            OpenDialog openDialog;
            String string2 = "Select template image file...";
            File file = null;
            if (this.plugin.templateImageFilename != null && this.plugin.templateImageFilename.length() > 0) {
                file = new File(this.plugin.templateImageFilename);
            }
            if ((openDialog = file == null ? new OpenDialog(string2, null) : new OpenDialog(string2, file.getParent(), file.getName())).getFileName() != null && this.plugin.useTemplate(string = openDialog.getDirectory() + openDialog.getFileName())) {
                this.templateFileName.setText(string);
                this.pack();
            }
        } else if (object == this.setAsDefaultTemplate) {
            this.plugin.setDefaultTemplate();
        } else if (object == this.clearTemplate) {
            this.plugin.useTemplate(null);
            this.templateFileName.setText("[None chosen]");
            this.pack();
        } else if (object == this.registerRigid) {
            this.plugin.doRegistration(2);
        } else if (object == this.registerAffine) {
            this.plugin.doRegistration(1);
        } else if (object == this.registerBookstein) {
            this.plugin.doRegistration(3);
        }
    }

    public void closeSafely() {
        YesNoCancelDialog yesNoCancelDialog;
        if (this.plugin.unsaved && !(yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Really quit?", "There are unsaved changes. Do you really want to quit?")).yesPressed()) {
            return;
        }
        this.plugin.stopFineTuneThreads();
        this.dispose();
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("Got windowClosing...");
        this.closeSafely();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }
}

