/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import landmarks.NamedPointSet;
import landmarks.NamedPointWorld;
import math3d.Point3d;
import util.Overlay_Registered;
import vib.FastMatrix;
import vib.TransformedImage;
import vib.oldregistration.RegistrationAlgorithm;

public class Rigid_From_Landmarks
extends RegistrationAlgorithm
implements PlugIn {
    boolean allowScaling;

    public void run(String string) {
        String string2;
        ImagePlus imagePlus;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error((String)"Rigid_From_Landmarks: No images are open.");
            return;
        }
        String[] stringArray = new String[nArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            imagePlus = WindowManager.getImage((int)nArray[i]);
            stringArray[i] = imagePlus != null ? imagePlus.getTitle() : "";
        }
        stringArray[nArray.length] = string2 = "*None*";
        imagePlus = new GenericDialog("Rigid Registration from Landmarks");
        imagePlus.addChoice("Template stack:", stringArray, stringArray[0]);
        imagePlus.addChoice("Stack to transform:", stringArray, stringArray[1]);
        imagePlus.addCheckbox("Allow scaling", true);
        imagePlus.addCheckbox("Overlay result", true);
        imagePlus.showDialog();
        if (imagePlus.wasCanceled()) {
            return;
        }
        int[] nArray2 = new int[]{imagePlus.getNextChoiceIndex(), imagePlus.getNextChoiceIndex()};
        this.setImages(WindowManager.getImage((int)nArray[nArray2[0]]), WindowManager.getImage((int)nArray[nArray2[1]]));
        this.allowScaling = imagePlus.getNextBoolean();
        boolean bl = imagePlus.getNextBoolean();
        ImagePlus imagePlus2 = this.register();
        if (bl) {
            ImagePlus imagePlus3 = Overlay_Registered.overlayToImagePlus(this.sourceImages[0], imagePlus2);
            imagePlus3.setTitle("Registered and Overlayed");
            imagePlus3.show();
        } else {
            imagePlus2.show();
        }
    }

    public ImagePlus register() {
        NamedPointSet namedPointSet = null;
        NamedPointSet namedPointSet2 = null;
        try {
            namedPointSet = NamedPointSet.forImage(this.sourceImages[0]);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            IJ.error((String)("No corresponding .points file found for image: \"" + this.sourceImages[0].getTitle() + "\""));
            System.out.println("for 0 in Rigid_From_Landmarks.register()");
            return null;
        }
        try {
            namedPointSet2 = NamedPointSet.forImage(this.sourceImages[1]);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            IJ.error((String)("No corresponding .points file found for image: \"" + this.sourceImages[1].getTitle() + "\""));
            System.out.println("for 1 in Rigid_From_Landmarks.register()");
            return null;
        }
        return this.register(namedPointSet, namedPointSet2);
    }

    public ImagePlus register(NamedPointSet namedPointSet, NamedPointSet namedPointSet2) {
        NamedPointWorld namedPointWorld;
        ArrayList<String> arrayList = namedPointSet.namesSharedWith(namedPointSet2, true);
        Point3d[] point3dArray = new Point3d[arrayList.size()];
        Point3d[] point3dArray2 = new Point3d[arrayList.size()];
        int n = 0;
        for (String object2 : arrayList) {
            namedPointWorld = namedPointSet.getPoint(object2);
            NamedPointWorld namedPointWorld2 = namedPointSet2.getPoint(object2);
            point3dArray2[n] = namedPointWorld.toPoint3d();
            point3dArray[n] = namedPointWorld2.toPoint3d();
            ++n;
        }
        FastMatrix fastMatrix = FastMatrix.bestRigid(point3dArray, point3dArray2, this.allowScaling);
        TransformedImage transformedImage = new TransformedImage(this.sourceImages[0], this.sourceImages[1]);
        transformedImage.setTransformation(fastMatrix);
        namedPointWorld = transformedImage.getTransformed();
        namedPointWorld.setTitle("Transformed");
        return namedPointWorld;
    }
}

